/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.MultiPostingsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReaderSlice;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001,B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/index/MappingMultiPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "field", "", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/index/MergeState;)V", "getField", "()Ljava/lang/String;", "multiDocsAndPositionsEnum", "Lorg/gnit/lucenekmp/index/MultiPostingsEnum;", "getMultiDocsAndPositionsEnum", "()Lorg/gnit/lucenekmp/index/MultiPostingsEnum;", "setMultiDocsAndPositionsEnum", "(Lorg/gnit/lucenekmp/index/MultiPostingsEnum;)V", "docIDMerger", "Lorg/gnit/lucenekmp/index/DocIDMerger;", "Lorg/gnit/lucenekmp/index/MappingMultiPostingsEnum$MappingPostingsSub;", "getDocIDMerger", "()Lorg/gnit/lucenekmp/index/DocIDMerger;", "current", "allSubs", "", "[Lorg/gnit/lucenekmp/index/MappingMultiPostingsEnum$MappingPostingsSub;", "subs", "", "reset", "postingsEnum", "freq", "", "docID", "advance", "target", "nextDoc", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "cost", "", "MappingPostingsSub", "core"})
public final class MappingMultiPostingsEnum
extends PostingsEnum {
    @Nullable
    private final String field;
    @Nullable
    private MultiPostingsEnum multiDocsAndPositionsEnum;
    @NotNull
    private final DocIDMerger<MappingPostingsSub> docIDMerger;
    @Nullable
    private MappingPostingsSub current;
    @NotNull
    private final MappingPostingsSub[] allSubs;
    @NotNull
    private final List<MappingPostingsSub> subs;

    public MappingMultiPostingsEnum(@Nullable String field, @NotNull MergeState mergeState) {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        this.field = field;
        this.subs = new ArrayList();
        this.allSubs = new MappingPostingsSub[mergeState.getFieldsProducers().length];
        int n = this.allSubs.length;
        for (int i = 0; i < n; ++i) {
            MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
            Intrinsics.checkNotNull((Object)docMapArray);
            this.allSubs[i] = new MappingPostingsSub(docMapArray[i]);
        }
        this.docIDMerger = DocIDMerger.Companion.of(this.subs, this.allSubs.length, mergeState.getNeedsIndexSort());
    }

    @Nullable
    public final String getField() {
        return this.field;
    }

    @Nullable
    public final MultiPostingsEnum getMultiDocsAndPositionsEnum() {
        return this.multiDocsAndPositionsEnum;
    }

    public final void setMultiDocsAndPositionsEnum(@Nullable MultiPostingsEnum multiPostingsEnum) {
        this.multiDocsAndPositionsEnum = multiPostingsEnum;
    }

    @NotNull
    public final DocIDMerger<MappingPostingsSub> getDocIDMerger() {
        return this.docIDMerger;
    }

    @NotNull
    public final MappingMultiPostingsEnum reset(@NotNull MultiPostingsEnum postingsEnum) throws IOException {
        Intrinsics.checkNotNullParameter((Object)postingsEnum, (String)"postingsEnum");
        this.multiDocsAndPositionsEnum = postingsEnum;
        MultiPostingsEnum.EnumWithSlice[] subsArray = postingsEnum.getSubs();
        int count = postingsEnum.getNumSubs();
        this.subs.clear();
        for (int i = 0; i < count; ++i) {
            MappingPostingsSub sub;
            MultiPostingsEnum.EnumWithSlice enumWithSlice = subsArray[i];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            ReaderSlice readerSlice = enumWithSlice.getSlice();
            Intrinsics.checkNotNull((Object)readerSlice);
            MappingPostingsSub mappingPostingsSub = sub = this.allSubs[readerSlice.getReaderIndex()];
            Intrinsics.checkNotNull((Object)mappingPostingsSub);
            MultiPostingsEnum.EnumWithSlice enumWithSlice2 = subsArray[i];
            Intrinsics.checkNotNull((Object)enumWithSlice2);
            mappingPostingsSub.setPostings(enumWithSlice2.getPostingsEnum());
            this.subs.add(sub);
        }
        this.docIDMerger.reset();
        return this;
    }

    @Override
    public int freq() throws IOException {
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        PostingsEnum postingsEnum = mappingPostingsSub.getPostings();
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.freq();
    }

    @Override
    public int docID() {
        if (this.current == null) {
            return -1;
        }
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        return mappingPostingsSub.getMappedDocID();
    }

    @Override
    public int advance(int target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextDoc() throws IOException {
        this.current = this.docIDMerger.next();
        if (this.current == null) {
            return Integer.MAX_VALUE;
        }
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        return mappingPostingsSub.getMappedDocID();
    }

    @Override
    public int nextPosition() throws IOException {
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        PostingsEnum postingsEnum = mappingPostingsSub.getPostings();
        Intrinsics.checkNotNull((Object)postingsEnum);
        int pos = postingsEnum.nextPosition();
        if (pos < 0) {
            MappingPostingsSub mappingPostingsSub2 = this.current;
            Intrinsics.checkNotNull((Object)mappingPostingsSub2);
            String string = "position=" + pos + " is negative, field=\"" + this.field + " doc=" + mappingPostingsSub2.getMappedDocID();
            MappingPostingsSub mappingPostingsSub3 = this.current;
            Intrinsics.checkNotNull((Object)mappingPostingsSub3);
            throw new CorruptIndexException(string, String.valueOf(mappingPostingsSub3.getPostings()), null, 4, null);
        }
        if (pos > 0x7FFFFF7F) {
            MappingPostingsSub mappingPostingsSub4 = this.current;
            Intrinsics.checkNotNull((Object)mappingPostingsSub4);
            String string = "position=" + pos + " is too large (> IndexWriter.MAX_POSITION=2147483519), field=\"" + this.field + "\" doc=" + mappingPostingsSub4.getMappedDocID();
            MappingPostingsSub mappingPostingsSub5 = this.current;
            Intrinsics.checkNotNull((Object)mappingPostingsSub5);
            throw new CorruptIndexException(string, String.valueOf(mappingPostingsSub5.getPostings()), null, 4, null);
        }
        return pos;
    }

    @Override
    public int startOffset() throws IOException {
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        PostingsEnum postingsEnum = mappingPostingsSub.getPostings();
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        PostingsEnum postingsEnum = mappingPostingsSub.getPostings();
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.endOffset();
    }

    @Override
    @Nullable
    public BytesRef getPayload() {
        MappingPostingsSub mappingPostingsSub = this.current;
        Intrinsics.checkNotNull((Object)mappingPostingsSub);
        PostingsEnum postingsEnum = mappingPostingsSub.getPostings();
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.getPayload();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (MappingPostingsSub sub : this.subs) {
            PostingsEnum postingsEnum = sub.getPostings();
            Intrinsics.checkNotNull((Object)postingsEnum);
            cost += postingsEnum.cost();
        }
        return cost;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/MappingMultiPostingsEnum$MappingPostingsSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;)V", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "getPostings", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "setPostings", "(Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "nextDoc", "", "core"})
    public static final class MappingPostingsSub
    extends DocIDMerger.Sub {
        @Nullable
        private PostingsEnum postings;

        public MappingPostingsSub(@Nullable MergeState.DocMap docMap) {
            MergeState.DocMap docMap2 = docMap;
            Intrinsics.checkNotNull((Object)docMap2);
            super(docMap2);
        }

        @Nullable
        public final PostingsEnum getPostings() {
            return this.postings;
        }

        public final void setPostings(@Nullable PostingsEnum postingsEnum) {
            this.postings = postingsEnum;
        }

        @Override
        public int nextDoc() {
            try {
                PostingsEnum postingsEnum = this.postings;
                Intrinsics.checkNotNull((Object)postingsEnum);
                return postingsEnum.nextDoc();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

