/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/index/MultiBits;", "Lorg/gnit/lucenekmp/util/Bits;", "subs", "", "starts", "", "defaultValue", "", "<init>", "([Lorg/gnit/lucenekmp/util/Bits;[IZ)V", "[Lorg/gnit/lucenekmp/util/Bits;", "checkLength", "reader", "", "doc", "get", "index", "toString", "", "length", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMultiBits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiBits.kt\norg/gnit/lucenekmp/index/MultiBits\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,123:1\n3#2,8:124\n8#2,2:133\n3#2,8:135\n3#2,8:144\n10#3:132\n10#3:143\n10#3:152\n*S KotlinDebug\n*F\n+ 1 MultiBits.kt\norg/gnit/lucenekmp/index/MultiBits\n*L\n28#1:124,8\n36#1:133,2\n53#1:135,8\n58#1:144,8\n28#1:132\n53#1:143\n58#1:152\n*E\n"})
public final class MultiBits
implements Bits {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bits[] subs;
    @NotNull
    private final int[] starts;
    private final boolean defaultValue;

    private MultiBits(Bits[] subs, int[] starts, boolean defaultValue) {
        boolean condition$iv = starts.length == 1 + subs.length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.subs = subs;
        this.starts = starts;
        this.defaultValue = defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkLength(int reader2, int doc) {
        void condition$iv;
        int length = this.starts[1 + reader2] - this.starts[reader2];
        boolean bl = doc - this.starts[reader2] < length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == false) {
            boolean bl2 = false;
            String string = "doc=" + doc + " reader=" + reader2 + " starts[reader]=" + this.starts[reader2] + " length=" + length;
            throw new AssertionError((Object)string);
        }
        return true;
    }

    @Override
    public boolean get(int index) {
        int reader2 = ReaderUtil.INSTANCE.subIndex(index, this.starts);
        boolean condition$iv = reader2 != -1;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        Bits bits = this.subs[reader2];
        if (bits == null) {
            return this.defaultValue;
        }
        boolean condition$iv2 = this.checkLength(reader2, index);
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return bits.get(index - this.starts[reader2]);
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.subs.length).append(" subs: ");
        int n = this.subs.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                b.append("; ");
            }
            StringBuilder stringBuilder = this.subs[i] == null ? b.append("s=").append(this.starts[i]).append(" l=null") : b.append("s=").append(this.starts[i]).append(" l=").append(this.subs[i].length()).append(" b=").append(this.subs[i]);
        }
        b.append(" end=").append(this.starts[this.subs.length]);
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int length() {
        return this.starts[this.starts.length - 1];
    }

    @Override
    public void applyMask(@NotNull FixedBitSet bitSet, int offset) {
        Bits.super.applyMask(bitSet, offset);
    }

    public /* synthetic */ MultiBits(Bits[] subs, int[] starts, boolean defaultValue, DefaultConstructorMarker $constructor_marker) {
        this(subs, starts, defaultValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/index/MultiBits$Companion;", "", "<init>", "()V", "getLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "reader", "Lorg/gnit/lucenekmp/index/IndexReader;", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiBits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiBits.kt\norg/gnit/lucenekmp/index/MultiBits$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,123:1\n8#2,2:124\n*S KotlinDebug\n*F\n+ 1 MultiBits.kt\norg/gnit/lucenekmp/index/MultiBits$Companion\n*L\n102#1:124,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Bits getLiveDocs(@NotNull IndexReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            if (reader2.hasDeletions()) {
                List<LeafReaderContext> leaves = reader2.leaves();
                int size2 = leaves.size();
                boolean condition$iv = size2 > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-MultiBits$Companion$getLiveDocs$22 = false;
                    String $i$a$-assert-MultiBits$Companion$getLiveDocs$22 = "A reader with deletions must have at least one leave";
                    throw new AssertionError((Object)$i$a$-assert-MultiBits$Companion$getLiveDocs$22);
                }
                if (size2 == 1) {
                    return leaves.get(0).reader().getLiveDocs();
                }
                Bits[] liveDocs2 = new Bits[size2];
                int[] starts = new int[size2 + 1];
                for (int i = 0; i < size2; ++i) {
                    LeafReaderContext ctx = leaves.get(i);
                    Intrinsics.checkNotNull((Object)ctx.reader().getLiveDocs());
                    starts[i] = ctx.getDocBase();
                }
                starts[size2] = reader2.maxDoc();
                return new MultiBits(liveDocs2, starts, true, null);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

