/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexSorter;
import org.gnit.lucenekmp.index.LeafMetaData;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.gnit.lucenekmp.util.Version;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/index/MultiSorter;", "", "<init>", "()V", "sort", "", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "Lorg/gnit/lucenekmp/search/Sort;", "readers", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "(Lorg/gnit/lucenekmp/search/Sort;Ljava/util/List;)[Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "LeafAndDocID", "core"})
@SourceDebugExtension(value={"SMAP\nMultiSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiSorter.kt\norg/gnit/lucenekmp/index/MultiSorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1#2:165\n*E\n"})
public final class MultiSorter {
    @NotNull
    public static final MultiSorter INSTANCE = new MultiSorter();

    private MultiSorter() {
    }

    @Nullable
    public final MergeState.DocMap[] sort(@NotNull Sort sort2, @NotNull List<CodecReader> readers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        SortField[] fields = sort2.getSort();
        IndexSorter.ComparableProvider[][] comparables = new IndexSorter.ComparableProvider[fields.length][];
        int[] reverseMuls = new int[fields.length];
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            IndexSorter sorter2;
            Intrinsics.checkNotNull((Object)fields[i].getIndexSorter());
            if (sorter2 == null) {
                boolean $i$a$-requireNotNull-MultiSorter$sort$22 = false;
                String $i$a$-requireNotNull-MultiSorter$sort$22 = "Cannot use sort field " + fields[i] + " for index sorting";
                throw new IllegalArgumentException($i$a$-requireNotNull-MultiSorter$sort$22.toString());
            }
            comparables[i] = sorter2.getComparableProviders(readers);
            int n2 = ((Collection)readers).size();
            for (int j = 0; j < n2; ++j) {
                CodecReader codecReader = readers.get(j);
                FieldInfos fieldInfos = codecReader.getFieldInfos();
                LeafMetaData metaData = codecReader.getMetaData();
                if (metaData.getHasBlocks() && fieldInfos.getParentField() != null) {
                    IndexSorter.ComparableProvider[] providers;
                    NumericDocValues parentDocs;
                    if (codecReader.getNumericDocValues(fieldInfos.getParentField()) == null) {
                        boolean $i$a$-checkNotNull-MultiSorter$sort$parentDocs$22 = false;
                        String $i$a$-checkNotNull-MultiSorter$sort$parentDocs$22 = "parent field: " + fieldInfos.getParentField() + " must be present if index sorting is used with blocks";
                        throw new IllegalStateException($i$a$-checkNotNull-MultiSorter$sort$parentDocs$22.toString());
                    }
                    BitSet parents = BitSet.Companion.of(parentDocs, codecReader.maxDoc());
                    Intrinsics.checkNotNull((Object)comparables[i]);
                    IndexSorter.ComparableProvider provider = providers[j];
                    providers[j] = new IndexSorter.ComparableProvider(provider, parents){
                        final /* synthetic */ IndexSorter.ComparableProvider $provider;
                        final /* synthetic */ BitSet $parents;
                        {
                            this.$provider = $provider;
                            this.$parents = $parents;
                        }

                        public long getAsComparableLong(int docId) {
                            return this.$provider.getAsComparableLong(this.$parents.nextSetBit(docId));
                        }
                    };
                }
                if (!metaData.getHasBlocks() || fieldInfos.getParentField() != null || metaData.getCreatedVersionMajor() < Version.Companion.getLUCENE_10_0_0().getMajor()) continue;
                throw new CorruptIndexException("parent field is not set but the index has blocks and uses index sorting. indexCreatedVersionMajor: " + metaData.getCreatedVersionMajor(), "IndexingChain", null, 4, null);
            }
            reverseMuls[i] = fields[i].getReverse() ? -1 : 1;
        }
        int leafCount = readers.size();
        PriorityQueue queue2 = new PriorityQueue<LeafAndDocID>(leafCount, comparables, reverseMuls){
            final /* synthetic */ IndexSorter.ComparableProvider[][] $comparables;
            final /* synthetic */ int[] $reverseMuls;
            {
                this.$comparables = $comparables;
                this.$reverseMuls = $reverseMuls;
                super($leafCount, null, 2, null);
            }

            public boolean lessThan(LeafAndDocID a, LeafAndDocID b) {
                int n = ((Object[])this.$comparables).length;
                for (int i = 0; i < n; ++i) {
                    LeafAndDocID leafAndDocID = a;
                    Intrinsics.checkNotNull((Object)leafAndDocID);
                    long l = leafAndDocID.getValuesAsComparableLongs()[i];
                    LeafAndDocID leafAndDocID2 = b;
                    Intrinsics.checkNotNull((Object)leafAndDocID2);
                    int cmp = LongExtKt.compare(LongCompanionObject.INSTANCE, l, leafAndDocID2.getValuesAsComparableLongs()[i]);
                    if (cmp == 0) continue;
                    return this.$reverseMuls[i] * cmp < 0;
                }
                LeafAndDocID leafAndDocID = a;
                Intrinsics.checkNotNull((Object)leafAndDocID);
                int n2 = leafAndDocID.getReaderIndex();
                LeafAndDocID leafAndDocID3 = b;
                Intrinsics.checkNotNull((Object)leafAndDocID3);
                if (n2 != leafAndDocID3.getReaderIndex()) {
                    return a.getReaderIndex() < b.getReaderIndex();
                }
                return a.getDocID() < b.getDocID();
            }
        };
        PackedLongValues.Builder[] builders = new PackedLongValues.Builder[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            CodecReader reader2 = readers.get(i);
            LeafAndDocID leaf = new LeafAndDocID(i, reader2.getLiveDocs(), reader2.maxDoc(), ((Object[])comparables).length);
            int metaData = ((Object[])comparables).length;
            for (int j = 0; j < metaData; ++j) {
                long[] lArray = leaf.getValuesAsComparableLongs();
                IndexSorter.ComparableProvider[] comparableProviderArray = comparables[j];
                Intrinsics.checkNotNull((Object)comparableProviderArray);
                lArray[j] = comparableProviderArray[i].getAsComparableLong(leaf.getDocID());
            }
            queue2.add(leaf);
            builders[i] = PackedLongValues.Companion.monotonicBuilder(0.0f);
        }
        int mappedDocID = 0;
        int lastReaderIndex = 0;
        boolean isSorted = true;
        while (queue2.size() != 0) {
            LeafAndDocID leafAndDocID;
            Object t = queue2.top();
            Intrinsics.checkNotNull(t);
            LeafAndDocID top = (LeafAndDocID)t;
            if (lastReaderIndex > top.getReaderIndex()) {
                isSorted = false;
            }
            lastReaderIndex = top.getReaderIndex();
            PackedLongValues.Builder builder = builders[top.getReaderIndex()];
            Intrinsics.checkNotNull((Object)builder);
            builder.add(mappedDocID);
            if (top.getLiveDocs() == null || top.getLiveDocs().get(top.getDocID())) {
                ++mappedDocID;
            }
            int metaData = top.getDocID();
            top.setDocID(metaData + 1);
            if (top.getDocID() < top.getMaxDoc()) {
                int parentDocs = ((Object[])comparables).length;
                for (int j = 0; j < parentDocs; ++j) {
                    long[] lArray = top.getValuesAsComparableLongs();
                    IndexSorter.ComparableProvider[] comparableProviderArray = comparables[j];
                    Intrinsics.checkNotNull((Object)comparableProviderArray);
                    lArray[j] = comparableProviderArray[top.getReaderIndex()].getAsComparableLong(top.getDocID());
                }
                leafAndDocID = (LeafAndDocID)queue2.updateTop();
                continue;
            }
            leafAndDocID = (LeafAndDocID)queue2.pop();
        }
        if (isSorted) {
            return null;
        }
        MergeState.DocMap[] docMaps = new MergeState.DocMap[leafCount];
        for (int i = 0; i < leafCount; ++i) {
            PackedLongValues.Builder builder = builders[i];
            Intrinsics.checkNotNull((Object)builder);
            PackedLongValues remapped = builder.build();
            Bits liveDocs2 = readers.get(i).getLiveDocs();
            docMaps[i] = arg_0 -> MultiSorter.sort$lambda$2(liveDocs2, remapped, arg_0);
        }
        return docMaps;
    }

    private static final int sort$lambda$2(Bits $liveDocs, PackedLongValues $remapped, int docID) {
        if ($liveDocs == null || $liveDocs.get(docID)) {
            return (int)$remapped.get(docID);
        }
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0016\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/MultiSorter$LeafAndDocID;", "", "readerIndex", "", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "maxDoc", "numComparables", "<init>", "(ILorg/gnit/lucenekmp/util/Bits;II)V", "getReaderIndex", "()I", "getLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "getMaxDoc", "valuesAsComparableLongs", "", "getValuesAsComparableLongs", "()[J", "docID", "getDocID", "setDocID", "(I)V", "core"})
    private static final class LeafAndDocID {
        private final int readerIndex;
        @Nullable
        private final Bits liveDocs;
        private final int maxDoc;
        @NotNull
        private final long[] valuesAsComparableLongs;
        private int docID;

        public LeafAndDocID(int readerIndex, @Nullable Bits liveDocs2, int maxDoc, int numComparables) {
            this.readerIndex = readerIndex;
            this.liveDocs = liveDocs2;
            this.maxDoc = maxDoc;
            this.valuesAsComparableLongs = new long[numComparables];
        }

        public final int getReaderIndex() {
            return this.readerIndex;
        }

        @Nullable
        public final Bits getLiveDocs() {
            return this.liveDocs;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        @NotNull
        public final long[] getValuesAsComparableLongs() {
            return this.valuesAsComparableLongs;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }
    }
}

