/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.MultiTermsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReaderSlice;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.TermsEnumIndex;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0001*B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010!\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/index/MultiTerms;", "Lorg/gnit/lucenekmp/index/Terms;", "subTerms", "", "subSlices", "Lorg/gnit/lucenekmp/index/ReaderSlice;", "<init>", "([Lorg/gnit/lucenekmp/index/Terms;[Lorg/gnit/lucenekmp/index/ReaderSlice;)V", "getSubTerms", "()[Lorg/gnit/lucenekmp/index/Terms;", "[Lorg/gnit/lucenekmp/index/Terms;", "getSubSlices", "()[Lorg/gnit/lucenekmp/index/ReaderSlice;", "[Lorg/gnit/lucenekmp/index/ReaderSlice;", "hasFreqs", "", "hasOffsets", "hasPositions", "hasPayloads", "intersect", "Lorg/gnit/lucenekmp/index/TermsEnum;", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "startTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "min", "getMin", "()Lorg/gnit/lucenekmp/util/BytesRef;", "max", "getMax", "iterator", "size", "", "sumTotalTermFreq", "getSumTotalTermFreq", "()J", "sumDocFreq", "getSumDocFreq", "docCount", "", "getDocCount", "()I", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMultiTerms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTerms.kt\norg/gnit/lucenekmp/index/MultiTerms\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,228:1\n1#2:229\n37#3:230\n36#3,3:231\n37#3:234\n36#3,3:235\n*S KotlinDebug\n*F\n+ 1 MultiTerms.kt\norg/gnit/lucenekmp/index/MultiTerms\n*L\n62#1:230\n62#1:231,3\n105#1:234\n105#1:235,3\n*E\n"})
public final class MultiTerms
extends Terms {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terms[] subTerms;
    @NotNull
    private final ReaderSlice[] subSlices;
    private final boolean hasFreqs;
    private final boolean hasOffsets;
    private final boolean hasPositions;
    private final boolean hasPayloads;

    public MultiTerms(@NotNull Terms[] subTerms, @NotNull ReaderSlice[] subSlices) {
        Intrinsics.checkNotNullParameter((Object)subTerms, (String)"subTerms");
        Intrinsics.checkNotNullParameter((Object)subSlices, (String)"subSlices");
        this.subTerms = subTerms;
        this.subSlices = subSlices;
        if (!(this.subTerms.length > 0)) {
            boolean $i$a$-require-MultiTerms$22 = false;
            String $i$a$-require-MultiTerms$22 = "inefficient: don't use MultiTerms over one sub";
            throw new IllegalArgumentException($i$a$-require-MultiTerms$22.toString());
        }
        boolean _hasFreqs = true;
        boolean _hasOffsets = true;
        boolean _hasPositions = true;
        boolean _hasPayloads = false;
        int n = this.subTerms.length;
        for (int i = 0; i < n; ++i) {
            _hasFreqs &= this.subTerms[i].hasFreqs();
            _hasOffsets &= this.subTerms[i].hasOffsets();
            _hasPositions &= this.subTerms[i].hasPositions();
            _hasPayloads |= this.subTerms[i].hasPayloads();
        }
        this.hasFreqs = _hasFreqs;
        this.hasOffsets = _hasOffsets;
        this.hasPositions = _hasPositions;
        this.hasPayloads = this.hasPositions && _hasPayloads;
    }

    @NotNull
    public final Terms[] getSubTerms() {
        return this.subTerms;
    }

    @NotNull
    public final ReaderSlice[] getSubSlices() {
        return this.subSlices;
    }

    @Override
    @NotNull
    public TermsEnum intersect(@NotNull CompiledAutomaton compiled, @Nullable BytesRef startTerm) throws IOException {
        Intrinsics.checkNotNullParameter((Object)compiled, (String)"compiled");
        List termsEnums = new ArrayList();
        int n = this.subTerms.length;
        for (int i = 0; i < n; ++i) {
            TermsEnum termsEnum = this.subTerms[i].intersect(compiled, startTerm);
            if (termsEnum == null) continue;
            termsEnums.add(new TermsEnumIndex(termsEnum, i));
        }
        if (!((Collection)termsEnums).isEmpty()) {
            Collection $this$toTypedArray$iv = termsEnums;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new MultiTermsEnum(this.subSlices).reset(thisCollection$iv.toArray(new TermsEnumIndex[0]));
        }
        return TermsEnum.Companion.getEMPTY();
    }

    @Override
    @Nullable
    public BytesRef getMin() {
        BytesRef minTerm = null;
        for (Terms terms : this.subTerms) {
            BytesRef term = terms.getMin();
            if (minTerm != null) {
                BytesRef bytesRef = term;
                Intrinsics.checkNotNull((Object)bytesRef);
                if (bytesRef.compareTo(minTerm) >= 0) continue;
            }
            minTerm = term;
        }
        return minTerm;
    }

    @Override
    @Nullable
    public BytesRef getMax() {
        BytesRef maxTerm = null;
        for (Terms terms : this.subTerms) {
            BytesRef term = terms.getMax();
            if (maxTerm != null) {
                BytesRef bytesRef = term;
                Intrinsics.checkNotNull((Object)bytesRef);
                if (bytesRef.compareTo(maxTerm) <= 0) continue;
            }
            maxTerm = term;
        }
        return maxTerm;
    }

    @Override
    @NotNull
    public TermsEnum iterator() throws IOException {
        List termsEnums = new ArrayList();
        int n = this.subTerms.length;
        for (int i = 0; i < n; ++i) {
            TermsEnum termsEnum = this.subTerms[i].iterator();
            if (termsEnum == null) continue;
            termsEnums.add(new TermsEnumIndex(termsEnum, i));
        }
        if (!((Collection)termsEnums).isEmpty()) {
            Collection $this$toTypedArray$iv = termsEnums;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new MultiTermsEnum(this.subSlices).reset(thisCollection$iv.toArray(new TermsEnumIndex[0]));
        }
        return TermsEnum.Companion.getEMPTY();
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long getSumTotalTermFreq() {
        long sum = 0L;
        for (Terms terms : this.subTerms) {
            long v = terms.getSumTotalTermFreq();
            if (!(v != -1L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public long getSumDocFreq() {
        long sum = 0L;
        for (Terms terms : this.subTerms) {
            long v = terms.getSumDocFreq();
            if (!(v != -1L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public int getDocCount() {
        int sum = 0;
        for (Terms terms : this.subTerms) {
            int v = terms.getDocCount();
            if (!(v != -1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public boolean hasFreqs() {
        return this.hasFreqs;
    }

    @Override
    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    @Override
    public boolean hasPositions() {
        return this.hasPositions;
    }

    @Override
    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/MultiTerms$Companion;", "", "<init>", "()V", "getTerms", "Lorg/gnit/lucenekmp/index/Terms;", "r", "Lorg/gnit/lucenekmp/index/IndexReader;", "field", "", "getTermPostingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "flags", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiTerms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTerms.kt\norg/gnit/lucenekmp/index/MultiTerms$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,228:1\n37#2:229\n36#2,3:230\n*S KotlinDebug\n*F\n+ 1 MultiTerms.kt\norg/gnit/lucenekmp/index/MultiTerms$Companion\n*L\n189#1:229\n189#1:230,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Terms getTerms(@NotNull IndexReader r, @Nullable String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            List<LeafReaderContext> leaves = r.leaves();
            if (leaves.size() == 1) {
                LeafReader leafReader = leaves.get(0).reader();
                String string = field;
                Intrinsics.checkNotNull((Object)string);
                return leafReader.terms(string);
            }
            List termsPerLeaf = new ArrayList();
            List slicePerLeaf = new ArrayList();
            int n = ((Collection)leaves).size();
            for (int leafIdx = 0; leafIdx < n; ++leafIdx) {
                LeafReaderContext ctx = leaves.get(leafIdx);
                LeafReader leafReader = ctx.reader();
                String string = field;
                Intrinsics.checkNotNull((Object)string);
                Terms subTerms = leafReader.terms(string);
                if (subTerms == null) continue;
                termsPerLeaf.add(subTerms);
                slicePerLeaf.add(new ReaderSlice(ctx.getDocBase(), r.maxDoc(), leafIdx));
            }
            if (termsPerLeaf.isEmpty()) {
                return null;
            }
            Collection $this$toTypedArray$iv = termsPerLeaf;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = slicePerLeaf;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return new MultiTerms(thisCollection$iv.toArray(new Terms[0]), thisCollection$iv.toArray(new ReaderSlice[0]));
        }

        @Nullable
        public final PostingsEnum getTermPostingsEnum(@NotNull IndexReader r, @NotNull String field, @NotNull BytesRef term) throws IOException {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            return Companion.getTermPostingsEnum(r, field, term, PostingsEnum.Companion.getALL());
        }

        @Nullable
        public final PostingsEnum getTermPostingsEnum(@NotNull IndexReader r, @NotNull String field, @NotNull BytesRef term, int flags) throws IOException {
            TermsEnum termsEnum;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Terms terms = this.getTerms(r, field);
            if (terms != null && (termsEnum = terms.iterator()).seekExact(term)) {
                return termsEnum.postings(null, flags);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

