/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesFieldUpdates;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.SparseFixedBitSet;
import org.gnit.lucenekmp.util.packed.AbstractPagedMutable;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PagedGrowableWriter;
import org.gnit.lucenekmp.util.packed.PagedMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001f B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0014J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\b\u0010\u0015\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates;", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates;", "delGen", "", "field", "", "maxDoc", "", "<init>", "(JLjava/lang/String;I)V", "minValue", "maxValue", "(JLjava/lang/String;JJI)V", "values", "Lorg/gnit/lucenekmp/util/packed/AbstractPagedMutable;", "add", "", "doc", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "docId", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "swap", "i", "j", "grow", "size", "resize", "Lorg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates$Iterator;", "ramBytesUsed", "Iterator", "SingleValueNumericDocValuesFieldUpdates", "core"})
@SourceDebugExtension(value={"SMAP\nNumericDocValuesFieldUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericDocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,216:1\n8#2,2:217\n*S KotlinDebug\n*F\n+ 1 NumericDocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates\n*L\n69#1:217,2\n*E\n"})
public final class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    @NotNull
    private AbstractPagedMutable<?> values;
    private final long minValue;

    public NumericDocValuesFieldUpdates(long delGen, @NotNull String field, int maxDoc) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.25f);
        this.minValue = 0L;
    }

    /*
     * WARNING - void declaration
     */
    public NumericDocValuesFieldUpdates(long delGen, @NotNull String field, long minValue, long maxValue, int maxDoc) {
        void condition$iv;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super(maxDoc, delGen, field, DocValuesType.NUMERIC);
        boolean bl = minValue <= maxValue;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == false) {
            boolean bl2 = false;
            String string = "minValue must be <= maxValue [" + minValue + " > " + maxValue + "]";
            throw new AssertionError((Object)string);
        }
        int bitsPerValue = PackedInts.INSTANCE.unsignedBitsRequired(maxValue - minValue);
        this.values = new PagedMutable(1L, 1024, bitsPerValue, 0.25f);
        this.minValue = minValue;
    }

    @Override
    public void add(int doc, @NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int docId, @NotNull DocValuesFieldUpdates.Iterator iterator2) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        this.add(docId, iterator2.longValue());
    }

    @Override
    public void add(int doc, long value) {
        int add = this.add(doc);
        this.values.set(add, value - this.minValue);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpVal = this.values.get(j);
        this.values.set(j, this.values.get(i));
        this.values.set(i, tmpVal);
    }

    @Override
    protected void grow(int size2) {
        super.grow(size2);
        this.values = this.values.grow(size2);
    }

    @Override
    protected void resize(int size2) {
        super.resize(size2);
        this.values = this.values.resize(size2);
    }

    @Override
    @NotNull
    public Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.getSize(), this.minValue, this.values, this.getDocs(), this.getDelGen());
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + super.ramBytesUsed() + (long)8 + (long)4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates$Iterator;", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$AbstractIterator;", "size", "", "minValue", "", "values", "Lorg/gnit/lucenekmp/util/packed/AbstractPagedMutable;", "docs", "Lorg/gnit/lucenekmp/util/packed/PagedMutable;", "delGen", "<init>", "(IJLorg/gnit/lucenekmp/util/packed/AbstractPagedMutable;Lorg/gnit/lucenekmp/util/packed/PagedMutable;J)V", "value", "longValue", "binaryValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "set", "", "idx", "core"})
    public static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final long minValue;
        @NotNull
        private final AbstractPagedMutable<?> values;
        private long value;

        public Iterator(int size2, long minValue, @NotNull AbstractPagedMutable<?> values2, @NotNull PagedMutable docs, long delGen) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            super(size2, docs, delGen);
            this.minValue = minValue;
            this.values = values2;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        @NotNull
        public BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void set(long idx) {
            this.value = this.values.get(idx) + this.minValue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates$SingleValueNumericDocValuesFieldUpdates;", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates;", "delGen", "", "field", "", "maxDoc", "", "value", "<init>", "(JLjava/lang/String;IJ)V", "bitSet", "Lorg/gnit/lucenekmp/util/BitSet;", "hasNoValue", "hasAtLeastOneValue", "", "longValue", "add", "", "doc", "Lorg/gnit/lucenekmp/util/BytesRef;", "reset", "docId", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "any", "ramBytesUsed", "core"})
    @SourceDebugExtension(value={"SMAP\nNumericDocValuesFieldUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericDocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates$SingleValueNumericDocValuesFieldUpdates\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,216:1\n3#2,8:217\n10#3:225\n*S KotlinDebug\n*F\n+ 1 NumericDocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/NumericDocValuesFieldUpdates$SingleValueNumericDocValuesFieldUpdates\n*L\n146#1:217,8\n146#1:225\n*E\n"})
    public static final class SingleValueNumericDocValuesFieldUpdates
    extends DocValuesFieldUpdates {
        private final long value;
        @NotNull
        private final BitSet bitSet;
        @Nullable
        private BitSet hasNoValue;
        private boolean hasAtLeastOneValue;

        public SingleValueNumericDocValuesFieldUpdates(long delGen, @NotNull String field, int maxDoc, long value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            super(maxDoc, delGen, field, DocValuesType.NUMERIC);
            this.value = value;
            this.bitSet = new SparseFixedBitSet(maxDoc);
        }

        public final long longValue() {
            return this.value;
        }

        @Override
        public void add(int doc, long value) {
            boolean condition$iv = this.value == value;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue != null) {
                BitSet bitSet = this.hasNoValue;
                Intrinsics.checkNotNull((Object)bitSet);
                bitSet.clear(doc);
            }
        }

        @Override
        public void add(int doc, @NotNull BytesRef value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset(int doc) {
            this.bitSet.set(doc);
            this.hasAtLeastOneValue = true;
            if (this.hasNoValue == null) {
                this.hasNoValue = new SparseFixedBitSet(this.getMaxDoc());
            }
            BitSet bitSet = this.hasNoValue;
            Intrinsics.checkNotNull((Object)bitSet);
            bitSet.set(doc);
        }

        @Override
        public void add(int docId, @NotNull DocValuesFieldUpdates.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean any() {
            return super.any() || this.hasAtLeastOneValue;
        }

        @Override
        public long ramBytesUsed() {
            long l;
            long l2 = super.ramBytesUsed() + this.bitSet.ramBytesUsed();
            if (this.hasNoValue == null) {
                l = 0L;
            } else {
                BitSet bitSet = this.hasNoValue;
                Intrinsics.checkNotNull((Object)bitSet);
                l = bitSet.ramBytesUsed();
            }
            return l2 + l;
        }

        @Override
        @NotNull
        public DocValuesFieldUpdates.Iterator iterator() {
            BitSetIterator iterator2 = new BitSetIterator(this.bitSet, this.getMaxDoc());
            return new DocValuesFieldUpdates.Iterator(iterator2, this){
                final /* synthetic */ BitSetIterator $iterator;
                final /* synthetic */ SingleValueNumericDocValuesFieldUpdates this$0;
                {
                    this.$iterator = $iterator;
                    this.this$0 = $receiver;
                }

                public int docID() {
                    return this.$iterator.docID();
                }

                public int nextDoc() {
                    return this.$iterator.nextDoc();
                }

                public long longValue() {
                    return SingleValueNumericDocValuesFieldUpdates.access$getValue$p(this.this$0);
                }

                public BytesRef binaryValue() {
                    throw new UnsupportedOperationException();
                }

                public long delGen() {
                    return this.this$0.getDelGen();
                }

                public boolean hasValue() {
                    if (SingleValueNumericDocValuesFieldUpdates.access$getHasNoValue$p(this.this$0) != null) {
                        BitSet bitSet = SingleValueNumericDocValuesFieldUpdates.access$getHasNoValue$p(this.this$0);
                        Intrinsics.checkNotNull((Object)bitSet);
                        return !bitSet.get(this.docID());
                    }
                    return true;
                }
            };
        }

        public static final /* synthetic */ long access$getValue$p(SingleValueNumericDocValuesFieldUpdates $this) {
            return $this.value;
        }

        public static final /* synthetic */ BitSet access$getHasNoValue$p(SingleValueNumericDocValuesFieldUpdates $this) {
            return $this.hasNoValue;
        }
    }
}

