/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.TermsEnumIndex;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.Accountables;
import org.gnit.lucenekmp.util.InPlaceMergeSorter;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u0003./0B1\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010J\u000e\u0010)\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0010J\b\u0010\"\u001a\u00020\u0010H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001b\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/index/OrdinalMap;", "Lorg/gnit/lucenekmp/util/Accountable;", "owner", "Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;", "subs", "", "Lorg/gnit/lucenekmp/index/TermsEnum;", "segmentMap", "Lorg/gnit/lucenekmp/index/OrdinalMap$SegmentMap;", "acceptableOverheadRatio", "", "<init>", "(Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;[Lorg/gnit/lucenekmp/index/TermsEnum;Lorg/gnit/lucenekmp/index/OrdinalMap$SegmentMap;F)V", "getOwner", "()Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;", "valueCount", "", "getValueCount", "()J", "globalOrdDeltas", "Lorg/gnit/lucenekmp/util/LongValues;", "getGlobalOrdDeltas", "()Lorg/gnit/lucenekmp/util/LongValues;", "setGlobalOrdDeltas", "(Lorg/gnit/lucenekmp/util/LongValues;)V", "firstSegments", "getFirstSegments", "setFirstSegments", "segmentToGlobalOrds", "getSegmentToGlobalOrds", "()[Lorg/gnit/lucenekmp/util/LongValues;", "[Lorg/gnit/lucenekmp/util/LongValues;", "getSegmentMap", "()Lorg/gnit/lucenekmp/index/OrdinalMap$SegmentMap;", "ramBytesUsed", "getRamBytesUsed", "getGlobalOrds", "segmentIndex", "", "getFirstSegmentOrd", "globalOrd", "getFirstSegmentNumber", "childResources", "", "getChildResources", "()Ljava/util/Collection;", "TermsEnumPriorityQueue", "SegmentMap", "Companion", "core"})
public final class OrdinalMap
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IndexReader.CacheKey owner;
    private final long valueCount;
    @NotNull
    private LongValues globalOrdDeltas;
    @NotNull
    private LongValues firstSegments;
    @NotNull
    private final LongValues[] segmentToGlobalOrds;
    @NotNull
    private final SegmentMap segmentMap;
    private final long ramBytesUsed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(OrdinalMap.class));

    private OrdinalMap(IndexReader.CacheKey owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio) {
        this.owner = owner;
        this.segmentMap = segmentMap;
        PackedLongValues.Builder globalOrdDeltas = PackedLongValues.Companion.monotonicBuilder(0.0f);
        PackedLongValues.Builder firstSegments = PackedLongValues.Companion.packedBuilder(0.0f);
        long firstSegmentBits = 0L;
        PackedLongValues.Builder[] ordDeltas = new PackedLongValues.Builder[subs.length];
        int n = ordDeltas.length;
        for (int i = 0; i < n; ++i) {
            ordDeltas[i] = PackedLongValues.Companion.monotonicBuilder(acceptableOverheadRatio);
        }
        long[] ordDeltaBits = new long[subs.length];
        long[] segmentOrds = new long[subs.length];
        TermsEnumPriorityQueue queue2 = new TermsEnumPriorityQueue(subs.length);
        int n2 = subs.length;
        for (int i = 0; i < n2; ++i) {
            TermsEnumIndex sub = new TermsEnumIndex(subs[segmentMap.newToOld(i)], i);
            if (sub.next() == null) continue;
            queue2.add(sub);
        }
        TermsEnumIndex.TermState topState = new TermsEnumIndex.TermState();
        long globalOrd = 0L;
        while (queue2.size() != 0) {
            long segmentOrd;
            TermsEnumIndex top = (TermsEnumIndex)queue2.top();
            topState.copyFrom(top);
            int firstSegmentIndex = Integer.MAX_VALUE;
            long globalOrdDelta = Long.MAX_VALUE;
            do {
                TermsEnum termsEnum = top.getTermsEnum();
                Intrinsics.checkNotNull((Object)termsEnum);
                segmentOrd = termsEnum.ord();
                long delta = globalOrd - segmentOrd;
                int segmentIndex = top.getSubIndex();
                if (segmentIndex < firstSegmentIndex) {
                    firstSegmentIndex = segmentIndex;
                    globalOrdDelta = delta;
                }
                ordDeltaBits[segmentIndex] = ordDeltaBits[segmentIndex] | delta;
                if (!(segmentOrds[segmentIndex] <= segmentOrd)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                do {
                    PackedLongValues.Builder builder = ordDeltas[segmentIndex];
                    Intrinsics.checkNotNull((Object)builder);
                    builder.add(delta);
                    long l = segmentOrds[segmentIndex];
                    segmentOrds[segmentIndex] = l + 1L;
                } while (segmentOrds[segmentIndex] <= segmentOrd);
                if (top.next() == null) {
                    queue2.pop();
                    if (queue2.size() == 0) break;
                    top = (TermsEnumIndex)queue2.top();
                    continue;
                }
                top = (TermsEnumIndex)queue2.updateTop();
            } while (top.termEquals(topState));
            firstSegments.add(firstSegmentIndex);
            firstSegmentBits |= (long)firstSegmentIndex;
            globalOrdDeltas.add(globalOrdDelta);
            segmentOrd = globalOrd;
            globalOrd = segmentOrd + 1L;
        }
        long ramBytesUsed = BASE_RAM_BYTES_USED + segmentMap.ramBytesUsed();
        this.valueCount = globalOrd;
        if (ordDeltaBits.length > 0 && ordDeltaBits[0] == 0L && firstSegmentBits == 0L) {
            this.firstSegments = LongValues.Companion.getZEROES();
            this.globalOrdDeltas = LongValues.Companion.getZEROES();
        } else {
            PackedLongValues packedFirstSegments = firstSegments.build();
            PackedLongValues packedGlobalOrdDeltas = globalOrdDeltas.build();
            this.firstSegments = packedFirstSegments;
            this.globalOrdDeltas = packedGlobalOrdDeltas;
            ramBytesUsed += packedFirstSegments.ramBytesUsed() + packedGlobalOrdDeltas.ramBytesUsed();
        }
        this.segmentToGlobalOrds = new LongValues[subs.length];
        ramBytesUsed += RamUsageEstimator.Companion.shallowSizeOf((Object)this.segmentToGlobalOrds);
        int n3 = ordDeltas.length;
        for (int i = 0; i < n3; ++i) {
            PackedLongValues.Builder builder = ordDeltas[i];
            Intrinsics.checkNotNull((Object)builder);
            final PackedLongValues deltas = builder.build();
            if (ordDeltaBits[i] == 0L) {
                this.segmentToGlobalOrds[i] = LongValues.Companion.getIDENTITY();
                continue;
            }
            int bitsRequired = ordDeltaBits[i] < 0L ? 64 : PackedInts.INSTANCE.bitsRequired(ordDeltaBits[i]);
            long monotonicBits = deltas.ramBytesUsed() * (long)8;
            long packedBits = (long)bitsRequired * deltas.size();
            if (deltas.size() <= Integer.MAX_VALUE && (float)packedBits <= (float)monotonicBits * (1.0f + acceptableOverheadRatio)) {
                int size2 = (Integer)deltas.size();
                final PackedInts.Mutable newDeltas = PackedInts.INSTANCE.getMutable(size2, bitsRequired, acceptableOverheadRatio);
                PackedLongValues.Iterator it = deltas.iterator();
                for (int ord = 0; ord < size2; ++ord) {
                    newDeltas.set(ord, it.next());
                }
                if (!(!it.hasNext())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + newDeltas.get((int)ord);
                    }
                };
                ramBytesUsed += newDeltas.ramBytesUsed();
            } else {
                this.segmentToGlobalOrds[i] = new LongValues(){

                    @Override
                    public long get(long ord) {
                        return ord + deltas.get(ord);
                    }
                };
                ramBytesUsed += deltas.ramBytesUsed();
            }
            ramBytesUsed += RamUsageEstimator.Companion.shallowSizeOf(this.segmentToGlobalOrds[i]);
        }
        this.ramBytesUsed = ramBytesUsed;
    }

    @Nullable
    public final IndexReader.CacheKey getOwner() {
        return this.owner;
    }

    public final long getValueCount() {
        return this.valueCount;
    }

    @NotNull
    public final LongValues getGlobalOrdDeltas() {
        return this.globalOrdDeltas;
    }

    public final void setGlobalOrdDeltas(@NotNull LongValues longValues) {
        Intrinsics.checkNotNullParameter((Object)longValues, (String)"<set-?>");
        this.globalOrdDeltas = longValues;
    }

    @NotNull
    public final LongValues getFirstSegments() {
        return this.firstSegments;
    }

    public final void setFirstSegments(@NotNull LongValues longValues) {
        Intrinsics.checkNotNullParameter((Object)longValues, (String)"<set-?>");
        this.firstSegments = longValues;
    }

    @NotNull
    public final LongValues[] getSegmentToGlobalOrds() {
        return this.segmentToGlobalOrds;
    }

    @NotNull
    public final SegmentMap getSegmentMap() {
        return this.segmentMap;
    }

    public final long getRamBytesUsed() {
        return this.ramBytesUsed;
    }

    @NotNull
    public final LongValues getGlobalOrds(int segmentIndex) {
        LongValues longValues = this.segmentToGlobalOrds[this.segmentMap.oldToNew(segmentIndex)];
        Intrinsics.checkNotNull((Object)longValues);
        return longValues;
    }

    public final long getFirstSegmentOrd(long globalOrd) {
        return globalOrd - this.globalOrdDeltas.get(globalOrd);
    }

    public final int getFirstSegmentNumber(long globalOrd) {
        return this.segmentMap.newToOld((Integer)this.firstSegments.get(globalOrd));
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        List resources = new ArrayList();
        resources.add(Accountables.INSTANCE.namedAccountable("segment map", this.segmentMap));
        return resources;
    }

    public /* synthetic */ OrdinalMap(IndexReader.CacheKey owner, TermsEnum[] subs, SegmentMap segmentMap, float acceptableOverheadRatio, DefaultConstructorMarker $constructor_marker) {
        this(owner, subs, segmentMap, acceptableOverheadRatio);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ+\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/OrdinalMap$Companion;", "", "<init>", "()V", "build", "Lorg/gnit/lucenekmp/index/OrdinalMap;", "owner", "Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;", "values", "", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "acceptableOverheadRatio", "", "(Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;[Lorg/gnit/lucenekmp/index/SortedDocValues;F)Lorg/gnit/lucenekmp/index/OrdinalMap;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "(Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;[Lorg/gnit/lucenekmp/index/SortedSetDocValues;F)Lorg/gnit/lucenekmp/index/OrdinalMap;", "subs", "Lorg/gnit/lucenekmp/index/TermsEnum;", "weights", "", "(Lorg/gnit/lucenekmp/index/IndexReader$CacheKey;[Lorg/gnit/lucenekmp/index/TermsEnum;[JF)Lorg/gnit/lucenekmp/index/OrdinalMap;", "BASE_RAM_BYTES_USED", "", "core"})
    @SourceDebugExtension(value={"SMAP\nOrdinalMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrdinalMap.kt\norg/gnit/lucenekmp/index/OrdinalMap$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OrdinalMap build(@Nullable IndexReader.CacheKey owner, @NotNull SortedDocValues[] values2, float acceptableOverheadRatio) throws IOException {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            TermsEnum[] subs = new TermsEnum[values2.length];
            long[] weights = new long[values2.length];
            int n = values2.length;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNull((Object)values2[i].termsEnum());
                weights[i] = values2[i].getValueCount();
            }
            return this.build(owner, subs, weights, acceptableOverheadRatio);
        }

        @NotNull
        public final OrdinalMap build(@Nullable IndexReader.CacheKey owner, @NotNull SortedSetDocValues[] values2, float acceptableOverheadRatio) throws IOException {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            TermsEnum[] subs = new TermsEnum[values2.length];
            long[] weights = new long[values2.length];
            int n = values2.length;
            for (int i = 0; i < n; ++i) {
                subs[i] = values2[i].termsEnum();
                weights[i] = values2[i].getValueCount();
            }
            return this.build(owner, subs, weights, acceptableOverheadRatio);
        }

        @NotNull
        public final OrdinalMap build(@Nullable IndexReader.CacheKey owner, @NotNull TermsEnum[] subs, @NotNull long[] weights, float acceptableOverheadRatio) throws IOException {
            Intrinsics.checkNotNullParameter((Object)subs, (String)"subs");
            Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
            if (!(subs.length == weights.length)) {
                boolean bl = false;
                String string = "subs and weights must have the same length";
                throw new IllegalArgumentException(string.toString());
            }
            SegmentMap segmentMap = new SegmentMap(weights);
            return new OrdinalMap(owner, subs, segmentMap, acceptableOverheadRatio, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/OrdinalMap$SegmentMap;", "Lorg/gnit/lucenekmp/util/Accountable;", "weights", "", "<init>", "([J)V", "newToOld", "", "oldToNew", "", "segment", "ramBytesUsed", "", "Companion", "core"})
    public static final class SegmentMap
    implements Accountable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final int[] newToOld;
        @NotNull
        private final int[] oldToNew;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(SegmentMap.class));

        public SegmentMap(@NotNull long[] weights) {
            Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
            this.newToOld = SegmentMap.Companion.map(weights);
            this.oldToNew = SegmentMap.Companion.inverse(this.newToOld);
            if (!Arrays.equals(this.newToOld, SegmentMap.Companion.inverse(this.oldToNew))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int newToOld(int segment) {
            return this.newToOld[segment];
        }

        public final int oldToNew(int segment) {
            return this.oldToNew[segment];
        }

        @Override
        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.newToOld) + RamUsageEstimator.Companion.sizeOf(this.oldToNew);
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return Accountable.super.getChildResources();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/index/OrdinalMap$SegmentMap$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "map", "", "weights", "", "inverse", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final int[] map(long[] weights) {
                int[] newToOld = new int[weights.length];
                int n = weights.length;
                for (int i = 0; i < n; ++i) {
                    newToOld[i] = i;
                }
                new InPlaceMergeSorter(newToOld, weights){
                    final /* synthetic */ int[] $newToOld;
                    final /* synthetic */ long[] $weights;
                    {
                        this.$newToOld = $newToOld;
                        this.$weights = $weights;
                    }

                    protected void swap(int i, int j) {
                        int tmp = this.$newToOld[i];
                        this.$newToOld[i] = this.$newToOld[j];
                        this.$newToOld[j] = tmp;
                    }

                    protected int compare(int i, int j) {
                        return LongExtKt.compare(LongCompanionObject.INSTANCE, this.$weights[this.$newToOld[j]], this.$weights[this.$newToOld[i]]);
                    }
                }.sort(0, weights.length);
                return newToOld;
            }

            private final int[] inverse(int[] map2) {
                int[] inverse = new int[map2.length];
                int n = map2.length;
                for (int i = 0; i < n; ++i) {
                    inverse[map2[i]] = i;
                }
                return inverse;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/index/OrdinalMap$TermsEnumPriorityQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "size", "", "<init>", "(I)V", "lessThan", "", "a", "b", "core"})
    private static final class TermsEnumPriorityQueue
    extends PriorityQueue<TermsEnumIndex> {
        public TermsEnumPriorityQueue(int size2) {
            super(size2, null, 2, null);
        }

        @Override
        public boolean lessThan(@NotNull TermsEnumIndex a, @NotNull TermsEnumIndex b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.compareTermTo(b) < 0;
        }
    }
}

