/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\u0000J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "", "size", "", "<init>", "(I)V", "getSize", "()I", "textStarts", "", "getTextStarts", "()[I", "addressOffset", "getAddressOffset", "byteStarts", "getByteStarts", "bytesPerPosting", "newInstance", "grow", "copyTo", "", "toArray", "numToCopy", "Companion", "core"})
public class ParallelPostingsArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final int[] textStarts;
    @NotNull
    private final int[] addressOffset;
    @NotNull
    private final int[] byteStarts;
    public static final int BYTES_PER_POSTING = 12;

    public ParallelPostingsArray(int size2) {
        this.size = size2;
        this.textStarts = new int[this.size];
        this.addressOffset = new int[this.size];
        this.byteStarts = new int[this.size];
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final int[] getTextStarts() {
        return this.textStarts;
    }

    @NotNull
    public final int[] getAddressOffset() {
        return this.addressOffset;
    }

    @NotNull
    public final int[] getByteStarts() {
        return this.byteStarts;
    }

    public int bytesPerPosting() {
        return 12;
    }

    @NotNull
    public ParallelPostingsArray newInstance(int size2) {
        return new ParallelPostingsArray(size2);
    }

    @NotNull
    public final ParallelPostingsArray grow() {
        int newSize = ArrayUtil.Companion.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray newArray = this.newInstance(newSize);
        this.copyTo(newArray, this.size);
        return newArray;
    }

    public void copyTo(@NotNull ParallelPostingsArray toArray, int numToCopy) {
        Intrinsics.checkNotNullParameter((Object)toArray, (String)"toArray");
        System.INSTANCE.arraycopy(this.textStarts, 0, toArray.textStarts, 0, numToCopy);
        System.INSTANCE.arraycopy(this.addressOffset, 0, toArray.addressOffset, 0, numToCopy);
        System.INSTANCE.arraycopy(this.byteStarts, 0, toArray.byteStarts, 0, numToCopy);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/ParallelPostingsArray$Companion;", "", "<init>", "()V", "BYTES_PER_POSTING", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

