/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.DocValuesFieldUpdates;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.TrackingDirectoryWrapper;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0016H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\n\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0016H\u0002J\b\u0010.\u001a\u00020(H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0016J\u0016\u00104\u001a\u00020\u00072\f\u00105\u001a\b\u0012\u0004\u0012\u00020)06H\u0016J\u0018\u00107\u001a\u00020(2\u0006\u0010\u0002\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020=2\f\u00105\u001a\b\u0012\u0004\u0012\u00020)06H\u0016J\u000e\u0010>\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020)J\u0006\u0010A\u001a\u00020\u0016J\u000e\u0010B\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020)J\b\u0010C\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010$\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0011\u0010?\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0018\u00a8\u0006D"}, d2={"Lorg/gnit/lucenekmp/index/PendingDeletes;", "", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "initialLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "liveDocsInitialized", "", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentCommitInfo;Lorg/gnit/lucenekmp/util/Bits;Z)V", "reader", "Lorg/gnit/lucenekmp/index/SegmentReader;", "(Lorg/gnit/lucenekmp/index/SegmentReader;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "getInfo", "()Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "value", "liveDocs", "getLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "writeableLiveDocs", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "pendingDeleteCount", "", "getPendingDeleteCount", "()I", "setPendingDeleteCount", "(I)V", "getLiveDocsInitialized", "()Z", "setLiveDocsInitialized", "(Z)V", "mutableBits", "getMutableBits", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "delete", "docID", "hardLiveDocs", "getHardLiveDocs", "numPendingDeletes", "onNewReader", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "assertCheckLiveDocs", "bits", "expectedLength", "expectedDeleteCount", "dropChanges", "toString", "", "writeLiveDocs", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "isFullyDeleted", "readerIOSupplier", "Lorg/gnit/lucenekmp/util/IOSupplier;", "onDocValuesUpdate", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "numDeletesToMerge", "policy", "Lorg/gnit/lucenekmp/index/MergePolicy;", "needsRefresh", "delCount", "getDelCount", "numDocs", "verifyDocCounts", "mustInitOnDelete", "core"})
@SourceDebugExtension(value={"SMAP\nPendingDeletes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingDeletes.kt\norg/gnit/lucenekmp/index/PendingDeletes\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,317:1\n8#2,2:318\n3#2,8:320\n8#2,2:329\n3#2,8:331\n8#2,2:340\n3#2,8:342\n3#2,8:351\n8#2,2:360\n3#2,8:362\n8#2,2:371\n8#2,2:373\n8#2,2:375\n10#3:328\n10#3:339\n10#3:350\n10#3:359\n10#3:370\n*S KotlinDebug\n*F\n+ 1 PendingDeletes.kt\norg/gnit/lucenekmp/index/PendingDeletes\n*L\n54#1:318,2\n77#1:320,8\n79#1:329,2\n113#1:331,8\n118#1:340,2\n120#1:342,8\n134#1:351,8\n141#1:360,2\n169#1:362,8\n274#1:371,2\n290#1:373,2\n293#1:375,2\n77#1:328\n113#1:339\n120#1:350\n134#1:359\n169#1:370\n*E\n"})
public class PendingDeletes {
    @NotNull
    private final SegmentCommitInfo info;
    @Nullable
    private Bits liveDocs;
    @Nullable
    private FixedBitSet writeableLiveDocs;
    private int pendingDeleteCount;
    private boolean liveDocsInitialized;

    public PendingDeletes(@NotNull SegmentCommitInfo info, @Nullable Bits initialLiveDocs, boolean liveDocsInitialized) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        this.liveDocs = initialLiveDocs;
        this.pendingDeleteCount = 0;
        this.liveDocsInitialized = liveDocsInitialized;
    }

    public /* synthetic */ PendingDeletes(SegmentCommitInfo segmentCommitInfo, Bits bits, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bits = null;
        }
        if ((n & 4) != 0) {
            bl = !segmentCommitInfo.hasDeletions();
        }
        this(segmentCommitInfo, bits, bl);
    }

    @NotNull
    public final SegmentCommitInfo getInfo() {
        return this.info;
    }

    @Nullable
    public final Bits getLiveDocs() {
        this.writeableLiveDocs = null;
        return this.liveDocs;
    }

    protected final int getPendingDeleteCount() {
        return this.pendingDeleteCount;
    }

    protected final void setPendingDeleteCount(int n) {
        this.pendingDeleteCount = n;
    }

    public final boolean getLiveDocsInitialized() {
        return this.liveDocsInitialized;
    }

    public final void setLiveDocsInitialized(boolean bl) {
        this.liveDocsInitialized = bl;
    }

    public PendingDeletes(@NotNull SegmentReader reader2, @NotNull SegmentCommitInfo info) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this(info, reader2.getLiveDocs(), true);
        this.pendingDeleteCount = reader2.numDeletedDocs() - info.getDelCount();
    }

    @NotNull
    protected final FixedBitSet getMutableBits() {
        boolean condition$iv = this.liveDocsInitialized;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "can't delete if liveDocs are not initialized";
            throw new AssertionError((Object)string);
        }
        if (this.writeableLiveDocs == null) {
            if (this.getLiveDocs() != null) {
                Bits bits = this.getLiveDocs();
                Intrinsics.checkNotNull((Object)bits);
                this.writeableLiveDocs = FixedBitSet.Companion.copyOf(bits);
            } else {
                FixedBitSet fixedBitSet = this.writeableLiveDocs = new FixedBitSet(this.info.getInfo().maxDoc());
                Intrinsics.checkNotNull((Object)fixedBitSet);
                fixedBitSet.set(0, this.info.getInfo().maxDoc());
            }
            FixedBitSet fixedBitSet = this.writeableLiveDocs;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            this.liveDocs = fixedBitSet.asReadOnlyBits();
        }
        FixedBitSet fixedBitSet = this.writeableLiveDocs;
        Intrinsics.checkNotNull((Object)fixedBitSet);
        return fixedBitSet;
    }

    public boolean delete(int docID) throws IOException {
        boolean condition$iv = this.info.getInfo().maxDoc() > 0;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        FixedBitSet fixedBitSet = this.getMutableBits();
        if (fixedBitSet == null) {
            String $i$f$assert2 = "Required value was null.";
            throw new IllegalStateException($i$f$assert2.toString());
        }
        FixedBitSet mutableBits = fixedBitSet;
        boolean condition$iv2 = docID >= 0 && docID < mutableBits.length();
        $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean bl = false;
            String string = "out of bounds: docid=" + docID + " liveDocsLength=" + mutableBits.length() + " seg=" + this.info.getInfo().getName() + " maxDoc=" + this.info.getInfo().maxDoc();
            throw new AssertionError((Object)string);
        }
        boolean didDelete = mutableBits.getAndClear(docID);
        if (didDelete) {
            int n = this.pendingDeleteCount;
            this.pendingDeleteCount = n + 1;
        }
        return didDelete;
    }

    @Nullable
    public Bits getHardLiveDocs() {
        return this.getLiveDocs();
    }

    public int numPendingDeletes() {
        return this.pendingDeleteCount;
    }

    /*
     * Unable to fully structure code
     */
    public void onNewReader(@NotNull CodecReader reader, @NotNull SegmentCommitInfo info) throws IOException {
        block5: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (this.liveDocsInitialized) break block5;
                condition$iv = this.writeableLiveDocs == null;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                if (!reader.hasDeletions()) break block6;
                condition$iv = this.pendingDeleteCount == 0;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-PendingDeletes$onNewReader$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "pendingDeleteCount: " + this.pendingDeleteCount;
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                this.liveDocs = reader.getLiveDocs();
                if (this.getLiveDocs() == null) ** GOTO lbl-1000
                v0 = this.getLiveDocs();
                Intrinsics.checkNotNull((Object)v0);
                if (this.assertCheckLiveDocs(v0, info.getInfo().maxDoc(), info.getDelCount())) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                condition$iv = v1;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    var6_9 = "assertion failed";
                    throw new AssertionError((Object)var6_9);
                }
            }
            this.liveDocsInitialized = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean assertCheckLiveDocs(Bits bits, int expectedLength, int expectedDeleteCount) {
        void condition$iv;
        int i;
        boolean condition$iv2 = bits.length() == expectedLength;
        int $i$f$assert = 0;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        int deletedCount = 0;
        $i$f$assert = bits.length();
        for (i = 0; i < $i$f$assert; ++i) {
            if (bits.get(i)) continue;
            int $i$a$-assert-AssertKt$assert$22 = deletedCount;
            deletedCount = $i$a$-assert-AssertKt$assert$22 + 1;
        }
        i = deletedCount == expectedDeleteCount ? 1 : 0;
        $i$f$assert = 0;
        if (_Assertions.ENABLED && condition$iv == false) {
            boolean bl = false;
            String string = "deleted: " + deletedCount + " != expected: " + expectedDeleteCount;
            throw new AssertionError((Object)string);
        }
        return true;
    }

    public void dropChanges() {
        this.pendingDeleteCount = 0;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingDeletes(seg=").append(this.info);
        sb.append(" numPendingDeletes=").append(this.pendingDeleteCount);
        sb.append(" writeable=").append(this.writeableLiveDocs != null);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeLiveDocs(@NotNull Directory dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.pendingDeleteCount == 0) {
            return false;
        }
        Bits bits = this.getLiveDocs();
        if (bits == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Bits liveDocs2 = bits;
        boolean condition$iv = liveDocs2.length() == this.info.getInfo().maxDoc();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(dir);
        boolean success = false;
        try {
            Codec codec = this.info.getInfo().getCodec();
            codec.liveDocsFormat().writeLiveDocs(liveDocs2, trackingDir, this.info, this.pendingDeleteCount, IOContext.Companion.getDEFAULT());
            success = true;
        }
        catch (Throwable throwable) {
            this.info.advanceNextWriteDelGen();
            for (String fileName : trackingDir.getCreatedFiles()) {
                String[] stringArray = new String[]{fileName};
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(dir, stringArray);
            }
            throw throwable;
        }
        this.info.advanceDelGen();
        SegmentCommitInfo segmentCommitInfo = this.info;
        segmentCommitInfo.setDelCount(segmentCommitInfo.getDelCount() + this.pendingDeleteCount);
        this.dropChanges();
        return true;
    }

    public boolean isFullyDeleted(@NotNull IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        Intrinsics.checkNotNullParameter(readerIOSupplier, (String)"readerIOSupplier");
        return this.getDelCount() == this.info.getInfo().maxDoc();
    }

    public void onDocValuesUpdate(@NotNull FieldInfo info, @NotNull DocValuesFieldUpdates.Iterator iterator2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
    }

    public int numDeletesToMerge(@NotNull MergePolicy policy, @NotNull IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter(readerIOSupplier, (String)"readerIOSupplier");
        return policy.numDeletesToMerge(this.info, this.getDelCount(), readerIOSupplier);
    }

    public final boolean needsRefresh(@NotNull CodecReader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        return reader2.getLiveDocs() != this.getLiveDocs() || reader2.numDeletedDocs() != this.getDelCount();
    }

    public final int getDelCount() {
        int delCount = this.info.getDelCount() + this.info.getSoftDelCount() + this.numPendingDeletes();
        return delCount;
    }

    public final int numDocs() {
        return this.info.getInfo().maxDoc() - this.getDelCount();
    }

    public final boolean verifyDocCounts(@NotNull CodecReader reader2) {
        boolean condition$iv;
        int docID;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        int count = 0;
        Bits liveDocs2 = this.getLiveDocs();
        if (liveDocs2 != null) {
            int n = this.info.getInfo().maxDoc();
            for (docID = 0; docID < n; ++docID) {
                if (!liveDocs2.get(docID)) continue;
                int n2 = count;
                count = n2 + 1;
            }
        } else {
            count = this.info.getInfo().maxDoc();
        }
        docID = this.numDocs() == count ? 1 : 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "info.maxDoc=" + this.info.getInfo().maxDoc() + " info.delCount=" + this.info.getDelCount() + " info.getSoftDelCount()=" + this.info.getSoftDelCount() + " pendingDeletes=" + this + " count=" + count + " numDocs: " + this.numDocs();
            throw new AssertionError((Object)string);
        }
        condition$iv = reader2.numDocs() == this.numDocs();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "reader.numDocs() = " + reader2.numDocs() + " numDocs() " + this.numDocs();
            throw new AssertionError((Object)string);
        }
        condition$iv = reader2.numDeletedDocs() <= this.info.getInfo().maxDoc();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "delCount=" + reader2.numDeletedDocs() + " info.maxDoc=" + this.info.getInfo().maxDoc() + " rld.pendingDeleteCount=" + this.numPendingDeletes() + " info.delCount=" + this.info.getDelCount();
            throw new AssertionError((Object)string);
        }
        return true;
    }

    public boolean mustInitOnDelete() {
        return false;
    }
}

