/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IntsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\b&\u0018\u0000 #2\u00020\u0001:\u0004 !\"#B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u001d\u001a\u00020\rH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0012\u0010\u001b\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0012\u0010\u001e\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/index/PointValues;", "", "<init>", "()V", "pointTree", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "getPointTree", "()Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "intersect", "", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "estimatePointCount", "", "estimateDocCount", "minPackedValue", "", "getMinPackedValue", "()[B", "maxPackedValue", "getMaxPackedValue", "numDimensions", "", "getNumDimensions", "()I", "numIndexDimensions", "getNumIndexDimensions", "bytesPerDimension", "getBytesPerDimension", "size", "docCount", "getDocCount", "Relation", "PointTree", "IntersectVisitor", "Companion", "core"})
public abstract class PointValues {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_NUM_BYTES = 16;
    private static final int MAX_DIMENSIONS = 16;
    private static final int MAX_INDEX_DIMENSIONS = 8;

    protected PointValues() {
    }

    @NotNull
    public abstract PointTree getPointTree();

    public final void intersect(@NotNull IntersectVisitor visitor2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        PointTree pointTree2 = this.getPointTree();
        this.intersect(visitor2, pointTree2);
        if (!(!pointTree2.moveToParent())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void intersect(IntersectVisitor visitor2, PointTree pointTree2) throws IOException {
        Relation r = visitor2.compare(pointTree2.getMinPackedValue(), pointTree2.getMaxPackedValue());
        switch (WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                pointTree2.visitDocIDs(visitor2);
                break;
            }
            case 3: {
                if (pointTree2.moveToChild()) {
                    do {
                        this.intersect(visitor2, pointTree2);
                    } while (pointTree2.moveToSibling());
                    pointTree2.moveToParent();
                    break;
                }
                pointTree2.visitDocValues(visitor2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final long estimatePointCount(@NotNull IntersectVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        try {
            PointTree pointTree2 = this.getPointTree();
            long count = PointValues.Companion.estimatePointCount(visitor2, pointTree2, Long.MAX_VALUE);
            if (!(!pointTree2.moveToParent())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return count;
        }
        catch (IOException ioe) {
            throw new IOException(ioe.getMessage());
        }
    }

    public final long estimateDocCount(@NotNull IntersectVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        long estimatedPointCount = this.estimatePointCount(visitor2);
        int docCount = this.getDocCount();
        double size2 = this.size();
        if ((double)estimatedPointCount >= size2) {
            return docCount;
        }
        if (size2 == (double)docCount || estimatedPointCount == 0L) {
            return estimatedPointCount;
        }
        long docEstimate = (long)((double)docCount * (1.0 - Math.pow((size2 - (double)estimatedPointCount) / size2, size2 / (double)docCount)));
        return docEstimate == 0L ? 1L : docEstimate;
    }

    @NotNull
    public abstract byte[] getMinPackedValue();

    @NotNull
    public abstract byte[] getMaxPackedValue();

    public abstract int getNumDimensions();

    public abstract int getNumIndexDimensions();

    public abstract int getBytesPerDimension();

    public abstract long size();

    public abstract int getDocCount();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fJ \u0010\u001c\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/index/PointValues$Companion;", "", "<init>", "()V", "MAX_NUM_BYTES", "", "MAX_DIMENSIONS", "getMAX_DIMENSIONS", "()I", "MAX_INDEX_DIMENSIONS", "getMAX_INDEX_DIMENSIONS", "size", "", "reader", "Lorg/gnit/lucenekmp/index/IndexReader;", "field", "", "getDocCount", "getMinPackedValue", "", "getMaxPackedValue", "isEstimatedPointCountGreaterThanOrEqualTo", "", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "pointTree", "Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "upperBound", "estimatePointCount", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_DIMENSIONS() {
            return MAX_DIMENSIONS;
        }

        public final int getMAX_INDEX_DIMENSIONS() {
            return MAX_INDEX_DIMENSIONS;
        }

        public final long size(@NotNull IndexReader reader2, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            long size2 = 0L;
            for (LeafReaderContext ctx : reader2.leaves()) {
                PointValues values2 = ctx.reader().getPointValues(field);
                if (values2 == null) continue;
                size2 += values2.size();
            }
            return size2;
        }

        public final int getDocCount(@NotNull IndexReader reader2, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            int count = 0;
            for (LeafReaderContext ctx : reader2.leaves()) {
                PointValues values2 = ctx.reader().getPointValues(field);
                if (values2 == null) continue;
                count += values2.getDocCount();
            }
            return count;
        }

        @Nullable
        public final byte[] getMinPackedValue(@NotNull IndexReader reader2, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            byte[] minValue = null;
            for (LeafReaderContext ctx : reader2.leaves()) {
                byte[] leafMinValue;
                PointValues values2 = ctx.reader().getPointValues(field);
                if (values2 == null || (leafMinValue = values2.getMinPackedValue()) == null) continue;
                if (minValue == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(leafMinValue, leafMinValue.length), (String)"copyOf(...)");
                    Intrinsics.checkNotNull((Object)minValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    continue;
                }
                int numDimensions = values2.getNumIndexDimensions();
                int numBytesPerDimension = values2.getBytesPerDimension();
                ArrayUtil.Companion.ByteArrayComparator comparator2 = ArrayUtil.Companion.getUnsignedComparator(numBytesPerDimension);
                for (int i = 0; i < numDimensions; ++i) {
                    int offset = i * numBytesPerDimension;
                    if (comparator2.compare(leafMinValue, offset, minValue, offset) >= 0) continue;
                    ArraysKt.copyInto((byte[])leafMinValue, (byte[])minValue, (int)offset, (int)offset, (int)(offset + numBytesPerDimension));
                }
            }
            return minValue;
        }

        @Nullable
        public final byte[] getMaxPackedValue(@NotNull IndexReader reader2, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            byte[] maxValue = null;
            for (LeafReaderContext ctx : reader2.leaves()) {
                byte[] leafMaxValue;
                PointValues values2 = ctx.reader().getPointValues(field);
                if (values2 == null || (leafMaxValue = values2.getMaxPackedValue()) == null) continue;
                if (maxValue == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(leafMaxValue, leafMaxValue.length), (String)"copyOf(...)");
                    Intrinsics.checkNotNull((Object)maxValue, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    continue;
                }
                int numDimensions = values2.getNumIndexDimensions();
                int numBytesPerDimension = values2.getBytesPerDimension();
                ArrayUtil.Companion.ByteArrayComparator comparator2 = ArrayUtil.Companion.getUnsignedComparator(numBytesPerDimension);
                for (int i = 0; i < numDimensions; ++i) {
                    int offset = i * numBytesPerDimension;
                    if (comparator2.compare(leafMaxValue, offset, maxValue, offset) <= 0) continue;
                    ArraysKt.copyInto((byte[])leafMaxValue, (byte[])maxValue, (int)offset, (int)offset, (int)(offset + numBytesPerDimension));
                }
            }
            return maxValue;
        }

        public final boolean isEstimatedPointCountGreaterThanOrEqualTo(@NotNull IntersectVisitor visitor2, @NotNull PointTree pointTree2, long upperBound) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)pointTree2, (String)"pointTree");
            return this.estimatePointCount(visitor2, pointTree2, upperBound) >= upperBound;
        }

        private final long estimatePointCount(IntersectVisitor visitor2, PointTree pointTree2, long upperBound) throws IOException {
            Relation r = visitor2.compare(pointTree2.getMinPackedValue(), pointTree2.getMaxPackedValue());
            switch (WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
                case 1: {
                    return 0L;
                }
                case 2: {
                    return pointTree2.size();
                }
                case 3: {
                    if (pointTree2.moveToChild()) {
                        long cost = 0L;
                        while ((cost += this.estimatePointCount(visitor2, pointTree2, upperBound - cost)) < upperBound && pointTree2.moveToSibling()) {
                        }
                        pointTree2.moveToParent();
                        return cost;
                    }
                    return (pointTree2.size() + 1L) / (long)2;
                }
            }
            throw new IllegalArgumentException("Unreachable code");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Relation.values().length];
                try {
                    nArray[Relation.CELL_OUTSIDE_QUERY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Relation.CELL_INSIDE_QUERY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Relation.CELL_CROSSES_QUERY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH&J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "", "visit", "", "docID", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "ref", "Lorg/gnit/lucenekmp/util/IntsRef;", "packedValue", "", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "grow", "count", "core"})
    @SourceDebugExtension(value={"SMAP\nPointValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointValues.kt\norg/gnit/lucenekmp/index/PointValues$IntersectVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,486:1\n1#2:487\n*E\n"})
    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        default public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            int docID = 0;
            while (true) {
                int n;
                int it = n = iterator2.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                this.visit(docID);
            }
        }

        default public void visit(@NotNull IntsRef ref) throws IOException {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            int n = ref.getLength() + ref.getOffset();
            for (int i = ref.getOffset(); i < n; ++i) {
                this.visit(ref.getInts()[i]);
            }
        }

        public void visit(int var1, @NotNull byte[] var2) throws IOException;

        default public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            int docID = 0;
            while (true) {
                int n;
                int it = n = iterator2.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                this.visit(docID, packedValue);
            }
        }

        @NotNull
        public Relation compare(@NotNull byte[] var1, @NotNull byte[] var2);

        default public void grow(int count) {
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void visit(@NotNull IntersectVisitor $this, @NotNull DocIdSetIterator iterator2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                $this.visit(iterator2);
            }

            @Deprecated
            public static void visit(@NotNull IntersectVisitor $this, @NotNull IntsRef ref) throws IOException {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                $this.visit(ref);
            }

            @Deprecated
            public static void visit(@NotNull IntersectVisitor $this, @NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                $this.visit(iterator2, packedValue);
            }

            @Deprecated
            public static void grow(@NotNull IntersectVisitor $this, int count) {
                $this.grow(count);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001J\b\u0010\u0002\u001a\u00020\u0000H&J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0004H&J\b\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/PointValues$PointTree;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "clone", "moveToChild", "", "moveToSibling", "moveToParent", "minPackedValue", "", "getMinPackedValue", "()[B", "maxPackedValue", "getMaxPackedValue", "size", "", "visitDocIDs", "", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "visitDocValues", "core"})
    public static interface PointTree
    extends Cloneable<PointTree> {
        @Override
        @NotNull
        public PointTree clone();

        public boolean moveToChild() throws IOException;

        public boolean moveToSibling() throws IOException;

        public boolean moveToParent() throws IOException;

        @NotNull
        public byte[] getMinPackedValue();

        @NotNull
        public byte[] getMaxPackedValue();

        public long size();

        public void visitDocIDs(@NotNull IntersectVisitor var1) throws IOException;

        public void visitDocValues(@NotNull IntersectVisitor var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/PointValues$Relation;", "", "<init>", "(Ljava/lang/String;I)V", "CELL_INSIDE_QUERY", "CELL_OUTSIDE_QUERY", "CELL_CROSSES_QUERY", "core"})
    public static final class Relation
    extends Enum<Relation> {
        public static final /* enum */ Relation CELL_INSIDE_QUERY = new Relation();
        public static final /* enum */ Relation CELL_OUTSIDE_QUERY = new Relation();
        public static final /* enum */ Relation CELL_CROSSES_QUERY = new Relation();
        private static final /* synthetic */ Relation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Relation[] values() {
            return (Relation[])$VALUES.clone();
        }

        public static Relation valueOf(String value) {
            return Enum.valueOf(Relation.class, value);
        }

        @NotNull
        public static EnumEntries<Relation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = relationArray = new Relation[]{Relation.CELL_INSIDE_QUERY, Relation.CELL_OUTSIDE_QUERY, Relation.CELL_CROSSES_QUERY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Relation.values().length];
            try {
                nArray[Relation.CELL_OUTSIDE_QUERY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Relation.CELL_INSIDE_QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Relation.CELL_CROSSES_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

