/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.FieldTermIterator;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.StringHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u001f\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "Lorg/gnit/lucenekmp/util/Accountable;", "content", "", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "size", "", "<init>", "(Ljava/util/List;J)V", "delGen", "lazyHash", "", "ramBytesUsed", "setDelGen", "", "iterator", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms$TermIterator;", "hashCode", "equals", "", "obj", "", "Builder", "TermIterator", "core"})
@SourceDebugExtension(value={"SMAP\nPrefixCodedTerms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrefixCodedTerms.kt\norg/gnit/lucenekmp/index/PrefixCodedTerms\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class PrefixCodedTerms
implements Accountable {
    @NotNull
    private final List<ByteBuffer> content;
    private final long size;
    private long delGen;
    private int lazyHash;

    private PrefixCodedTerms(List<ByteBuffer> content, long size2) {
        this.content = content;
        this.size = size2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long ramBytesUsed() {
        Iterable iterable = this.content;
        long l = 0L;
        for (Object t : iterable) {
            void buf;
            ByteBuffer byteBuffer = (ByteBuffer)t;
            long l2 = l;
            boolean bl = false;
            long l3 = buf.getCapacity();
            l = l2 + l3;
        }
        return l + (long)16;
    }

    public final void setDelGen(long delGen) {
        this.delGen = delGen;
    }

    @NotNull
    public final TermIterator iterator() {
        return new TermIterator(this.delGen, new ByteBuffersDataInput(this.content));
    }

    public final long size() {
        return this.size;
    }

    public int hashCode() {
        if (this.lazyHash == 0) {
            int h = 1;
            for (ByteBuffer bb : this.content) {
                h += 31 * bb.hashCode();
            }
            this.lazyHash = h = 31 * h + (int)(this.delGen ^ this.delGen >>> 32);
        }
        return this.lazyHash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixCodedTerms other = (PrefixCodedTerms)obj;
        return this.delGen == other.delGen && this.size() == other.size() && Intrinsics.areEqual(this.content, other.content);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    public /* synthetic */ PrefixCodedTerms(List content, long size2, DefaultConstructorMarker $constructor_marker) {
        this(content, size2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/index/PrefixCodedTerms$Builder;", "", "<init>", "()V", "output", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "lastTerm", "Lorg/gnit/lucenekmp/index/Term;", "lastTermBytes", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "size", "", "add", "", "term", "field", "", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "finish", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "core"})
    public static final class Builder {
        @NotNull
        private final ByteBuffersDataOutput output = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
        @NotNull
        private final Term lastTerm = new Term("", null, 2, null);
        @NotNull
        private final BytesRefBuilder lastTermBytes = new BytesRefBuilder();
        private long size;

        public final void add(@NotNull Term term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.add(term.field(), term.bytes());
        }

        public final void add(@NotNull String field, @NotNull BytesRef bytes) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (!(Intrinsics.areEqual((Object)this.lastTerm, (Object)new Term("", null, 2, null)) || new Term(field, bytes).compareTo(this.lastTerm) > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                int prefix = 0;
                if (this.size > 0L && Intrinsics.areEqual((Object)field, (Object)this.lastTerm.getField())) {
                    prefix = StringHelper.INSTANCE.bytesDifference(this.lastTerm.getBytes(), bytes);
                    this.output.writeVInt(prefix << 1);
                } else {
                    prefix = 0;
                    this.output.writeVInt(1);
                    this.output.writeString(field);
                }
                int suffix = bytes.getLength() - prefix;
                this.output.writeVInt(suffix);
                this.output.writeBytes(bytes.getBytes(), bytes.getOffset() + prefix, suffix);
                this.lastTermBytes.copyBytes(bytes);
                this.lastTerm.setBytes(this.lastTermBytes.get());
                this.lastTerm.setField(field);
                ++this.size;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        public final PrefixCodedTerms finish() {
            return new PrefixCodedTerms(this.output.toBufferList(), this.size, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/index/PrefixCodedTerms$TermIterator;", "Lorg/gnit/lucenekmp/index/FieldTermIterator;", "delGen", "", "input", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "<init>", "(JLorg/gnit/lucenekmp/store/ByteBuffersDataInput;)V", "getDelGen", "()J", "getInput", "()Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "builder", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getBuilder", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "getBytes", "()Lorg/gnit/lucenekmp/util/BytesRef;", "end", "getEnd", "field", "", "getField", "()Ljava/lang/String;", "setField", "(Ljava/lang/String;)V", "next", "readTermBytes", "", "prefix", "", "suffix", "core"})
    public static final class TermIterator
    extends FieldTermIterator {
        private final long delGen;
        @NotNull
        private final ByteBuffersDataInput input;
        @NotNull
        private final BytesRefBuilder builder;
        @NotNull
        private final BytesRef bytes;
        private final long end;
        @Nullable
        private String field;

        public TermIterator(long delGen, @NotNull ByteBuffersDataInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.delGen = delGen;
            this.input = input;
            this.builder = new BytesRefBuilder();
            this.bytes = this.builder.get();
            this.end = this.input.length();
            this.field = "";
        }

        public final long getDelGen() {
            return this.delGen;
        }

        @NotNull
        public final ByteBuffersDataInput getInput() {
            return this.input;
        }

        @NotNull
        public final BytesRefBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final BytesRef getBytes() {
            return this.bytes;
        }

        public final long getEnd() {
            return this.end;
        }

        @Nullable
        public final String getField() {
            return this.field;
        }

        public final void setField(@Nullable String string) {
            this.field = string;
        }

        @Override
        @Nullable
        public BytesRef next() {
            if (this.input.position() < this.end) {
                try {
                    boolean newField;
                    int code = this.input.readVInt();
                    boolean bl = newField = (code & 1) != 0;
                    if (newField) {
                        this.field = this.input.readString();
                    }
                    int prefix = code >>> 1;
                    int suffix = this.input.readVInt();
                    this.readTermBytes(prefix, suffix);
                    return this.bytes;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.field = null;
            return null;
        }

        private final void readTermBytes(int prefix, int suffix) throws IOException {
            this.builder.grow(prefix + suffix);
            this.input.readBytes(this.builder.bytes(), prefix, suffix);
            this.builder.setLength(prefix + suffix);
        }

        @Override
        @Nullable
        public String field() {
            return this.field;
        }

        @Override
        public long delGen() {
            return this.delGen;
        }
    }
}

