/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.util.StringHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0014\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0014\u00101\u001a\u0002022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0006\u00103\u001a\u000202J\u0006\u00104\u001a\u000202J\u0006\u00105\u001a\u00020\bJ\u000e\u00106\u001a\u0002022\u0006\u0010&\u001a\u00020\bJ\u0006\u00107\u001a\u000202J\u0006\u00108\u001a\u000202J\u0006\u00109\u001a\u00020\bJ\u000e\u0010:\u001a\u0002022\u0006\u0010&\u001a\u00020\bJ\u0006\u0010;\u001a\u000202J\u0006\u0010<\u001a\u000202J\u0006\u0010=\u001a\u00020\bJ\u000e\u0010>\u001a\u0002022\u0006\u0010&\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\bJ\f\u0010?\u001a\b\u0012\u0004\u0012\u00020#0@J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020BJ\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010E\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020\u0005J\b\u0010F\u001a\u00020#H\u0016J\u0006\u0010H\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010I\u001a\u00020BJ\b\u0010J\u001a\u000202H\u0002J\b\u0010K\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R \u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010*RH\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006L"}, d2={"Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "", "info", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "delCount", "", "softDelCount", "delGen", "", "fieldInfosGen", "docValuesGen", "id", "", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentInfo;IIJJJ[B)V", "getInfo", "()Lorg/gnit/lucenekmp/index/SegmentInfo;", "value", "getDelCount", "()I", "setDelCount", "(I)V", "getDelGen", "()J", "nextDelGen", "getNextDelGen", "getFieldInfosGen", "nextFieldInfosGen", "getNextFieldInfosGen", "getDocValuesGen", "nextDocValuesGen", "getNextDocValuesGen", "dvUpdatesFiles", "", "", "", "fieldInfosFiles", "sizeInBytes", "v", "bufferedDeletesGen", "getBufferedDeletesGen", "setBufferedDeletesGen", "(J)V", "docValuesUpdatesFiles", "getDocValuesUpdatesFiles", "()Ljava/util/Map;", "setDocValuesUpdatesFiles", "(Ljava/util/Map;)V", "getFieldInfosFiles", "setFieldInfosFiles", "", "advanceDelGen", "advanceNextWriteDelGen", "getNextWriteDelGen", "setNextWriteDelGen", "advanceFieldInfosGen", "advanceNextWriteFieldInfosGen", "getNextWriteFieldInfosGen", "setNextWriteFieldInfosGen", "advanceDocValuesGen", "advanceNextWriteDocValuesGen", "getNextWriteDocValuesGen", "setNextWriteDocValuesGen", "files", "", "hasDeletions", "", "hasFieldUpdates", "getSoftDelCount", "setSoftDelCount", "toString", "pendingDelCount", "clone", "includeSoftDeletes", "generationAdvanced", "getId", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentCommitInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentCommitInfo.kt\norg/gnit/lucenekmp/index/SegmentCommitInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
public final class SegmentCommitInfo {
    @NotNull
    private final SegmentInfo info;
    @Nullable
    private byte[] id;
    private int delCount;
    private int softDelCount;
    private long delGen;
    private long nextDelGen;
    private long fieldInfosGen;
    private long nextFieldInfosGen;
    private long docValuesGen;
    private long nextDocValuesGen;
    @NotNull
    private final Map<Integer, Set<String>> dvUpdatesFiles;
    @NotNull
    private final Set<String> fieldInfosFiles;
    private volatile long sizeInBytes;
    private long bufferedDeletesGen;

    public SegmentCommitInfo(@NotNull SegmentInfo info, int delCount, int softDelCount, long delGen, long fieldInfosGen, long docValuesGen, @Nullable byte[] id) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.info = info;
        this.delCount = delCount;
        this.dvUpdatesFiles = new HashMap();
        this.fieldInfosFiles = new HashSet();
        this.sizeInBytes = -1L;
        this.bufferedDeletesGen = -1L;
        this.setDelCount(delCount);
        this.softDelCount = softDelCount;
        this.delGen = delGen;
        this.nextDelGen = delGen == -1L ? 1L : delGen + 1L;
        this.fieldInfosGen = fieldInfosGen;
        this.nextFieldInfosGen = fieldInfosGen == -1L ? 1L : fieldInfosGen + 1L;
        this.docValuesGen = docValuesGen;
        this.nextDocValuesGen = docValuesGen == -1L ? 1L : docValuesGen + 1L;
        this.id = id;
        if (!(id == null || id.length == 16)) {
            boolean bl = false;
            String string = Arrays.toString(id);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = "invalid id: " + string;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final SegmentInfo getInfo() {
        return this.info;
    }

    public final int getDelCount() {
        return this.delCount;
    }

    public final void setDelCount(int value) {
        if (!(value >= 0 && value <= this.info.maxDoc())) {
            boolean $i$a$-require-SegmentCommitInfo$delCount$32 = false;
            String $i$a$-require-SegmentCommitInfo$delCount$32 = "invalid delCount=" + value + " (maxDoc=" + this.info.maxDoc() + ")";
            throw new IllegalArgumentException($i$a$-require-SegmentCommitInfo$delCount$32.toString());
        }
        if (!(this.softDelCount + value <= this.info.maxDoc())) {
            boolean bl = false;
            String string = "maxDoc=" + this.info.maxDoc() + ",delCount=" + value + ",softDelCount=" + this.softDelCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.delCount = value;
    }

    public final long getDelGen() {
        return this.delGen;
    }

    public final long getNextDelGen() {
        return this.nextDelGen;
    }

    public final long getFieldInfosGen() {
        return this.fieldInfosGen;
    }

    public final long getNextFieldInfosGen() {
        return this.nextFieldInfosGen;
    }

    public final long getDocValuesGen() {
        return this.docValuesGen;
    }

    public final long getNextDocValuesGen() {
        return this.nextDocValuesGen;
    }

    public final long getBufferedDeletesGen() {
        return this.bufferedDeletesGen;
    }

    public final void setBufferedDeletesGen(long v) {
        if (this.bufferedDeletesGen != -1L) {
            throw new IllegalStateException("buffered deletes gen should only be set once");
        }
        this.bufferedDeletesGen = v;
        this.generationAdvanced();
    }

    @NotNull
    public final Map<Integer, Set<String>> getDocValuesUpdatesFiles() {
        return this.dvUpdatesFiles;
    }

    public final void setDocValuesUpdatesFiles(@NotNull Map<Integer, Set<String>> dvUpdatesFiles) {
        Intrinsics.checkNotNullParameter(dvUpdatesFiles, (String)"dvUpdatesFiles");
        this.dvUpdatesFiles.clear();
        for (Map.Entry<Integer, Set<String>> kv : dvUpdatesFiles.entrySet()) {
            Set set = new HashSet();
            for (String file : kv.getValue()) {
                set.add(this.info.namedForThisSegment(file));
            }
            this.dvUpdatesFiles.put(kv.getKey(), set);
        }
    }

    @NotNull
    public final Set<String> getFieldInfosFiles() {
        return this.fieldInfosFiles;
    }

    public final void setFieldInfosFiles(@NotNull Set<String> fieldInfosFiles) {
        Intrinsics.checkNotNullParameter(fieldInfosFiles, (String)"fieldInfosFiles");
        this.fieldInfosFiles.clear();
        for (String file : fieldInfosFiles) {
            this.fieldInfosFiles.add(this.info.namedForThisSegment(file));
        }
    }

    public final void advanceDelGen() {
        this.delGen = this.nextDelGen;
        this.nextDelGen = this.delGen + 1L;
        this.generationAdvanced();
    }

    public final void advanceNextWriteDelGen() {
        long l = this.nextDelGen;
        this.nextDelGen = l + 1L;
    }

    public final long getNextWriteDelGen() {
        return this.nextDelGen;
    }

    public final void setNextWriteDelGen(long v) {
        this.nextDelGen = v;
    }

    public final void advanceFieldInfosGen() {
        this.fieldInfosGen = this.nextFieldInfosGen;
        this.nextFieldInfosGen = this.fieldInfosGen + 1L;
        this.generationAdvanced();
    }

    public final void advanceNextWriteFieldInfosGen() {
        long l = this.nextFieldInfosGen;
        this.nextFieldInfosGen = l + 1L;
    }

    public final long getNextWriteFieldInfosGen() {
        return this.nextFieldInfosGen;
    }

    public final void setNextWriteFieldInfosGen(long v) {
        this.nextFieldInfosGen = v;
    }

    public final void advanceDocValuesGen() {
        this.docValuesGen = this.nextDocValuesGen;
        this.nextDocValuesGen = this.docValuesGen + 1L;
        this.generationAdvanced();
    }

    public final void advanceNextWriteDocValuesGen() {
        long l = this.nextDocValuesGen;
        this.nextDocValuesGen = l + 1L;
    }

    public final long getNextWriteDocValuesGen() {
        return this.nextDocValuesGen;
    }

    public final void setNextWriteDocValuesGen(long v) {
        this.nextDocValuesGen = v;
    }

    public final long sizeInBytes() throws IOException {
        if (this.sizeInBytes == -1L) {
            long sum = 0L;
            for (String fileName : this.files()) {
                sum += this.info.getDir().fileLength(fileName);
            }
            this.sizeInBytes = sum;
        }
        return this.sizeInBytes;
    }

    @NotNull
    public final Collection<String> files() throws IOException {
        Collection files = new HashSet(this.info.files());
        if (this.hasDeletions()) {
            this.info.getCodec().liveDocsFormat().files(this, files);
        }
        for (Set<String> updatefiles : this.dvUpdatesFiles.values()) {
            files.addAll((Collection)updatefiles);
        }
        files.addAll((Collection)this.fieldInfosFiles);
        return files;
    }

    public final boolean hasDeletions() {
        return this.delGen != -1L;
    }

    public final boolean hasFieldUpdates() {
        return this.fieldInfosGen != -1L;
    }

    public final int getSoftDelCount() {
        return this.softDelCount;
    }

    public final void setSoftDelCount(int softDelCount) {
        if (!(softDelCount >= 0 && softDelCount <= this.info.maxDoc())) {
            boolean $i$a$-require-SegmentCommitInfo$setSoftDelCount$32 = false;
            String $i$a$-require-SegmentCommitInfo$setSoftDelCount$32 = "invalid softDelCount=" + softDelCount + " (maxDoc=" + this.info.maxDoc() + ")";
            throw new IllegalArgumentException($i$a$-require-SegmentCommitInfo$setSoftDelCount$32.toString());
        }
        if (!(softDelCount + this.delCount <= this.info.maxDoc())) {
            boolean bl = false;
            String string = "maxDoc=" + this.info.maxDoc() + ",delCount=" + this.delCount + ",softDelCount=" + softDelCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.softDelCount = softDelCount;
    }

    @NotNull
    public final String toString(int pendingDelCount) {
        Object s = this.info.toString(this.delCount + pendingDelCount);
        if (this.delGen != -1L) {
            s = (String)s + ":delGen=" + this.delGen;
        }
        if (this.fieldInfosGen != -1L) {
            s = (String)s + ":fieldInfosGen=" + this.fieldInfosGen;
        }
        if (this.docValuesGen != -1L) {
            s = (String)s + ":dvGen=" + this.docValuesGen;
        }
        if (this.softDelCount > 0) {
            s = (String)s + " :softDel=" + this.softDelCount;
        }
        if (this.id != null) {
            s = (String)s + " :id=" + StringHelper.INSTANCE.idToString(this.id);
        }
        return s;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final SegmentCommitInfo clone() {
        SegmentCommitInfo other = new SegmentCommitInfo(this.info, this.delCount, this.softDelCount, this.delGen, this.fieldInfosGen, this.docValuesGen, this.getId());
        other.nextDelGen = this.nextDelGen;
        other.nextFieldInfosGen = this.nextFieldInfosGen;
        other.nextDocValuesGen = this.nextDocValuesGen;
        for (Map.Entry<Integer, Set<String>> e : this.dvUpdatesFiles.entrySet()) {
            other.dvUpdatesFiles.put(e.getKey(), new HashSet(e.getValue()));
        }
        other.fieldInfosFiles.addAll((Collection<String>)this.fieldInfosFiles);
        return other;
    }

    public final int getDelCount(boolean includeSoftDeletes) {
        return includeSoftDeletes ? this.delCount + this.getSoftDelCount() : this.delCount;
    }

    private final void generationAdvanced() {
        this.sizeInBytes = -1L;
        this.id = StringHelper.INSTANCE.randomId();
    }

    @Nullable
    public final byte[] getId() {
        byte[] byArray;
        if (this.id == null) {
            byArray = null;
        } else {
            Intrinsics.checkNotNull((Object)this.id);
            byte[] byArray2 = Arrays.copyOf(this.id, this.id.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            byArray = byArray2;
            Intrinsics.checkNotNull((Object)byArray2, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        }
        return byArray;
    }
}

