/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentDocValues;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.internal.hppc.LongArrayList;
import org.gnit.lucenekmp.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/index/SegmentDocValuesProducer;", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "si", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "coreInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "allInfos", "segDocValues", "Lorg/gnit/lucenekmp/index/SegmentDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentCommitInfo;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/FieldInfos;Lorg/gnit/lucenekmp/index/FieldInfos;Lorg/gnit/lucenekmp/index/SegmentDocValues;)V", "dvProducersByField", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "getDvProducersByField", "()Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "dvProducers", "", "getDvProducers", "()Ljava/util/Set;", "dvGens", "Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "getDvGens", "()Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "getNumeric", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getBinary", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "getSorted", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "getSortedNumeric", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getSortedSet", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getSkipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "checkIntegrity", "", "close", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentDocValuesProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentDocValuesProducer.kt\norg/gnit/lucenekmp/index/SegmentDocValuesProducer\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,128:1\n3#2,8:129\n10#3:137\n*S KotlinDebug\n*F\n+ 1 SegmentDocValuesProducer.kt\norg/gnit/lucenekmp/index/SegmentDocValuesProducer\n*L\n52#1:129,8\n52#1:137\n*E\n"})
public final class SegmentDocValuesProducer
extends DocValuesProducer {
    @NotNull
    private final IntObjectHashMap<DocValuesProducer> dvProducersByField;
    @NotNull
    private final Set<DocValuesProducer> dvProducers;
    @NotNull
    private final LongArrayList dvGens;

    public SegmentDocValuesProducer(@NotNull SegmentCommitInfo si, @NotNull Directory dir, @NotNull FieldInfos coreInfos, @NotNull FieldInfos allInfos, @NotNull SegmentDocValues segDocValues) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)coreInfos, (String)"coreInfos");
        Intrinsics.checkNotNullParameter((Object)allInfos, (String)"allInfos");
        Intrinsics.checkNotNullParameter((Object)segDocValues, (String)"segDocValues");
        this.dvProducersByField = new IntObjectHashMap();
        this.dvProducers = new LinkedHashSet();
        this.dvGens = new LongArrayList();
        try {
            DocValuesProducer baseProducer = null;
            for (FieldInfo fi : allInfos) {
                DocValuesProducer docValuesProducer;
                if (fi.getDocValuesType() == DocValuesType.NONE) continue;
                long docValuesGen = fi.getDocValuesGen();
                if (docValuesGen == -1L) {
                    if (baseProducer == null) {
                        baseProducer = segDocValues.getDocValuesProducer(docValuesGen, si, dir, coreInfos);
                        this.dvGens.add(docValuesGen);
                        this.dvProducers.add(baseProducer);
                    }
                    docValuesProducer = this.dvProducersByField.put(fi.getNumber(), baseProducer);
                    continue;
                }
                boolean condition$iv = !this.dvGens.contains(docValuesGen);
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                FieldInfo[] fieldInfoArray = new FieldInfo[]{fi};
                DocValuesProducer dvp = segDocValues.getDocValuesProducer(docValuesGen, si, dir, new FieldInfos(fieldInfoArray));
                this.dvGens.add(docValuesGen);
                this.dvProducers.add(dvp);
                docValuesProducer = this.dvProducersByField.put(fi.getNumber(), dvp);
            }
        }
        catch (Throwable t) {
            try {
                segDocValues.decRef(this.dvGens);
            }
            catch (Throwable t1) {
                ExceptionsKt.addSuppressed((Throwable)t, (Throwable)t1);
            }
            throw t;
        }
    }

    @NotNull
    public final IntObjectHashMap<DocValuesProducer> getDvProducersByField() {
        return this.dvProducersByField;
    }

    @NotNull
    public final Set<DocValuesProducer> getDvProducers() {
        return this.dvProducers;
    }

    @NotNull
    public final LongArrayList getDvGens() {
        return this.dvGens;
    }

    @Override
    @NotNull
    public NumericDocValues getNumeric(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getNumeric(field);
    }

    @Override
    @NotNull
    public BinaryDocValues getBinary(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getBinary(field);
    }

    @Override
    @NotNull
    public SortedDocValues getSorted(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getSorted(field);
    }

    @Override
    @NotNull
    public SortedNumericDocValues getSortedNumeric(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getSortedNumeric(field);
    }

    @Override
    @NotNull
    public SortedSetDocValues getSortedSet(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getSortedSet(field);
    }

    @Override
    @Nullable
    public DocValuesSkipper getSkipper(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesProducer docValuesProducer = this.dvProducersByField.get(field.getNumber());
        if (docValuesProducer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DocValuesProducer dvProducer = docValuesProducer;
        return dvProducer.getSkipper(field);
    }

    @Override
    public void checkIntegrity() throws IOException {
        for (DocValuesProducer producer2 : this.dvProducers) {
            producer2.checkIntegrity();
        }
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(producers=" + this.dvProducers.size() + ")";
    }
}

