/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexFormatTooOldException;
import org.gnit.lucenekmp.index.IndexNotFoundException;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.PrintStream;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0012\u0018\u0000 g2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002fgB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020!J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u000e\u00105\u001a\u0002062\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020\u0000H\u0016J\u000e\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020\u0000J\u000e\u0010>\u001a\u0002062\u0006\u0010=\u001a\u00020\u0000J\u000e\u0010?\u001a\u0002062\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010@\u001a\u0002062\u0006\u0010A\u001a\u000208J\u000e\u0010B\u001a\u0002062\u0006\u0010A\u001a\u000208J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00190D2\u0006\u0010E\u001a\u000200J\u000e\u0010F\u001a\u00020\u00192\u0006\u0010A\u001a\u000208J\u000e\u0010G\u001a\u0002062\u0006\u0010A\u001a\u000208J\b\u0010H\u001a\u00020\u0019H\u0016J\"\u0010\u001c\u001a\u0002062\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010J\u001a\u000200J\u000e\u0010K\u001a\u0002062\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010L\u001a\u00020\u0005J\u0006\u0010M\u001a\u000206J\u0016\u0010N\u001a\u0002062\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u000200J\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fJ\u0014\u0010S\u001a\u0002062\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fJ\u000f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030VH\u0096\u0002J\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fJ\u0006\u0010X\u001a\u00020\u0005J\u000e\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020\u0003J\u0014\u0010[\u001a\u0002062\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0006\u0010]\u001a\u000206J\u000e\u0010^\u001a\u0002002\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010^\u001a\u0002062\u0006\u0010_\u001a\u00020\u0005J\u000e\u0010`\u001a\u0002002\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010a\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\u0003J\b\u0010e\u001a\u0004\u0018\u00010#R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010)\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000bR\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0013\u0010b\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\u00a8\u0006h"}, d2={"Lorg/gnit/lucenekmp/index/SegmentInfos;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "indexCreatedVersionMajor", "", "<init>", "(I)V", "counter", "", "getCounter", "()J", "setCounter", "(J)V", "newVersion", "version", "getVersion", "setVersion", "value", "generation", "getGeneration", "lastGeneration", "getLastGeneration", "userData", "", "", "getUserData", "()Ljava/util/Map;", "setUserData", "(Ljava/util/Map;)V", "segments", "", "id", "", "luceneVersion", "Lorg/gnit/lucenekmp/util/Version;", "minSegmentLuceneVersion", "getIndexCreatedVersionMajor", "()I", "info", "i", "segmentsFileName", "getSegmentsFileName", "()Ljava/lang/String;", "nextPendingGeneration", "getNextPendingGeneration", "getId", "pendingCommit", "", "getPendingCommit", "()Z", "setPendingCommit", "(Z)V", "write", "", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "out", "Lorg/gnit/lucenekmp/store/IndexOutput;", "clone", "updateGeneration", "other", "updateGenerationVersionAndCounter", "setNextWriteGeneration", "rollbackCommit", "dir", "prepareCommit", "files", "", "includeSegmentsFile", "finishCommit", "commit", "toString", "data", "doIncrementVersion", "replace", "totalMaxDoc", "changed", "applyMergeChanges", "merge", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "dropSegment", "createBackupSegmentInfos", "rollbackSegmentInfos", "infos", "iterator", "", "asList", "size", "add", "si", "addAll", "sis", "clear", "remove", "index", "contains", "indexOf", "commitLuceneVersion", "getCommitLuceneVersion", "()Lorg/gnit/lucenekmp/util/Version;", "getMinSegmentLuceneVersion", "FindSegmentsFile", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentInfos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentInfos.kt\norg/gnit/lucenekmp/index/SegmentInfos\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1202:1\n1#2:1203\n8#3,2:1204\n3#3,8:1206\n3#3,8:1215\n10#4:1214\n10#4:1223\n*S KotlinDebug\n*F\n+ 1 SegmentInfos.kt\norg/gnit/lucenekmp/index/SegmentInfos\n*L\n311#1:1204,2\n626#1:1206,8\n648#1:1215,8\n626#1:1214\n648#1:1223\n*E\n"})
public final class SegmentInfos
implements Cloneable<SegmentInfos>,
Iterable<SegmentCommitInfo>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long counter;
    private long version;
    private long generation;
    private long lastGeneration;
    @NotNull
    private Map<String, String> userData = new LinkedHashMap();
    @NotNull
    private List<SegmentCommitInfo> segments = new ArrayList();
    private byte[] id;
    @Nullable
    private Version luceneVersion;
    @Nullable
    private Version minSegmentLuceneVersion;
    private final int indexCreatedVersionMajor;
    private boolean pendingCommit;
    public static final int VERSION_74 = 9;
    public static final int VERSION_86 = 10;
    public static final int VERSION_CURRENT = 10;
    @NotNull
    public static final String OLD_SEGMENTS_GEN = "segments.gen";
    @Nullable
    private static PrintStream infoStream;

    public SegmentInfos(int indexCreatedVersionMajor) {
        if (!(indexCreatedVersionMajor <= Version.Companion.getLATEST().getMajor())) {
            boolean $i$a$-require-SegmentInfos$32 = false;
            String $i$a$-require-SegmentInfos$32 = "indexCreatedVersionMajor is in the future: " + indexCreatedVersionMajor;
            throw new IllegalArgumentException($i$a$-require-SegmentInfos$32.toString());
        }
        if (!(indexCreatedVersionMajor >= 6)) {
            boolean bl = false;
            String string = "indexCreatedVersionMajor must be >= 6, got: " + indexCreatedVersionMajor;
            throw new IllegalArgumentException(string.toString());
        }
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
    }

    public final long getCounter() {
        return this.counter;
    }

    public final void setCounter(long l) {
        this.counter = l;
    }

    public final long getVersion() {
        return this.version;
    }

    public final void setVersion(long newVersion) {
        if (!(newVersion >= this.version)) {
            boolean bl = false;
            String string = "newVersion (=" + newVersion + ") cannot be less than current version (=" + this.version + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.version = newVersion;
    }

    public final long getGeneration() {
        return this.generation;
    }

    public final long getLastGeneration() {
        return this.lastGeneration;
    }

    @NotNull
    public final Map<String, String> getUserData() {
        return this.userData;
    }

    public final void setUserData(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.userData = map2;
    }

    public final int getIndexCreatedVersionMajor() {
        return this.indexCreatedVersionMajor;
    }

    @NotNull
    public final SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    @Nullable
    public final String getSegmentsFileName() {
        return IndexFileNames.INSTANCE.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    private final long getNextPendingGeneration() {
        return this.generation == -1L ? 1L : this.generation + 1L;
    }

    @NotNull
    public final byte[] getId() {
        byte[] byArray = this.id;
        if (this.id == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"id");
            byArray = null;
        }
        byte[] byArray2 = byArray;
        byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        return byArray3;
    }

    public final boolean getPendingCommit() {
        return this.pendingCommit;
    }

    public final void setPendingCommit(boolean bl) {
        this.pendingCommit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void write(Directory directory) throws IOException {
        long nextGeneration = this.getNextPendingGeneration();
        String segmentFileName = IndexFileNames.INSTANCE.fileNameFromGeneration("pending_segments", "", nextGeneration);
        this.generation = nextGeneration;
        IndexOutput segnOutput = null;
        boolean success = false;
        try {
            String string = segmentFileName;
            Intrinsics.checkNotNull((Object)string);
            segnOutput = directory.createOutput(string, IOContext.Companion.getDEFAULT());
            this.write(segnOutput);
            segnOutput.close();
            Object[] objectArray = new String[]{segmentFileName};
            directory.sync(SetsKt.mutableSetOf((Object[])objectArray));
            success = true;
        }
        catch (Throwable throwable) {
            Object[] objectArray = new AutoCloseable[]{segnOutput};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable((AutoCloseable[])objectArray);
            objectArray = new String[1];
            Intrinsics.checkNotNull((Object)segmentFileName);
            IOUtils.INSTANCE.deleteFilesIgnoringExceptions(directory, (String[])objectArray);
            throw throwable;
        }
        this.pendingCommit = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull IndexOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        DataOutput dataOutput = out;
        byte[] byArray = StringHelper.INSTANCE.randomId();
        String string = Long.toString(this.generation, CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CodecUtil.INSTANCE.writeIndexHeader(dataOutput, "segments", 10, byArray, string);
        out.writeVInt(Version.Companion.getLATEST().getMajor());
        out.writeVInt(Version.Companion.getLATEST().getMinor());
        out.writeVInt(Version.Companion.getLATEST().getBugfix());
        out.writeVInt(this.indexCreatedVersionMajor);
        CodecUtil.INSTANCE.writeBELong(out, this.version);
        out.writeVLong(this.counter);
        CodecUtil.INSTANCE.writeBEInt(out, this.size());
        if (this.size() > 0) {
            Version minSegmentVersion = null;
            for (SegmentCommitInfo siPerCommit : this) {
                Version segmentVersion = siPerCommit.getInfo().getVersion();
                if (minSegmentVersion != null && segmentVersion.onOrAfter(minSegmentVersion)) continue;
                minSegmentVersion = segmentVersion;
            }
            Version version = minSegmentVersion;
            Intrinsics.checkNotNull(version);
            out.writeVInt(version.getMajor());
            out.writeVInt(minSegmentVersion.getMinor());
            out.writeVInt(minSegmentVersion.getBugfix());
        }
        for (SegmentCommitInfo siPerCommit : this) {
            SegmentInfo si = siPerCommit.getInfo();
            if (!(this.indexCreatedVersionMajor < 7 || si.getMinVersion() != null)) {
                boolean $i$a$-check-SegmentInfos$write$52 = false;
                String $i$a$-check-SegmentInfos$write$52 = "Segments must record minVersion if they have been created on or after Lucene 7: " + si;
                throw new IllegalStateException($i$a$-check-SegmentInfos$write$52.toString());
            }
            out.writeString(si.getName());
            byte[] segmentID = si.getId();
            if (!(segmentID.length == 16)) {
                boolean $i$a$-check-SegmentInfos$write$62 = false;
                String $i$a$-check-SegmentInfos$write$62 = "cannot write segment: invalid id segment=" + si.getName() + "id=" + StringHelper.INSTANCE.idToString(segmentID);
                throw new IllegalStateException($i$a$-check-SegmentInfos$write$62.toString());
            }
            out.writeBytes(segmentID, segmentID.length);
            out.writeString(si.getCodec().getName());
            CodecUtil.INSTANCE.writeBELong(out, siPerCommit.getDelGen());
            int delCount = siPerCommit.getDelCount();
            if (!(delCount >= 0 && delCount <= si.maxDoc())) {
                boolean $i$a$-check-SegmentInfos$write$72 = false;
                String $i$a$-check-SegmentInfos$write$72 = "cannot write segment: invalid maxDoc segment=" + si.getName() + " maxDoc=" + si.maxDoc() + " delCount=" + delCount;
                throw new IllegalStateException($i$a$-check-SegmentInfos$write$72.toString());
            }
            CodecUtil.INSTANCE.writeBEInt(out, delCount);
            CodecUtil.INSTANCE.writeBELong(out, siPerCommit.getFieldInfosGen());
            CodecUtil.INSTANCE.writeBELong(out, siPerCommit.getDocValuesGen());
            int softDelCount = siPerCommit.getSoftDelCount();
            if (!(softDelCount >= 0 && softDelCount <= si.maxDoc())) {
                boolean $i$a$-check-SegmentInfos$write$82 = false;
                String $i$a$-check-SegmentInfos$write$82 = "cannot write segment: invalid maxDoc segment=" + si.getName() + " maxDoc=" + si.maxDoc() + " softDelCount=" + softDelCount;
                throw new IllegalStateException($i$a$-check-SegmentInfos$write$82.toString());
            }
            CodecUtil.INSTANCE.writeBEInt(out, softDelCount);
            byte[] sciId = siPerCommit.getId();
            if (sciId != null) {
                void condition$iv;
                out.writeByte((byte)1);
                boolean $i$a$-check-SegmentInfos$write$82 = sciId.length == 16;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == false) {
                    boolean bl = false;
                    String string2 = Arrays.toString(sciId);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String string3 = "invalid SegmentCommitInfo#id: " + string2;
                    throw new AssertionError((Object)string3);
                }
                out.writeBytes(sciId, 0, sciId.length);
            } else {
                out.writeByte((byte)0);
            }
            out.writeSetOfStrings(siPerCommit.getFieldInfosFiles());
            Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
            CodecUtil.INSTANCE.writeBEInt(out, dvUpdatesFiles.size());
            for (Map.Entry<Integer, Set<String>> e : dvUpdatesFiles.entrySet()) {
                CodecUtil.INSTANCE.writeBEInt(out, ((Number)e.getKey()).intValue());
                out.writeSetOfStrings(e.getValue());
            }
        }
        out.writeMapOfStrings(this.userData);
        CodecUtil.INSTANCE.writeFooter(out);
    }

    @Override
    @NotNull
    public SegmentInfos clone() {
        try {
            SegmentInfos sis = new SegmentInfos(this.indexCreatedVersionMajor);
            sis.segments = new ArrayList(this.size());
            for (SegmentCommitInfo info : this) {
                if (info.getInfo().getCodec() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                sis.add(info.clone());
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (Exception e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    public final void updateGeneration(@NotNull SegmentInfos other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    public final void updateGenerationVersionAndCounter(@NotNull SegmentInfos other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.updateGeneration(other);
        this.setVersion(other.version);
        this.counter = other.counter;
    }

    public final void setNextWriteGeneration(long generation) {
        if (!(generation >= this.generation)) {
            boolean bl = false;
            String string = "cannot decrease generation to " + generation + " from current generation " + this.generation;
            throw new IllegalStateException(string.toString());
        }
        this.generation = generation;
    }

    public final void rollbackCommit(@NotNull Directory dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.pendingCommit) {
            this.pendingCommit = false;
            String pending = IndexFileNames.INSTANCE.fileNameFromGeneration("pending_segments", "", this.generation);
            String[] stringArray = new String[1];
            Intrinsics.checkNotNull((Object)pending);
            IOUtils.INSTANCE.deleteFilesIgnoringExceptions(dir, stringArray);
        }
    }

    public final void prepareCommit(@NotNull Directory dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!(!this.pendingCommit)) {
            boolean bl = false;
            String string = "prepareCommit was already called";
            throw new IllegalStateException(string.toString());
        }
        dir.syncMetaData();
        this.write(dir);
    }

    @NotNull
    public final Collection<String> files(boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            SegmentCommitInfo info = this.info(i);
            files.addAll(info.files());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String finishCommit(@NotNull Directory dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!this.pendingCommit) {
            boolean $i$a$-check-SegmentInfos$finishCommit$22 = false;
            String $i$a$-check-SegmentInfos$finishCommit$22 = "prepareCommit was not called";
            throw new IllegalStateException($i$a$-check-SegmentInfos$finishCommit$22.toString());
        }
        boolean successRenameAndSync = false;
        String dest = null;
        try {
            String src = IndexFileNames.INSTANCE.fileNameFromGeneration("pending_segments", "", this.generation);
            dest = IndexFileNames.INSTANCE.fileNameFromGeneration("segments", "", this.generation);
            String string = src;
            Intrinsics.checkNotNull((Object)string);
            String string2 = dest;
            Intrinsics.checkNotNull((Object)string2);
            dir.rename(string, string2);
            try {
                dir.syncMetaData();
                successRenameAndSync = true;
            }
            catch (Throwable throwable) {
                String[] stringArray = new String[]{dest};
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(dir, stringArray);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (!successRenameAndSync) {
                this.rollbackCommit(dir);
            }
            throw throwable;
        }
        this.pendingCommit = false;
        this.lastGeneration = this.generation;
        return dest;
    }

    public final void commit(@NotNull Directory dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info = this.info(i);
            buffer.append(info.toString(0));
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void setUserData(@NotNull Map<String, String> data, boolean doIncrementVersion) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.userData = data;
        if (doIncrementVersion) {
            this.changed();
        }
    }

    public final void replace(@NotNull SegmentInfos other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
        this.userData = other.userData;
    }

    public final int totalMaxDoc() {
        long count = 0L;
        for (SegmentCommitInfo info : this) {
            count += (long)info.getInfo().maxDoc();
        }
        boolean condition$iv = count <= (long)IndexWriter.Companion.getActualMaxDocs();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return Math.INSTANCE.toIntExact(count);
    }

    public final void changed() {
        long l = this.version;
        this.setVersion(l + 1L);
    }

    /*
     * Unable to fully structure code
     */
    public final void applyMergeChanges(@NotNull MergePolicy.OneMerge merge, boolean dropSegment) {
        Intrinsics.checkNotNullParameter((Object)merge, (String)"merge");
        if (this.indexCreatedVersionMajor < 7) ** GOTO lbl-1000
        v0 = merge.getInfo();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.getInfo().getMinVersion() != null) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-SegmentInfos$applyMergeChanges$1 = false;
            $i$a$-require-SegmentInfos$applyMergeChanges$1 = "All segments must record the minVersion for indices created on or after Lucene 7";
            throw new IllegalArgumentException($i$a$-require-SegmentInfos$applyMergeChanges$1.toString());
        }
        mergedAway = new HashSet<E>(merge.getSegments());
        inserted = false;
        newSegIdx = 0;
        cnt = this.segments.size();
        for (segIdx = 0; segIdx < cnt; ++segIdx) {
            condition$iv = segIdx >= newSegIdx;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                $i$a$-assert-AssertKt$assert$1 = false;
                var10_14 = "assertion failed";
                throw new AssertionError((Object)var10_14);
            }
            info = this.segments.get(segIdx);
            if (mergedAway.contains(info)) {
                if (inserted || dropSegment) continue;
                v2 = merge.getInfo();
                Intrinsics.checkNotNull((Object)v2);
                this.segments.set(segIdx, v2);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            v3 = merge.getInfo();
            Intrinsics.checkNotNull((Object)v3);
            this.segments.add(0, v3);
        }
    }

    @NotNull
    public final List<SegmentCommitInfo> createBackupSegmentInfos() {
        List list = new ArrayList(this.size());
        for (SegmentCommitInfo info : this) {
            if (info.getInfo().getCodec() == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            list.add(info.clone());
        }
        return list;
    }

    public final void rollbackSegmentInfos(@NotNull List<SegmentCommitInfo> infos) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        this.clear();
        this.addAll((Iterable<SegmentCommitInfo>)infos);
    }

    @Override
    @NotNull
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    @NotNull
    public final List<SegmentCommitInfo> asList() {
        return CollectionsKt.toMutableList((Collection)this.segments);
    }

    public final int size() {
        return this.segments.size();
    }

    public final void add(@NotNull SegmentCommitInfo si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        if (!(this.indexCreatedVersionMajor < 7 || si.getInfo().getMinVersion() != null)) {
            boolean bl = false;
            String string = "All segments must record the minVersion for indices created on or after Lucene 7";
            throw new IllegalArgumentException(string.toString());
        }
        this.segments.add(si);
    }

    public final void addAll(@NotNull Iterable<SegmentCommitInfo> sis) {
        Intrinsics.checkNotNullParameter(sis, (String)"sis");
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public final void clear() {
        this.segments.clear();
    }

    public final boolean remove(@NotNull SegmentCommitInfo si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return this.segments.remove(si);
    }

    public final void remove(int index) {
        this.segments.remove(index);
    }

    public final boolean contains(@NotNull SegmentCommitInfo si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return this.segments.contains(si);
    }

    public final int indexOf(@NotNull SegmentCommitInfo si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return this.segments.indexOf(si);
    }

    @Nullable
    public final Version getCommitLuceneVersion() {
        return this.luceneVersion;
    }

    @Nullable
    public final Version getMinSegmentLuceneVersion() {
        return this.minSegmentLuceneVersion;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tJ\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020 H\u0002J\u001a\u0010%\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007J\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020\u000bJ\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/index/SegmentInfos$Companion;", "", "<init>", "()V", "VERSION_74", "", "VERSION_86", "VERSION_CURRENT", "OLD_SEGMENTS_GEN", "", "infoStream", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "getLastCommitGeneration", "", "files", "", "([Ljava/lang/String;)J", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "getLastCommitSegmentsFileName", "([Ljava/lang/String;)Ljava/lang/String;", "generationFromSegmentsFileName", "fileName", "readCommit", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "segmentFileName", "minSupportedMajorVersion", "input", "Lorg/gnit/lucenekmp/store/ChecksumIndexInput;", "generation", "parseSegmentInfos", "", "Lorg/gnit/lucenekmp/store/DataInput;", "infos", "format", "readCodec", "Lorg/gnit/lucenekmp/codecs/Codec;", "readLatestCommit", "setInfoStream", "getInfoStream", "message", "core"})
    @SourceDebugExtension(value={"SMAP\nSegmentInfos.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentInfos.kt\norg/gnit/lucenekmp/index/SegmentInfos$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1202:1\n1#2:1203\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getLastCommitGeneration(@NotNull String[] files) {
            Intrinsics.checkNotNullParameter((Object)files, (String)"files");
            long max = -1L;
            for (String file : files) {
                long gen;
                if (!StringsKt.startsWith$default((String)file, (String)"segments", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)file, (String)SegmentInfos.OLD_SEGMENTS_GEN, (boolean)false, (int)2, null) || (gen = this.generationFromSegmentsFileName(file)) <= max) continue;
                max = gen;
            }
            return max;
        }

        public final long getLastCommitGeneration(@NotNull Directory directory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return this.getLastCommitGeneration(directory.listAll());
        }

        @Nullable
        public final String getLastCommitSegmentsFileName(@NotNull String[] files) {
            Intrinsics.checkNotNullParameter((Object)files, (String)"files");
            return IndexFileNames.INSTANCE.fileNameFromGeneration("segments", "", this.getLastCommitGeneration(files));
        }

        @Nullable
        public final String getLastCommitSegmentsFileName(@NotNull Directory directory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return IndexFileNames.INSTANCE.fileNameFromGeneration("segments", "", this.getLastCommitGeneration(directory));
        }

        public final long generationFromSegmentsFileName(@NotNull String fileName) {
            long l;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (!(!Intrinsics.areEqual((Object)fileName, (Object)SegmentInfos.OLD_SEGMENTS_GEN))) {
                boolean bl = false;
                String string = "\"segments.gen\" is not a valid segment file name since 4.0";
                throw new IllegalArgumentException(string.toString());
            }
            if (Intrinsics.areEqual((Object)fileName, (Object)"segments")) {
                l = 0L;
            } else if (StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null)) {
                String string = fileName.substring(9);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                l = Long.parseLong(string, CharsKt.checkRadix((int)36));
            } else {
                throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
            }
            return l;
        }

        /*
         * Exception decompiling
         */
        @JvmOverloads
        @NotNull
        public final SegmentInfos readCommit(@NotNull Directory directory, @NotNull String segmentFileName, int minSupportedMajorVersion) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static /* synthetic */ SegmentInfos readCommit$default(Companion companion, Directory directory, String string, int n, int n2, Object object) throws IOException {
            if ((n2 & 4) != 0) {
                n = Version.Companion.getMIN_SUPPORTED_MAJOR();
            }
            return companion.readCommit(directory, string, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmOverloads
        @NotNull
        public final SegmentInfos readCommit(@NotNull Directory directory, @NotNull ChecksumIndexInput input, long generation, int minSupportedMajorVersion) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Throwable priorE = null;
            int format = -1;
            try {
                int magic = CodecUtil.INSTANCE.readBEInt(input);
                if (magic != 1071082519) {
                    throw new IndexFormatTooOldException(input, magic, 1071082519, 1071082519);
                }
                format = CodecUtil.INSTANCE.checkHeaderNoMagic(input, "segments", 9, 10);
                byte[] id = new byte[16];
                input.readBytes(id, 0, id.length);
                DataInput dataInput = input;
                String string = Long.toString(generation, CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                CodecUtil.INSTANCE.checkIndexHeaderSuffix(dataInput, string);
                Version luceneVersion = Version.Companion.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
                int indexCreatedVersion = input.readVInt();
                if (luceneVersion.getMajor() < indexCreatedVersion) {
                    throw new CorruptIndexException("Creation version [" + indexCreatedVersion + ".x] can't be greater than the version that wrote the segment infos: [" + luceneVersion + "]", input);
                }
                if (indexCreatedVersion < minSupportedMajorVersion) {
                    throw new IndexFormatTooOldException(input, "This index was initially created with Lucene " + indexCreatedVersion + ".x while the current version is " + Version.Companion.getLATEST() + " and Lucene only supports reading" + (String)(minSupportedMajorVersion == Version.Companion.getMIN_SUPPORTED_MAJOR() ? " the current and previous major versions" : " from version " + minSupportedMajorVersion + " upwards"));
                }
                SegmentInfos infos = new SegmentInfos(indexCreatedVersion);
                infos.id = id;
                infos.generation = generation;
                infos.lastGeneration = generation;
                infos.luceneVersion = luceneVersion;
                this.parseSegmentInfos(directory, input, infos, format);
                SegmentInfos segmentInfos = infos;
                return segmentInfos;
            }
            catch (Throwable t) {
                priorE = t;
            }
            finally {
                if (format < 9) {
                    Throwable throwable = priorE;
                    Intrinsics.checkNotNull((Object)throwable);
                    IOUtils.INSTANCE.rethrowAlways(throwable);
                    throw new KotlinNothingValueException();
                }
                CodecUtil.INSTANCE.checkFooter(input, priorE);
            }
            throw new Error("Unreachable code");
        }

        public static /* synthetic */ SegmentInfos readCommit$default(Companion companion, Directory directory, ChecksumIndexInput checksumIndexInput, long l, int n, int n2, Object object) throws IOException {
            if ((n2 & 8) != 0) {
                n = Version.Companion.getMIN_SUPPORTED_MAJOR();
            }
            return companion.readCommit(directory, checksumIndexInput, l, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void parseSegmentInfos(Directory directory, DataInput input, SegmentInfos infos, int format) throws IOException {
            infos.setVersion(CodecUtil.INSTANCE.readBELong(input));
            infos.setCounter(input.readVLong());
            int numSegments = CodecUtil.INSTANCE.readBEInt(input);
            if (numSegments < 0) {
                throw new CorruptIndexException("invalid segment count: " + numSegments, input);
            }
            if (numSegments > 0) {
                infos.minSegmentLuceneVersion = Version.Companion.fromBits(input.readVInt(), input.readVInt(), input.readVInt());
            }
            long totalDocs = 0L;
            for (int seg = 0; seg < numSegments; ++seg) {
                String segName = input.readString();
                byte[] segmentID = new byte[16];
                input.readBytes(segmentID, 0, segmentID.length);
                Codec codec = this.readCodec(input);
                SegmentInfo info = codec.segmentInfoFormat().read(directory, segName, segmentID, IOContext.Companion.getDEFAULT());
                info.setCodec(codec);
                totalDocs += (long)info.maxDoc();
                long delGen = CodecUtil.INSTANCE.readBELong(input);
                int delCount = CodecUtil.INSTANCE.readBEInt(input);
                if (delCount < 0 || delCount > info.maxDoc()) {
                    throw new CorruptIndexException("invalid deletion count: " + delCount + " vs maxDoc=" + info.maxDoc(), input);
                }
                long fieldInfosGen = CodecUtil.INSTANCE.readBELong(input);
                long dvGen = CodecUtil.INSTANCE.readBELong(input);
                int softDelCount = CodecUtil.INSTANCE.readBEInt(input);
                if (softDelCount < 0 || softDelCount > info.maxDoc()) {
                    throw new CorruptIndexException("invalid deletion count: " + softDelCount + " vs maxDoc=" + info.maxDoc(), input);
                }
                if (softDelCount + delCount > info.maxDoc()) {
                    throw new CorruptIndexException("invalid deletion count: " + (softDelCount + delCount) + " vs maxDoc=" + info.maxDoc(), input);
                }
                byte[] sciId = null;
                if (format > 9) {
                    byte marker = input.readByte();
                    byte by = marker;
                    if (by == 1) {
                        sciId = new byte[16];
                        input.readBytes(sciId, 0, sciId.length);
                    } else {
                        if (by != 0) throw new CorruptIndexException("invalid SegmentCommitInfo ID marker: " + marker, input);
                        sciId = null;
                    }
                } else {
                    sciId = null;
                }
                SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info, delCount, softDelCount, delGen, fieldInfosGen, dvGen, sciId);
                siPerCommit.setFieldInfosFiles(input.readSetOfStrings());
                Map dvUpdateFiles = null;
                int numDVFields = CodecUtil.INSTANCE.readBEInt(input);
                if (numDVFields == 0) {
                    dvUpdateFiles = new LinkedHashMap();
                } else {
                    Map<Integer, Set<String>> map2 = CollectionUtil.INSTANCE.newHashMap(numDVFields);
                    for (int i = 0; i < numDVFields; ++i) {
                        map2.put(CodecUtil.INSTANCE.readBEInt(input), input.readSetOfStrings());
                    }
                    dvUpdateFiles = MapsKt.toMutableMap(map2);
                }
                siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
                infos.add(siPerCommit);
                Version segmentVersion = info.getVersion();
                Version version = infos.minSegmentLuceneVersion;
                Intrinsics.checkNotNull((Object)version);
                if (!segmentVersion.onOrAfter(version)) {
                    throw new CorruptIndexException("segments file recorded minSegmentLuceneVersion=" + infos.minSegmentLuceneVersion + " but segment=" + info + " has older version=" + segmentVersion, input);
                }
                if (infos.getIndexCreatedVersionMajor() >= 7 && segmentVersion.getMajor() < infos.getIndexCreatedVersionMajor()) {
                    throw new CorruptIndexException("segments file recorded indexCreatedVersionMajor=" + infos.getIndexCreatedVersionMajor() + " but segment=" + info + " has older version=" + segmentVersion, input);
                }
                if (infos.getIndexCreatedVersionMajor() < 7 || info.getMinVersion() != null) continue;
                throw new CorruptIndexException("segments infos must record minVersion with indexCreatedVersionMajor=" + infos.getIndexCreatedVersionMajor(), input);
            }
            infos.setUserData(input.readMapOfStrings());
            if (totalDocs <= (long)IndexWriter.Companion.getActualMaxDocs()) return;
            throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.Companion.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs, input);
        }

        private final Codec readCodec(DataInput input) throws IOException {
            String name = input.readString();
            try {
                return Codec.Companion.forName(name);
            }
            catch (IllegalArgumentException e) {
                if (StringsKt.startsWith$default((String)name, (String)"Lucene", (boolean)false, (int)2, null)) {
                    throw new IllegalArgumentException("Could not load codec '" + name + "'. Did you forget to add lucene-backward-codecs.jar", e);
                }
                throw e;
            }
        }

        @JvmOverloads
        @NotNull
        public final SegmentInfos readLatestCommit(@NotNull Directory directory, int minSupportedMajorVersion) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return (SegmentInfos)FindSegmentsFile.run$default(new FindSegmentsFile<SegmentInfos>(directory, minSupportedMajorVersion){
                final /* synthetic */ Directory $directory;
                final /* synthetic */ int $minSupportedMajorVersion;
                {
                    this.$directory = $directory;
                    this.$minSupportedMajorVersion = $minSupportedMajorVersion;
                    super($directory);
                }

                protected SegmentInfos doBody(String segmentFileName) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)segmentFileName, (String)"segmentFileName");
                    return SegmentInfos.Companion.readCommit(this.$directory, segmentFileName, this.$minSupportedMajorVersion);
                }
            }, null, 1, null);
        }

        public static /* synthetic */ SegmentInfos readLatestCommit$default(Companion companion, Directory directory, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = Version.Companion.getMIN_SUPPORTED_MAJOR();
            }
            return companion.readLatestCommit(directory, n);
        }

        public final void setInfoStream(@NotNull PrintStream infoStream) {
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            infoStream = infoStream;
        }

        @NotNull
        public final PrintStream getInfoStream() {
            PrintStream printStream = infoStream;
            Intrinsics.checkNotNull((Object)printStream);
            return printStream;
        }

        private final void message(String message) {
            PrintStream printStream = infoStream;
            Intrinsics.checkNotNull((Object)printStream);
            printStream.println("SIS []: " + message);
        }

        @JvmOverloads
        @NotNull
        public final SegmentInfos readCommit(@NotNull Directory directory, @NotNull String segmentFileName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)segmentFileName, (String)"segmentFileName");
            return org.gnit.lucenekmp.index.SegmentInfos$Companion.readCommit$default(this, directory, segmentFileName, 0, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final SegmentInfos readCommit(@NotNull Directory directory, @NotNull ChecksumIndexInput input, long generation) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return org.gnit.lucenekmp.index.SegmentInfos$Companion.readCommit$default(this, directory, input, generation, 0, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final SegmentInfos readLatestCommit(@NotNull Directory directory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return org.gnit.lucenekmp.index.SegmentInfos$Companion.readLatestCommit$default(this, directory, 0, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00028\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH$\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/SegmentInfos$FindSegmentsFile;", "T", "", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;)V", "getDirectory", "()Lorg/gnit/lucenekmp/store/Directory;", "run", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "(Lorg/gnit/lucenekmp/index/IndexCommit;)Ljava/lang/Object;", "doBody", "segmentFileName", "", "(Ljava/lang/String;)Ljava/lang/Object;", "core"})
    public static abstract class FindSegmentsFile<T> {
        @NotNull
        private final Directory directory;

        protected FindSegmentsFile(@NotNull Directory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.directory = directory;
        }

        @NotNull
        public final Directory getDirectory() {
            return this.directory;
        }

        @JvmOverloads
        public final T run(@Nullable IndexCommit commit2) throws IOException {
            if (commit2 != null) {
                if (this.directory != commit2.getDirectory()) {
                    throw new IOException("the specified commit does not match the specified Directory");
                }
                String string = commit2.getSegmentsFileName();
                Intrinsics.checkNotNull((Object)string);
                return this.doBody(string);
            }
            long lastGen = 0L;
            long gen = -1L;
            IOException exc = null;
            while (true) {
                lastGen = gen;
                Object[] files = this.directory.listAll();
                Object[] files2 = this.directory.listAll();
                org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort((Comparable[])files);
                org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort((Comparable[])files2);
                if (!Arrays.equals(files, files2)) continue;
                gen = Companion.getLastCommitGeneration((String[])files);
                if (infoStream != null) {
                    Companion.message("directory listing gen=" + gen);
                }
                if (gen == -1L) {
                    String string = Arrays.toString(files);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + string);
                }
                if (gen <= lastGen) break;
                String segmentFileName = IndexFileNames.INSTANCE.fileNameFromGeneration("segments", "", gen);
                try {
                    String string = segmentFileName;
                    Intrinsics.checkNotNull((Object)string);
                    T t = this.doBody(string);
                    if (infoStream != null) {
                        Companion.message("success on " + segmentFileName);
                    }
                    return t;
                }
                catch (IOException err) {
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream == null) continue;
                    Companion.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: gen = " + gen);
                    continue;
                }
                break;
            }
            IOException iOException = exc;
            Intrinsics.checkNotNull(iOException, (String)"null cannot be cast to non-null type kotlin.Throwable");
            throw (Throwable)iOException;
        }

        public static /* synthetic */ Object run$default(FindSegmentsFile findSegmentsFile, IndexCommit indexCommit, int n, Object object) throws IOException {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
            }
            if ((n & 1) != 0) {
                indexCommit = null;
            }
            return findSegmentsFile.run(indexCommit);
        }

        protected abstract T doBody(@NotNull String var1) throws IOException;

        @JvmOverloads
        public final T run() throws IOException {
            return (T)FindSegmentsFile.run$default(this, null, 1, null);
        }
    }
}

