/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.AutomatonTermsEnum;
import org.gnit.lucenekmp.index.DocValuesIterator;
import org.gnit.lucenekmp.index.SingleTermsEnum;
import org.gnit.lucenekmp.index.SortedDocValuesTermsEnum;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H&J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u0012\u0010\t\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/SortedDocValues;", "Lorg/gnit/lucenekmp/index/DocValuesIterator;", "<init>", "()V", "ordValue", "", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "valueCount", "getValueCount", "()I", "lookupTerm", "key", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "intersect", "automaton", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "core"})
public abstract class SortedDocValues
extends DocValuesIterator {
    protected SortedDocValues() {
    }

    public abstract int ordValue() throws IOException;

    @Nullable
    public abstract BytesRef lookupOrd(int var1) throws IOException;

    public abstract int getValueCount();

    public int lookupTerm(@NotNull BytesRef key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int low = 0;
        int high = this.getValueCount() - 1;
        while (low <= high) {
            BytesRef term;
            int mid = low + high >>> 1;
            Intrinsics.checkNotNull((Object)this.lookupOrd(mid));
            int cmp = term.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Nullable
    public TermsEnum termsEnum() throws IOException {
        return new SortedDocValuesTermsEnum(this);
    }

    @Nullable
    public final TermsEnum intersect(@NotNull CompiledAutomaton automaton) throws IOException {
        Intrinsics.checkNotNullParameter((Object)automaton, (String)"automaton");
        TermsEnum in = this.termsEnum();
        switch (WhenMappings.$EnumSwitchMapping$0[automaton.getType().ordinal()]) {
            case 1: {
                return TermsEnum.Companion.getEMPTY();
            }
            case 2: {
                return in;
            }
            case 3: {
                TermsEnum termsEnum = in;
                Intrinsics.checkNotNull((Object)termsEnum);
                return new SingleTermsEnum(termsEnum, automaton.getTerm());
            }
            case 4: {
                return new AutomatonTermsEnum(in, automaton);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompiledAutomaton.AUTOMATON_TYPE.values().length];
            try {
                nArray[CompiledAutomaton.AUTOMATON_TYPE.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompiledAutomaton.AUTOMATON_TYPE.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompiledAutomaton.AUTOMATON_TYPE.SINGLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompiledAutomaton.AUTOMATON_TYPE.NORMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

