/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.NumericDocValuesWriter;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003,-.B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u000fJ\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J \u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter;", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;)V", "pending", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "pendingCounts", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "bytesUsed", "", "currentDoc", "", "currentValues", "", "currentUpto", "finalValues", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "finalValuesCount", "addValue", "", "docID", "value", "finishCurrentDoc", "addOneValue", "updateBytesUsed", "docValues", "getDocValues", "()Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getValues", "values", "valueCounts", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dvConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "LongValues", "BufferedSortedNumericDocValues", "SortingSortedNumericDocValues", "core"})
@SourceDebugExtension(value={"SMAP\nSortedNumericDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedNumericDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedNumericDocValuesWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,324:1\n3#2,8:325\n3#2,8:334\n10#3:333\n10#3:342\n*S KotlinDebug\n*F\n+ 1 SortedNumericDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedNumericDocValuesWriter\n*L\n45#1:325,8\n104#1:334,8\n45#1:333\n104#1:342\n*E\n"})
public final class SortedNumericDocValuesWriter
extends DocValuesWriter<SortedNumericDocValues> {
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final Counter iwBytesUsed;
    @NotNull
    private final PackedLongValues.Builder pending;
    @Nullable
    private PackedLongValues.Builder pendingCounts;
    @NotNull
    private final DocsWithFieldSet docsWithField;
    private long bytesUsed;
    private int currentDoc;
    @NotNull
    private long[] currentValues;
    private int currentUpto;
    @Nullable
    private PackedLongValues finalValues;
    @Nullable
    private PackedLongValues finalValuesCount;

    public SortedNumericDocValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.pending = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.currentDoc = -1;
        this.currentValues = new long[8];
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public final void addValue(int docID, long value) {
        boolean condition$iv = docID >= this.currentDoc;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private final void finishCurrentDoc() {
        int i;
        if (this.currentDoc == -1) {
            return;
        }
        if (this.currentUpto > 1) {
            Arrays.INSTANCE.sort(this.currentValues, 0, this.currentUpto);
        }
        int n = this.currentUpto;
        for (i = 0; i < n; ++i) {
            this.pending.add(this.currentValues[i]);
        }
        if (this.pendingCounts != null) {
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            builder.add(this.currentUpto);
        } else if (this.currentUpto != 1) {
            this.pendingCounts = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
            n = this.docsWithField.cardinality();
            for (i = 0; i < n; ++i) {
                PackedLongValues.Builder builder = this.pendingCounts;
                Intrinsics.checkNotNull((Object)builder);
                builder.add(1L);
            }
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            builder.add(this.currentUpto);
        }
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    private final void addOneValue(long value) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.Companion.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = value;
        int n = this.currentUpto;
        this.currentUpto = n + 1;
    }

    private final void updateBytesUsed() {
        long l;
        long l2 = this.pending.ramBytesUsed();
        if (this.pendingCounts == null) {
            l = 0L;
        } else {
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            l = builder.ramBytesUsed();
        }
        long newBytesUsed = l2 + l + this.docsWithField.ramBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    @NotNull
    public SortedNumericDocValues getDocValues() {
        if (this.finalValues == null) {
            PackedLongValues packedLongValues;
            boolean condition$iv = this.finalValuesCount == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.finishCurrentDoc();
            this.finalValues = this.pending.build();
            if (this.pendingCounts == null) {
                packedLongValues = null;
            } else {
                PackedLongValues.Builder builder = this.pendingCounts;
                Intrinsics.checkNotNull((Object)builder);
                packedLongValues = builder.build();
            }
            this.finalValuesCount = packedLongValues;
        }
        PackedLongValues packedLongValues = this.finalValues;
        Intrinsics.checkNotNull((Object)packedLongValues);
        PackedLongValues packedLongValues2 = this.finalValuesCount;
        Intrinsics.checkNotNull((Object)packedLongValues2);
        return this.getValues(packedLongValues, packedLongValues2, this.docsWithField);
    }

    private final SortedNumericDocValues getValues(PackedLongValues values2, PackedLongValues valueCounts, DocsWithFieldSet docsWithField) {
        return valueCounts == null ? DocValues.INSTANCE.singleton(new NumericDocValuesWriter.BufferedNumericDocValues(values2, docsWithField.iterator())) : (SortedNumericDocValues)new BufferedSortedNumericDocValues(values2, valueCounts, docsWithField.iterator());
    }

    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull DocValuesConsumer dvConsumer) throws IOException {
        LongValues longValues;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dvConsumer, (String)"dvConsumer");
        PackedLongValues values2 = null;
        PackedLongValues valueCounts = null;
        if (this.finalValues == null) {
            PackedLongValues packedLongValues;
            this.finishCurrentDoc();
            values2 = this.pending.build();
            if (this.pendingCounts == null) {
                packedLongValues = null;
            } else {
                PackedLongValues.Builder builder = this.pendingCounts;
                Intrinsics.checkNotNull((Object)builder);
                packedLongValues = builder.build();
            }
            valueCounts = packedLongValues;
        } else {
            values2 = this.finalValues;
            valueCounts = this.finalValuesCount;
        }
        if (valueCounts == null) {
            PackedLongValues packedLongValues = values2;
            Intrinsics.checkNotNull((Object)packedLongValues);
            DocValuesProducer singleValueProducer = NumericDocValuesWriter.Companion.getDocValuesProducer(this.fieldInfo, packedLongValues, this.docsWithField, sortMap);
            dvConsumer.addSortedNumericField(this.fieldInfo, new EmptyDocValuesProducer(singleValueProducer){
                final /* synthetic */ DocValuesProducer $singleValueProducer;
                {
                    this.$singleValueProducer = $singleValueProducer;
                }

                public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                    return DocValues.INSTANCE.singleton(this.$singleValueProducer.getNumeric(fieldInfo));
                }
            });
            return;
        }
        if (sortMap != null) {
            int n = state2.getSegmentInfo().maxDoc();
            PackedLongValues packedLongValues = values2;
            Intrinsics.checkNotNull((Object)packedLongValues);
            longValues = new LongValues(n, sortMap, this.getValues(packedLongValues, valueCounts, this.docsWithField), 7.0f);
        } else {
            longValues = null;
        }
        LongValues sorted = longValues;
        dvConsumer.addSortedNumericField(this.fieldInfo, new EmptyDocValuesProducer(this, values2, valueCounts, sorted){
            final /* synthetic */ SortedNumericDocValuesWriter this$0;
            final /* synthetic */ PackedLongValues $values;
            final /* synthetic */ PackedLongValues $valueCounts;
            final /* synthetic */ LongValues $sorted;
            {
                this.this$0 = $receiver;
                this.$values = $values;
                this.$valueCounts = $valueCounts;
                this.$sorted = $sorted;
            }

            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfoIn) {
                Intrinsics.checkNotNullParameter((Object)fieldInfoIn, (String)"fieldInfoIn");
                if (!Intrinsics.areEqual((Object)fieldInfoIn, (Object)SortedNumericDocValuesWriter.access$getFieldInfo$p(this.this$0))) {
                    boolean bl = false;
                    String string = "wrong fieldInfo";
                    throw new IllegalArgumentException(string.toString());
                }
                PackedLongValues packedLongValues = this.$values;
                Intrinsics.checkNotNull((Object)packedLongValues);
                SortedNumericDocValues buf = SortedNumericDocValuesWriter.access$getValues(this.this$0, packedLongValues, this.$valueCounts, SortedNumericDocValuesWriter.access$getDocsWithField$p(this.this$0));
                return this.$sorted == null ? buf : (SortedNumericDocValues)new SortingSortedNumericDocValues(buf, this.$sorted);
            }
        });
    }

    public static final /* synthetic */ FieldInfo access$getFieldInfo$p(SortedNumericDocValuesWriter $this) {
        return $this.fieldInfo;
    }

    public static final /* synthetic */ SortedNumericDocValues access$getValues(SortedNumericDocValuesWriter $this, PackedLongValues values2, PackedLongValues valueCounts, DocsWithFieldSet docsWithField) {
        return $this.getValues(values2, valueCounts, docsWithField);
    }

    public static final /* synthetic */ DocsWithFieldSet access$getDocsWithField$p(SortedNumericDocValuesWriter $this) {
        return $this.docsWithField;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u00060\fR\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\fR\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$BufferedSortedNumericDocValues;", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "values", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "valueCounts", "docsWithField", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedLongValues;Lorg/gnit/lucenekmp/util/packed/PackedLongValues;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "valuesIter", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getValuesIter", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "valueCountsIter", "getValueCountsIter", "valueCount", "", "valueUpto", "docID", "nextDoc", "advance", "target", "advanceExact", "", "docValueCount", "nextValue", "", "cost", "core"})
    private static final class BufferedSortedNumericDocValues
    extends SortedNumericDocValues {
        @NotNull
        private final DocIdSetIterator docsWithField;
        @NotNull
        private final PackedLongValues.Iterator valuesIter;
        @NotNull
        private final PackedLongValues.Iterator valueCountsIter;
        private int valueCount;
        private int valueUpto;

        public BufferedSortedNumericDocValues(@NotNull PackedLongValues values2, @NotNull PackedLongValues valueCounts, @NotNull DocIdSetIterator docsWithField) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)valueCounts, (String)"valueCounts");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            this.docsWithField = docsWithField;
            this.valuesIter = values2.iterator();
            this.valueCountsIter = valueCounts.iterator();
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @NotNull
        public final PackedLongValues.Iterator getValuesIter() {
            return this.valuesIter;
        }

        @NotNull
        public final PackedLongValues.Iterator getValueCountsIter() {
            return this.valueCountsIter;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int n = this.valueCount;
            for (int i = this.valueUpto; i < n; ++i) {
                this.valuesIter.next();
            }
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.valueCount = Math.INSTANCE.toIntExact(this.valueCountsIter.next());
                this.valueUpto = 0;
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docValueCount() {
            return this.valueCount;
        }

        @Override
        public long nextValue() {
            int n = this.valueUpto;
            this.valueUpto = n + 1;
            return this.valuesIter.next();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$LongValues;", "", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "oldValues", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "acceptableOverheadRatio", "", "<init>", "(ILorg/gnit/lucenekmp/index/Sorter$DocMap;Lorg/gnit/lucenekmp/index/SortedNumericDocValues;F)V", "offsets", "", "getOffsets", "()[J", "values", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "getValues", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedNumericDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedNumericDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$LongValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static final class LongValues {
        @NotNull
        private final long[] offsets;
        @NotNull
        private final PackedLongValues values;

        public LongValues(int maxDoc, @NotNull Sorter.DocMap sortMap, @NotNull SortedNumericDocValues oldValues, float acceptableOverheadRatio) {
            Intrinsics.checkNotNullParameter((Object)sortMap, (String)"sortMap");
            Intrinsics.checkNotNullParameter((Object)oldValues, (String)"oldValues");
            this.offsets = new long[maxDoc];
            PackedLongValues.Builder valuesBuiler = PackedLongValues.Companion.packedBuilder(acceptableOverheadRatio);
            int docID = 0;
            long offsetIndex = 1L;
            block0: while (true) {
                int n;
                int it = n = oldValues.nextDoc();
                boolean $i$a$-also-SortedNumericDocValuesWriter$LongValues$22 = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                int newDocID = sortMap.oldToNew(docID);
                int numValues = oldValues.docValueCount();
                valuesBuiler.add(numValues);
                long $i$a$-also-SortedNumericDocValuesWriter$LongValues$22 = offsetIndex;
                offsetIndex = $i$a$-also-SortedNumericDocValuesWriter$LongValues$22 + 1L;
                this.offsets[newDocID] = $i$a$-also-SortedNumericDocValuesWriter$LongValues$22;
                int i = 0;
                while (true) {
                    if (i >= numValues) continue block0;
                    valuesBuiler.add(oldValues.nextValue());
                    long l = offsetIndex;
                    offsetIndex = l + 1L;
                    ++i;
                }
                break;
            }
            this.values = valuesBuiler.build();
        }

        @NotNull
        public final long[] getOffsets() {
            return this.offsets;
        }

        @NotNull
        public final PackedLongValues getValues() {
            return this.values;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$SortingSortedNumericDocValues;", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "in", "values", "Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$LongValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedNumericDocValues;Lorg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$LongValues;)V", "docID", "", "upto", "", "numValues", "nextDoc", "advance", "target", "advanceExact", "", "nextValue", "cost", "docValueCount", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedNumericDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedNumericDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedNumericDocValuesWriter$SortingSortedNumericDocValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static final class SortingSortedNumericDocValues
    extends SortedNumericDocValues {
        @NotNull
        private final SortedNumericDocValues in;
        @NotNull
        private final LongValues values;
        private int docID;
        private long upto;
        private int numValues;

        public SortingSortedNumericDocValues(@NotNull SortedNumericDocValues in, @NotNull LongValues values2) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            this.in = in;
            this.values = values2;
            this.docID = -1;
            this.numValues = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                int n = this.docID;
                this.docID = n + 1;
                if (this.docID < this.values.getOffsets().length) continue;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.docID = it;
                return n;
            } while (this.values.getOffsets()[this.docID] <= 0L);
            this.upto = this.values.getOffsets()[this.docID];
            this.numValues = Math.INSTANCE.toIntExact(this.values.getValues().get(this.upto - 1L));
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.upto = this.values.getOffsets()[this.docID];
            if (this.values.getOffsets()[this.docID] > 0L) {
                this.numValues = Math.INSTANCE.toIntExact(this.values.getValues().get(this.upto - 1L));
                return true;
            }
            return false;
        }

        @Override
        public long nextValue() {
            long l = this.upto;
            this.upto = l + 1L;
            return this.values.getValues().get(l);
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int docValueCount() {
            return this.numValues;
        }
    }
}

