/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.SortedDocValuesWriter;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.GrowableWriter;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00039:;B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\"H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020\"H\u0002J\b\u0010)\u001a\u00020\"H\u0002J@\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u00102\u001a\u00020\"2\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006<"}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter;", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "hash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "getHash", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "pending", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "pendingCounts", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "bytesUsed", "", "currentDoc", "", "currentValues", "", "currentUpto", "maxCount", "finalOrds", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "finalOrdCounts", "finalSortedValues", "finalOrdMap", "addValue", "", "docID", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "finishCurrentDoc", "addOneValue", "updateBytesUsed", "finish", "docValues", "getDocValues", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getValues", "sortedValues", "ordMap", "ords", "ordCounts", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dvConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "BufferedSortedSetDocValues", "SortingSortedSetDocValues", "DocOrds", "core"})
@SourceDebugExtension(value={"SMAP\nSortedSetDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,424:1\n3#2,8:425\n3#2,8:435\n10#3:433\n10#3:443\n1#4:434\n*S KotlinDebug\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter\n*L\n67#1:425,8\n153#1:435,8\n67#1:433\n153#1:443\n*E\n"})
public final class SortedSetDocValuesWriter
extends DocValuesWriter<SortedSetDocValues> {
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final Counter iwBytesUsed;
    @NotNull
    private final BytesRefHash hash;
    @NotNull
    private final PackedLongValues.Builder pending;
    @Nullable
    private PackedLongValues.Builder pendingCounts;
    @NotNull
    private final DocsWithFieldSet docsWithField;
    private long bytesUsed;
    private int currentDoc;
    @NotNull
    private int[] currentValues;
    private int currentUpto;
    private int maxCount;
    @Nullable
    private PackedLongValues finalOrds;
    @Nullable
    private PackedLongValues finalOrdCounts;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    public SortedSetDocValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed, @NotNull ByteBlockPool pool) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, this.iwBytesUsed));
        this.pending = PackedLongValues.Companion.packedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.currentDoc = -1;
        this.currentValues = new int[8];
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(this.bytesUsed);
    }

    @NotNull
    public final BytesRefHash getHash() {
        return this.hash;
    }

    public final void addValue(int docID, @NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean condition$iv = docID >= this.currentDoc;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!(value.getLength() <= 32766)) {
            boolean bl = false;
            String string = "DocValuesField \"" + this.fieldInfo.getName() + "\" is too large, must be <= 32766";
            throw new IllegalArgumentException(string.toString());
        }
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
            this.currentDoc = docID;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private final void finishCurrentDoc() {
        int i;
        if (this.currentDoc == -1) {
            return;
        }
        if (this.currentUpto > 1) {
            Arrays.INSTANCE.sort(this.currentValues, 0, this.currentUpto);
        }
        int lastValue = -1;
        int count = 0;
        int n = this.currentUpto;
        for (i = 0; i < n; ++i) {
            int termID = this.currentValues[i];
            if (termID != lastValue) {
                this.pending.add(termID);
                ++count;
            }
            lastValue = termID;
        }
        if (this.pendingCounts != null) {
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            builder.add(count);
        } else if (count != 1) {
            this.pendingCounts = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
            n = this.docsWithField.cardinality();
            for (i = 0; i < n; ++i) {
                PackedLongValues.Builder builder = this.pendingCounts;
                Intrinsics.checkNotNull((Object)builder);
                builder.add(1L);
            }
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            builder.add(count);
        }
        this.maxCount = java.lang.Math.max(this.maxCount, count);
        this.currentUpto = 0;
        this.docsWithField.add(this.currentDoc);
    }

    private final void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.Companion.grow(this.currentValues, this.currentValues.length + 1);
            this.iwBytesUsed.addAndGet((long)(this.currentValues.length - this.currentUpto) * 4L);
        }
        this.currentValues[this.currentUpto] = termID;
        int n = this.currentUpto;
        this.currentUpto = n + 1;
    }

    private final void updateBytesUsed() {
        long l;
        long l2 = this.pending.ramBytesUsed();
        if (this.pendingCounts == null) {
            l = 0L;
        } else {
            PackedLongValues.Builder builder = this.pendingCounts;
            Intrinsics.checkNotNull((Object)builder);
            l = builder.ramBytesUsed();
        }
        long newBytesUsed = l2 + l + this.docsWithField.ramBytesUsed() + RamUsageEstimator.Companion.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    private final void finish() {
        if (this.finalOrds == null) {
            PackedLongValues packedLongValues;
            if (this.finalOrdCounts == null) {
                int[] nArray = this.finalSortedValues;
                if (this.finalSortedValues == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
                    nArray = null;
                }
            }
            boolean condition$iv = false;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.finishCurrentDoc();
            int valueCount = this.hash.size();
            this.finalOrds = this.pending.build();
            if (this.pendingCounts == null) {
                packedLongValues = null;
            } else {
                PackedLongValues.Builder builder = this.pendingCounts;
                Intrinsics.checkNotNull((Object)builder);
                packedLongValues = builder.build();
            }
            this.finalOrdCounts = packedLongValues;
            this.finalSortedValues = this.hash.sort();
            this.finalOrdMap = new int[valueCount];
            int ord = 0;
            int[] nArray = this.finalOrdMap;
            if (this.finalOrdMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
                nArray = null;
            }
            int n = nArray.length;
            while (ord < n) {
                int[] nArray2 = this.finalOrdMap;
                if (this.finalOrdMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
                    nArray2 = null;
                }
                int[] nArray3 = this.finalSortedValues;
                if (this.finalSortedValues == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
                    nArray3 = null;
                }
                nArray2[nArray3[ord]] = ord;
                ++ord;
            }
        }
    }

    @Override
    @NotNull
    public SortedSetDocValues getDocValues() {
        this.finish();
        int[] nArray = this.finalSortedValues;
        if (this.finalSortedValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
            nArray = null;
        }
        int[] nArray2 = this.finalOrdMap;
        if (this.finalOrdMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
            nArray2 = null;
        }
        PackedLongValues packedLongValues = this.finalOrds;
        Intrinsics.checkNotNull((Object)packedLongValues);
        PackedLongValues packedLongValues2 = this.finalOrdCounts;
        Intrinsics.checkNotNull((Object)packedLongValues2);
        return this.getValues(nArray, nArray2, this.hash, packedLongValues, packedLongValues2, this.maxCount, this.docsWithField);
    }

    private final SortedSetDocValues getValues(int[] sortedValues, int[] ordMap, BytesRefHash hash, PackedLongValues ords, PackedLongValues ordCounts, int maxCount, DocsWithFieldSet docsWithField) {
        return ordCounts == null ? DocValues.INSTANCE.singleton(new SortedDocValuesWriter.BufferedSortedDocValues(hash, ords, sortedValues, ordMap, docsWithField.iterator())) : (SortedSetDocValues)new BufferedSortedSetDocValues(sortedValues, ordMap, hash, ords, ordCounts, maxCount, docsWithField.iterator());
    }

    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull DocValuesConsumer dvConsumer) throws IOException {
        DocOrds docOrds;
        int[] ordMap;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dvConsumer, (String)"dvConsumer");
        this.finish();
        PackedLongValues ords = this.finalOrds;
        PackedLongValues ordCounts = this.finalOrdCounts;
        int[] nArray = this.finalSortedValues;
        if (this.finalSortedValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
            nArray = null;
        }
        int[] sortedValues = nArray;
        int[] nArray2 = this.finalOrdMap;
        if (this.finalOrdMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
            nArray2 = ordMap = null;
        }
        if (ordCounts == null) {
            PackedLongValues packedLongValues = ords;
            Intrinsics.checkNotNull((Object)packedLongValues);
            DocValuesProducer singleValueProducer = SortedDocValuesWriter.Companion.getDocValuesProducer(this.fieldInfo, this.hash, packedLongValues, sortedValues, ordMap, this.docsWithField, sortMap);
            dvConsumer.addSortedSetField(this.fieldInfo, new EmptyDocValuesProducer(singleValueProducer){
                final /* synthetic */ DocValuesProducer $singleValueProducer;
                {
                    this.$singleValueProducer = $singleValueProducer;
                }

                public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                    return DocValues.INSTANCE.singleton(this.$singleValueProducer.getSorted(fieldInfo));
                }
            });
            return;
        }
        if (sortMap != null) {
            int n = state2.getSegmentInfo().maxDoc();
            PackedLongValues packedLongValues = ords;
            Intrinsics.checkNotNull((Object)packedLongValues);
            docOrds = new DocOrds(n, sortMap, this.getValues(sortedValues, ordMap, this.hash, packedLongValues, ordCounts, this.maxCount, this.docsWithField), 7.0f, PackedInts.INSTANCE.bitsRequired(this.maxCount));
        } else {
            docOrds = null;
        }
        DocOrds docOrds2 = docOrds;
        dvConsumer.addSortedSetField(this.fieldInfo, new EmptyDocValuesProducer(this, sortedValues, ordMap, ords, ordCounts, docOrds2){
            final /* synthetic */ SortedSetDocValuesWriter this$0;
            final /* synthetic */ int[] $sortedValues;
            final /* synthetic */ int[] $ordMap;
            final /* synthetic */ PackedLongValues $ords;
            final /* synthetic */ PackedLongValues $ordCounts;
            final /* synthetic */ DocOrds $docOrds;
            {
                this.this$0 = $receiver;
                this.$sortedValues = $sortedValues;
                this.$ordMap = $ordMap;
                this.$ords = $ords;
                this.$ordCounts = $ordCounts;
                this.$docOrds = $docOrds;
            }

            public SortedSetDocValues getSortedSet(FieldInfo fieldInfoIn) {
                Intrinsics.checkNotNullParameter((Object)fieldInfoIn, (String)"fieldInfoIn");
                if (!Intrinsics.areEqual((Object)fieldInfoIn, (Object)SortedSetDocValuesWriter.access$getFieldInfo$p(this.this$0))) {
                    boolean bl = false;
                    String string = "wrong fieldInfo";
                    throw new IllegalArgumentException(string.toString());
                }
                BytesRefHash bytesRefHash = this.this$0.getHash();
                PackedLongValues packedLongValues = this.$ords;
                Intrinsics.checkNotNull((Object)packedLongValues);
                SortedSetDocValues buf = SortedSetDocValuesWriter.access$getValues(this.this$0, this.$sortedValues, this.$ordMap, bytesRefHash, packedLongValues, this.$ordCounts, SortedSetDocValuesWriter.access$getMaxCount$p(this.this$0), SortedSetDocValuesWriter.access$getDocsWithField$p(this.this$0));
                return this.$docOrds == null ? buf : (SortedSetDocValues)new SortingSortedSetDocValues(buf, this.$docOrds);
            }
        });
    }

    public static final /* synthetic */ FieldInfo access$getFieldInfo$p(SortedSetDocValuesWriter $this) {
        return $this.fieldInfo;
    }

    public static final /* synthetic */ SortedSetDocValues access$getValues(SortedSetDocValuesWriter $this, int[] sortedValues, int[] ordMap, BytesRefHash hash, PackedLongValues ords, PackedLongValues ordCounts, int maxCount, DocsWithFieldSet docsWithField) {
        return $this.getValues(sortedValues, ordMap, hash, ords, ordCounts, maxCount, docsWithField);
    }

    public static final /* synthetic */ int access$getMaxCount$p(SortedSetDocValuesWriter $this) {
        return $this.maxCount;
    }

    public static final /* synthetic */ DocsWithFieldSet access$getDocsWithField$p(SortedSetDocValuesWriter $this) {
        return $this.docsWithField;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020(H\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u000bH\u0016J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u001b\u001a\u00060\u001cR\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u001f\u001a\u00060\u001cR\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R\u000e\u0010#\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$BufferedSortedSetDocValues;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "sortedValues", "", "ordMap", "hash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "ords", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "ordCounts", "maxCount", "", "docsWithField", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "([I[ILorg/gnit/lucenekmp/util/BytesRefHash;Lorg/gnit/lucenekmp/util/packed/PackedLongValues;Lorg/gnit/lucenekmp/util/packed/PackedLongValues;ILorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getSortedValues", "()[I", "getOrdMap", "getHash", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "scratch", "Lorg/gnit/lucenekmp/util/BytesRef;", "getScratch", "()Lorg/gnit/lucenekmp/util/BytesRef;", "ordsIter", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getOrdsIter", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "ordCountsIter", "getOrdCountsIter", "currentDoc", "getCurrentDoc", "ordCount", "ordUpto", "docID", "nextDoc", "nextOrd", "", "docValueCount", "cost", "advance", "target", "advanceExact", "", "valueCount", "getValueCount", "()J", "lookupOrd", "ord", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedSetDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter$BufferedSortedSetDocValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,424:1\n3#2,8:425\n8#2,2:434\n10#3:433\n*S KotlinDebug\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter$BufferedSortedSetDocValues\n*L\n280#1:425,8\n315#1:434,2\n280#1:433\n*E\n"})
    private static final class BufferedSortedSetDocValues
    extends SortedSetDocValues {
        @NotNull
        private final int[] sortedValues;
        @NotNull
        private final int[] ordMap;
        @NotNull
        private final BytesRefHash hash;
        @NotNull
        private final DocIdSetIterator docsWithField;
        @NotNull
        private final BytesRef scratch;
        @NotNull
        private final PackedLongValues.Iterator ordsIter;
        @NotNull
        private final PackedLongValues.Iterator ordCountsIter;
        @NotNull
        private final int[] currentDoc;
        private int ordCount;
        private int ordUpto;

        public BufferedSortedSetDocValues(@NotNull int[] sortedValues, @NotNull int[] ordMap, @NotNull BytesRefHash hash, @NotNull PackedLongValues ords, @NotNull PackedLongValues ordCounts, int maxCount, @NotNull DocIdSetIterator docsWithField) {
            Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
            Intrinsics.checkNotNullParameter((Object)ordMap, (String)"ordMap");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)ords, (String)"ords");
            Intrinsics.checkNotNullParameter((Object)ordCounts, (String)"ordCounts");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            this.sortedValues = sortedValues;
            this.ordMap = ordMap;
            this.hash = hash;
            this.docsWithField = docsWithField;
            this.scratch = new BytesRef();
            this.ordsIter = ords.iterator();
            this.ordCountsIter = ordCounts.iterator();
            this.currentDoc = new int[maxCount];
        }

        @NotNull
        public final int[] getSortedValues() {
            return this.sortedValues;
        }

        @NotNull
        public final int[] getOrdMap() {
            return this.ordMap;
        }

        @NotNull
        public final BytesRefHash getHash() {
            return this.hash;
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @NotNull
        public final BytesRef getScratch() {
            return this.scratch;
        }

        @NotNull
        public final PackedLongValues.Iterator getOrdsIter() {
            return this.ordsIter;
        }

        @NotNull
        public final PackedLongValues.Iterator getOrdCountsIter() {
            return this.ordCountsIter;
        }

        @NotNull
        public final int[] getCurrentDoc() {
            return this.currentDoc;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ordCount = (int)this.ordCountsIter.next();
                boolean condition$iv = this.ordCount > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                int n = this.ordCount;
                for (int i = 0; i < n; ++i) {
                    this.currentDoc[i] = this.ordMap[Math.INSTANCE.toIntExact(this.ordsIter.next())];
                }
                Arrays.INSTANCE.sort(this.currentDoc, 0, this.ordCount);
                this.ordUpto = 0;
            }
            return docID;
        }

        @Override
        public long nextOrd() {
            int n = this.ordUpto;
            this.ordUpto = n + 1;
            return this.currentDoc[n];
        }

        @Override
        public int docValueCount() {
            return this.ordCount;
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getValueCount() {
            return this.ordMap.length;
        }

        @Override
        @NotNull
        public BytesRef lookupOrd(long ord) {
            boolean condition$iv = ord >= 0L && ord < (long)this.ordMap.length;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "ord=" + ord + " is out of bounds 0 .. " + (this.ordMap.length - 1);
                throw new AssertionError((Object)string);
            }
            this.hash.get(this.sortedValues[Math.INSTANCE.toIntExact(ord)], this.scratch);
            return this.scratch;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$DocOrds;", "", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "oldValues", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "acceptableOverheadRatio", "", "bitsPerValue", "<init>", "(ILorg/gnit/lucenekmp/index/Sorter$DocMap;Lorg/gnit/lucenekmp/index/SortedSetDocValues;FI)V", "offsets", "", "getOffsets", "()[J", "ords", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "getOrds", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "docValueCounts", "Lorg/gnit/lucenekmp/util/packed/GrowableWriter;", "getDocValueCounts", "()Lorg/gnit/lucenekmp/util/packed/GrowableWriter;", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedSetDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter$DocOrds\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,424:1\n1#2:425\n*E\n"})
    public static final class DocOrds {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final long[] offsets;
        @NotNull
        private final PackedLongValues ords;
        @NotNull
        private final GrowableWriter docValueCounts;
        public static final int START_BITS_PER_VALUE = 2;

        public DocOrds(int maxDoc, @NotNull Sorter.DocMap sortMap, @NotNull SortedSetDocValues oldValues, float acceptableOverheadRatio, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)sortMap, (String)"sortMap");
            Intrinsics.checkNotNullParameter((Object)oldValues, (String)"oldValues");
            this.offsets = new long[maxDoc];
            PackedLongValues.Builder builder = PackedLongValues.Companion.packedBuilder(acceptableOverheadRatio);
            this.docValueCounts = new GrowableWriter(bitsPerValue, maxDoc, acceptableOverheadRatio);
            long ordOffset = 1L;
            int docID = 0;
            while (true) {
                int n;
                int it = n = oldValues.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                int newDocID = sortMap.oldToNew(docID);
                long startOffset = ordOffset;
                int docValueCount = oldValues.docValueCount();
                ordOffset += (long)docValueCount;
                for (int i = 0; i < docValueCount; ++i) {
                    builder.add(oldValues.nextOrd());
                }
                this.docValueCounts.set(newDocID, ordOffset - startOffset);
                if (startOffset == ordOffset) continue;
                this.offsets[newDocID] = startOffset;
            }
            this.ords = builder.build();
        }

        @NotNull
        public final long[] getOffsets() {
            return this.offsets;
        }

        @NotNull
        public final PackedLongValues getOrds() {
            return this.ords;
        }

        @NotNull
        public final GrowableWriter getDocValueCounts() {
            return this.docValueCounts;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$DocOrds$Companion;", "", "<init>", "()V", "START_BITS_PER_VALUE", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$SortingSortedSetDocValues;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "in", "ords", "Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$DocOrds;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;Lorg/gnit/lucenekmp/index/SortedSetDocValuesWriter$DocOrds;)V", "docID", "", "ordUpto", "", "count", "nextDoc", "advance", "target", "advanceExact", "", "nextOrd", "docValueCount", "cost", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "valueCount", "getValueCount", "()J", "initCount", "", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedSetDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter$SortingSortedSetDocValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,424:1\n1#2:425\n3#3,8:426\n3#3,8:435\n10#4:434\n10#4:443\n*S KotlinDebug\n*F\n+ 1 SortedSetDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedSetDocValuesWriter$SortingSortedSetDocValues\n*L\n361#1:426,8\n378#1:435,8\n361#1:434\n378#1:443\n*E\n"})
    public static final class SortingSortedSetDocValues
    extends SortedSetDocValues {
        @NotNull
        private final SortedSetDocValues in;
        @NotNull
        private final DocOrds ords;
        private int docID;
        private long ordUpto;
        private int count;

        public SortingSortedSetDocValues(@NotNull SortedSetDocValues in, @NotNull DocOrds ords) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)ords, (String)"ords");
            this.in = in;
            this.ords = ords;
            this.docID = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                int n = this.docID;
                this.docID = n + 1;
                if (this.docID != this.ords.getOffsets().length) continue;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.docID = it;
                return n;
            } while (this.ords.getOffsets()[this.docID] <= 0L);
            this.initCount();
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            this.initCount();
            return this.ords.getOffsets()[this.docID] > 0L;
        }

        @Override
        public long nextOrd() {
            long l = this.ordUpto;
            this.ordUpto = l + 1L;
            return this.ords.getOrds().get(l);
        }

        @Override
        public int docValueCount() {
            boolean condition$iv = this.docID >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return this.count;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(long ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public long getValueCount() {
            return this.in.getValueCount();
        }

        private final void initCount() {
            boolean condition$iv = this.docID >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.ordUpto = this.ords.getOffsets()[this.docID] - 1L;
            this.count = (int)this.ords.getDocValueCounts().get(this.docID);
        }
    }
}

