/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexSorter;
import org.gnit.lucenekmp.index.LeafMetaData;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.TimSorter;
import org.gnit.lucenekmp.util.Version;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0002\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ#\u0010\u0002\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/index/Sorter;", "", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "<init>", "(Lorg/gnit/lucenekmp/search/Sort;)V", "getSort", "()Lorg/gnit/lucenekmp/search/Sort;", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "maxDoc", "", "comparators", "", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "(I[Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;)Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "iD", "", "getID", "()Ljava/lang/String;", "toString", "DocMap", "DocValueSorter", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sorter.kt\norg/gnit/lucenekmp/index/Sorter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class Sorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sort sort;

    public Sorter(@NotNull Sort sort2) {
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        if (!(!sort2.needsScores())) {
            boolean bl = false;
            String string = "Cannot sort an index with a Sort that refers to the relevance score";
            throw new IllegalArgumentException(string.toString());
        }
        this.sort = sort2;
    }

    @NotNull
    public final Sort getSort() {
        return this.sort;
    }

    @Nullable
    public final DocMap sort(@NotNull LeafReader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        SortField[] fields = this.sort.getSort();
        IndexSorter.DocComparator[] comparators = new IndexSorter.DocComparator[fields.length];
        Function1 comparatorWrapper = Sorter::sort$lambda$1;
        LeafMetaData metaData = reader2.getMetaData();
        FieldInfos fieldInfos = reader2.getFieldInfos();
        if (metaData.getHasBlocks() && fieldInfos.getParentField() != null) {
            NumericDocValues numericDocValues = reader2.getNumericDocValues(fieldInfos.getParentField());
            Intrinsics.checkNotNull((Object)numericDocValues);
            BitSet parents = BitSet.Companion.of(numericDocValues, reader2.maxDoc());
            comparatorWrapper = arg_0 -> Sorter.sort$lambda$2(parents, arg_0);
        }
        if (metaData.getHasBlocks() && fieldInfos.getParentField() == null && metaData.getCreatedVersionMajor() >= Version.Companion.getLUCENE_10_0_0().getMajor()) {
            throw new CorruptIndexException("parent field is not set but the index has blocks. indexCreatedVersionMajor: " + metaData.getCreatedVersionMajor(), "Sorter", null, 4, null);
        }
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            IndexSorter sorter2 = fields[i].getIndexSorter();
            if (sorter2 == null) {
                boolean bl = false;
                String string = "Cannot use sortfield + " + fields[i] + " to sort indexes";
                throw new IllegalArgumentException(string.toString());
            }
            comparators[i] = comparatorWrapper.invoke((Object)sorter2.getDocComparator(reader2, reader2.maxDoc()));
        }
        return this.sort(reader2.maxDoc(), comparators);
    }

    @Nullable
    public final DocMap sort(int maxDoc, @NotNull IndexSorter.DocComparator[] comparators) throws IOException {
        Intrinsics.checkNotNullParameter((Object)comparators, (String)"comparators");
        IndexSorter.DocComparator comparator2 = new IndexSorter.DocComparator(comparators){
            final /* synthetic */ IndexSorter.DocComparator[] $comparators;
            {
                this.$comparators = $comparators;
            }

            public int compare(int docID1, int docID2) {
                int n = this.$comparators.length;
                for (int i = 0; i < n; ++i) {
                    int comp = this.$comparators[i].compare(docID1, docID2);
                    if (comp == 0) continue;
                    return comp;
                }
                return IntExtKt.compare(IntCompanionObject.INSTANCE, docID1, docID2);
            }
        };
        return Sorter.Companion.sort(maxDoc, comparator2);
    }

    @NotNull
    public final String getID() {
        return this.sort.toString();
    }

    @NotNull
    public String toString() {
        return this.getID();
    }

    private static final IndexSorter.DocComparator sort$lambda$1(IndexSorter.DocComparator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final sort.1.1 sort$lambda$2(BitSet $parents, IndexSorter.DocComparator input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new IndexSorter.DocComparator(input, $parents){
            final /* synthetic */ IndexSorter.DocComparator $input;
            final /* synthetic */ BitSet $parents;
            {
                this.$input = $input;
                this.$parents = $parents;
            }

            public int compare(int docID1, int docID2) {
                return this.$input.compare(this.$parents.nextSetBit(docID1), this.$parents.nextSetBit(docID2));
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/index/Sorter$Companion;", "", "<init>", "()V", "isConsistent", "", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "sort", "maxDoc", "", "comparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "core"})
    @SourceDebugExtension(value={"SMAP\nSorter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sorter.kt\norg/gnit/lucenekmp/index/Sorter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isConsistent(@NotNull DocMap docMap) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            int maxDoc = docMap.size();
            for (int i = 0; i < maxDoc; ++i) {
                int newID = docMap.oldToNew(i);
                int oldID = docMap.newToOld(newID);
                if (!(newID >= 0 && newID < maxDoc)) {
                    boolean $i$a$-require-Sorter$Companion$isConsistent$32 = false;
                    String $i$a$-require-Sorter$Companion$isConsistent$32 = "doc IDs must be in [0-" + maxDoc + "[, got " + newID;
                    throw new IllegalArgumentException($i$a$-require-Sorter$Companion$isConsistent$32.toString());
                }
                if (!(i == oldID)) {
                    boolean bl = false;
                    String string = "mapping is inconsistent: " + i + " --oldToNew--> " + newID + " --newToOld--> " + oldID;
                    throw new IllegalArgumentException(string.toString());
                }
                if (i == oldID && newID >= 0 && newID < maxDoc) continue;
                return false;
            }
            return true;
        }

        private final DocMap sort(int maxDoc, IndexSorter.DocComparator comparator2) {
            boolean sorted = true;
            for (int i = 1; i < maxDoc; ++i) {
                if (comparator2.compare(i - 1, i) <= 0) continue;
                sorted = false;
                break;
            }
            if (sorted) {
                return null;
            }
            int[] docs = new int[maxDoc];
            for (int i = 0; i < maxDoc; ++i) {
                docs[i] = i;
            }
            DocValueSorter sorter2 = new DocValueSorter(docs, comparator2);
            sorter2.sort(0, docs.length);
            PackedLongValues.Builder newToOldBuilder = PackedLongValues.Companion.monotonicBuilder(0.0f);
            for (int i = 0; i < maxDoc; ++i) {
                newToOldBuilder.add(docs[i]);
            }
            PackedLongValues newToOld = newToOldBuilder.build();
            for (int i = 0; i < maxDoc; ++i) {
                docs[(int)newToOld.get((long)((long)i))] = i;
            }
            PackedLongValues.Builder oldToNewBuilder = PackedLongValues.Companion.monotonicBuilder(0.0f);
            for (int i = 0; i < maxDoc; ++i) {
                oldToNewBuilder.add(docs[i]);
            }
            PackedLongValues oldToNew = oldToNewBuilder.build();
            return new DocMap(oldToNew, newToOld, maxDoc){
                final /* synthetic */ PackedLongValues $oldToNew;
                final /* synthetic */ PackedLongValues $newToOld;
                final /* synthetic */ int $maxDoc;
                {
                    this.$oldToNew = $oldToNew;
                    this.$newToOld = $newToOld;
                    this.$maxDoc = $maxDoc;
                }

                public int oldToNew(int docID) {
                    return (int)this.$oldToNew.get(docID);
                }

                public int newToOld(int docID) {
                    return (int)this.$newToOld.get(docID);
                }

                public int size() {
                    return this.$maxDoc;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "", "<init>", "()V", "oldToNew", "", "docID", "newToOld", "size", "core"})
    public static abstract class DocMap {
        protected DocMap() {
        }

        public abstract int oldToNew(int var1);

        public abstract int newToOld(int var1);

        public abstract int size();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0014J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/Sorter$DocValueSorter;", "Lorg/gnit/lucenekmp/util/TimSorter;", "docs", "", "comparator", "Lorg/gnit/lucenekmp/index/IndexSorter$DocComparator;", "<init>", "([ILorg/gnit/lucenekmp/index/IndexSorter$DocComparator;)V", "tmp", "compare", "", "i", "j", "swap", "", "copy", "src", "dest", "save", "len", "restore", "compareSaved", "core"})
    private static final class DocValueSorter
    extends TimSorter {
        @NotNull
        private final int[] docs;
        @NotNull
        private final IndexSorter.DocComparator comparator;
        @NotNull
        private final int[] tmp;

        public DocValueSorter(@NotNull int[] docs, @NotNull IndexSorter.DocComparator comparator2) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            super(docs.length / 64);
            this.docs = docs;
            this.comparator = comparator2;
            this.tmp = new int[this.docs.length / 64];
        }

        @Override
        protected int compare(int i, int j) {
            return this.comparator.compare(this.docs[i], this.docs[j]);
        }

        @Override
        protected void swap(int i, int j) {
            int tmpDoc = this.docs[i];
            this.docs[i] = this.docs[j];
            this.docs[j] = tmpDoc;
        }

        @Override
        protected void copy(int src, int dest) {
            this.docs[dest] = this.docs[src];
        }

        @Override
        protected void save(int i, int len) {
            ArraysKt.copyInto((int[])this.docs, (int[])this.tmp, (int)0, (int)i, (int)(i + len));
        }

        @Override
        protected void restore(int i, int j) {
            this.docs[j] = this.tmp[i];
        }

        @Override
        protected int compareSaved(int i, int j) {
            return this.comparator.compare(this.tmp[i], this.docs[j]);
        }
    }
}

