/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.StoredFieldsFormat;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsWriter;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.gnit.lucenekmp.index.StoredFieldsConsumer;
import org.gnit.lucenekmp.index.TrackingTmpOutputDirectoryWrapper;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/SortingStoredFieldsConsumer;", "Lorg/gnit/lucenekmp/index/StoredFieldsConsumer;", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "info", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "<init>", "(Lorg/gnit/lucenekmp/codecs/Codec;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;)V", "tmpDirectory", "Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;", "getTmpDirectory", "()Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;", "setTmpDirectory", "(Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;)V", "initStoredFieldsWriter", "", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "abort", "CopyVisitor", "Companion", "core"})
public final class SortingStoredFieldsConsumer
extends StoredFieldsConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TrackingTmpOutputDirectoryWrapper tmpDirectory;
    @NotNull
    private static final CompressionMode NO_COMPRESSION = new CompressionMode(){

        public Compressor newCompressor() {
            return new Compressor(){

                public void close() throws IOException {
                }

                public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                    out.copyBytes(buffersInput, buffersInput.length());
                }
            };
        }

        public Decompressor newDecompressor() {
            return new Decompressor(){

                public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                    bytes.setBytes(ArrayUtil.Companion.growNoCopy(bytes.getBytes(), length));
                    in.skipBytes(offset);
                    in.readBytes(bytes.getBytes(), 0, length);
                    bytes.setOffset(0);
                    bytes.setLength(length);
                }

                public Decompressor clone() {
                    return this;
                }
            };
        }
    };
    @NotNull
    private static final StoredFieldsFormat TEMP_STORED_FIELDS_FORMAT = new Lucene90CompressingStoredFieldsFormat("TempStoredFields", NO_COMPRESSION, 131072, 1, 10);

    public SortingStoredFieldsConsumer(@NotNull Codec codec, @NotNull Directory directory, @NotNull SegmentInfo info) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(codec, directory, info);
    }

    @Nullable
    public final TrackingTmpOutputDirectoryWrapper getTmpDirectory() {
        return this.tmpDirectory;
    }

    public final void setTmpDirectory(@Nullable TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper) {
        this.tmpDirectory = trackingTmpOutputDirectoryWrapper;
    }

    @Override
    protected void initStoredFieldsWriter() throws IOException {
        if (this.getWriter() == null) {
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.getDirectory());
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
            this.setWriter(TEMP_STORED_FIELDS_FORMAT.fieldsWriter(trackingTmpOutputDirectoryWrapper, this.getInfo(), IOContext.Companion.getDEFAULT()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        super.flush(state2, sortMap);
        TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory;
        Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
        StoredFieldsReader reader2 = TEMP_STORED_FIELDS_FORMAT.fieldsReader(trackingTmpOutputDirectoryWrapper, state2.getSegmentInfo(), state2.getFieldInfos(), IOContext.Companion.getDEFAULT());
        StoredFieldsWriter sortWriter = this.getCodec().storedFieldsFormat().fieldsWriter(state2.getDirectory(), state2.getSegmentInfo(), state2.getContext());
        try {
            reader2.checkIntegrity();
            CopyVisitor visitor2 = new CopyVisitor(sortWriter);
            int n = state2.getSegmentInfo().maxDoc();
            for (int docID = 0; docID < n; ++docID) {
                sortWriter.startDocument();
                Sorter.DocMap docMap = sortMap;
                reader2.document(docMap == null ? docID : docMap.newToOld(docID), visitor2);
                sortWriter.finishDocument();
            }
            sortWriter.finish(state2.getSegmentInfo().maxDoc());
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{reader2, sortWriter};
            IOUtils.INSTANCE.close(autoCloseableArray);
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper2 = this.tmpDirectory;
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper2);
            Directory directory = trackingTmpOutputDirectoryWrapper2;
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper3 = this.tmpDirectory;
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper3);
            IOUtils.INSTANCE.deleteFiles(directory, trackingTmpOutputDirectoryWrapper3.getTemporaryFiles().values());
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{reader2, sortWriter};
        IOUtils.INSTANCE.close(autoCloseableArray);
        TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper4 = this.tmpDirectory;
        Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper4);
        Directory directory = trackingTmpOutputDirectoryWrapper4;
        TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper5 = this.tmpDirectory;
        Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper5);
        IOUtils.INSTANCE.deleteFiles(directory, trackingTmpOutputDirectoryWrapper5.getTemporaryFiles().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
                Directory directory = trackingTmpOutputDirectoryWrapper;
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper2 = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper2);
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(directory, trackingTmpOutputDirectoryWrapper2.getTemporaryFiles().values());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/SortingStoredFieldsConsumer$Companion;", "", "<init>", "()V", "NO_COMPRESSION", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "getNO_COMPRESSION", "()Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "TEMP_STORED_FIELDS_FORMAT", "Lorg/gnit/lucenekmp/codecs/StoredFieldsFormat;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompressionMode getNO_COMPRESSION() {
            return NO_COMPRESSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/index/SortingStoredFieldsConsumer$CopyVisitor;", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor;", "writer", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "<init>", "(Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;)V", "getWriter", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "binaryField", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "value", "Lorg/gnit/lucenekmp/index/StoredFieldDataInput;", "", "stringField", "", "intField", "", "longField", "", "floatField", "", "doubleField", "", "needsField", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor$Status;", "core"})
    private static final class CopyVisitor
    extends StoredFieldVisitor {
        @NotNull
        private final StoredFieldsWriter writer;

        public CopyVisitor(@NotNull StoredFieldsWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.writer = writer;
        }

        @NotNull
        public final StoredFieldsWriter getWriter() {
            return this.writer;
        }

        @Override
        public void binaryField(@NotNull FieldInfo fieldInfo, @NotNull StoredFieldDataInput value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void binaryField(@NotNull FieldInfo fieldInfo, @NotNull byte[] value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.writer.writeField(fieldInfo, new BytesRef(value));
        }

        @Override
        public void stringField(@NotNull FieldInfo fieldInfo, @NotNull String value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void intField(@NotNull FieldInfo fieldInfo, int value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void longField(@NotNull FieldInfo fieldInfo, long value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void floatField(@NotNull FieldInfo fieldInfo, float value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void doubleField(@NotNull FieldInfo fieldInfo, double value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        @NotNull
        public StoredFieldVisitor.Status needsField(@NotNull FieldInfo fieldInfo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            return StoredFieldVisitor.Status.YES;
        }
    }
}

