/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.TermVectorsFormat;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.codecs.TermVectorsWriter;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingTermVectorsFormat;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.SortingStoredFieldsConsumer;
import org.gnit.lucenekmp.index.TermVectorsConsumer;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.index.TrackingTmpOutputDirectoryWrapper;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FlushInfo;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ6\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/SortingTermVectorsConsumer;", "Lorg/gnit/lucenekmp/index/TermVectorsConsumer;", "intBlockAllocator", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "byteBlockAllocator", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "info", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "<init>", "(Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/codecs/Codec;)V", "tmpDirectory", "Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;", "getTmpDirectory", "()Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;", "setTmpDirectory", "(Lorg/gnit/lucenekmp/index/TrackingTmpOutputDirectoryWrapper;)V", "flush", "", "fieldsToFlush", "", "", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "norms", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "initTermVectorsWriter", "abort", "Companion", "core"})
public final class SortingTermVectorsConsumer
extends TermVectorsConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TrackingTmpOutputDirectoryWrapper tmpDirectory;
    @NotNull
    private static final TermVectorsFormat TEMP_TERM_VECTORS_FORMAT = new Lucene90CompressingTermVectorsFormat("TempTermVectors", "", SortingStoredFieldsConsumer.Companion.getNO_COMPRESSION(), 8192, 128, 10);

    public SortingTermVectorsConsumer(@NotNull IntBlockPool.Allocator intBlockAllocator, @NotNull ByteBlockPool.Allocator byteBlockAllocator, @NotNull Directory directory, @NotNull SegmentInfo info, @NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)intBlockAllocator, (String)"intBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)byteBlockAllocator, (String)"byteBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        super(intBlockAllocator, byteBlockAllocator, directory, info, codec);
    }

    @Nullable
    public final TrackingTmpOutputDirectoryWrapper getTmpDirectory() {
        return this.tmpDirectory;
    }

    public final void setTmpDirectory(@Nullable TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper) {
        this.tmpDirectory = trackingTmpOutputDirectoryWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(@NotNull Map<String, TermsHashPerField> fieldsToFlush, @NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull NormsProducer norms) throws IOException {
        Intrinsics.checkNotNullParameter(fieldsToFlush, (String)"fieldsToFlush");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        super.flush(fieldsToFlush, state2, sortMap, norms);
        if (this.tmpDirectory != null) {
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory;
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
            TermVectorsReader reader2 = TEMP_TERM_VECTORS_FORMAT.vectorsReader(trackingTmpOutputDirectoryWrapper, state2.getSegmentInfo(), state2.getFieldInfos(), IOContext.Companion.getDEFAULT());
            TermVectorsWriter writer = this.getCodec().termVectorsFormat().vectorsWriter(state2.getDirectory(), state2.getSegmentInfo(), state2.getContext());
            try {
                reader2.checkIntegrity();
                int n = state2.getSegmentInfo().maxDoc();
                for (int docID = 0; docID < n; ++docID) {
                    Sorter.DocMap docMap = sortMap;
                    Fields vectors = reader2.get(docMap == null ? docID : docMap.newToOld(docID));
                    SortingTermVectorsConsumer.Companion.writeTermVectors(writer, vectors, state2.getFieldInfos());
                }
                writer.finish(state2.getSegmentInfo().maxDoc());
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{reader2, writer};
                IOUtils.INSTANCE.close(autoCloseableArray);
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper2 = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper2);
                Directory directory = trackingTmpOutputDirectoryWrapper2;
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper3 = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper3);
                IOUtils.INSTANCE.deleteFiles(directory, trackingTmpOutputDirectoryWrapper3.getTemporaryFiles().values());
                throw throwable;
            }
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{reader2, writer};
            IOUtils.INSTANCE.close(autoCloseableArray);
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper4 = this.tmpDirectory;
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper4);
            Directory directory = trackingTmpOutputDirectoryWrapper4;
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper5 = this.tmpDirectory;
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper5);
            IOUtils.INSTANCE.deleteFiles(directory, trackingTmpOutputDirectoryWrapper5.getTemporaryFiles().values());
        }
    }

    @Override
    public void initTermVectorsWriter() throws IOException {
        if (this.getWriter() == null) {
            IOContext context = new IOContext(new FlushInfo(this.getLastDocID(), this.getBytesUsed().get()));
            TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.getDirectory());
            Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
            this.setWriter(TEMP_TERM_VECTORS_FORMAT.vectorsWriter(trackingTmpOutputDirectoryWrapper, this.getInfo(), context));
            this.setLastDocID(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper);
                Directory directory = trackingTmpOutputDirectoryWrapper;
                TrackingTmpOutputDirectoryWrapper trackingTmpOutputDirectoryWrapper2 = this.tmpDirectory;
                Intrinsics.checkNotNull((Object)trackingTmpOutputDirectoryWrapper2);
                IOUtils.INSTANCE.deleteFilesIgnoringExceptions(directory, trackingTmpOutputDirectoryWrapper2.getTemporaryFiles().values());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/SortingTermVectorsConsumer$Companion;", "", "<init>", "()V", "TEMP_TERM_VECTORS_FORMAT", "Lorg/gnit/lucenekmp/codecs/TermVectorsFormat;", "writeTermVectors", "", "writer", "Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;", "vectors", "Lorg/gnit/lucenekmp/index/Fields;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "core"})
    @SourceDebugExtension(value={"SMAP\nSortingTermVectorsConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortingTermVectorsConsumer.kt\norg/gnit/lucenekmp/index/SortingTermVectorsConsumer$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,201:1\n8#2,2:202\n3#2,8:204\n3#2,8:213\n3#2,8:222\n3#2,8:231\n3#2,8:240\n3#2,8:249\n10#3:212\n10#3:221\n10#3:230\n10#3:239\n10#3:248\n10#3:257\n*S KotlinDebug\n*F\n+ 1 SortingTermVectorsConsumer.kt\norg/gnit/lucenekmp/index/SortingTermVectorsConsumer$Companion\n*L\n130#1:202,2\n144#1:204,8\n177#1:213,8\n178#1:222,8\n187#1:231,8\n193#1:240,8\n196#1:249,8\n144#1:212\n177#1:221\n178#1:230\n187#1:239\n193#1:248\n196#1:257\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void writeTermVectors(TermVectorsWriter writer, Fields vectors, FieldInfos fieldInfos) throws IOException {
            if (vectors == null) {
                writer.startDocument(0);
                writer.finishDocument();
                return;
            }
            int numFields = vectors.size();
            if (numFields == -1) {
                numFields = 0;
                Iterator<String> it = vectors.iterator();
                while (it.hasNext()) {
                    it.next();
                    ++numFields;
                }
            }
            writer.startDocument(numFields);
            String lastFieldName = null;
            TermsEnum termsEnum = null;
            PostingsEnum docsAndPositionsEnum = null;
            int fieldCount = 0;
            for (String fieldName : vectors) {
                void condition$iv;
                ++fieldCount;
                FieldInfos fieldInfos2 = fieldInfos;
                Intrinsics.checkNotNull((Object)fieldInfos2);
                FieldInfo fieldInfo = fieldInfos2.fieldInfo(fieldName);
                boolean bl = lastFieldName == null || fieldName.compareTo(lastFieldName) > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == false) {
                    boolean bl2 = false;
                    String string = "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
                    throw new AssertionError((Object)string);
                }
                lastFieldName = fieldName;
                Terms terms = vectors.terms(fieldName);
                if (terms == null) continue;
                boolean hasPositions = terms.hasPositions();
                boolean hasOffsets = terms.hasOffsets();
                boolean hasPayloads = terms.hasPayloads();
                boolean condition$iv2 = !hasPayloads || hasPositions;
                boolean $i$f$assert2 = false;
                if (_Assertions.ENABLED && !condition$iv2) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
                int numTerms = (int)terms.size();
                if (numTerms == -1) {
                    numTerms = 0;
                    termsEnum = terms.iterator();
                    while (termsEnum.next() != null) {
                        ++numTerms;
                    }
                }
                writer.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
                termsEnum = terms.iterator();
                int termCount = 0;
                while (termsEnum.next() != null) {
                    ++termCount;
                    int freq = (int)termsEnum.totalTermFreq();
                    writer.startTerm(termsEnum.term(), freq);
                    if (hasPositions || hasOffsets) {
                        boolean $i$a$-assert-AssertKt$assert$32;
                        if ((docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, PostingsEnum.Companion.getOFFSETS() | PostingsEnum.Companion.getPAYLOADS())) == null) {
                            String $i$a$-assert-AssertKt$assert$22 = "Required value was null.";
                            throw new IllegalStateException($i$a$-assert-AssertKt$assert$22.toString());
                        }
                        int docID = docsAndPositionsEnum.nextDoc();
                        boolean condition$iv3 = docID != Integer.MAX_VALUE;
                        boolean $i$f$assert3 = false;
                        if (_Assertions.ENABLED && !condition$iv3) {
                            $i$a$-assert-AssertKt$assert$32 = false;
                            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                        }
                        condition$iv3 = docsAndPositionsEnum.freq() == freq;
                        $i$f$assert3 = false;
                        if (_Assertions.ENABLED && !condition$iv3) {
                            $i$a$-assert-AssertKt$assert$32 = false;
                            String string = "assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        for (int posUpto = 0; posUpto < freq; ++posUpto) {
                            int pos = docsAndPositionsEnum.nextPosition();
                            int startOffset = docsAndPositionsEnum.startOffset();
                            int endOffset = docsAndPositionsEnum.endOffset();
                            BytesRef payload = docsAndPositionsEnum.getPayload();
                            boolean condition$iv4 = !hasPositions || pos >= 0;
                            boolean $i$f$assert4 = false;
                            if (_Assertions.ENABLED && !condition$iv4) {
                                boolean bl3 = false;
                                String string = "assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            writer.addPosition(pos, startOffset, endOffset, payload);
                        }
                    }
                    writer.finishTerm();
                }
                boolean condition$iv5 = termCount == numTerms;
                boolean $i$f$assert5 = false;
                if (_Assertions.ENABLED && !condition$iv5) {
                    boolean bl4 = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                writer.finishField();
            }
            boolean condition$iv = fieldCount == numFields;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            writer.finishDocument();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

