/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.TermVectorsWriter;
import org.gnit.lucenekmp.index.ByteSliceReader;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInvertState;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.TermVectorsConsumerPerField;
import org.gnit.lucenekmp.index.TermsHash;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FlushInfo;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ6\u00107\u001a\u0002082\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020BH\u0016J\u000e\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020'J\b\u0010E\u001a\u000208H\u0016J\u0006\u0010F\u001a\u000208J\u0010\u0010G\u001a\u0002082\u0006\u0010D\u001a\u00020'H\u0016J\b\u0010H\u001a\u000208H\u0016J\u0006\u0010I\u001a\u000208J\u0018\u0010J\u001a\u00020<2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u0002082\b\u0010P\u001a\u0004\u0018\u00010/J\b\u0010Q\u001a\u000208H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0018\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006R"}, d2={"Lorg/gnit/lucenekmp/index/TermVectorsConsumer;", "Lorg/gnit/lucenekmp/index/TermsHash;", "intBlockAllocator", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "byteBlockAllocator", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "info", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "<init>", "(Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/codecs/Codec;)V", "getDirectory", "()Lorg/gnit/lucenekmp/store/Directory;", "getInfo", "()Lorg/gnit/lucenekmp/index/SegmentInfo;", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "writer", "Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;", "getWriter", "()Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;", "setWriter", "(Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;)V", "flushTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "getFlushTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "vectorSliceReaderPos", "Lorg/gnit/lucenekmp/index/ByteSliceReader;", "getVectorSliceReaderPos", "()Lorg/gnit/lucenekmp/index/ByteSliceReader;", "vectorSliceReaderOff", "getVectorSliceReaderOff", "hasVectors", "", "numVectorFields", "", "lastDocID", "getLastDocID", "()I", "setLastDocID", "(I)V", "perFields", "", "Lorg/gnit/lucenekmp/index/TermVectorsConsumerPerField;", "[Lorg/gnit/lucenekmp/index/TermVectorsConsumerPerField;", "accountable", "Lorg/gnit/lucenekmp/util/Accountable;", "getAccountable", "()Lorg/gnit/lucenekmp/util/Accountable;", "setAccountable", "(Lorg/gnit/lucenekmp/util/Accountable;)V", "flush", "", "fieldsToFlush", "", "", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "norms", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "fill", "docID", "initTermVectorsWriter", "setHasVectors", "finishDocument", "abort", "resetFields", "addField", "invertState", "Lorg/gnit/lucenekmp/index/FieldInvertState;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "addFieldToFlush", "fieldToFlush", "startDocument", "core"})
@SourceDebugExtension(value={"SMAP\nTermVectorsConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermVectorsConsumer.kt\norg/gnit/lucenekmp/index/TermVectorsConsumer\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,173:1\n3#2,8:174\n8#2,2:183\n10#3:182\n*S KotlinDebug\n*F\n+ 1 TermVectorsConsumer.kt\norg/gnit/lucenekmp/index/TermVectorsConsumer\n*L\n62#1:174,8\n124#1:183,2\n62#1:182\n*E\n"})
public class TermVectorsConsumer
extends TermsHash {
    @NotNull
    private final Directory directory;
    @NotNull
    private final SegmentInfo info;
    @NotNull
    private final Codec codec;
    @Nullable
    private TermVectorsWriter writer;
    @NotNull
    private final BytesRef flushTerm;
    @NotNull
    private final ByteSliceReader vectorSliceReaderPos;
    @NotNull
    private final ByteSliceReader vectorSliceReaderOff;
    private boolean hasVectors;
    private int numVectorFields;
    private int lastDocID;
    @NotNull
    private TermVectorsConsumerPerField[] perFields;
    @NotNull
    private Accountable accountable;

    public TermVectorsConsumer(@NotNull IntBlockPool.Allocator intBlockAllocator, @NotNull ByteBlockPool.Allocator byteBlockAllocator, @NotNull Directory directory, @NotNull SegmentInfo info, @NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)intBlockAllocator, (String)"intBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)byteBlockAllocator, (String)"byteBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        super(intBlockAllocator, byteBlockAllocator, Counter.Companion.newCounter$default(Counter.Companion, false, 1, null), null);
        this.directory = directory;
        this.info = info;
        this.codec = codec;
        this.flushTerm = new BytesRef();
        this.vectorSliceReaderPos = new ByteSliceReader();
        this.vectorSliceReaderOff = new ByteSliceReader();
        this.perFields = new TermVectorsConsumerPerField[1];
        this.accountable = Accountable.Companion.getNULL_ACCOUNTABLE();
    }

    @NotNull
    protected final Directory getDirectory() {
        return this.directory;
    }

    @NotNull
    protected final SegmentInfo getInfo() {
        return this.info;
    }

    @NotNull
    protected final Codec getCodec() {
        return this.codec;
    }

    @Nullable
    public final TermVectorsWriter getWriter() {
        return this.writer;
    }

    public final void setWriter(@Nullable TermVectorsWriter termVectorsWriter) {
        this.writer = termVectorsWriter;
    }

    @NotNull
    public final BytesRef getFlushTerm() {
        return this.flushTerm;
    }

    @NotNull
    public final ByteSliceReader getVectorSliceReaderPos() {
        return this.vectorSliceReaderPos;
    }

    @NotNull
    public final ByteSliceReader getVectorSliceReaderOff() {
        return this.vectorSliceReaderOff;
    }

    public final int getLastDocID() {
        return this.lastDocID;
    }

    public final void setLastDocID(int n) {
        this.lastDocID = n;
    }

    @NotNull
    public final Accountable getAccountable() {
        return this.accountable;
    }

    public final void setAccountable(@NotNull Accountable accountable) {
        Intrinsics.checkNotNullParameter((Object)accountable, (String)"<set-?>");
        this.accountable = accountable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(@NotNull Map<String, TermsHashPerField> fieldsToFlush, @NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull NormsProducer norms) throws IOException {
        Intrinsics.checkNotNullParameter(fieldsToFlush, (String)"fieldsToFlush");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        if (this.writer != null) {
            int numDocs = state2.getSegmentInfo().maxDoc();
            boolean condition$iv = numDocs > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            try {
                this.fill(numDocs);
                if (state2.getSegmentInfo() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                TermVectorsWriter termVectorsWriter = this.writer;
                Intrinsics.checkNotNull((Object)termVectorsWriter);
                termVectorsWriter.finish(numDocs);
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
                IOUtils.INSTANCE.closeNullable(autoCloseableArray);
                throw throwable;
            }
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
            IOUtils.INSTANCE.closeNullable(autoCloseableArray);
        }
    }

    public final void fill(int docID) throws IOException {
        while (this.lastDocID < docID) {
            TermVectorsWriter termVectorsWriter = this.writer;
            Intrinsics.checkNotNull((Object)termVectorsWriter);
            termVectorsWriter.startDocument(0);
            TermVectorsWriter termVectorsWriter2 = this.writer;
            Intrinsics.checkNotNull((Object)termVectorsWriter2);
            termVectorsWriter2.finishDocument();
            int n = this.lastDocID;
            this.lastDocID = n + 1;
        }
    }

    public void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.lastDocID, this.getBytesUsed().get()));
            this.writer = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.info, context);
            this.lastDocID = 0;
            TermVectorsWriter termVectorsWriter = this.writer;
            Intrinsics.checkNotNull((Object)termVectorsWriter);
            this.accountable = termVectorsWriter;
        }
    }

    public final void setHasVectors() {
        this.hasVectors = true;
    }

    @Override
    public void finishDocument(int docID) throws IOException {
        if (!this.hasVectors) {
            return;
        }
        ArrayUtil.Companion.introSort(this.perFields, 0, this.numVectorFields);
        this.initTermVectorsWriter();
        this.fill(docID);
        TermVectorsWriter termVectorsWriter = this.writer;
        Intrinsics.checkNotNull((Object)termVectorsWriter);
        termVectorsWriter.startDocument(this.numVectorFields);
        int n = this.numVectorFields;
        for (int i = 0; i < n; ++i) {
            TermVectorsConsumerPerField termVectorsConsumerPerField = this.perFields[i];
            Intrinsics.checkNotNull((Object)termVectorsConsumerPerField);
            termVectorsConsumerPerField.finishDocument();
        }
        TermVectorsWriter termVectorsWriter2 = this.writer;
        Intrinsics.checkNotNull((Object)termVectorsWriter2);
        termVectorsWriter2.finishDocument();
        boolean condition$iv = this.lastDocID == docID;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "lastDocID=" + this.lastDocID + " docID=" + docID;
            throw new AssertionError((Object)string);
        }
        int n2 = this.lastDocID;
        this.lastDocID = n2 + 1;
        super.reset();
        this.resetFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        try {
            super.abort();
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            this.reset();
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
        IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
        this.reset();
    }

    public final void resetFields() {
        Arrays.INSTANCE.fill(this.perFields, null);
        this.numVectorFields = 0;
    }

    @Override
    @NotNull
    public TermsHashPerField addField(@NotNull FieldInvertState invertState, @NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)invertState, (String)"invertState");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        return new TermVectorsConsumerPerField(invertState, this, fieldInfo);
    }

    public final void addFieldToFlush(@Nullable TermVectorsConsumerPerField fieldToFlush) {
        if (this.numVectorFields == this.perFields.length) {
            int newSize = ArrayUtil.Companion.oversize(this.numVectorFields + 1, 4);
            TermVectorsConsumerPerField[] newArray = new TermVectorsConsumerPerField[newSize];
            System.INSTANCE.arraycopyKtNullable(this.perFields, 0, newArray, 0, this.numVectorFields);
            this.perFields = newArray;
        }
        int n = this.numVectorFields;
        this.numVectorFields = n + 1;
        this.perFields[n] = fieldToFlush;
    }

    @Override
    public void startDocument() {
        this.resetFields();
        this.numVectorFields = 0;
    }
}

