/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.ShortCompanionObject;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\"R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "subIndex", "", "<init>", "(Lorg/gnit/lucenekmp/index/TermsEnum;I)V", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "setTermsEnum", "(Lorg/gnit/lucenekmp/index/TermsEnum;)V", "getSubIndex", "()I", "currentTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "currentTermPrefix8", "", "term", "setTerm", "", "next", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "seekExact", "", "ord", "reset", "tei", "compareTermTo", "that", "toString", "", "termEquals", "Lorg/gnit/lucenekmp/index/TermsEnumIndex$TermState;", "TermState", "Companion", "core"})
public class TermsEnumIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private TermsEnum termsEnum;
    private final int subIndex;
    @Nullable
    private BytesRef currentTerm;
    private long currentTermPrefix8;
    @NotNull
    private static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];

    public TermsEnumIndex(@Nullable TermsEnum termsEnum, int subIndex) {
        this.termsEnum = termsEnum;
        this.subIndex = subIndex;
    }

    @Nullable
    public final TermsEnum getTermsEnum() {
        return this.termsEnum;
    }

    public final void setTermsEnum(@Nullable TermsEnum termsEnum) {
        this.termsEnum = termsEnum;
    }

    public final int getSubIndex() {
        return this.subIndex;
    }

    @Nullable
    public final BytesRef term() {
        return this.currentTerm;
    }

    private final void setTerm(BytesRef term) {
        this.currentTerm = term;
        if (this.currentTerm == null) {
            this.currentTermPrefix8 = 0L;
        } else {
            BytesRef bytesRef = this.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef);
            this.currentTermPrefix8 = Companion.prefix8ToComparableUnsignedLong(bytesRef);
        }
    }

    @Nullable
    public final BytesRef next() throws IOException {
        TermsEnum termsEnum = this.termsEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        BytesRef term = termsEnum.next();
        this.setTerm(term);
        return term;
    }

    @NotNull
    public final TermsEnum.SeekStatus seekCeil(@NotNull BytesRef term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        TermsEnum termsEnum = this.termsEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        TermsEnum.SeekStatus status = termsEnum.seekCeil(term);
        if (status == TermsEnum.SeekStatus.END) {
            this.setTerm(null);
        } else {
            TermsEnum termsEnum2 = this.termsEnum;
            Intrinsics.checkNotNull((Object)termsEnum2);
            this.setTerm(termsEnum2.term());
        }
        return status;
    }

    public final boolean seekExact(@NotNull BytesRef term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        TermsEnum termsEnum = this.termsEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        boolean found = termsEnum.seekExact(term);
        if (found) {
            TermsEnum termsEnum2 = this.termsEnum;
            Intrinsics.checkNotNull((Object)termsEnum2);
            this.setTerm(termsEnum2.term());
        } else {
            this.setTerm(null);
        }
        return found;
    }

    public final void seekExact(long ord) throws IOException {
        TermsEnum termsEnum = this.termsEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        termsEnum.seekExact(ord);
        TermsEnum termsEnum2 = this.termsEnum;
        Intrinsics.checkNotNull((Object)termsEnum2);
        this.setTerm(termsEnum2.term());
    }

    public final void reset(@NotNull TermsEnumIndex tei) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tei, (String)"tei");
        this.termsEnum = tei.termsEnum;
        this.currentTerm = tei.currentTerm;
        this.currentTermPrefix8 = tei.currentTermPrefix8;
    }

    public final int compareTermTo(@NotNull TermsEnumIndex that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (this.currentTermPrefix8 != that.currentTermPrefix8) {
            int cmp = LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, this.currentTermPrefix8, that.currentTermPrefix8);
            int n = IntExtKt.signum(IntCompanionObject.INSTANCE, cmp);
            BytesRef bytesRef = this.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef);
            byte[] byArray = bytesRef.getBytes();
            BytesRef bytesRef2 = this.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef2);
            int n2 = bytesRef2.getOffset();
            BytesRef bytesRef3 = this.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef3);
            int n3 = bytesRef3.getOffset();
            BytesRef bytesRef4 = this.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef4);
            int n4 = n3 + bytesRef4.getLength();
            BytesRef bytesRef5 = that.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef5);
            byte[] byArray2 = bytesRef5.getBytes();
            BytesRef bytesRef6 = that.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef6);
            int n5 = bytesRef6.getOffset();
            BytesRef bytesRef7 = that.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef7);
            int n6 = bytesRef7.getOffset();
            BytesRef bytesRef8 = that.currentTerm;
            Intrinsics.checkNotNull((Object)bytesRef8);
            if (!(n == IntExtKt.signum(IntCompanionObject.INSTANCE, Arrays.INSTANCE.compareUnsigned(byArray, n2, n4, byArray2, n5, n6 + bytesRef8.getLength())))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return cmp;
        }
        BytesRef bytesRef = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef);
        byte[] byArray = bytesRef.getBytes();
        BytesRef bytesRef9 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef9);
        int n = bytesRef9.getOffset();
        BytesRef bytesRef10 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef10);
        int n7 = bytesRef10.getOffset();
        BytesRef bytesRef11 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef11);
        int n8 = n7 + bytesRef11.getLength();
        BytesRef bytesRef12 = that.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef12);
        byte[] byArray3 = bytesRef12.getBytes();
        BytesRef bytesRef13 = that.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef13);
        int n9 = bytesRef13.getOffset();
        BytesRef bytesRef14 = that.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef14);
        int n10 = bytesRef14.getOffset();
        BytesRef bytesRef15 = that.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef15);
        return Arrays.INSTANCE.compareUnsigned(byArray, n, n8, byArray3, n9, n10 + bytesRef15.getLength());
    }

    @NotNull
    public String toString() {
        return this.termsEnum + " subIndex=" + this.subIndex + " term=" + this.currentTerm;
    }

    public final boolean termEquals(@NotNull TermState that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (this.currentTermPrefix8 != that.getTermPrefix8$core()) {
            return false;
        }
        BytesRef bytesRef = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef);
        byte[] byArray = bytesRef.getBytes();
        BytesRef bytesRef2 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef2);
        int n = bytesRef2.getOffset();
        BytesRef bytesRef3 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef3);
        int n2 = bytesRef3.getOffset();
        BytesRef bytesRef4 = this.currentTerm;
        Intrinsics.checkNotNull((Object)bytesRef4);
        return Arrays.INSTANCE.equals(byArray, n, n2 + bytesRef4.getLength(), that.getTerm$core().bytes(), 0, that.getTerm$core().length());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/TermsEnumIndex$Companion;", "", "<init>", "()V", "EMPTY_ARRAY", "", "Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "getEMPTY_ARRAY", "()[Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "[Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "prefix8ToComparableUnsignedLong", "", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TermsEnumIndex[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        public final long prefix8ToComparableUnsignedLong(@NotNull BytesRef term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            if (term.getLength() >= 8) {
                return BitUtilKt.getLongBE(term.getBytes(), term.getOffset());
            }
            long l = 0L;
            int o = 0;
            if (4 <= term.getLength()) {
                l = BitUtilKt.getIntBE(term.getBytes(), term.getOffset());
                o = 4;
            } else {
                l = 0L;
                o = 0;
            }
            if (o + 2 <= term.getLength()) {
                l = l << 16 | ShortExtKt.toUnsignedLong(ShortCompanionObject.INSTANCE, BitUtilKt.getShortBE(term.getBytes(), term.getOffset() + o));
                o += 2;
            }
            if (o < term.getLength()) {
                l = l << 8 | ByteExtKt.toUnsignedLong(ByteCompanionObject.INSTANCE, term.getBytes()[term.getOffset() + o]);
            }
            return l <<= 8 - term.getLength() << 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/TermsEnumIndex$TermState;", "", "<init>", "()V", "term", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getTerm$core", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "termPrefix8", "", "getTermPrefix8$core", "()J", "setTermPrefix8$core", "(J)V", "copyFrom", "", "tei", "Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "core"})
    public static final class TermState {
        @NotNull
        private final BytesRefBuilder term = new BytesRefBuilder();
        private long termPrefix8;

        @NotNull
        public final BytesRefBuilder getTerm$core() {
            return this.term;
        }

        public final long getTermPrefix8$core() {
            return this.termPrefix8;
        }

        public final void setTermPrefix8$core(long l) {
            this.termPrefix8 = l;
        }

        public final void copyFrom(@NotNull TermsEnumIndex tei) {
            Intrinsics.checkNotNullParameter((Object)tei, (String)"tei");
            BytesRef bytesRef = tei.term();
            Intrinsics.checkNotNull((Object)bytesRef);
            this.term.copyBytes(bytesRef);
            this.termPrefix8 = tei.currentTermPrefix8;
        }
    }
}

