/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.ByteSlicePool;
import org.gnit.lucenekmp.index.ByteSliceReader;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.ParallelPostingsArray;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 W2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002VWBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010(\u001a\u00020)J\u001e\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003J\u0006\u00100\u001a\u00020)J\u0006\u00101\u001a\u00020\u001bJ\u0006\u00102\u001a\u00020)J\u0018\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0002J\u0018\u00108\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0002J\u0010\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020\u0003H\u0002J\u0016\u00105\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u00020\u0003J\u0018\u0010=\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0002J\u0016\u0010>\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010?\u001a\u00020@J&\u0010A\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010?\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00032\u0006\u0010D\u001a\u00020\u0003J\u0016\u0010E\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0003J\u0011\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u0000H\u0096\u0002J\b\u0010I\u001a\u00020)H\u0016J\u0018\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u000204H\u0016J\u0018\u0010Q\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H&J\u0018\u0010R\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H&J\b\u0010S\u001a\u00020)H&J\u0010\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020\u0003H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006X"}, d2={"Lorg/gnit/lucenekmp/index/TermsHashPerField;", "", "streamCount", "", "intPool", "Lorg/gnit/lucenekmp/util/IntBlockPool;", "bytePool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "termBytePool", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "nextPerField", "fieldName", "", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "<init>", "(ILorg/gnit/lucenekmp/util/IntBlockPool;Lorg/gnit/lucenekmp/util/ByteBlockPool;Lorg/gnit/lucenekmp/util/ByteBlockPool;Lorg/gnit/lucenekmp/util/Counter;Lorg/gnit/lucenekmp/index/TermsHashPerField;Ljava/lang/String;Lorg/gnit/lucenekmp/index/IndexOptions;)V", "getBytePool", "()Lorg/gnit/lucenekmp/util/ByteBlockPool;", "getNextPerField", "()Lorg/gnit/lucenekmp/index/TermsHashPerField;", "getFieldName", "()Ljava/lang/String;", "slicePool", "Lorg/gnit/lucenekmp/index/ByteSlicePool;", "termStreamAddressBuffer", "", "streamAddressOffset", "getIndexOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "bytesHash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "postingsArray", "Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "getPostingsArray", "()Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "setPostingsArray", "(Lorg/gnit/lucenekmp/index/ParallelPostingsArray;)V", "lastDocID", "reset", "", "initReader", "reader", "Lorg/gnit/lucenekmp/index/ByteSliceReader;", "termID", "stream", "sortedTermIDs", "sortTerms", "getSortedTermIDs", "reinitHash", "doNextCall", "", "add", "textStart", "docID", "initStreamSlices", "assertDocId", "docId", "termBytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "positionStreamSlice", "writeByte", "b", "", "writeBytes", "", "offset", "len", "writeVInt", "i", "compareTo", "other", "finish", "numTerms", "getNumTerms", "()I", "start", "field", "Lorg/gnit/lucenekmp/index/IndexableField;", "first", "newTerm", "addTerm", "newPostingsArray", "createPostingsArray", "size", "PostingsBytesStartArray", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTermsHashPerField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermsHashPerField.kt\norg/gnit/lucenekmp/index/TermsHashPerField\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,336:1\n3#2,8:337\n3#2,8:346\n3#2,8:355\n8#2,2:364\n3#2,8:366\n3#2,8:375\n10#3:345\n10#3:354\n10#3:363\n10#3:374\n10#3:383\n*S KotlinDebug\n*F\n+ 1 TermsHashPerField.kt\norg/gnit/lucenekmp/index/TermsHashPerField\n*L\n99#1:337,8\n58#1:346,8\n77#1:355,8\n159#1:364,2\n170#1:366,8\n244#1:375,8\n99#1:345\n58#1:354\n77#1:363\n170#1:374\n244#1:383\n*E\n"})
public abstract class TermsHashPerField
implements Comparable<TermsHashPerField> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int streamCount;
    @NotNull
    private final IntBlockPool intPool;
    @NotNull
    private final ByteBlockPool bytePool;
    @Nullable
    private final TermsHashPerField nextPerField;
    @NotNull
    private final String fieldName;
    @NotNull
    private final ByteSlicePool slicePool;
    private int[] termStreamAddressBuffer;
    private int streamAddressOffset;
    @NotNull
    private final IndexOptions indexOptions;
    @NotNull
    private final BytesRefHash bytesHash;
    @Nullable
    private ParallelPostingsArray postingsArray;
    private int lastDocID;
    @Nullable
    private int[] sortedTermIDs;
    private boolean doNextCall;
    private static final int HASH_INIT_SIZE = 4;

    public TermsHashPerField(int streamCount, @NotNull IntBlockPool intPool, @NotNull ByteBlockPool bytePool, @NotNull ByteBlockPool termBytePool, @NotNull Counter bytesUsed, @Nullable TermsHashPerField nextPerField, @NotNull String fieldName, @NotNull IndexOptions indexOptions) {
        Intrinsics.checkNotNullParameter((Object)intPool, (String)"intPool");
        Intrinsics.checkNotNullParameter((Object)bytePool, (String)"bytePool");
        Intrinsics.checkNotNullParameter((Object)termBytePool, (String)"termBytePool");
        Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
        this.streamCount = streamCount;
        this.intPool = intPool;
        this.bytePool = bytePool;
        this.nextPerField = nextPerField;
        this.fieldName = fieldName;
        this.slicePool = new ByteSlicePool(this.bytePool);
        boolean condition$iv = indexOptions != IndexOptions.NONE;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.indexOptions = indexOptions;
        PostingsBytesStartArray byteStarts = new PostingsBytesStartArray(this, bytesUsed);
        this.bytesHash = new BytesRefHash(termBytePool, 4, byteStarts);
    }

    @NotNull
    public final ByteBlockPool getBytePool() {
        return this.bytePool;
    }

    @Nullable
    public final TermsHashPerField getNextPerField() {
        return this.nextPerField;
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public final IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final ParallelPostingsArray getPostingsArray() {
        return this.postingsArray;
    }

    public final void setPostingsArray(@Nullable ParallelPostingsArray parallelPostingsArray) {
        this.postingsArray = parallelPostingsArray;
    }

    public final void reset() {
        block0: {
            this.bytesHash.clear(false);
            this.sortedTermIDs = null;
            TermsHashPerField termsHashPerField = this.nextPerField;
            if (termsHashPerField == null) break block0;
            termsHashPerField.reset();
        }
    }

    public final void initReader(@NotNull ByteSliceReader reader2, int termID, int stream) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        boolean condition$iv = stream < this.streamCount;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        ParallelPostingsArray parallelPostingsArray = this.postingsArray;
        Intrinsics.checkNotNull((Object)parallelPostingsArray);
        int streamStartOffset = parallelPostingsArray.getAddressOffset()[termID];
        int[] streamAddressBuffer = this.intPool.getBuffers()[streamStartOffset >> 13];
        int offsetInAddressBuffer = streamStartOffset & IntBlockPool.Companion.getINT_BLOCK_MASK();
        ParallelPostingsArray parallelPostingsArray2 = this.postingsArray;
        Intrinsics.checkNotNull((Object)parallelPostingsArray2);
        reader2.init(this.bytePool, parallelPostingsArray2.getByteStarts()[termID] + stream * ByteSlicePool.Companion.getFIRST_LEVEL_SIZE(), streamAddressBuffer[offsetInAddressBuffer + stream]);
    }

    public final void sortTerms() {
        boolean condition$iv = this.sortedTermIDs == null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.sortedTermIDs = this.bytesHash.sort();
    }

    @NotNull
    public final int[] getSortedTermIDs() {
        int[] nArray = this.sortedTermIDs;
        if (this.sortedTermIDs == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.sortedTermIDs);
        return this.sortedTermIDs;
    }

    public final void reinitHash() {
        this.sortedTermIDs = null;
        this.bytesHash.reinit();
    }

    private final void add(int textStart, int docID) throws IOException {
        int termID = this.bytesHash.addByPoolOffset(textStart);
        if (termID >= 0) {
            this.initStreamSlices(termID, docID);
        } else {
            this.positionStreamSlice(termID, docID);
        }
    }

    private final void initStreamSlices(int termID, int docID) throws IOException {
        if (this.streamCount + this.intPool.getIntUpto() > IntBlockPool.Companion.getINT_BLOCK_SIZE()) {
            this.intPool.nextBuffer();
        }
        if (32768 - this.bytePool.getByteUpto() < 2 * this.streamCount * ByteSlicePool.Companion.getFIRST_LEVEL_SIZE()) {
            this.bytePool.nextBuffer();
        }
        this.termStreamAddressBuffer = this.intPool.getBuffer();
        this.streamAddressOffset = this.intPool.getIntUpto();
        IntBlockPool intBlockPool = this.intPool;
        intBlockPool.setIntUpto(intBlockPool.getIntUpto() + this.streamCount);
        ParallelPostingsArray parallelPostingsArray = this.postingsArray;
        Intrinsics.checkNotNull((Object)parallelPostingsArray);
        parallelPostingsArray.getAddressOffset()[termID] = this.streamAddressOffset + this.intPool.getIntOffset();
        int n = this.streamCount;
        for (int i = 0; i < n; ++i) {
            int upto = this.slicePool.newSlice(ByteSlicePool.Companion.getFIRST_LEVEL_SIZE());
            int[] nArray = this.termStreamAddressBuffer;
            if (this.termStreamAddressBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
                nArray = null;
            }
            nArray[this.streamAddressOffset + i] = upto + this.bytePool.getByteOffset();
        }
        ParallelPostingsArray parallelPostingsArray2 = this.postingsArray;
        Intrinsics.checkNotNull((Object)parallelPostingsArray2);
        int[] nArray = parallelPostingsArray2.getByteStarts();
        int[] nArray2 = this.termStreamAddressBuffer;
        if (this.termStreamAddressBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
            nArray2 = null;
        }
        nArray[termID] = nArray2[this.streamAddressOffset];
        this.newTerm(termID, docID);
    }

    private final boolean assertDocId(int docId) {
        boolean condition$iv = docId >= this.lastDocID;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "docID must be >= " + this.lastDocID + " but was: " + docId;
            throw new AssertionError((Object)string);
        }
        this.lastDocID = docId;
        return true;
    }

    public final void add(@NotNull BytesRef termBytes, int docID) throws IOException {
        Intrinsics.checkNotNullParameter((Object)termBytes, (String)"termBytes");
        boolean condition$iv = this.assertDocId(docID);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int termID = this.bytesHash.add(termBytes);
        if (termID >= 0) {
            this.initStreamSlices(termID, docID);
        } else {
            termID = this.positionStreamSlice(termID, docID);
        }
        if (this.doNextCall) {
            TermsHashPerField termsHashPerField = this.nextPerField;
            Intrinsics.checkNotNull((Object)termsHashPerField);
            ParallelPostingsArray parallelPostingsArray = this.postingsArray;
            Intrinsics.checkNotNull((Object)parallelPostingsArray);
            termsHashPerField.add(parallelPostingsArray.getTextStarts()[termID], docID);
        }
    }

    private final int positionStreamSlice(int termID, int docID) throws IOException {
        int termID2 = termID;
        termID2 = -termID2 - 1;
        ParallelPostingsArray parallelPostingsArray = this.postingsArray;
        Intrinsics.checkNotNull((Object)parallelPostingsArray);
        int intStart = parallelPostingsArray.getAddressOffset()[termID2];
        this.termStreamAddressBuffer = this.intPool.getBuffers()[intStart >> 13];
        this.streamAddressOffset = intStart & IntBlockPool.Companion.getINT_BLOCK_MASK();
        this.addTerm(termID2, docID);
        return termID2;
    }

    public final void writeByte(int stream, byte b) {
        int streamAddress = this.streamAddressOffset + stream;
        int[] nArray = this.termStreamAddressBuffer;
        if (this.termStreamAddressBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
            nArray = null;
        }
        int upto = nArray[streamAddress];
        byte[] byArray = this.bytePool.getBuffer(upto >> 15);
        if (byArray == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        byte[] bytes = byArray;
        int offset = upto & Short.MAX_VALUE;
        if (bytes[offset] != 0) {
            offset = this.slicePool.allocSlice(bytes, offset);
            byte[] byArray2 = this.bytePool.getBuffer();
            Intrinsics.checkNotNull((Object)byArray2);
            bytes = byArray2;
            int[] nArray2 = this.termStreamAddressBuffer;
            if (this.termStreamAddressBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
                nArray2 = null;
            }
            nArray2[streamAddress] = offset + this.bytePool.getByteOffset();
        }
        bytes[offset] = b;
        int[] nArray3 = this.termStreamAddressBuffer;
        if (this.termStreamAddressBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
            nArray3 = null;
        }
        int[] nArray4 = nArray3;
        int n = nArray4[streamAddress];
        nArray4[streamAddress] = n + 1;
    }

    public final void writeBytes(int stream, @NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset2 = offset;
        int end = offset2 + len;
        int streamAddress = this.streamAddressOffset + stream;
        int[] nArray = this.termStreamAddressBuffer;
        if (this.termStreamAddressBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
            nArray = null;
        }
        int upto = nArray[streamAddress];
        byte[] byArray = this.bytePool.getBuffer(upto >> 15);
        if (byArray == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        byte[] slice = byArray;
        int sliceOffset = upto & Short.MAX_VALUE;
        while (slice[sliceOffset] == 0 && offset2 < end) {
            slice[sliceOffset++] = b[offset2++];
            int[] nArray2 = this.termStreamAddressBuffer;
            if (this.termStreamAddressBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
                nArray2 = null;
            }
            int[] nArray3 = nArray2;
            int n = nArray3[streamAddress];
            nArray3[streamAddress] = n + 1;
        }
        while (offset2 < end) {
            int offsetAndLength = this.slicePool.allocKnownSizeSlice(slice, sliceOffset);
            sliceOffset = offsetAndLength >> 8;
            int sliceLength = offsetAndLength & 0xFF;
            Intrinsics.checkNotNull((Object)this.bytePool.getBuffer());
            int writeLength = Math.min(sliceLength - 1, end - offset2);
            System.INSTANCE.arraycopy(b, offset2, slice, sliceOffset, writeLength);
            sliceOffset += writeLength;
            offset2 += writeLength;
            int[] nArray4 = this.termStreamAddressBuffer;
            if (this.termStreamAddressBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"termStreamAddressBuffer");
                nArray4 = null;
            }
            nArray4[streamAddress] = sliceOffset + this.bytePool.getByteOffset();
        }
    }

    public final void writeVInt(int stream, int i) {
        int i2 = i;
        boolean condition$iv = stream < this.streamCount;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte(stream, (byte)(i2 & 0x7F | 0x80));
            i2 >>>= 7;
        }
        this.writeByte(stream, (byte)i2);
    }

    @Override
    public int compareTo(@NotNull TermsHashPerField other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.fieldName.compareTo(other.fieldName);
    }

    public void finish() throws IOException {
        block0: {
            TermsHashPerField termsHashPerField = this.nextPerField;
            if (termsHashPerField == null) break block0;
            termsHashPerField.finish();
        }
    }

    public final int getNumTerms() {
        return this.bytesHash.size();
    }

    public boolean start(@NotNull IndexableField field, boolean first) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (this.nextPerField != null) {
            this.doNextCall = this.nextPerField.start(field, first);
        }
        return true;
    }

    public abstract void newTerm(int var1, int var2) throws IOException;

    public abstract void addTerm(int var1, int var2) throws IOException;

    public abstract void newPostingsArray();

    @NotNull
    public abstract ParallelPostingsArray createPostingsArray(int var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/TermsHashPerField$Companion;", "", "<init>", "()V", "HASH_INIT_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/index/TermsHashPerField$PostingsBytesStartArray;", "Lorg/gnit/lucenekmp/util/BytesRefHash$BytesStartArray;", "perField", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/index/TermsHashPerField;Lorg/gnit/lucenekmp/util/Counter;)V", "init", "", "grow", "clear", "core"})
    private static final class PostingsBytesStartArray
    extends BytesRefHash.BytesStartArray {
        @NotNull
        private final TermsHashPerField perField;
        @NotNull
        private final Counter bytesUsed;

        public PostingsBytesStartArray(@NotNull TermsHashPerField perField, @NotNull Counter bytesUsed) {
            Intrinsics.checkNotNullParameter((Object)perField, (String)"perField");
            Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
            this.perField = perField;
            this.bytesUsed = bytesUsed;
        }

        @Override
        @NotNull
        public int[] init() {
            if (this.perField.getPostingsArray() == null) {
                this.perField.setPostingsArray(this.perField.createPostingsArray(2));
                this.perField.newPostingsArray();
                ParallelPostingsArray parallelPostingsArray = this.perField.getPostingsArray();
                Intrinsics.checkNotNull((Object)parallelPostingsArray);
                long l = parallelPostingsArray.getSize();
                ParallelPostingsArray parallelPostingsArray2 = this.perField.getPostingsArray();
                Intrinsics.checkNotNull((Object)parallelPostingsArray2);
                this.bytesUsed.addAndGet(l * (long)parallelPostingsArray2.bytesPerPosting());
            }
            ParallelPostingsArray parallelPostingsArray = this.perField.getPostingsArray();
            Intrinsics.checkNotNull((Object)parallelPostingsArray);
            return parallelPostingsArray.getTextStarts();
        }

        @Override
        @NotNull
        public int[] grow() {
            ParallelPostingsArray parallelPostingsArray = this.perField.getPostingsArray();
            Intrinsics.checkNotNull((Object)parallelPostingsArray);
            ParallelPostingsArray postingsArray = parallelPostingsArray;
            ParallelPostingsArray parallelPostingsArray2 = this.perField.getPostingsArray();
            Intrinsics.checkNotNull((Object)parallelPostingsArray2);
            int oldSize = parallelPostingsArray2.getSize();
            this.perField.setPostingsArray(postingsArray.grow());
            ParallelPostingsArray parallelPostingsArray3 = this.perField.getPostingsArray();
            Intrinsics.checkNotNull((Object)parallelPostingsArray3);
            postingsArray = parallelPostingsArray3;
            this.perField.newPostingsArray();
            this.bytesUsed.addAndGet((long)postingsArray.bytesPerPosting() * (long)(postingsArray.getSize() - oldSize));
            return postingsArray.getTextStarts();
        }

        @Override
        @Nullable
        public int[] clear() {
            if (this.perField.getPostingsArray() != null) {
                ParallelPostingsArray parallelPostingsArray = this.perField.getPostingsArray();
                Intrinsics.checkNotNull((Object)parallelPostingsArray);
                int n = parallelPostingsArray.getSize();
                ParallelPostingsArray parallelPostingsArray2 = this.perField.getPostingsArray();
                Intrinsics.checkNotNull((Object)parallelPostingsArray2);
                this.bytesUsed.addAndGet(-((long)(n * parallelPostingsArray2.bytesPerPosting())));
                this.perField.setPostingsArray(null);
                this.perField.newPostingsArray();
            }
            return null;
        }

        @Override
        @NotNull
        public Counter bytesUsed() {
            return this.bytesUsed;
        }
    }
}

