/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.MergeTrigger;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 J2\u00020\u0001:\u0004GHIJB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\b\u0010\u001c\u001a\u00020\u0005H\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016JX\u0010+\u001a\u0004\u0018\u00010(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0002J2\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002080!2\u0006\u00109\u001a\u0002042\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\"0;H\u0004J6\u0010<\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$2\u0006\u0010=\u001a\u00020\u00102\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u0002040;2\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010?\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u0010J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005H\u0002J\b\u0010E\u001a\u00020FH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006K"}, d2={"Lorg/gnit/lucenekmp/index/TieredMergePolicy;", "Lorg/gnit/lucenekmp/index/MergePolicy;", "<init>", "()V", "maxMergedSegmentBytes", "", "floorSegmentBytes", "value", "", "segmentsPerTier", "getSegmentsPerTier", "()D", "forceMergeDeletesPctAllowed", "getForceMergeDeletesPctAllowed", "deletesPctAllowed", "getDeletesPctAllowed", "", "targetSearchConcurrency", "getTargetSearchConcurrency", "()I", "setMaxMergedSegmentMB", "v", "maxMergedSegmentMB", "getMaxMergedSegmentMB", "setDeletesPctAllowed", "setFloorSegmentMB", "floorSegmentMB", "getFloorSegmentMB", "maxFullFlushMergeSize", "setForceMergeDeletesPctAllowed", "setSegmentsPerTier", "setTargetSearchConcurrency", "getSortedBySegmentSize", "", "Lorg/gnit/lucenekmp/index/TieredMergePolicy$SegmentSizeAndDocs;", "infos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "mergeContext", "Lorg/gnit/lucenekmp/index/MergePolicy$MergeContext;", "findMerges", "Lorg/gnit/lucenekmp/index/MergePolicy$MergeSpecification;", "mergeTrigger", "Lorg/gnit/lucenekmp/index/MergeTrigger;", "doFindMerges", "sortedEligibleInfos", "mergeFactor", "allowedSegCount", "allowedDelCount", "allowedDocCount", "mergeType", "Lorg/gnit/lucenekmp/index/TieredMergePolicy$MERGE_TYPE;", "maxMergeIsRunning", "", "score", "Lorg/gnit/lucenekmp/index/TieredMergePolicy$MergeScore;", "candidate", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "hitTooLarge", "segmentsSizes", "", "findForcedMerges", "maxSegmentCount", "segmentsToMerge", "findForcedDeletesMerges", "getMaxAllowedDocs", "totalMaxDoc", "totalDelDocs", "floorSize", "bytes", "toString", "", "MERGE_TYPE", "SegmentSizeAndDocs", "MergeScore", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTieredMergePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TieredMergePolicy.kt\norg/gnit/lucenekmp/index/TieredMergePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MutableListExt.kt\norg/gnit/lucenekmp/jdkport/MutableListExtKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 6 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,970:1\n1#2:971\n4#3,4:972\n8#3,5:980\n37#4:976\n36#4,3:977\n3#5,8:985\n3#5,8:994\n3#5,8:1003\n3#5,8:1012\n10#6:993\n10#6:1002\n10#6:1011\n10#6:1020\n*S KotlinDebug\n*F\n+ 1 TieredMergePolicy.kt\norg/gnit/lucenekmp/index/TieredMergePolicy\n*L\n253#1:972,4\n253#1:980,5\n253#1:976\n253#1:977,3\n317#1:985,8\n318#1:994,8\n536#1:1003,8\n902#1:1012,8\n317#1:993\n318#1:1002\n536#1:1011\n902#1:1020\n*E\n"})
public class TieredMergePolicy
extends MergePolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long maxMergedSegmentBytes = 0x140000000L;
    private long floorSegmentBytes = 0x1000000L;
    private double segmentsPerTier = 10.0;
    private double forceMergeDeletesPctAllowed = 10.0;
    private double deletesPctAllowed = 20.0;
    private int targetSearchConcurrency = 1;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;

    public TieredMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    public final double getSegmentsPerTier() {
        return this.segmentsPerTier;
    }

    public final double getForceMergeDeletesPctAllowed() {
        return this.forceMergeDeletesPctAllowed;
    }

    public final double getDeletesPctAllowed() {
        return this.deletesPctAllowed;
    }

    public final int getTargetSearchConcurrency() {
        return this.targetSearchConcurrency;
    }

    @NotNull
    public final TieredMergePolicy setMaxMergedSegmentMB(double v) {
        double v2 = 0.0;
        v2 = v;
        if (!(!(v2 < 0.0))) {
            boolean bl = false;
            String string = "maxMergedSegmentMB must be >=0 (got " + v2 + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxMergedSegmentBytes = (v2 *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v2;
        return this;
    }

    public final double getMaxMergedSegmentMB() {
        return (double)this.maxMergedSegmentBytes / 1024.0 / 1024.0;
    }

    @NotNull
    public final TieredMergePolicy setDeletesPctAllowed(double v) {
        if (!(5.0 <= v ? v <= 50.0 : false)) {
            boolean bl = false;
            String string = "indexPctDeletedTarget must be >= 5.0 and <= 50 (got " + v + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.deletesPctAllowed = v;
        return this;
    }

    @NotNull
    public final TieredMergePolicy setFloorSegmentMB(double v) {
        double v2 = 0.0;
        v2 = v;
        if (!(!(v2 <= 0.0))) {
            boolean bl = false;
            String string = "floorSegmentMB must be > 0.0 (got " + v2 + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.floorSegmentBytes = (v2 *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v2;
        return this;
    }

    public final double getFloorSegmentMB() {
        return (double)this.floorSegmentBytes / 1048576.0;
    }

    @Override
    public long maxFullFlushMergeSize() {
        return this.floorSegmentBytes;
    }

    @NotNull
    public final TieredMergePolicy setForceMergeDeletesPctAllowed(double v) {
        if (!(0.0 <= v ? v <= 100.0 : false)) {
            boolean bl = false;
            String string = "forceMergeDeletesPctAllowed must be between 0.0 and 100.0 inclusive (got " + v + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.forceMergeDeletesPctAllowed = v;
        return this;
    }

    @NotNull
    public final TieredMergePolicy setSegmentsPerTier(double v) {
        if (!(!(v < 2.0))) {
            boolean bl = false;
            String string = "segmentsPerTier must be >= 2.0 (got " + v + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.segmentsPerTier = v;
        return this;
    }

    @NotNull
    public final TieredMergePolicy setTargetSearchConcurrency(int targetSearchConcurrency) {
        if (!(targetSearchConcurrency >= 1)) {
            boolean bl = false;
            String string = "targetSearchConcurrency must be >= 1 (got " + targetSearchConcurrency + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.targetSearchConcurrency = targetSearchConcurrency;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SegmentSizeAndDocs> getSortedBySegmentSize(SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        void $this$sort$iv;
        List sortedBySize = new ArrayList();
        for (SegmentCommitInfo info : infos) {
            sortedBySize.add(new SegmentSizeAndDocs(info, this.size(info, mergeContext), mergeContext.numDeletesToMerge(info)));
        }
        List list = sortedBySize;
        Comparator Comparator$iv = TieredMergePolicy::getSortedBySegmentSize$lambda$6;
        boolean $i$f$sort = false;
        int size$iv = $this$sort$iv.size();
        if (size$iv >= 2) {
            Collection $this$toTypedArray$iv$iv = (Collection)$this$sort$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] array$iv = thisCollection$iv$iv.toArray(new SegmentSizeAndDocs[0]);
            ArraysKt.sortWith((Object[])array$iv, (Comparator)Comparator$iv);
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                $this$sort$iv.set(i$iv, array$iv[i$iv]);
            }
        }
        return sortedBySize;
    }

    @Override
    @Nullable
    public MergePolicy.MergeSpecification findMerges(@NotNull MergeTrigger mergeTrigger, @NotNull SegmentInfos infos, @NotNull MergePolicy.MergeContext mergeContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)mergeTrigger), (String)"mergeTrigger");
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        long totIndexBytes = 0L;
        long minSegmentBytes = Long.MAX_VALUE;
        int totalDelDocs = 0;
        int totalMaxDoc = 0;
        long mergingBytes = 0L;
        List<SegmentSizeAndDocs> sortedInfos = this.getSortedBySegmentSize(infos, mergeContext);
        Iterator<SegmentSizeAndDocs> iter = sortedInfos.iterator();
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            long segBytes = segSizeDocs.getSizeInBytes();
            if (this.verbose(mergeContext)) {
                Object extra;
                Object object = extra = merging.contains(segSizeDocs.getSegInfo()) ? " [merging]" : "";
                if (segBytes >= this.maxMergedSegmentBytes) {
                    extra = (String)extra + " [skip: too large]";
                } else if (segBytes < this.floorSegmentBytes) {
                    extra = (String)extra + " [floored]";
                }
                Object[] objectArray = new SegmentCommitInfo[]{segSizeDocs.getSegInfo()};
                this.message("  seg=" + this.segString(mergeContext, SetsKt.mutableSetOf((Object[])objectArray)) + (double)segBytes / 1024.0 / 1024.0 + " MB", mergeContext);
            }
            if (merging.contains(segSizeDocs.getSegInfo())) {
                mergingBytes += segSizeDocs.getSizeInBytes();
                iter.remove();
                totalMaxDoc += segSizeDocs.getMaxDoc() - segSizeDocs.getDelCount();
            } else {
                totalDelDocs += segSizeDocs.getDelCount();
                totalMaxDoc += segSizeDocs.getMaxDoc();
            }
            minSegmentBytes = java.lang.Math.min(segBytes, minSegmentBytes);
            totIndexBytes += segBytes;
        }
        boolean condition$iv = totalMaxDoc >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = totalDelDocs >= 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        double totalDelPct = (double)100 * (double)totalDelDocs / (double)totalMaxDoc;
        int allowedDelCount = (int)(this.deletesPctAllowed * (double)totalMaxDoc / (double)100);
        int tooBigCount = 0;
        int concurrencyCount = 0;
        iter = sortedInfos.iterator();
        double allowedSegCount = 0.0;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            double segDelPct = (double)100 * (double)segSizeDocs.getDelCount() / (double)segSizeDocs.getMaxDoc();
            if (segSizeDocs.getSizeInBytes() > this.maxMergedSegmentBytes / (long)2 && (totalDelPct <= this.deletesPctAllowed || segDelPct <= this.deletesPctAllowed)) {
                iter.remove();
                ++tooBigCount;
                totIndexBytes -= segSizeDocs.getSizeInBytes();
                allowedDelCount -= segSizeDocs.getDelCount();
                continue;
            }
            if (concurrencyCount + tooBigCount >= this.targetSearchConcurrency - 1) continue;
            ++concurrencyCount;
            double d = allowedSegCount;
            allowedSegCount = d + 1.0;
            totIndexBytes -= segSizeDocs.getSizeInBytes();
        }
        allowedDelCount = java.lang.Math.max(0, allowedDelCount);
        int mergeFactor = (int)this.segmentsPerTier;
        long levelSize = java.lang.Math.max(minSegmentBytes, this.floorSegmentBytes);
        long bytesLeft = totIndexBytes;
        while (true) {
            double segCountLevel;
            if ((segCountLevel = (double)bytesLeft / (double)levelSize) < this.segmentsPerTier || levelSize == this.maxMergedSegmentBytes) {
                allowedSegCount += java.lang.Math.ceil(segCountLevel);
                break;
            }
            allowedSegCount += this.segmentsPerTier;
            bytesLeft = (long)((double)bytesLeft - this.segmentsPerTier * (double)levelSize);
            levelSize = java.lang.Math.min(this.maxMergedSegmentBytes, levelSize * (long)mergeFactor);
        }
        allowedSegCount = java.lang.Math.max(allowedSegCount, this.segmentsPerTier);
        allowedSegCount = java.lang.Math.max(allowedSegCount, (double)(this.targetSearchConcurrency - tooBigCount));
        int allowedDocCount = this.getMaxAllowedDocs(totalMaxDoc, totalDelDocs);
        if (this.verbose(mergeContext) && tooBigCount > 0) {
            this.message("  allowedSegmentCount=" + allowedSegCount + " vs count=" + infos.size() + " (eligible count=" + sortedInfos.size() + ") tooBigCount= " + tooBigCount + "  allowedDocCount=" + allowedDocCount + " vs doc count=" + infos.totalMaxDoc(), mergeContext);
        }
        return this.doFindMerges(sortedInfos, this.maxMergedSegmentBytes, mergeFactor, (int)allowedSegCount, allowedDelCount, allowedDocCount, MERGE_TYPE.NATURAL, mergeContext, mergingBytes >= this.maxMergedSegmentBytes);
    }

    /*
     * WARNING - void declaration
     */
    private final MergePolicy.MergeSpecification doFindMerges(List<SegmentSizeAndDocs> sortedEligibleInfos, long maxMergedSegmentBytes, int mergeFactor, int allowedSegCount, int allowedDelCount, int allowedDocCount, MERGE_TYPE mergeType, MergePolicy.MergeContext mergeContext, boolean maxMergeIsRunning) throws IOException {
        List sortedEligible = new ArrayList();
        Map segInfosSizes = new LinkedHashMap();
        for (SegmentSizeAndDocs segSizeDocs : sortedEligible) {
            segInfosSizes.put(segSizeDocs.getSegInfo(), segSizeDocs);
        }
        int originalSortedSize = sortedEligible.size();
        if (this.verbose(mergeContext)) {
            this.message("findMerges: " + originalSortedSize + " segments", mergeContext);
        }
        if (originalSortedSize == 0) {
            return null;
        }
        Set toBeMerged = new LinkedHashSet();
        MergePolicy.MergeSpecification spec = null;
        boolean haveOneLargeMerge = false;
        while (true) {
            Iterator iter = sortedEligible.iterator();
            while (iter.hasNext()) {
                SegmentSizeAndDocs segSizeDocs = (SegmentSizeAndDocs)iter.next();
                if (!toBeMerged.contains(segSizeDocs.getSegInfo())) continue;
                iter.remove();
            }
            if (this.verbose(mergeContext)) {
                this.message("  allowedSegmentCount=" + allowedSegCount + " vs count=" + originalSortedSize + " (eligible count=" + sortedEligible.size() + ")", mergeContext);
            }
            if (sortedEligible.isEmpty()) {
                return spec;
            }
            Iterable iterable = sortedEligible;
            int n = 0;
            for (Object t : iterable) {
                void c;
                SegmentSizeAndDocs segmentSizeAndDocs = (SegmentSizeAndDocs)t;
                int n2 = n;
                boolean bl = false;
                int n3 = c.getDelCount();
                n = n2 + n3;
            }
            int remainingDelCount = n;
            if (mergeType == MERGE_TYPE.NATURAL && sortedEligible.size() <= allowedSegCount && remainingDelCount <= allowedDelCount) {
                return spec;
            }
            MergeScore bestScore = null;
            List best = null;
            boolean bestTooLarge = false;
            long bestMergeBytes = 0L;
            int n4 = ((Collection)sortedEligible).size();
            for (int startIdx = 0; startIdx < n4; ++startIdx) {
                void condition$iv;
                List candidate = new ArrayList();
                boolean hitTooLarge = false;
                long bytesThisMerge = 0L;
                long docCountThisMerge = 0L;
                int idx = startIdx;
                while (!(idx >= sortedEligible.size() || candidate.size() >= mergeFactor && bytesThisMerge >= this.floorSegmentBytes || bytesThisMerge >= maxMergedSegmentBytes || bytesThisMerge >= this.floorSegmentBytes && docCountThisMerge > (long)allowedDocCount)) {
                    SegmentSizeAndDocs segSizeDocs = (SegmentSizeAndDocs)sortedEligible.get(idx);
                    long segBytes = segSizeDocs.getSizeInBytes();
                    int segDocCount = segSizeDocs.getMaxDoc() - segSizeDocs.getDelCount();
                    if (bytesThisMerge + segBytes > maxMergedSegmentBytes || bytesThisMerge > this.floorSegmentBytes && docCountThisMerge + (long)segDocCount > (long)allowedDocCount) {
                        hitTooLarge |= bytesThisMerge + segBytes > maxMergedSegmentBytes;
                        if (!((Collection)candidate).isEmpty()) {
                            ++idx;
                            continue;
                        }
                    }
                    candidate.add(segSizeDocs.getSegInfo());
                    bytesThisMerge += segBytes;
                    docCountThisMerge += (long)segDocCount;
                    ++idx;
                }
                boolean segSizeDocs = !((Collection)candidate).isEmpty();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == false) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                Object v = segInfosSizes.get(candidate.get(0));
                Intrinsics.checkNotNull(v);
                SegmentSizeAndDocs maxCandidateSegmentSize = (SegmentSizeAndDocs)v;
                if (!hitTooLarge && mergeType == MERGE_TYPE.NATURAL && (double)bytesThisMerge < (double)maxCandidateSegmentSize.getSizeInBytes() * 1.5 && (double)maxCandidateSegmentSize.getDelCount() < (double)maxCandidateSegmentSize.getMaxDoc() * this.deletesPctAllowed / (double)100 || candidate.size() == 1 && maxCandidateSegmentSize.getDelCount() == 0) continue;
                if (bestScore != null && !hitTooLarge && candidate.size() < mergeFactor) break;
                MergeScore score2 = this.score(candidate, hitTooLarge, segInfosSizes);
                if (this.verbose(mergeContext)) {
                    this.message("  maybe=" + this.segString(mergeContext, candidate) + " score=" + score2.getScore() + " " + score2.getExplanation() + " tooLarge=" + hitTooLarge + " size=" + (double)bytesThisMerge / 1024.0 / 1024.0 + " MB", mergeContext);
                }
                if (bestScore != null && !(score2.getScore() < bestScore.getScore()) || hitTooLarge && maxMergeIsRunning) continue;
                best = candidate;
                bestScore = score2;
                bestTooLarge = hitTooLarge;
                bestMergeBytes = bytesThisMerge;
            }
            if (best == null) {
                return spec;
            }
            if (!haveOneLargeMerge || !bestTooLarge || mergeType == MERGE_TYPE.FORCE_MERGE_DELETES) {
                haveOneLargeMerge |= bestTooLarge;
                if (spec == null) {
                    spec = new MergePolicy.MergeSpecification();
                }
                MergePolicy.OneMerge merge2 = new MergePolicy.OneMerge(best);
                spec.add(merge2);
                if (this.verbose(mergeContext)) {
                    String string = this.segString(mergeContext, (Iterable<SegmentCommitInfo>)merge2.getSegments());
                    double d = (double)bestMergeBytes / 1024.0 / 1024.0;
                    MergeScore mergeScore = bestScore;
                    Intrinsics.checkNotNull(mergeScore);
                    this.message("  add merge=" + string + " size=" + d + " MB score=" + mergeScore.getScore() + " " + bestScore.getExplanation() + (bestTooLarge ? " [max merge]" : ""), mergeContext);
                }
            }
            toBeMerged.addAll(best);
        }
    }

    @NotNull
    protected final MergeScore score(@NotNull List<SegmentCommitInfo> candidate, boolean hitTooLarge, @NotNull Map<SegmentCommitInfo, SegmentSizeAndDocs> segmentsSizes) throws IOException {
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter(segmentsSizes, (String)"segmentsSizes");
        long totBeforeMergeBytes = 0L;
        long totAfterMergeBytes = 0L;
        long totAfterMergeBytesFloored = 0L;
        for (SegmentCommitInfo info : candidate) {
            SegmentSizeAndDocs segmentSizeAndDocs = segmentsSizes.get(info);
            Intrinsics.checkNotNull((Object)segmentSizeAndDocs);
            long segBytes = segmentSizeAndDocs.getSizeInBytes();
            totAfterMergeBytes += segBytes;
            totAfterMergeBytesFloored += this.floorSize(segBytes);
            totBeforeMergeBytes += info.sizeInBytes();
        }
        double skew = 0.0;
        if (hitTooLarge) {
            int mergeFactor = (int)this.segmentsPerTier;
            skew = 1.0 / (double)mergeFactor;
        } else {
            SegmentSizeAndDocs segmentSizeAndDocs = segmentsSizes.get(candidate.get(0));
            Intrinsics.checkNotNull((Object)segmentSizeAndDocs);
            skew = (double)this.floorSize(segmentSizeAndDocs.getSizeInBytes()) / (double)totAfterMergeBytesFloored;
        }
        double mergeScore = skew;
        mergeScore *= java.lang.Math.pow(totAfterMergeBytes, 0.05);
        double nonDelRatio = (double)totAfterMergeBytes / (double)totBeforeMergeBytes;
        double finalMergeScore = mergeScore *= java.lang.Math.pow(nonDelRatio, 2.0);
        return new MergeScore(finalMergeScore, skew, nonDelRatio){
            final /* synthetic */ double $finalMergeScore;
            final /* synthetic */ double $skew;
            final /* synthetic */ double $nonDelRatio;
            {
                this.$finalMergeScore = $finalMergeScore;
                this.$skew = $skew;
                this.$nonDelRatio = $nonDelRatio;
            }

            public double getScore() {
                return this.$finalMergeScore;
            }

            public String getExplanation() {
                return "skew=" + this.$skew + " nonDelRatio=" + this.$nonDelRatio;
            }
        };
    }

    @Override
    @Nullable
    public MergePolicy.MergeSpecification findForcedMerges(@NotNull SegmentInfos infos, int maxSegmentCount, @NotNull Map<SegmentCommitInfo, Boolean> segmentsToMerge, @NotNull MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification spec;
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter(segmentsToMerge, (String)"segmentsToMerge");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        if (this.verbose(mergeContext)) {
            this.message("findForcedMerges maxSegmentCount=" + maxSegmentCount + " infos=" + this.segString(mergeContext, infos) + " segmentsToMerge=" + segmentsToMerge, mergeContext);
        }
        List<SegmentSizeAndDocs> sortedSizeAndDocs = this.getSortedBySegmentSize(infos, mergeContext);
        long totalMergeBytes = 0L;
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        Iterator<SegmentSizeAndDocs> iter = sortedSizeAndDocs.iterator();
        boolean forceMergeRunning = false;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            Boolean isOriginal = segmentsToMerge.get(segSizeDocs.getSegInfo());
            if (isOriginal == null) {
                iter.remove();
                continue;
            }
            if (merging.contains(segSizeDocs.getSegInfo())) {
                forceMergeRunning = true;
                iter.remove();
                continue;
            }
            totalMergeBytes += segSizeDocs.getSizeInBytes();
        }
        long maxMergeBytes = this.maxMergedSegmentBytes;
        if (maxSegmentCount == 1) {
            maxMergeBytes = Long.MAX_VALUE;
        } else if (maxSegmentCount != Integer.MAX_VALUE) {
            maxMergeBytes = java.lang.Math.max((long)((double)totalMergeBytes / (double)maxSegmentCount), this.maxMergedSegmentBytes);
            maxMergeBytes = (long)((double)maxMergeBytes * 1.25);
        }
        iter = sortedSizeAndDocs.iterator();
        boolean foundDeletes = false;
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            Boolean isOriginal = segmentsToMerge.get(segSizeDocs.getSegInfo());
            if (segSizeDocs.getDelCount() != 0) {
                if (isOriginal == null || !isOriginal.booleanValue()) continue;
                foundDeletes = true;
                continue;
            }
            if (maxSegmentCount == Integer.MAX_VALUE && isOriginal != null && Intrinsics.areEqual((Object)isOriginal, (Object)false)) {
                iter.remove();
            }
            if (maxSegmentCount == Integer.MAX_VALUE || segSizeDocs.getSizeInBytes() < maxMergeBytes) continue;
            iter.remove();
        }
        if (sortedSizeAndDocs.isEmpty()) {
            return null;
        }
        if (!foundDeletes) {
            SegmentCommitInfo infoZero = sortedSizeAndDocs.get(0).getSegInfo();
            if (maxSegmentCount != Integer.MAX_VALUE && maxSegmentCount > 1 && sortedSizeAndDocs.size() <= maxSegmentCount || maxSegmentCount == 1 && sortedSizeAndDocs.size() == 1 && (segmentsToMerge.get(infoZero) != null || this.isMerged(infos, infoZero, mergeContext))) {
                if (this.verbose(mergeContext)) {
                    this.message("already merged", mergeContext);
                }
                return null;
            }
        }
        if (this.verbose(mergeContext)) {
            this.message("eligible=" + sortedSizeAndDocs, mergeContext);
        }
        int startingSegmentCount = sortedSizeAndDocs.size();
        if (forceMergeRunning) {
            return null;
        }
        if (maxSegmentCount == 1 && totalMergeBytes < maxMergeBytes) {
            spec = new MergePolicy.MergeSpecification();
            List allOfThem = new ArrayList();
            for (SegmentSizeAndDocs segSizeDocs : sortedSizeAndDocs) {
                allOfThem.add(segSizeDocs.getSegInfo());
            }
            spec.add(new MergePolicy.OneMerge(allOfThem));
            return spec;
        }
        spec = null;
        int index = startingSegmentCount - 1;
        int resultingSegments = startingSegmentCount;
        while (true) {
            int candidateSize;
            List candidate = new ArrayList();
            long currentCandidateBytes = 0L;
            while (index >= 0 && resultingSegments > maxSegmentCount) {
                SegmentCommitInfo current = sortedSizeAndDocs.get(index).getSegInfo();
                int initialCandidateSize = candidate.size();
                long currentSegmentSize = current.sizeInBytes();
                if (currentCandidateBytes + currentSegmentSize > maxMergeBytes && initialCandidateSize >= 2) break;
                candidate.add(current);
                --index;
                currentCandidateBytes += currentSegmentSize;
                if (initialCandidateSize <= 0) continue;
                --resultingSegments;
            }
            if ((candidateSize = candidate.size()) <= 1 || forceMergeRunning && !((double)currentCandidateBytes > 0.7 * (double)maxMergeBytes)) break;
            MergePolicy.OneMerge merge2 = new MergePolicy.OneMerge(candidate);
            if (this.verbose(mergeContext)) {
                this.message("add merge=" + this.segString(mergeContext, (Iterable<SegmentCommitInfo>)merge2.getSegments()), mergeContext);
            }
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.add(merge2);
        }
        return spec;
    }

    @Override
    @Nullable
    public MergePolicy.MergeSpecification findForcedDeletesMerges(@NotNull SegmentInfos infos, @NotNull MergePolicy.MergeContext mergeContext) throws IOException {
        double pctDeletes;
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        if (this.verbose(mergeContext)) {
            this.message("findForcedDeletesMerges infos=" + this.segString(mergeContext, infos) + " forceMergeDeletesPctAllowed=" + this.forceMergeDeletesPctAllowed, mergeContext);
        }
        Set<SegmentCommitInfo> merging = mergeContext.getMergingSegments();
        boolean haveWork = false;
        int totalDelCount = 0;
        for (SegmentCommitInfo info : infos) {
            int delCount = mergeContext.numDeletesToMerge(info);
            boolean condition$iv = this.assertDelCount(delCount, info);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            totalDelCount += delCount;
            pctDeletes = 100.0 * (double)delCount / (double)info.getInfo().maxDoc();
            haveWork = haveWork || pctDeletes > this.forceMergeDeletesPctAllowed && !merging.contains(info);
        }
        if (!haveWork) {
            return null;
        }
        List<SegmentSizeAndDocs> sortedInfos = this.getSortedBySegmentSize(infos, mergeContext);
        Iterator<SegmentSizeAndDocs> iter = sortedInfos.iterator();
        while (iter.hasNext()) {
            SegmentSizeAndDocs segSizeDocs = iter.next();
            pctDeletes = 100.0 * ((double)segSizeDocs.getDelCount() / (double)segSizeDocs.getMaxDoc());
            if (!merging.contains(segSizeDocs.getSegInfo()) && !(pctDeletes <= this.forceMergeDeletesPctAllowed)) continue;
            iter.remove();
        }
        if (this.verbose(mergeContext)) {
            this.message("eligible=" + sortedInfos, mergeContext);
        }
        MergePolicy.MergeSpecification mergeSpecification = this.doFindMerges(sortedInfos, this.maxMergedSegmentBytes, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.getMaxAllowedDocs(infos.totalMaxDoc(), totalDelCount), MERGE_TYPE.FORCE_MERGE_DELETES, mergeContext, false);
        Intrinsics.checkNotNull((Object)mergeSpecification);
        return mergeSpecification;
    }

    public final int getMaxAllowedDocs(int totalMaxDoc, int totalDelDocs) {
        return Math.INSTANCE.ceilDiv(totalMaxDoc - totalDelDocs, this.targetSearchConcurrency);
    }

    private final long floorSize(long bytes) {
        return java.lang.Math.max(this.floorSegmentBytes, bytes);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("[" + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ": ");
        sb.append("maxMergedSegmentMB=").append((double)this.maxMergedSegmentBytes / 1024.0 / 1024.0).append(", ");
        sb.append("floorSegmentMB=").append((double)this.floorSegmentBytes / 1024.0 / 1024.0).append(", ");
        sb.append("forceMergeDeletesPctAllowed=").append(this.forceMergeDeletesPctAllowed).append(", ");
        sb.append("segmentsPerTier=").append(this.segmentsPerTier).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.getNoCFSRatio()).append(", ");
        sb.append("deletesPctAllowed=").append(this.deletesPctAllowed).append(", ");
        sb.append("targetSearchConcurrency=").append(this.targetSearchConcurrency);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int getSortedBySegmentSize$lambda$6(SegmentSizeAndDocs o1, SegmentSizeAndDocs o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        int cmp = LongExtKt.compare(LongCompanionObject.INSTANCE, o2.getSizeInBytes(), o1.getSizeInBytes());
        if (cmp == 0) {
            cmp = o1.getName().compareTo(o2.getName());
        }
        return cmp;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/TieredMergePolicy$Companion;", "", "<init>", "()V", "DEFAULT_NO_CFS_RATIO", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/TieredMergePolicy$MERGE_TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "NATURAL", "FORCE_MERGE", "FORCE_MERGE_DELETES", "core"})
    private static final class MERGE_TYPE
    extends Enum<MERGE_TYPE> {
        public static final /* enum */ MERGE_TYPE NATURAL = new MERGE_TYPE();
        public static final /* enum */ MERGE_TYPE FORCE_MERGE = new MERGE_TYPE();
        public static final /* enum */ MERGE_TYPE FORCE_MERGE_DELETES = new MERGE_TYPE();
        private static final /* synthetic */ MERGE_TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MERGE_TYPE[] values() {
            return (MERGE_TYPE[])$VALUES.clone();
        }

        public static MERGE_TYPE valueOf(String value) {
            return Enum.valueOf(MERGE_TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<MERGE_TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mERGE_TYPEArray = new MERGE_TYPE[]{MERGE_TYPE.NATURAL, MERGE_TYPE.FORCE_MERGE, MERGE_TYPE.FORCE_MERGE_DELETES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b$\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/index/TieredMergePolicy$MergeScore;", "", "<init>", "()V", "score", "", "getScore", "()D", "explanation", "", "getExplanation", "()Ljava/lang/String;", "core"})
    protected static abstract class MergeScore {
        protected MergeScore() {
        }

        public abstract double getScore();

        @NotNull
        public abstract String getExplanation();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/TieredMergePolicy$SegmentSizeAndDocs;", "", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "sizeInBytes", "", "segDelCount", "", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentCommitInfo;JI)V", "getSizeInBytes", "()J", "segInfo", "getSegInfo", "()Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "delCount", "getDelCount", "()I", "maxDoc", "getMaxDoc", "name", "", "getName", "()Ljava/lang/String;", "core"})
    public static final class SegmentSizeAndDocs {
        private final long sizeInBytes;
        @NotNull
        private final SegmentCommitInfo segInfo;
        private final int delCount;
        private final int maxDoc;
        @NotNull
        private final String name;

        public SegmentSizeAndDocs(@NotNull SegmentCommitInfo info, long sizeInBytes, int segDelCount) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.sizeInBytes = sizeInBytes;
            this.segInfo = info;
            this.delCount = segDelCount;
            this.maxDoc = info.getInfo().maxDoc();
            this.name = info.getInfo().getName();
        }

        public final long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @NotNull
        public final SegmentCommitInfo getSegInfo() {
            return this.segInfo;
        }

        public final int getDelCount() {
            return this.delCount;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }
}

