/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.util.BitUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010!\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0010\n\u0002\u0010\u0016\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/HashContainers;", "", "<init>", "()V", "DEFAULT_EXPECTED_ELEMENTS", "", "DEFAULT_LOAD_FACTOR", "", "MIN_LOAD_FACTOR", "getMIN_LOAD_FACTOR", "()F", "MAX_LOAD_FACTOR", "getMAX_LOAD_FACTOR", "MIN_HASH_ARRAY_LENGTH", "MAX_HASH_ARRAY_LENGTH", "getMAX_HASH_ARRAY_LENGTH", "()I", "ITERATION_SEED", "Lkotlin/concurrent/atomics/AtomicInt;", "getITERATION_SEED$annotations", "getITERATION_SEED", "()Ljava/util/concurrent/atomic/AtomicInteger;", "Ljava/util/concurrent/atomic/AtomicInteger;", "iterationIncrement", "seed", "nextBufferSize", "arraySize", "elements", "loadFactor", "", "expandAtCount", "checkPowerOfTwo", "", "minBufferSize", "checkLoadFactor", "", "minAllowedInclusive", "maxAllowedInclusive", "core"})
@SourceDebugExtension(value={"SMAP\nHashContainers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashContainers.kt\norg/gnit/lucenekmp/internal/hppc/HashContainers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class HashContainers {
    @NotNull
    public static final HashContainers INSTANCE = new HashContainers();
    public static final int DEFAULT_EXPECTED_ELEMENTS = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final float MIN_LOAD_FACTOR = 0.01f;
    private static final float MAX_LOAD_FACTOR = 0.99f;
    public static final int MIN_HASH_ARRAY_LENGTH = 4;
    private static final int MAX_HASH_ARRAY_LENGTH = 0x40000000;
    @NotNull
    private static final AtomicInteger ITERATION_SEED = new AtomicInteger(0);

    private HashContainers() {
    }

    public final float getMIN_LOAD_FACTOR() {
        return MIN_LOAD_FACTOR;
    }

    public final float getMAX_LOAD_FACTOR() {
        return MAX_LOAD_FACTOR;
    }

    public final int getMAX_HASH_ARRAY_LENGTH() {
        return MAX_HASH_ARRAY_LENGTH;
    }

    @NotNull
    public final AtomicInteger getITERATION_SEED() {
        return ITERATION_SEED;
    }

    public static /* synthetic */ void getITERATION_SEED$annotations() {
    }

    public final int iterationIncrement(int seed) {
        return 29 + ((seed & 7) << 1);
    }

    public final int nextBufferSize(int arraySize, int elements, double loadFactor) {
        if (!this.checkPowerOfTwo(arraySize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (arraySize == MAX_HASH_ARRAY_LENGTH) {
            Object[] objectArray = new Object[]{elements, loadFactor};
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", objectArray);
        }
        return arraySize << 1;
    }

    public final int expandAtCount(int arraySize, double loadFactor) {
        if (!this.checkPowerOfTwo(arraySize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Math.min(arraySize - 1, (int)Math.ceil((double)arraySize * loadFactor));
    }

    public final boolean checkPowerOfTwo(int arraySize) {
        if (!(arraySize > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(BitUtil.INSTANCE.nextHighestPowerOfTwo(arraySize) == arraySize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    public final int minBufferSize(int elements, double loadFactor) {
        if (!(elements >= 0)) {
            boolean bl = false;
            String string = "Number of elements must be >= 0: " + elements;
            throw new IllegalArgumentException(string.toString());
        }
        long length = (long)Math.ceil((double)elements / loadFactor);
        if (length == (long)elements) {
            long l = length;
            length = l + 1L;
        }
        if ((length = Math.max(4L, BitUtil.INSTANCE.nextHighestPowerOfTwo(length))) > (long)MAX_HASH_ARRAY_LENGTH) {
            Object[] objectArray = new Object[]{elements, loadFactor};
            throw new BufferAllocationException("Maximum array size exceeded for this load factor (elements: %d, load factor: %f)", objectArray);
        }
        return (int)length;
    }

    public final void checkLoadFactor(double loadFactor, double minAllowedInclusive, double maxAllowedInclusive) {
        if (loadFactor < minAllowedInclusive || loadFactor > maxAllowedInclusive) {
            Object[] objectArray = new Object[]{minAllowedInclusive, maxAllowedInclusive, loadFactor};
            throw new BufferAllocationException("The load factor should be in range [%.2f, %.2f]: %f", objectArray);
        }
    }
}

