/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\u0018\u0000 ^2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0002]^B\u001b\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\rB\u0017\b\u0016\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\u0004\b\t\u0010\u0010J\u000e\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u0006J\u0012\u00101\u001a\u00020\u00062\n\u00102\u001a\u00020\u0012\"\u00020\u0006J\u000e\u00101\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000J\u0016\u00101\u001a\u00020\u00062\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001J\u0014\u00101\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ\u0006\u00104\u001a\u00020\u0012J\u000e\u00105\u001a\u00020#2\u0006\u00100\u001a\u00020\u0006J\u000e\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0000J\u000e\u00108\u001a\u00020#2\u0006\u00100\u001a\u00020\u0006J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020:J\u000e\u0010=\u001a\u00020:2\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010>\u001a\u00020\u0006J\b\u0010?\u001a\u00020\u0006H\u0016J\u0013\u0010@\u001a\u00020#2\b\u0010A\u001a\u0004\u0018\u00010BH\u0096\u0002J\u0010\u0010C\u001a\u00020#2\u0006\u00107\u001a\u00020\u0000H\u0002J\b\u0010D\u001a\u00020\u0000H\u0016J\u0011\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020FH\u0096\u0002J\b\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020\u0006H\u0004J\u0010\u0010J\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006H\u0004J\u000e\u0010K\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006J\u000e\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020\u0006J\u000e\u0010N\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u0006J\u0016\u0010O\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u00062\u0006\u0010P\u001a\u00020\u0006J\u0016\u0010Q\u001a\u00020:2\u0006\u0010M\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006J\u000e\u0010R\u001a\u00020:2\u0006\u0010M\u001a\u00020\u0006J\u0010\u0010S\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010T\u001a\u00020:2\u0006\u0010U\u001a\u00020\u0012H\u0004J\u0010\u0010V\u001a\u00020:2\u0006\u0010W\u001a\u00020\u0006H\u0004J\u0018\u0010X\u001a\u00020:2\u0006\u0010Y\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u0006H\u0004J\u0010\u0010[\u001a\u00020:2\u0006\u0010\\\u001a\u00020\u0006H\u0004R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010\u001bR\u0011\u0010<\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010%\u00a8\u0006_"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntHashSet;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "()V", "set", "(Lorg/gnit/lucenekmp/internal/hppc/IntHashSet;)V", "collection", "", "(Ljava/util/Collection;)V", "keys", "", "getKeys", "()[I", "setKeys", "([I)V", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "add", "key", "addAll", "elements", "iterable", "toArray", "remove", "removeAll", "other", "contains", "clear", "", "release", "isEmpty", "ensureCapacity", "size", "hashCode", "equals", "obj", "", "sameKeys", "clone", "iterator", "", "ramBytesUsed", "", "nextIterationSeed", "hashKey", "indexOf", "indexExists", "index", "indexGet", "indexReplace", "equivalentKey", "indexInsert", "indexRemove", "verifyLoadFactor", "rehash", "fromKeys", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "shiftConflictingKeys", "gapSlot", "EntryIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntHashSet.kt\norg/gnit/lucenekmp/internal/hppc/IntHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntHashSet.kt\norg/gnit/lucenekmp/internal/hppc/IntHashSetKt\n*L\n1#1,716:1\n1#2:717\n22#3,2:718\n22#3,2:720\n22#3,2:722\n22#3,2:724\n22#3,2:726\n22#3,2:728\n22#3,2:730\n22#3,2:732\n22#3,2:734\n22#3,2:736\n22#3,2:738\n*S KotlinDebug\n*F\n+ 1 IntHashSet.kt\norg/gnit/lucenekmp/internal/hppc/IntHashSet\n*L\n510#1:718,2\n511#1:720,2\n530#1:722,2\n531#1:724,2\n532#1:726,2\n551#1:728,2\n555#1:730,2\n556#1:732,2\n559#1:734,2\n581#1:736,2\n582#1:738,2\n*E\n"})
public final class IntHashSet
implements Iterable<IntCursor>,
Accountable,
Cloneable<IntHashSet>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private int[] keys;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntHashSet.class));

    @JvmOverloads
    public IntHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ IntHashSet(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final int[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable int[] nArray) {
        this.keys = nArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public IntHashSet() {
        this(4, 0.0, 2, null);
    }

    public IntHashSet(@NotNull IntHashSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this(set.size(), 0.0, 2, null);
        this.addAll(set);
    }

    public IntHashSet(@NotNull Collection<Integer> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this(collection.size(), 0.0, 2, null);
        this.addAll(collection);
    }

    public final boolean add(int key) {
        int n;
        if (key == 0) {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[this.mask + 1] == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        n = this.assigned;
        this.assigned = n + 1;
        return true;
    }

    public final int addAll(int ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.ensureCapacity(elements.length);
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(@NotNull IntHashSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this.ensureCapacity(set.size());
        return this.addAll((Iterable<IntCursor>)set);
    }

    public final int addAll(@NotNull Iterable<IntCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = 0;
        for (IntCursor cursor : iterable) {
            if (!this.add(cursor.getValue())) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(@NotNull Collection<Integer> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        int count = 0;
        Iterator<Integer> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            int element = ((Number)iterator2.next()).intValue();
            if (!this.add(element)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public final int[] toArray() {
        int[] cloned = new int[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            int n = j;
            j = n + 1;
            cloned[n] = 0;
        }
        int[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.INSTANCE.iterationIncrement(seed);
        IntHashSet $this$toArray_u24lambda_u242 = this;
        boolean bl = false;
        int mask = $this$toArray_u24lambda_u242.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            int n;
            int existing = 0;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl2 = false;
            existing = it;
            if (n != 0) {
                n = j;
                j = n + 1;
                cloned[n] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public final boolean remove(int key) {
        if (key == 0) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int removeAll(@NotNull IntHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int before = this.size();
        if (other.size() >= this.size()) {
            if (this.hasEmptyKey && other.contains(0)) {
                this.hasEmptyKey = false;
            }
            int[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                int n;
                int existing = 0;
                Intrinsics.checkNotNull((Object)keys);
                int it = n = keys[slot];
                boolean bl = false;
                existing = it;
                if (n != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            Iterator<IntCursor> iterator2 = other.iterator();
            while (iterator2.hasNext()) {
                IntCursor c;
                IntCursor intCursor = c = iterator2.next();
                Intrinsics.checkNotNull((Object)intCursor);
                this.remove(intCursor.getValue());
            }
        }
        return before - this.size();
    }

    public final boolean contains(int key) {
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final void clear() {
        block0: {
            this.assigned = 0;
            this.hasEmptyKey = false;
            if (this.keys == null) break block0;
            ArraysKt.fill$default((int[])this.keys, (int)0, (int)0, (int)0, (int)6, null);
        }
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        int[] keys = this.keys;
        for (int slot = this.mask; -1 < slot; --slot) {
            int n;
            int existing = 0;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) continue;
            h += BitMixer.INSTANCE.mix(existing);
        }
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.sameKeys((IntHashSet)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)obj));
    }

    private final boolean sameKeys(IntHashSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        Iterator<IntCursor> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            IntCursor c;
            IntCursor intCursor = c = iterator2.next();
            Intrinsics.checkNotNull((Object)intCursor);
            if (this.contains(intCursor.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public IntHashSet clone() {
        int[] nArray;
        IntHashSet cloned = new IntHashSet();
        if (this.keys != null) {
            int[] nArray2 = Arrays.copyOf(this.keys, this.keys.length);
            nArray = nArray2;
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        } else {
            nArray = null;
        }
        cloned.keys = nArray;
        cloned.mask = this.mask;
        cloned.assigned = this.assigned;
        cloned.resizeAt = this.resizeAt;
        cloned.hasEmptyKey = this.hasEmptyKey;
        cloned.loadFactor = this.loadFactor;
        cloned.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        return cloned;
    }

    @Override
    @NotNull
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        Intrinsics.checkNotNull((Object)this.keys);
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys);
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    protected final int hashKey(int key) {
        if (!(key != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    public final int indexOf(int key) {
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        if (!(index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index >= 0;
    }

    public final int indexGet(int index) {
        boolean value$iv = index >= 0;
        boolean $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new AssertionError((Object)string);
        }
        value$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)this.keys);
        return this.keys[index];
    }

    public final int indexReplace(int index, int equivalentKey) {
        boolean value$iv = index >= 0;
        boolean $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new AssertionError((Object)string);
        }
        value$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)this.keys);
        value$iv = this.keys[index] == equivalentKey;
        $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)this.keys);
        int previousValue = this.keys[index];
        Intrinsics.checkNotNull((Object)this.keys);
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public final void indexInsert(int index, int key) {
        int index2 = index;
        boolean value$iv = index2 < 0;
        boolean $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "The index must not point at an existing key.";
            throw new AssertionError((Object)string);
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            value$iv = index2 == this.mask + 1;
            $i$f$assertOrThrow = false;
            if (!value$iv) {
                boolean bl = false;
                String string = "";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull((Object)this.keys);
            value$iv = this.keys[index2] == 0;
            $i$f$assertOrThrow = false;
            if (!value$iv) {
                boolean bl = false;
                String string = "";
                throw new AssertionError((Object)string);
            }
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            value$iv = this.keys[index2] == 0;
            $i$f$assertOrThrow = false;
            if (!value$iv) {
                boolean bl = false;
                String string = "";
                throw new AssertionError((Object)string);
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    public final void indexRemove(int index) {
        boolean value$iv = index >= 0;
        boolean $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new AssertionError((Object)string);
        }
        value$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        $i$f$assertOrThrow = false;
        if (!value$iv) {
            boolean bl = false;
            String string = "";
            throw new AssertionError((Object)string);
        }
        if (index > this.mask) {
            this.hasEmptyKey = false;
        } else {
            this.shiftConflictingKeys(index);
        }
    }

    protected final double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull int[] fromKeys) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        if (!HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int existing = 0;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            int n;
            int it = n = fromKeys[i];
            boolean bl = false;
            existing = it;
            if (n == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (true) {
                Intrinsics.checkNotNull((Object)keys);
                if (keys[slot] == 0) break;
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected final void allocateBuffers(int arraySize) {
        if (!(IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            Object[] objectArray = new Object[]{this.keys == null ? 0 : this.size(), arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, int pendingKey) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0 && pendingKey != 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            var4_3 = "Failed requirement.";
            throw new IllegalArgumentException(var4_3.toString());
        }
        prevKeys = this.keys;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        if (!(v1 > prevKeys.length)) {
            var5_5 = "Failed requirement.";
            throw new IllegalArgumentException(var5_5.toString());
        }
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        int[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            int existing = keys[slot];
            if (existing == 0) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public IntHashSet(int expectedElements) {
        this(expectedElements, 0.0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00020\t\"\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntHashSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/IntHashSet;", "elements", "", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntHashSet from(int ... elements) {
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            IntHashSet set = new IntHashSet(elements.length, 0.0, 2, null);
            set.addAll(Arrays.copyOf(elements, elements.length));
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntHashSet$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntHashSet;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nIntHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntHashSet.kt\norg/gnit/lucenekmp/internal/hppc/IntHashSet$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,716:1\n1#2:717\n*E\n"})
    protected final class EntryIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntHashSet.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntHashSet.this.getMask();
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            int mask = IntHashSet.this.getMask();
            while (this.index <= mask) {
                int existing = 0;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntHashSet.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                int it = n = nArray[this.slot];
                boolean bl = false;
                existing = it;
                if (n == 0) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntHashSet.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0);
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

