/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0016\u0018\u0000 o2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\bhijklmnoB\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\rJ\u0016\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u0014\u00102\u001a\u00020\u00062\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0016\u00104\u001a\u00020#2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u001e\u00105\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006J\u0016\u00108\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006J\u000e\u00109\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006J\u000e\u0010:\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006J\u0016\u0010;\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u0010<\u001a\u00020\u0006J\u000e\u0010=\u001a\u00020#2\u0006\u00100\u001a\u00020\u0006J\u000e\u0010>\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020\u0006J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006J\u0016\u0010B\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\u0006J\u001e\u0010D\u001a\u00020E2\u0006\u0010@\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u000e\u0010F\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006J\u0006\u0010G\u001a\u00020EJ\u0006\u0010H\u001a\u00020EJ\u0006\u0010I\u001a\u00020\u0006J\b\u0010K\u001a\u00020\u0006H\u0016J\u0013\u0010L\u001a\u00020#2\b\u0010M\u001a\u0004\u0018\u00010NH\u0096\u0002J\u0010\u0010O\u001a\u00020#2\u0006\u0010M\u001a\u00020\u0000H\u0004J\u000e\u0010P\u001a\u00020E2\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010Q\u001a\u00020\u0006H\u0004J\b\u0010R\u001a\u00020SH\u0016J\u000f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020UH\u0096\u0002J\n\u0010\u000e\u001a\u00060VR\u00020\u0000J\n\u0010\u0014\u001a\u00060WR\u00020\u0000J\b\u0010X\u001a\u00020\u0000H\u0016J\b\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006H\u0004J\u0010\u0010\\\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0018\u0010]\u001a\u00020E2\u0006\u0010^\u001a\u00020\u000f2\u0006\u0010_\u001a\u00020\u000fH\u0004J\u0010\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020\u0006H\u0004J \u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020\u00062\u0006\u0010d\u001a\u00020\u00062\u0006\u0010e\u001a\u00020\u0006H\u0004J\u0010\u0010f\u001a\u00020E2\u0006\u0010g\u001a\u00020\u0006H\u0004R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010\u001bR\u0011\u0010J\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010%\u00a8\u0006p"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntIntCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "()V", "map", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "keys", "", "getKeys", "()[I", "setKeys", "([I)V", "values", "getValues", "setValues", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "put", "key", "value", "putAll", "iterable", "putIfAbsent", "putOrAdd", "putValue", "incrementValue", "addTo", "remove", "get", "getOrDefault", "defaultValue", "containsKey", "indexOf", "indexExists", "index", "indexGet", "indexReplace", "newValue", "indexInsert", "", "indexRemove", "clear", "release", "size", "isEmpty", "hashCode", "equals", "other", "", "equalElements", "ensureCapacity", "nextIterationSeed", "ramBytesUsed", "", "iterator", "", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$KeysContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntContainer;", "clone", "toString", "", "hashKey", "verifyLoadFactor", "rehash", "fromKeys", "fromValues", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "pendingValue", "shiftConflictingKeys", "gapSlot", "EntryIterator", "KeysContainer", "KeysIterator", "ValuesContainer", "IntContainer", "ValuesIterator", "IntIntCursor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntIntHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,818:1\n1#2:819\n*E\n"})
public class IntIntHashMap
implements Iterable<IntIntCursor>,
Accountable,
Cloneable<IntIntHashMap>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private int[] keys;
    @Nullable
    private int[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntIntHashMap.class));

    public IntIntHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ IntIntHashMap(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final int[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable int[] nArray) {
        this.keys = nArray;
    }

    @Nullable
    public final int[] getValues() {
        return this.values;
    }

    public final void setValues(@Nullable int[] nArray) {
        this.values = nArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public IntIntHashMap() {
        this(4, 0.0, 2, null);
    }

    public IntIntHashMap(@NotNull IntIntHashMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        this(map2.size(), 0.0, 2, null);
        this.putAll(map2);
    }

    public final int put(int key, int value) {
        int n;
        if (!(this.assigned < this.mask + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int mask = this.mask;
        if (key == 0) {
            int n2;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n2 = this.values[mask + 1];
            } else {
                n2 = 0;
            }
            int previousValue = n2;
            this.hasEmptyKey = true;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = value;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                int previousValue = this.values[slot];
                Intrinsics.checkNotNull((Object)this.values);
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[slot] = value;
        }
        n = this.assigned;
        this.assigned = n + 1;
        return 0;
    }

    public final int putAll(@NotNull Iterable<IntIntCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = this.size();
        for (IntIntCursor c : iterable) {
            this.put(c.getKey(), c.getValue());
        }
        return this.size() - count;
    }

    public final boolean putIfAbsent(int key, int value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    public final int putOrAdd(int key, int putValue, int incrementValue) {
        int putValue2 = putValue;
        if (!(this.assigned < this.mask + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            Intrinsics.checkNotNull((Object)this.values);
            putValue2 = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue2);
        } else {
            this.indexInsert(keyIndex, key, putValue2);
        }
        return putValue2;
    }

    public final int addTo(int key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public final int remove(int key) {
        int mask = this.mask;
        if (key == 0) {
            if (!this.hasEmptyKey) {
                return 0;
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            int previousValue = this.values[mask + 1];
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = 0;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                int previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public final int get(int key) {
        if (key == 0) {
            int n;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n = this.values[this.mask + 1];
            } else {
                n = 0;
            }
            return n;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public final int getOrDefault(int key, int defaultValue) {
        if (key == 0) {
            int n;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n = this.values[this.mask + 1];
            } else {
                n = defaultValue;
            }
            return n;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public final boolean containsKey(int key) {
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int indexOf(int key) {
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        if (!(index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index >= 0;
    }

    public final int indexGet(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        return this.values[index];
    }

    public final int indexReplace(int index, int newValue) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        int previousValue = this.values[index];
        Intrinsics.checkNotNull((Object)this.values);
        this.values[index] = newValue;
        return previousValue;
    }

    public final void indexInsert(int index, int key, int value) {
        int index2 = index;
        if (!(index2 < 0)) {
            boolean bl = false;
            String string = "The index must not point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            if (!(index2 == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index2] = value;
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[index2] == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
                Intrinsics.checkNotNull((Object)this.values);
                this.values[index2] = value;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    public final int indexRemove(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        int previousValue = this.values[index];
        if (index > this.mask) {
            if (!(index == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    public final void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Intrinsics.checkNotNull((Object)this.keys);
        ArraysKt.fill$default((int[])this.keys, (int)0, (int)0, (int)0, (int)6, null);
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (IntIntCursor c : this) {
            h += BitMixer.INSTANCE.mix(c.getKey()) + BitMixer.INSTANCE.mix(c.getValue());
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.equalElements((IntIntHashMap)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    protected final boolean equalElements(@NotNull IntIntHashMap other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.size() != this.size()) {
            return false;
        }
        for (IntIntCursor c : other) {
            int key = c.getKey();
            if (this.containsKey(key) && this.get(key) == c.getValue()) continue;
            return false;
        }
        return true;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            int[] prevValues = this.values;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                Intrinsics.checkNotNull((Object)prevValues);
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    @Override
    public long ramBytesUsed() {
        Intrinsics.checkNotNull((Object)this.keys);
        long l = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys);
        Intrinsics.checkNotNull((Object)this.values);
        return l + RamUsageEstimator.Companion.sizeOf(this.values);
    }

    @Override
    @NotNull
    public Iterator<IntIntCursor> iterator() {
        return new EntryIterator();
    }

    @NotNull
    public final KeysContainer keys() {
        return new KeysContainer();
    }

    @NotNull
    public final IntContainer values() {
        return new ValuesContainer();
    }

    @Override
    @NotNull
    public IntIntHashMap clone() {
        int[] nArray;
        IntIntHashMap cloned = new IntIntHashMap();
        if (this.keys != null) {
            int[] nArray2 = Arrays.copyOf(this.keys, this.keys.length);
            v1 = nArray2;
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        } else {
            v1 = cloned.keys = null;
        }
        if (this.values != null) {
            int[] nArray3 = Arrays.copyOf(this.values, this.values.length);
            nArray = nArray3;
            Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
        } else {
            nArray = null;
        }
        cloned.values = nArray;
        cloned.mask = this.mask;
        cloned.assigned = this.assigned;
        cloned.resizeAt = this.resizeAt;
        cloned.hasEmptyKey = this.hasEmptyKey;
        cloned.loadFactor = this.loadFactor;
        cloned.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        return cloned;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.getKey());
            buffer.append("=>");
            buffer.append(cursor.getValue());
            first = false;
        }
        buffer.append("]");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final int hashKey(int key) {
        if (!(key != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    protected final double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull int[] fromKeys, @NotNull int[] fromValues) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)fromValues, (String)"fromValues");
        if (!(fromKeys.length == fromValues.length && HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] keys = this.keys;
        int[] values2 = this.values;
        int mask = this.mask;
        int existing = 0;
        int from = fromKeys.length - 1;
        Intrinsics.checkNotNull((Object)keys);
        keys[keys.length - 1] = fromKeys[from];
        Intrinsics.checkNotNull((Object)values2);
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            int n;
            int it = n = fromKeys[from];
            boolean bl = false;
            existing = it;
            if (n == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected final void allocateBuffers(int arraySize) {
        if (!(IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] prevKeys = this.keys;
        int[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new int[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            this.values = prevValues;
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, int pendingKey, int pendingValue) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0 && pendingKey != 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            var5_4 = "Failed requirement.";
            throw new IllegalArgumentException(var5_4.toString());
        }
        prevKeys = this.keys;
        prevValues = this.values;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        if (!(v1 > prevKeys.length)) {
            var6_7 = "Failed requirement.";
            throw new IllegalArgumentException(var6_7.toString());
        }
        prevKeys[slot] = pendingKey;
        Intrinsics.checkNotNull((Object)prevValues);
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        int[] keys = this.keys;
        int[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            int existing = keys[slot];
            if (existing == 0) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            Intrinsics.checkNotNull((Object)values2);
            values2[gapSlot2] = values2[slot];
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0;
        Intrinsics.checkNotNull((Object)values2);
        values2[gapSlot2] = 0;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "keys", "", "values", "core"})
    @SourceDebugExtension(value={"SMAP\nIntIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntIntHashMap$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,818:1\n1#2:819\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntIntHashMap from(@NotNull int[] keys, @NotNull int[] values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            if (!(keys.length == values2.length)) {
                boolean $i$a$-require-IntIntHashMap$Companion$from$22 = false;
                String $i$a$-require-IntIntHashMap$Companion$from$22 = "Arrays of keys and values must have an identical length.";
                throw new IllegalArgumentException($i$a$-require-IntIntHashMap$Companion$from$22.toString());
            }
            IntIntHashMap map2 = new IntIntHashMap(keys.length, 0.0, 2, null);
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                map2.put(keys[i], values2[i]);
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntIntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nIntIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntIntHashMap$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,818:1\n1#2:819\n*E\n"})
    private final class EntryIterator
    extends AbstractIterator<IntIntCursor> {
        @NotNull
        private final IntIntCursor cursor = new IntIntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntIntCursor fetch() {
            int mask = IntIntHashMap.this.getMask();
            while (this.index <= mask) {
                int existing = 0;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                int it = n = nArray[this.slot];
                boolean bl = false;
                existing = it;
                if (n == 0) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setKey(existing);
                int[] nArray2 = IntIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray2);
                this.cursor.setValue(nArray2[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntIntHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                this.cursor.setKey(0);
                int[] nArray = IntIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                int n = this.index;
                this.index = n + 1;
                this.cursor.setValue(nArray[n]);
                return this.cursor;
            }
            return (IntIntCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u00a6\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "size", "", "toArray", "", "core"})
    public abstract class IntContainer
    implements Iterable<IntCursor>,
    KMappedMarker {
        public final int size() {
            return IntIntHashMap.this.size();
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.size()];
            int i = 0;
            for (IntCursor cursor : this) {
                array[i++] = cursor.getValue();
            }
            return array;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntIntCursor;", "", "<init>", "()V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "key", "getKey", "setKey", "value", "getValue", "setValue", "toString", "", "core"})
    public static final class IntIntCursor {
        private int index;
        private int key;
        private int value;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getKey() {
            return this.key;
        }

        public final void setKey(int n) {
            this.key = n;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        @NotNull
        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0096\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$KeysContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "iterator", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "core"})
    public final class KeysContainer
    extends IntContainer {
        @Override
        @NotNull
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$KeysIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nIntIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntIntHashMap$KeysIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,818:1\n1#2:819\n*E\n"})
    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = IntIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            int mask = IntIntHashMap.this.getMask();
            while (this.index <= mask) {
                int existing = 0;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                int it = n = nArray[this.slot];
                boolean bl = false;
                existing = it;
                if (n == 0) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntIntHashMap.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0);
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0096\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$ValuesContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$IntContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "iterator", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "core"})
    private final class ValuesContainer
    extends IntContainer {
        @Override
        @NotNull
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap$ValuesIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = IntIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            int n;
            int mask = IntIntHashMap.this.getMask();
            while (this.index <= mask) {
                n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                if (nArray[this.slot] == 0) continue;
                this.cursor.setIndex(this.slot);
                int[] nArray2 = IntIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray2);
                this.cursor.setValue(nArray2[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntIntHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                int[] nArray = IntIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                n = this.index;
                this.index = n + 1;
                this.cursor.setValue(nArray[n]);
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

