/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.internal.hppc.ObjectCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010(\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0016\u0018\u0000 v*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u00042\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0005:\u0007pqrstuvB\u001b\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fB\u0019\b\u0016\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0000\u00a2\u0006\u0004\b\n\u0010\u000eJ\u001f\u00105\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00108J \u00109\u001a\u00020\u00072\u0018\u0010:\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u00030\u0002J\u001d\u0010;\u001a\u00020)2\u0006\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010<J\u0015\u0010=\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020\u0007\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010>J\u001f\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020\u00072\b\u0010A\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00108J\u000e\u0010B\u001a\u00020)2\u0006\u00106\u001a\u00020\u0007J\u000e\u0010C\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007J\u000e\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020\u0007J\u0015\u0010F\u001a\u0004\u0018\u00018\u00002\u0006\u0010E\u001a\u00020\u0007\u00a2\u0006\u0002\u0010>J\u001f\u0010G\u001a\u0004\u0018\u00018\u00002\u0006\u0010E\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00108J%\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\b\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010KJ\u0015\u0010L\u001a\u0004\u0018\u00018\u00002\u0006\u0010E\u001a\u00020\u0007\u00a2\u0006\u0002\u0010>J\u0006\u0010M\u001a\u00020JJ\u0006\u0010N\u001a\u00020JJ\u0006\u0010O\u001a\u00020\u0007J\b\u0010Q\u001a\u00020\u0007H\u0016J\u0013\u0010R\u001a\u00020)2\b\u0010S\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0014\u0010T\u001a\u00020)2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004J\u000e\u0010V\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010W\u001a\u00020\u0007H\u0004J\u0015\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030YH\u0096\u0002J\b\u0010Z\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020[H\u0002J\u0010\u0010\u000f\u001a\f0]R\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0010\u0010\u0015\u001a\f0^R\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\b\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0004J\u0010\u0010c\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0004J%\u0010d\u001a\u00020J2\u0006\u0010e\u001a\u00020\u00102\u000e\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0016H\u0004\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u00020J2\u0006\u0010i\u001a\u00020\u0007H\u0004J'\u0010j\u001a\u00020J2\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020\u00072\b\u0010m\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010KJ\u0010\u0010n\u001a\u00020J2\u0006\u0010o\u001a\u00020\u0007H\u0004R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010%\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001f\"\u0004\b4\u0010!R\u0011\u0010P\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010+\u00a8\u0006w"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "VType", "", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$IntObjectCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "()V", "map", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "keys", "", "getKeys", "()[I", "setKeys", "([I)V", "values", "", "", "getValues", "()[Ljava/lang/Object;", "setValues", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "put", "key", "value", "(ILjava/lang/Object;)Ljava/lang/Object;", "putAll", "iterable", "putIfAbsent", "(ILjava/lang/Object;)Z", "remove", "(I)Ljava/lang/Object;", "get", "getOrDefault", "defaultValue", "containsKey", "indexOf", "indexExists", "index", "indexGet", "indexReplace", "newValue", "indexInsert", "", "(IILjava/lang/Object;)V", "indexRemove", "clear", "release", "size", "isEmpty", "hashCode", "equals", "obj", "equalElements", "other", "ensureCapacity", "nextIterationSeed", "iterator", "", "ramBytesUsed", "", "sizeOfValues", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$KeysContainer;", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$ValuesContainer;", "clone", "toString", "", "hashKey", "verifyLoadFactor", "rehash", "fromKeys", "fromValues", "([I[Ljava/lang/Object;)V", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "pendingValue", "shiftConflictingKeys", "gapSlot", "EntryIterator", "KeysContainer", "KeysIterator", "ValuesContainer", "ValuesIterator", "IntObjectCursor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntObjectHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,790:1\n1#2:791\n*E\n"})
public class IntObjectHashMap<VType>
implements Iterable<IntObjectCursor<VType>>,
Accountable,
Cloneable<IntObjectHashMap<VType>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private int[] keys;
    @Nullable
    private Object[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntObjectHashMap.class));

    @JvmOverloads
    public IntObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ IntObjectHashMap(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final int[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable int[] nArray) {
        this.keys = nArray;
    }

    @Nullable
    public final Object[] getValues() {
        return this.values;
    }

    public final void setValues(@Nullable Object[] objectArray) {
        this.values = objectArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public IntObjectHashMap() {
        this(4, 0.0, 2, null);
    }

    public IntObjectHashMap(@NotNull IntObjectHashMap<VType> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this(map2.size(), 0.0, 2, null);
        this.putAll(map2);
    }

    @Nullable
    public final VType put(int key, @Nullable VType value) {
        int n;
        if (!(this.assigned < this.mask + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int mask = this.mask;
        if (key == 0) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[mask + 1];
            } else {
                object = null;
            }
            Object previousValue = object;
            this.hasEmptyKey = true;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                Object previousValue = this.values[slot];
                Intrinsics.checkNotNull((Object)this.values);
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[slot] = value;
        }
        n = this.assigned;
        this.assigned = n + 1;
        return null;
    }

    public final int putAll(@NotNull Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = this.size();
        for (IntObjectCursor<VType> c : iterable) {
            this.put(c.getKey(), c.getValue());
        }
        return this.size() - count;
    }

    public final boolean putIfAbsent(int key, @Nullable VType value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Nullable
    public final VType remove(int key) {
        int mask = this.mask;
        if (key == 0) {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            Object previousValue = this.values[mask + 1];
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = 0;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Nullable
    public final VType get(int key) {
        if (key == 0) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[this.mask + 1];
            } else {
                object = null;
            }
            return (VType)object;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Nullable
    public final VType getOrDefault(int key, @Nullable VType defaultValue) {
        if (key == 0) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[this.mask + 1];
            } else {
                object = defaultValue;
            }
            return object;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public final boolean containsKey(int key) {
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int indexOf(int key) {
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        int existing = 0;
        while (true) {
            int n;
            Intrinsics.checkNotNull((Object)keys);
            int it = n = keys[slot];
            boolean bl = false;
            existing = it;
            if (n == 0) break;
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        if (!(index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index >= 0;
    }

    @Nullable
    public final VType indexGet(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        return (VType)this.values[index];
    }

    @Nullable
    public final VType indexReplace(int index, @Nullable VType newValue) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        Object previousValue = this.values[index];
        Intrinsics.checkNotNull((Object)this.values);
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    public final void indexInsert(int index, int key, @Nullable VType value) {
        int index2 = index;
        if (!(index2 < 0)) {
            boolean bl = false;
            String string = "The index must not point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            if (!(index2 == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index2] = value;
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[index2] == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
                Intrinsics.checkNotNull((Object)this.values);
                this.values[index2] = value;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    @Nullable
    public final VType indexRemove(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        Object previousValue = this.values[index];
        if (index > this.mask) {
            if (!(index == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return (VType)previousValue;
    }

    public final void clear() {
        block0: {
            this.assigned = 0;
            this.hasEmptyKey = false;
            if (this.keys == null) break block0;
            ArraysKt.fill$default((int[])this.keys, (int)0, (int)0, (int)0, (int)6, null);
        }
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        Iterator<IntObjectCursor<VType>> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            IntObjectCursor<VType> c;
            IntObjectCursor<VType> intObjectCursor = c = iterator2.next();
            Intrinsics.checkNotNull(intObjectCursor);
            h += BitMixer.INSTANCE.mix(intObjectCursor.getKey()) + BitMixer.INSTANCE.mix(c.getValue());
        }
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntObjectHashMap)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)obj));
    }

    protected final boolean equalElements(@NotNull IntObjectHashMap<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.size() != this.size()) {
            return false;
        }
        Iterator<IntObjectCursor<?>> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            IntObjectCursor<?> c;
            IntObjectCursor<?> intObjectCursor = c = iterator2.next();
            Intrinsics.checkNotNull(intObjectCursor);
            int key = intObjectCursor.getKey();
            if (this.containsKey(key) && Intrinsics.areEqual(c.getValue(), this.get(key))) continue;
            return false;
        }
        return true;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    @Override
    @NotNull
    public Iterator<IntObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        Intrinsics.checkNotNull((Object)this.keys);
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys) + this.sizeOfValues();
    }

    private final long sizeOfValues() {
        long size2 = RamUsageEstimator.Companion.shallowSizeOf((Object)this.values);
        for (ObjectCursor value : this.values()) {
            size2 += RamUsageEstimator.Companion.sizeOfObject(value);
        }
        return size2;
    }

    @NotNull
    public final KeysContainer keys() {
        return new KeysContainer();
    }

    @NotNull
    public final ValuesContainer values() {
        return new ValuesContainer();
    }

    @Override
    @NotNull
    public IntObjectHashMap<VType> clone() {
        Object[] objectArray;
        IntObjectHashMap<VType> cloned = new IntObjectHashMap<VType>();
        if (this.keys != null) {
            int[] nArray = Arrays.copyOf(this.keys, this.keys.length);
            v1 = nArray;
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        } else {
            v1 = cloned.keys = null;
        }
        if (this.values != null) {
            Object[] objectArray2 = Arrays.copyOf(this.values, this.values.length);
            objectArray = objectArray2;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
        } else {
            objectArray = null;
        }
        cloned.values = objectArray;
        cloned.mask = this.mask;
        cloned.assigned = this.assigned;
        cloned.resizeAt = this.resizeAt;
        cloned.hasEmptyKey = this.hasEmptyKey;
        cloned.loadFactor = this.loadFactor;
        cloned.iterationSeed = HashContainers.INSTANCE.getITERATION_SEED().addAndGet(1);
        return cloned;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            IntObjectCursor<VType> intObjectCursor = cursor;
            Intrinsics.checkNotNull(intObjectCursor);
            buffer.append(intObjectCursor.getKey());
            buffer.append("=>");
            buffer.append(cursor.getValue());
            first = false;
        }
        buffer.append("]");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final int hashKey(int key) {
        if (!(key != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    protected final double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull int[] fromKeys, @NotNull VType[] fromValues) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter(fromValues, (String)"fromValues");
        if (!(fromKeys.length == fromValues.length && HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int existing = 0;
        int from = fromKeys.length - 1;
        Intrinsics.checkNotNull((Object)keys);
        keys[keys.length - 1] = fromKeys[from];
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            int n;
            int it = n = fromKeys[from];
            boolean bl = false;
            existing = it;
            if (n == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected final void allocateBuffers(int arraySize) {
        if (!(IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            this.values = prevValues;
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, int pendingKey, @Nullable VType pendingValue) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0 && pendingKey != 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            var5_4 = "Failed requirement.";
            throw new IllegalArgumentException(var5_4.toString());
        }
        prevKeys = this.keys;
        prevValues = this.values;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        if (!(v1 > prevKeys.length)) {
            var6_7 = "Failed requirement.";
            throw new IllegalArgumentException(var6_7.toString());
        }
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        int[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            int existing = keys[slot];
            if (existing == 0) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            values2[gapSlot2] = values2[slot];
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0;
        values2[gapSlot2] = null;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public IntObjectHashMap(int expectedElements) {
        this(expectedElements, 0.0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\b0\u0007\"\u0004\b\u0001\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\b0\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "VType", "keys", "", "values", "", "([I[Ljava/lang/Object;)Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "core"})
    @SourceDebugExtension(value={"SMAP\nIntObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,790:1\n1#2:791\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <VType> IntObjectHashMap<VType> from(@NotNull int[] keys, @NotNull VType[] values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            if (!(keys.length == values2.length)) {
                boolean $i$a$-require-IntObjectHashMap$Companion$from$22 = false;
                String $i$a$-require-IntObjectHashMap$Companion$from$22 = "Arrays of keys and values must have an identical length.";
                throw new IllegalArgumentException($i$a$-require-IntObjectHashMap$Companion$from$22.toString());
            }
            IntObjectHashMap<VType> map2 = new IntObjectHashMap<VType>(keys.length, 0.0, 2, null);
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                map2.put(keys[i], values2[i]);
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0002H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$IntObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nIntObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,790:1\n1#2:791\n*E\n"})
    private final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        @NotNull
        private final IntObjectCursor<VType> cursor = new IntObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntObjectCursor<VType> fetch() {
            int mask = IntObjectHashMap.this.getMask();
            while (this.index <= mask) {
                int existing = 0;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                int it = n = nArray[this.slot];
                boolean bl = false;
                existing = it;
                if (n == 0) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setKey(existing);
                Object[] objectArray = IntObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                this.cursor.setValue(objectArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                this.cursor.setKey(0);
                Object[] objectArray = IntObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                int n = this.index;
                this.index = n + 1;
                this.cursor.setValue(objectArray[n]);
                return this.cursor;
            }
            return (IntObjectCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001e\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$IntObjectCursor;", "VType", "", "<init>", "()V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "key", "getKey", "setKey", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "toString", "", "core"})
    public static final class IntObjectCursor<VType> {
        private int index;
        private int key;
        @Nullable
        private VType value;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final int getKey() {
            return this.key;
        }

        public final void setKey(int n) {
            this.key = n;
        }

        @Nullable
        public final VType getValue() {
            return this.value;
        }

        public final void setValue(@Nullable VType VType) {
            this.value = VType;
        }

        @NotNull
        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$KeysContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "iterator", "", "size", "", "toArray", "", "core"})
    public final class KeysContainer
    implements Iterable<IntCursor>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        public final int size() {
            return IntObjectHashMap.this.size();
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.size()];
            int i = 0;
            for (IntCursor cursor : this) {
                int n = i++;
                IntCursor intCursor = cursor;
                Intrinsics.checkNotNull((Object)intCursor);
                array[n] = intCursor.getValue();
            }
            return array;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$KeysIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nIntObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$KeysIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,790:1\n1#2:791\n*E\n"})
    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            int mask = IntObjectHashMap.this.getMask();
            while (this.index <= mask) {
                int existing = 0;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                int it = n = nArray[this.slot];
                boolean bl = false;
                existing = it;
                if (n == 0) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0);
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$ValuesContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/ObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "iterator", "", "size", "", "core"})
    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        public final int size() {
            return IntObjectHashMap.this.size();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0002H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap$ValuesIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/ObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        @NotNull
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected ObjectCursor<VType> fetch() {
            int n;
            int mask = IntObjectHashMap.this.getMask();
            while (this.index <= mask) {
                n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                int[] nArray = IntObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)nArray);
                if (nArray[this.slot] == 0) continue;
                this.cursor.setIndex(this.slot);
                Object[] objectArray = IntObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                this.cursor.setValue(objectArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                Object[] objectArray = IntObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                n = this.index;
                this.index = n + 1;
                this.cursor.setValue(objectArray[n]);
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

