/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterable;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.sequences.Sequence;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.LongCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0003\b\u0016\u0018\u0000 M2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0002LMB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u001a\u001a\u00020\r\"\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0000J\u0014\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0006J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010%\u001a\u00020\u0019J\u0016\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010/\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00100\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u00103\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u0006H\u0004J\u000e\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0006J\u0006\u00108\u001a\u00020\u0006J\u0006\u00109\u001a\u00020\u0017J\u0006\u0010:\u001a\u00020\u0017J\u0006\u0010;\u001a\u00020\u0017J\u0006\u0010<\u001a\u00020\rJ\b\u0010=\u001a\u00020\u0000H\u0016J\b\u0010>\u001a\u00020\u0006H\u0016J\u0013\u0010?\u001a\u00020*2\b\u0010@\u001a\u0004\u0018\u00010AH\u0096\u0002J\u0010\u0010B\u001a\u00020*2\u0006\u0010@\u001a\u00020\u0000H\u0004J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020\u0019H\u0016J\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190GJ\u0006\u0010H\u001a\u00020\u0000J\u0006\u0010I\u001a\u00020\u0000J\u000f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00020KH\u0096\u0002R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\bR\u0011\u00101\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006N"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "Lorg/gnit/lucenekmp/util/Accountable;", "expectedElements", "", "<init>", "(I)V", "()V", "list", "(Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;)V", "buffer", "", "getBuffer", "()[J", "setBuffer", "([J)V", "elementsCount", "getElementsCount", "()I", "setElementsCount", "add", "", "e1", "", "elements", "start", "length", "addAll", "iterable", "", "insert", "index", "get", "set", "removeAt", "removeLast", "removeRange", "fromIndex", "toIndex", "removeElement", "", "e", "removeFirst", "removeAll", "contains", "indexOf", "lastIndexOf", "isEmpty", "()Z", "ensureCapacity", "ensureBufferSpace", "expectedAdditions", "resize", "newSize", "size", "trimToSize", "clear", "release", "toArray", "clone", "hashCode", "equals", "other", "", "equalElements", "toString", "", "ramBytesUsed", "asSequence", "Lkotlin/sequences/Sequence;", "sort", "reverse", "iterator", "", "ValueIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongArrayList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongArrayList.kt\norg/gnit/lucenekmp/internal/hppc/LongArrayList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1#2:418\n*E\n"})
public class LongArrayList
implements Iterable<LongCursor>,
Cloneable<LongArrayList>,
Accountable,
KMutableIterable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] buffer;
    private int elementsCount;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(LongArrayList.class));
    @NotNull
    private static final long[] EMPTY_ARRAY = new long[0];

    public LongArrayList(int expectedElements) {
        this.buffer = new long[expectedElements];
    }

    @NotNull
    public final long[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.buffer = lArray;
    }

    public final int getElementsCount() {
        return this.elementsCount;
    }

    public final void setElementsCount(int n) {
        this.elementsCount = n;
    }

    public LongArrayList() {
        this(4);
    }

    public LongArrayList(@NotNull LongArrayList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this(list.size());
        this.addAll(list);
    }

    public final void add(long e1) {
        this.ensureBufferSpace(1);
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        this.buffer[n] = e1;
    }

    public final void add(@NotNull long[] elements, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "Length must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureBufferSpace(length);
        System.INSTANCE.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(long ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.add(elements, 0, elements.length);
    }

    public final int addAll(@NotNull LongArrayList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int size2 = list.size();
        this.ensureBufferSpace(size2);
        for (LongCursor cursor : list) {
            this.add(cursor.getValue());
        }
        return size2;
    }

    public final int addAll(@NotNull Iterable<LongCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int size2 = 0;
        for (LongCursor cursor : iterable) {
            this.add(cursor.getValue());
            ++size2;
        }
        return size2;
    }

    public final void insert(int index, long e1) {
        if (!(index >= 0 && index <= this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + "].";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureBufferSpace(1);
        System.INSTANCE.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
    }

    public final long get(int index) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        return this.buffer[index];
    }

    public final long set(int index, long e1) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        long v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public final long removeAt(int index) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        long v = this.buffer[index];
        this.elementsCount += -1;
        System.INSTANCE.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index);
        return v;
    }

    public final long removeLast() {
        if (!(!this.isEmpty())) {
            boolean bl = false;
            String string = "List is empty";
            throw new IllegalArgumentException(string.toString());
        }
        this.elementsCount += -1;
        return this.buffer[this.elementsCount];
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (!(fromIndex >= 0 && fromIndex <= this.size())) {
            boolean $i$a$-require-LongArrayList$removeRange$42 = false;
            String $i$a$-require-LongArrayList$removeRange$42 = "Index " + fromIndex + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException($i$a$-require-LongArrayList$removeRange$42.toString());
        }
        if (!(toIndex >= 0 && toIndex <= this.size())) {
            boolean $i$a$-require-LongArrayList$removeRange$52 = false;
            String $i$a$-require-LongArrayList$removeRange$52 = "Index " + toIndex + " out of bounds [0, " + this.size() + "].";
            throw new IllegalArgumentException($i$a$-require-LongArrayList$removeRange$52.toString());
        }
        if (!(fromIndex <= toIndex)) {
            boolean bl = false;
            String string = "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
            throw new IllegalArgumentException(string.toString());
        }
        System.INSTANCE.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    public final boolean removeElement(long e) {
        return this.removeFirst(e) != -1;
    }

    public final int removeFirst(long e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public final int removeLast(long e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public final int removeAll(long e) {
        int to = 0;
        int n = this.elementsCount;
        for (int from = 0; from < n; ++from) {
            if (e == this.buffer[from]) continue;
            if (to != from) {
                this.buffer[to] = this.buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    public final boolean contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    public final int indexOf(long e1) {
        int n = this.elementsCount;
        for (int i = 0; i < n; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(long e1) {
        for (int i = this.elementsCount - 1; -1 < i; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.buffer.length) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.Companion.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public final void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.buffer, newSize, this.elementsCount, 0L);
            } else {
                org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.buffer, this.elementsCount, newSize, 0L);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public final void clear() {
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.buffer, 0, this.elementsCount, 0L);
        this.elementsCount = 0;
    }

    public final void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @NotNull
    public final long[] toArray() {
        return ArrayUtil.Companion.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    @Override
    @NotNull
    public LongArrayList clone() {
        LongArrayList cloned = new LongArrayList();
        long[] lArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        cloned.buffer = lArray;
        cloned.elementsCount = this.size();
        return cloned;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.INSTANCE.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.equalElements((LongArrayList)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    protected final boolean equalElements(@NotNull LongArrayList other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.toArray());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.buffer);
    }

    @NotNull
    public final Sequence<Long> asSequence() {
        return CollectionsKt.asSequence((Iterable)ArraysKt.slice((long[])this.buffer, (IntRange)RangesKt.until((int)0, (int)this.size())));
    }

    @NotNull
    public final LongArrayList sort() {
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(this.buffer, 0, this.elementsCount);
        return this;
    }

    @NotNull
    public final LongArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            long tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    @NotNull
    public Iterator<LongCursor> iterator() {
        return TypeIntrinsics.asMutableIterator((Object)new ValueIterator(this.buffer, this.size()));
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00020\u0007\"\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongArrayList$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[J", "from", "Lorg/gnit/lucenekmp/internal/hppc/LongArrayList;", "elements", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final long[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        @NotNull
        public final LongArrayList from(long ... elements) {
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            LongArrayList list = new LongArrayList(elements.length);
            list.add(Arrays.copyOf(elements, elements.length));
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongArrayList$ValueIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "buffer", "", "size", "", "<init>", "([JI)V", "cursor", "fetch", "core"})
    public static final class ValueIterator
    extends AbstractIterator<LongCursor> {
        @NotNull
        private final long[] buffer;
        private final int size;
        @NotNull
        private final LongCursor cursor;

        public ValueIterator(@NotNull long[] buffer, int size2) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.size = size2;
            this.cursor = new LongCursor();
            this.cursor.setIndex(-1);
        }

        @Override
        @Nullable
        protected LongCursor fetch() {
            if (this.cursor.getIndex() + 1 == this.size) {
                return (LongCursor)this.done();
            }
            LongCursor longCursor = this.cursor;
            longCursor.setIndex(longCursor.getIndex() + 1);
            this.cursor.setValue(this.buffer[longCursor.getIndex()]);
            return this.cursor;
        }
    }
}

