/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.LongCursor;
import org.gnit.lucenekmp.internal.hppc.ObjectCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0016\u0018\u0000 v*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u00042\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0005:\u0007pqrstuvB\u001b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0017\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\n\u0010\rJ\u001f\u00104\u001a\u0004\u0018\u00018\u00002\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u00108J\u001a\u00109\u001a\u00020\u00072\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0002J\u001b\u0010;\u001a\u00020(2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00028\u0000\u00a2\u0006\u0002\u0010<J\u0015\u0010=\u001a\u0004\u0018\u00018\u00002\u0006\u00105\u001a\u000206\u00a2\u0006\u0002\u0010>J\u0015\u0010?\u001a\u0004\u0018\u00018\u00002\u0006\u00105\u001a\u000206\u00a2\u0006\u0002\u0010>J\u001b\u0010@\u001a\u00028\u00002\u0006\u00105\u001a\u0002062\u0006\u0010A\u001a\u00028\u0000\u00a2\u0006\u0002\u00108J\u000e\u0010B\u001a\u00020(2\u0006\u00105\u001a\u000206J\u000e\u0010C\u001a\u00020\u00072\u0006\u00105\u001a\u000206J\u000e\u0010D\u001a\u00020(2\u0006\u0010E\u001a\u00020\u0007J\u0013\u0010F\u001a\u00028\u00002\u0006\u0010E\u001a\u00020\u0007\u00a2\u0006\u0002\u0010GJ\u001b\u0010H\u001a\u00028\u00002\u0006\u0010E\u001a\u00020\u00072\u0006\u0010I\u001a\u00028\u0000\u00a2\u0006\u0002\u0010JJ#\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020\u00072\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00028\u0000\u00a2\u0006\u0002\u0010MJ\u0013\u0010N\u001a\u00028\u00002\u0006\u0010E\u001a\u00020\u0007\u00a2\u0006\u0002\u0010GJ\u0006\u0010O\u001a\u00020LJ\u0006\u0010P\u001a\u00020LJ\u0006\u0010Q\u001a\u00020\u0007J\b\u0010S\u001a\u00020\u0007H\u0016J\u0013\u0010T\u001a\u00020(2\b\u0010U\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0014\u0010V\u001a\u00020(2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004J\u000e\u0010W\u001a\u00020L2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010X\u001a\u00020\u0007H\u0004J\u0015\u0010Y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030ZH\u0096\u0002J\b\u0010[\u001a\u000206H\u0016J\b\u0010\\\u001a\u000206H\u0002J\u0010\u0010\u000e\u001a\f0]R\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0010\u0010\u0014\u001a\f0^R\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\b\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020\u00072\u0006\u00105\u001a\u000206H\u0004J\u0010\u0010c\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0004J%\u0010d\u001a\u00020L2\u0006\u0010e\u001a\u00020\u000f2\u000e\u0010f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0015H\u0004\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u00020L2\u0006\u0010i\u001a\u00020\u0007H\u0004J'\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u0002062\b\u0010m\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010MJ\u0010\u0010n\u001a\u00020L2\u0006\u0010o\u001a\u00020\u0007H\u0004R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u0010 R\u0011\u0010R\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010*\u00a8\u0006w"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;", "VType", "", "Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$LongObjectCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "map", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "keys", "", "getKeys", "()[J", "setKeys", "([J)V", "values", "", "", "getValues", "()[Ljava/lang/Object;", "setValues", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "put", "key", "", "value", "(JLjava/lang/Object;)Ljava/lang/Object;", "putAll", "iterable", "putIfAbsent", "(JLjava/lang/Object;)Z", "remove", "(J)Ljava/lang/Object;", "get", "getOrDefault", "defaultValue", "containsKey", "indexOf", "indexExists", "index", "indexGet", "(I)Ljava/lang/Object;", "indexReplace", "newValue", "(ILjava/lang/Object;)Ljava/lang/Object;", "indexInsert", "", "(IJLjava/lang/Object;)V", "indexRemove", "clear", "release", "size", "isEmpty", "hashCode", "equals", "other", "equalElements", "ensureCapacity", "nextIterationSeed", "iterator", "", "ramBytesUsed", "sizeOfValues", "Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$KeysContainer;", "Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$ValuesContainer;", "clone", "toString", "", "hashKey", "verifyLoadFactor", "rehash", "fromKeys", "fromValues", "([J[Ljava/lang/Object;)V", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "pendingValue", "shiftConflictingKeys", "gapSlot", "EntryIterator", "KeysContainer", "KeysIterator", "ValuesContainer", "ValuesIterator", "LongObjectCursor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongObjectHashMap\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,789:1\n3#2,8:790\n3#2,8:800\n8#2,2:809\n3#2,8:811\n8#2,2:820\n3#2,8:822\n8#2,2:831\n3#2,8:833\n3#2,8:842\n8#2,2:851\n3#2,8:853\n3#2,8:862\n3#2,8:871\n3#2,8:880\n3#2,8:889\n3#2,8:898\n3#2,8:907\n10#3:798\n10#3:808\n10#3:819\n10#3:830\n10#3:841\n10#3:850\n10#3:861\n10#3:870\n10#3:879\n10#3:888\n10#3:897\n10#3:906\n10#3:915\n1#4:799\n*S KotlinDebug\n*F\n+ 1 LongObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongObjectHashMap\n*L\n87#1:790,8\n261#1:800,8\n267#1:809,2\n268#1:811,8\n274#1:820,2\n275#1:822,8\n284#1:831,2\n288#1:833,8\n292#1:842,8\n306#1:851,2\n307#1:853,8\n311#1:862,8\n611#1:871,8\n632#1:880,8\n665#1:889,8\n697#1:898,8\n703#1:907,8\n87#1:798\n261#1:808\n268#1:819\n275#1:830\n288#1:841\n292#1:850\n307#1:861\n311#1:870\n611#1:879\n632#1:888\n665#1:897\n697#1:906\n703#1:915\n*E\n"})
public class LongObjectHashMap<VType>
implements Iterable<LongObjectCursor<VType>>,
Accountable,
Cloneable<LongObjectHashMap<VType>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private long[] keys;
    @Nullable
    private Object[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(LongObjectHashMap.class));

    public LongObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = AtomicsKt.incrementAndFetch((AtomicInteger)HashContainers.INSTANCE.getITERATION_SEED());
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongObjectHashMap(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final long[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable long[] lArray) {
        this.keys = lArray;
    }

    @Nullable
    public final Object[] getValues() {
        return this.values;
    }

    public final void setValues(@Nullable Object[] objectArray) {
        this.values = objectArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public LongObjectHashMap(@NotNull LongObjectHashMap<VType> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this(map2.size(), 0.0, 2, null);
        this.putAll(map2);
    }

    @Nullable
    public final VType put(long key, @Nullable VType value) {
        boolean condition$iv = this.assigned < this.mask + 1;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int mask = this.mask;
        if (key == 0L) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[mask + 1];
            } else {
                object = null;
            }
            Object previousValue = object;
            this.hasEmptyKey = true;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                Object previousValue = this.values[slot];
                Intrinsics.checkNotNull((Object)this.values);
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[slot] = value;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return null;
    }

    public final int putAll(@NotNull Iterable<LongObjectCursor<VType>> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = this.size();
        for (LongObjectCursor<VType> c : iterable) {
            this.put(c.getKey(), c.getValue());
        }
        return this.size() - count;
    }

    public final boolean putIfAbsent(long key, VType value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Nullable
    public final VType remove(long key) {
        int mask = this.mask;
        if (key == 0L) {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            Object previousValue = this.values[mask + 1];
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = 0;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Nullable
    public final VType get(long key) {
        if (key == 0L) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[this.mask + 1];
            } else {
                object = null;
            }
            return (VType)object;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public final VType getOrDefault(long key, VType defaultValue) {
        if (key == 0L) {
            Object object;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                object = this.values[this.mask + 1];
            } else {
                object = defaultValue;
            }
            return object;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public final boolean containsKey(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int indexOf(long key) {
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        boolean condition$iv = index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return index >= 0;
    }

    public final VType indexGet(int index) {
        boolean condition$iv = index >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-LongObjectHashMap$indexGet$22 = false;
            String $i$a$-assert-LongObjectHashMap$indexGet$22 = "The index must point at an existing key.";
            throw new AssertionError((Object)$i$a$-assert-LongObjectHashMap$indexGet$22);
        }
        condition$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)this.values);
        return (VType)this.values[index];
    }

    public final VType indexReplace(int index, VType newValue) {
        boolean condition$iv = index >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-LongObjectHashMap$indexReplace$22 = false;
            String $i$a$-assert-LongObjectHashMap$indexReplace$22 = "The index must point at an existing key.";
            throw new AssertionError((Object)$i$a$-assert-LongObjectHashMap$indexReplace$22);
        }
        condition$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)this.values);
        Object previousValue = this.values[index];
        Intrinsics.checkNotNull((Object)this.values);
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    public final void indexInsert(int index, long key, VType value) {
        int index2 = index;
        boolean condition$iv = index2 < 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-LongObjectHashMap$indexInsert$22 = false;
            String $i$a$-assert-LongObjectHashMap$indexInsert$22 = "The index must not point at an existing key.";
            throw new AssertionError((Object)$i$a$-assert-LongObjectHashMap$indexInsert$22);
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            condition$iv = index2 == this.mask + 1;
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index2] = value;
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            condition$iv = this.keys[index2] == 0L;
            boolean $i$f$assert3 = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
                Intrinsics.checkNotNull((Object)this.values);
                this.values[index2] = value;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    public final VType indexRemove(int index) {
        boolean condition$iv = index >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-LongObjectHashMap$indexRemove$22 = false;
            String $i$a$-assert-LongObjectHashMap$indexRemove$22 = "The index must point at an existing key.";
            throw new AssertionError((Object)$i$a$-assert-LongObjectHashMap$indexRemove$22);
        }
        condition$iv = index <= this.mask || index == this.mask + 1 && this.hasEmptyKey;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        Intrinsics.checkNotNull((Object)this.values);
        Object previousValue = this.values[index];
        if (index > this.mask) {
            boolean condition$iv2 = index == this.mask + 1;
            boolean $i$f$assert3 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return (VType)previousValue;
    }

    public final void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        if (this.keys != null) {
            Intrinsics.checkNotNull((Object)this.keys);
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.keys, 0L);
        }
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongObjectCursor<VType> c : this) {
            h += BitMixer.INSTANCE.mix(c.getKey()) + BitMixer.INSTANCE.mix(c.getValue());
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.equalElements((LongObjectHashMap)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    protected final boolean equalElements(@NotNull LongObjectHashMap<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.size() != this.size()) {
            return false;
        }
        Iterator<LongObjectCursor<?>> iterator2 = other.iterator();
        while (iterator2.hasNext()) {
            LongObjectCursor<?> c;
            LongObjectCursor<?> longObjectCursor = c = iterator2.next();
            Intrinsics.checkNotNull(longObjectCursor);
            long key = longObjectCursor.getKey();
            if (this.containsKey(key) && Intrinsics.areEqual(c.getValue(), this.get(key))) continue;
            return false;
        }
        return true;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            Object[] objectArray = this.values;
            Object[] prevValues = objectArray instanceof Object[] ? objectArray : null;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && prevValues != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    @Override
    @NotNull
    public Iterator<LongObjectCursor<VType>> iterator() {
        return TypeIntrinsics.asMutableIterator((Object)new EntryIterator());
    }

    @Override
    public long ramBytesUsed() {
        long[] lArray = this.keys;
        if (this.keys == null) {
            lArray = new long[]{};
        }
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(lArray) + this.sizeOfValues();
    }

    private final long sizeOfValues() {
        long size2 = RamUsageEstimator.Companion.shallowSizeOf((Object)this.values);
        for (ObjectCursor value : this.values()) {
            size2 += RamUsageEstimator.Companion.sizeOfObject(value);
        }
        return size2;
    }

    @NotNull
    public final KeysContainer keys() {
        return new KeysContainer();
    }

    @NotNull
    public final ValuesContainer values() {
        return new ValuesContainer();
    }

    @Override
    @NotNull
    public LongObjectHashMap<VType> clone() {
        Object[] objectArray;
        LongObjectHashMap<VType> cloned = new LongObjectHashMap<VType>(0, 0.0, 3, null);
        if (this.keys != null) {
            long[] lArray = Arrays.copyOf(this.keys, this.keys.length);
            v1 = lArray;
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
        } else {
            v1 = cloned.keys = null;
        }
        if (this.values != null) {
            Object[] objectArray2 = Arrays.copyOf(this.values, this.values.length);
            objectArray = objectArray2;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
        } else {
            objectArray = null;
        }
        cloned.values = objectArray;
        cloned.mask = this.mask;
        cloned.assigned = this.assigned;
        cloned.resizeAt = this.resizeAt;
        cloned.hasEmptyKey = this.hasEmptyKey;
        cloned.loadFactor = this.loadFactor;
        cloned.iterationSeed = AtomicsKt.incrementAndFetch((AtomicInteger)HashContainers.INSTANCE.getITERATION_SEED());
        return cloned;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.getKey());
            buffer.append("=>");
            buffer.append(cursor.getValue());
            first = false;
        }
        buffer.append("]");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final int hashKey(long key) {
        boolean condition$iv = key != 0L;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    protected final double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull long[] fromKeys, @NotNull VType[] fromValues) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter(fromValues, (String)"fromValues");
        boolean condition$iv = fromKeys.length == fromValues.length && HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        long[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        long existing = 0L;
        int from = fromKeys.length - 1;
        Intrinsics.checkNotNull((Object)keys);
        keys[keys.length - 1] = fromKeys[from];
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            long l;
            long it = l = fromKeys[from];
            boolean bl = false;
            existing = it;
            if (l == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected final void allocateBuffers(int arraySize) {
        boolean condition$iv = IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        long[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            this.values = prevValues;
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, long pendingKey, @Nullable VType pendingValue) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0L && pendingKey != 0L) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        condition$iv = v0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            var8_8 = "assertion failed";
            throw new AssertionError((Object)var8_8);
        }
        prevKeys = this.keys;
        prevValues = this.values;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        condition$iv = v1 > prevKeys.length;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            var10_12 = "assertion failed";
            throw new AssertionError((Object)var10_12);
        }
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        long[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            long existing = keys[slot];
            if (existing == 0L) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            values2[gapSlot2] = values2[slot];
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0L;
        values2[gapSlot2] = null;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    public LongObjectHashMap() {
        this(0, 0.0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;", "VType", "keys", "", "values", "", "([J[Ljava/lang/Object;)Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;", "core"})
    @SourceDebugExtension(value={"SMAP\nLongObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,789:1\n1#2:790\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <VType> LongObjectHashMap<VType> from(@NotNull long[] keys, @NotNull VType[] values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            if (!(keys.length == values2.length)) {
                boolean $i$a$-require-LongObjectHashMap$Companion$from$22 = false;
                String $i$a$-require-LongObjectHashMap$Companion$from$22 = "Arrays of keys and values must have an identical length.";
                throw new IllegalArgumentException($i$a$-require-LongObjectHashMap$Companion$from$22.toString());
            }
            LongObjectHashMap<VType> map2 = new LongObjectHashMap<VType>(keys.length, 0.0, 2, null);
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                map2.put(keys[i], values2[i]);
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$LongObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nLongObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,789:1\n1#2:790\n*E\n"})
    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        @NotNull
        private final LongObjectCursor<VType> cursor = new LongObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected LongObjectCursor<VType> fetch() {
            int mask = LongObjectHashMap.this.getMask();
            while (this.index <= mask) {
                long l;
                long existing = 0L;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                long it = l = lArray[this.slot];
                boolean bl = false;
                existing = it;
                if (l == 0L) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setKey(existing);
                Object[] objectArray = LongObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                this.cursor.setValue(objectArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongObjectHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                this.cursor.setKey(0L);
                Object[] objectArray = LongObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                int n = this.index;
                this.index = n + 1;
                this.cursor.setValue(objectArray[n]);
                return this.cursor;
            }
            return (LongObjectCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$KeysContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "iterator", "", "size", "", "toArray", "", "core"})
    public final class KeysContainer
    implements Iterable<LongCursor>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<LongCursor> iterator() {
            return TypeIntrinsics.asMutableIterator((Object)new KeysIterator());
        }

        public final int size() {
            return LongObjectHashMap.this.size();
        }

        @NotNull
        public final long[] toArray() {
            long[] array = new long[this.size()];
            int i = 0;
            for (LongCursor cursor : this) {
                array[i++] = cursor.getValue();
            }
            return array;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$KeysIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nLongObjectHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongObjectHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$KeysIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,789:1\n1#2:790\n*E\n"})
    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        @NotNull
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = LongObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected LongCursor fetch() {
            int mask = LongObjectHashMap.this.getMask();
            while (this.index <= mask) {
                long l;
                long existing = 0L;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                long it = l = lArray[this.slot];
                boolean bl = false;
                existing = it;
                if (l == 0L) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongObjectHashMap.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0L);
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$LongObjectCursor;", "VType", "", "<init>", "()V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "key", "", "getKey", "()J", "setKey", "(J)V", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "toString", "", "core"})
    public static final class LongObjectCursor<VType> {
        private int index;
        private long key;
        @Nullable
        private VType value;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final long getKey() {
            return this.key;
        }

        public final void setKey(long l) {
            this.key = l;
        }

        @Nullable
        public final VType getValue() {
            return this.value;
        }

        public final void setValue(@Nullable VType VType) {
            this.value = VType;
        }

        @NotNull
        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$ValuesContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/ObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "iterator", "", "size", "", "core"})
    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<ObjectCursor<VType>> iterator() {
            return TypeIntrinsics.asMutableIterator((Object)new ValuesIterator());
        }

        public final int size() {
            return LongObjectHashMap.this.size();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap$ValuesIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/ObjectCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongObjectHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        @NotNull
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongObjectHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected ObjectCursor<VType> fetch() {
            int n;
            int mask = LongObjectHashMap.this.getMask();
            while (this.index <= mask) {
                n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongObjectHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                if (lArray[this.slot] == 0L) continue;
                this.cursor.setIndex(this.slot);
                Object[] objectArray = LongObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                this.cursor.setValue(objectArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongObjectHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                Object[] objectArray = LongObjectHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)objectArray);
                n = this.index;
                this.index = n + 1;
                this.cursor.setValue(objectArray[n]);
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

