/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.vectorization;

import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.vectorization.VectorUtilSupport;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.BitUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0004\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000eH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J(\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0016\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/internal/vectorization/DefaultVectorUtilSupport;", "Lorg/gnit/lucenekmp/internal/vectorization/VectorUtilSupport;", "<init>", "()V", "dotProduct", "", "a", "", "b", "cosine", "v1", "v2", "squareDistance", "", "", "int4DotProduct", "apacked", "", "bpacked", "int4BitDotProduct", "", "int4Quantized", "binaryQuantized", "decodeInt4", "nibble", "getInt4FromPacked", "array", "index", "findNextGEQ", "buffer", "", "target", "from", "to", "core"})
@SourceDebugExtension(value={"SMAP\nDefaultVectorUtilSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVectorUtilSupport.kt\norg/gnit/lucenekmp/internal/vectorization/DefaultVectorUtilSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class DefaultVectorUtilSupport
implements VectorUtilSupport {
    @Override
    public float dotProduct(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$dotProduct$22 = false;
            String $i$a$-require-DefaultVectorUtilSupport$dotProduct$22 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$dotProduct$22.toString());
        }
        float result = 0.0f;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    @Override
    public float cosine(@NotNull float[] v1, @NotNull float[] v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        if (!(v1.length == v2.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$cosine$22 = false;
            String $i$a$-require-DefaultVectorUtilSupport$cosine$22 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$cosine$22.toString());
        }
        float dot = this.dotProduct(v1, v2);
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        int n = v1.length;
        for (int i = 0; i < n; ++i) {
            norm1 += v1[i] * v1[i];
            norm2 += v2[i] * v2[i];
        }
        if (norm1 == 0.0f || norm2 == 0.0f) {
            return 0.0f;
        }
        return dot / (float)(Math.sqrt(norm1) * Math.sqrt(norm2));
    }

    @Override
    public float squareDistance(@NotNull float[] a, @NotNull float[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$squareDistance$22 = false;
            String $i$a$-require-DefaultVectorUtilSupport$squareDistance$22 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$squareDistance$22.toString());
        }
        float sum = 0.0f;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            float diff = a[i] - b[i];
            sum += diff * diff;
        }
        return sum;
    }

    @Override
    public int dotProduct(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$dotProduct$32 = false;
            String $i$a$-require-DefaultVectorUtilSupport$dotProduct$32 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$dotProduct$32.toString());
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    @Override
    public float cosine(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$cosine$32 = false;
            String $i$a$-require-DefaultVectorUtilSupport$cosine$32 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$cosine$32.toString());
        }
        int dot = 0;
        int normA = 0;
        int normB = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            byte aVal = a[i];
            byte bVal = b[i];
            dot += aVal * bVal;
            normA += aVal * aVal;
            normB += bVal * bVal;
        }
        if (normA == 0 || normB == 0) {
            return 0.0f;
        }
        return (float)dot / (float)(Math.sqrt(normA) * Math.sqrt(normB));
    }

    @Override
    public int squareDistance(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (!(a.length == b.length)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$squareDistance$32 = false;
            String $i$a$-require-DefaultVectorUtilSupport$squareDistance$32 = "Vectors must be the same length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$squareDistance$32.toString());
        }
        int sum = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            int diff = a[i] - b[i];
            sum += diff * diff;
        }
        return sum;
    }

    @Override
    public int int4DotProduct(@NotNull byte[] a, boolean apacked, @NotNull byte[] b, boolean bpacked) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int lengthA = apacked ? a.length * 2 : a.length;
        int lengthB = bpacked ? b.length * 2 : b.length;
        if (!(lengthA == lengthB)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$int4DotProduct$22 = false;
            String $i$a$-require-DefaultVectorUtilSupport$int4DotProduct$22 = "Vectors must be the same effective length";
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$int4DotProduct$22.toString());
        }
        int result = 0;
        for (int i = 0; i < lengthA; ++i) {
            int aVal = apacked ? this.getInt4FromPacked(a, i) : this.decodeInt4(a[i] & 0xF);
            int bVal = bpacked ? this.getInt4FromPacked(b, i) : this.decodeInt4(b[i] & 0xF);
            result += aVal * bVal;
        }
        return result;
    }

    @Override
    public long int4BitDotProduct(@NotNull byte[] int4Quantized, @NotNull byte[] binaryQuantized) {
        Intrinsics.checkNotNullParameter((Object)int4Quantized, (String)"int4Quantized");
        Intrinsics.checkNotNullParameter((Object)binaryQuantized, (String)"binaryQuantized");
        if (!(int4Quantized.length == binaryQuantized.length * 4)) {
            boolean $i$a$-require-DefaultVectorUtilSupport$int4BitDotProduct$22 = false;
            String $i$a$-require-DefaultVectorUtilSupport$int4BitDotProduct$22 = "vector dimensions incompatible: " + int4Quantized.length + " != 4 x " + binaryQuantized.length;
            throw new IllegalArgumentException($i$a$-require-DefaultVectorUtilSupport$int4BitDotProduct$22.toString());
        }
        int size2 = binaryQuantized.length;
        long result = 0L;
        for (int i = 0; i < 4; ++i) {
            int r;
            int sub = 0;
            int upperBound = size2 & 0xFFFFFFFC;
            for (r = 0; r < upperBound; r += 4) {
                int qInt = BitUtilKt.getIntLE(int4Quantized, i * size2 + r);
                int dInt = BitUtilKt.getIntLE(binaryQuantized, r);
                sub += IntExtKt.bitCount(IntCompanionObject.INSTANCE, qInt & dInt);
            }
            while (r < size2) {
                sub += IntExtKt.bitCount(IntCompanionObject.INSTANCE, int4Quantized[i * size2 + r] & binaryQuantized[r] & 0xFF);
                ++r;
            }
            result += (long)sub << i;
        }
        return result;
    }

    private final int decodeInt4(int nibble) {
        return nibble >= 8 ? nibble - 16 : nibble;
    }

    private final int getInt4FromPacked(byte[] array, int index) {
        int byteIndex = index / 2;
        if (byteIndex >= array.length) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for a packed array of size " + array.length * 2);
        }
        int nibble = index % 2 == 0 ? array[byteIndex] >>> 4 & 0xF : array[byteIndex] & 0xF;
        return this.decodeInt4(nibble);
    }

    @Override
    public int findNextGEQ(@NotNull int[] buffer, int target, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int low = from;
        int high = to - 1;
        int result = to;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (buffer[mid] >= target) {
                result = mid;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return result;
    }
}

