/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.vectorization;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.IndexInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;)V", "getIn", "()Lorg/gnit/lucenekmp/store/IndexInput;", "splitInts", "", "count", "", "b", "", "bShift", "dec", "bMask", "c", "cIndex", "cMask", "core"})
public final class PostingDecodingUtil {
    @NotNull
    private final IndexInput in;

    public PostingDecodingUtil(@NotNull IndexInput in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.in = in;
    }

    @NotNull
    public final IndexInput getIn() {
        return this.in;
    }

    public final void splitInts(int count, @NotNull int[] b, int bShift, int dec, int bMask, @NotNull int[] c, int cIndex, int cMask) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.in.readInts(c, cIndex, count);
        int maxIter = (bShift - 1) / dec;
        for (int i = 0; i < count; ++i) {
            int j = 0;
            if (j <= maxIter) {
                while (true) {
                    b[count * j + i] = c[cIndex + i] >>> bShift - j * dec & bMask;
                    if (j == maxIter) break;
                    ++j;
                }
            }
            c[cIndex + i] = c[cIndex + i] & cMask;
        }
    }
}

