/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020\u000eH\u0016J\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010#\u001a\u00020\u0011J\b\u0010$\u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedReader;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "in", "sz", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Reader;I)V", "cb", "", "nChars", "nextChar", "markedChar", "readAheadLimit", "skipLF", "", "markedSkipLF", "ensureOpen", "", "fill", "read", "read1", "cbuf", "off", "len", "readLine", "", "ignoreLF", "term", "", "skip", "", "n", "ready", "markSupported", "mark", "reset", "close", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedReader.kt\norg/gnit/lucenekmp/jdkport/BufferedReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,548:1\n1#2:549\n*E\n"})
public class BufferedReader
extends Reader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Reader in;
    @Nullable
    private char[] cb;
    private int nChars;
    private int nextChar;
    private int markedChar;
    private int readAheadLimit;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int DEFAULT_EXPECTED_LINE_LENGTH = 80;

    @JvmOverloads
    public BufferedReader(@NotNull Reader in, int sz) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.markedChar = -1;
        if (!(sz > 0)) {
            boolean bl = false;
            String string = "Buffer size <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.in = in;
        this.cb = new char[sz];
        this.nextChar = this.nChars = 0;
    }

    public /* synthetic */ BufferedReader(Reader reader2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(reader2, n);
    }

    private final void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private final void fill() throws IOException {
        Reader reader2;
        int dst = 0;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                Intrinsics.checkNotNull((Object)this.cb);
                if (this.readAheadLimit <= this.cb.length) {
                    Intrinsics.checkNotNull((Object)this.cb);
                    Intrinsics.checkNotNull((Object)this.cb);
                    System.INSTANCE.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    Intrinsics.checkNotNull((Object)this.cb);
                    System.INSTANCE.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        int n = 0;
        do {
            reader2 = this.in;
            Intrinsics.checkNotNull((Object)reader2);
            Intrinsics.checkNotNull((Object)this.cb);
            Intrinsics.checkNotNull((Object)this.cb);
        } while ((n = reader2.read(this.cb, dst, this.cb.length - dst)) == 0);
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    @Override
    public int read() {
        int n;
        this.ensureOpen();
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            Intrinsics.checkNotNull((Object)this.cb);
            if (this.cb[this.nextChar] != '\n') break;
            n = this.nextChar;
            this.nextChar = n + 1;
        }
        Intrinsics.checkNotNull((Object)this.cb);
        n = this.nextChar;
        this.nextChar = n + 1;
        return this.cb[n];
    }

    private final int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            Intrinsics.checkNotNull((Object)this.cb);
            if (len >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                Reader reader2 = this.in;
                Intrinsics.checkNotNull((Object)reader2);
                return reader2.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            Intrinsics.checkNotNull((Object)this.cb);
            if (this.cb[this.nextChar] == '\n') {
                int n = this.nextChar;
                this.nextChar = n + 1;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        Intrinsics.checkNotNull((Object)this.cb);
        System.INSTANCE.arraycopy(this.cb, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        int n1;
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.ensureOpen();
        Objects.INSTANCE.checkFromIndexSize(off, len, cbuf.length);
        if (len == 0) {
            return 0;
        }
        int n = this.read1(cbuf, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    @Nullable
    public final String readLine(boolean ignoreLF, @Nullable boolean[] term) throws IOException {
        boolean omitLF;
        StringBuilder s = null;
        int startChar = 0;
        this.ensureOpen();
        boolean bl = omitLF = ignoreLF || this.skipLF;
        if (term != null) {
            term[0] = false;
        }
        while (true) {
            Object object;
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return s != null && ((CharSequence)s).length() > 0 ? s.toString() : null;
            }
            boolean eol = false;
            char c = '\u0000';
            if (omitLF) {
                Intrinsics.checkNotNull((Object)this.cb);
                if (this.cb[this.nextChar] == '\n') {
                    int n = this.nextChar;
                    this.nextChar = n + 1;
                }
            }
            this.skipLF = false;
            omitLF = false;
            block4: for (i = this.nextChar; i < this.nChars; ++i) {
                Intrinsics.checkNotNull((Object)this.cb);
                c = this.cb[i];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if (term != null) {
                            term[0] = true;
                        }
                        eol = true;
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str = null;
                if (s == null) {
                    Intrinsics.checkNotNull((Object)this.cb);
                    str = StringExtKt.fromCharArray(StringCompanionObject.INSTANCE, this.cb, startChar, i - startChar);
                } else {
                    object = s;
                    Intrinsics.checkNotNull((Object)this.cb);
                    char[] cArray = this.cb;
                    int n = startChar + (i - startChar);
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append(cArray, startChar, n - startChar), (String)"append(...)");
                    str = s.toString();
                }
                int n = this.nextChar;
                this.nextChar = n + 1;
                if (c == '\r') {
                    this.skipLF = true;
                }
                return str;
            }
            if (s == null) {
                s = new StringBuilder(80);
            }
            StringBuilder stringBuilder = s;
            Intrinsics.checkNotNull((Object)this.cb);
            object = this.cb;
            int n = startChar + (i - startChar);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append((char[])object, startChar, n - startChar), (String)"append(...)");
        }
    }

    @Nullable
    public String readLine() throws IOException {
        return this.readLine(false, null);
    }

    public final long skip(long n) throws IOException {
        long r;
        long d;
        if (!(n >= 0L)) {
            boolean bl = false;
            String string = "skip value is negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureOpen();
        for (r = n; r > 0L; r -= d) {
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) break;
            if (this.skipLF) {
                this.skipLF = false;
                Intrinsics.checkNotNull((Object)this.cb);
                if (this.cb[this.nextChar] == '\n') {
                    int n2 = this.nextChar;
                    this.nextChar = n2 + 1;
                }
            }
            if (r <= (d = (long)(this.nChars - this.nextChar))) {
                this.nextChar += (int)r;
                r = 0L;
                break;
            }
            this.nextChar = this.nChars;
        }
        return n - r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        if (this.skipLF) {
            if (this.nextChar >= this.nChars) {
                Reader reader2 = this.in;
                Intrinsics.checkNotNull((Object)reader2);
                if (reader2.ready()) {
                    this.fill();
                }
            }
            if (this.nextChar < this.nChars) {
                Intrinsics.checkNotNull((Object)this.cb);
                if (this.cb[this.nextChar] == '\n') {
                    int n = this.nextChar;
                    this.nextChar = n + 1;
                }
                this.skipLF = false;
            }
        }
        if (this.nextChar < this.nChars) return true;
        Reader reader3 = this.in;
        Intrinsics.checkNotNull((Object)reader3);
        if (!reader3.ready()) return false;
        return true;
    }

    public final boolean markSupported() {
        return true;
    }

    public final void mark(int readAheadLimit) throws IOException {
        if (!(readAheadLimit >= 0)) {
            boolean bl = false;
            String string = "Read-ahead limit < 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureOpen();
        this.readAheadLimit = readAheadLimit;
        this.markedChar = this.nextChar;
        this.markedSkipLF = this.skipLF;
    }

    public final void reset() throws IOException {
        this.ensureOpen();
        if (this.markedChar < 0) {
            throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.nextChar = this.markedChar;
        this.skipLF = this.markedSkipLF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.in == null) {
            return;
        }
        try {
            Reader reader2 = this.in;
            Intrinsics.checkNotNull((Object)reader2);
            reader2.close();
        }
        finally {
            this.in = null;
            this.cb = null;
        }
    }

    @JvmOverloads
    public BufferedReader(@NotNull Reader in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this(in, 0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedReader$Companion;", "", "<init>", "()V", "INVALIDATED", "", "UNMARKED", "DEFAULT_CHAR_BUFFER_SIZE", "DEFAULT_EXPECTED_LINE_LENGTH", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

