/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.Writer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedWriter;", "Lorg/gnit/lucenekmp/jdkport/Writer;", "out", "initialSize", "", "maxSize", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Writer;II)V", "(Lorg/gnit/lucenekmp/jdkport/Writer;)V", "sz", "(Lorg/gnit/lucenekmp/jdkport/Writer;I)V", "cb", "", "nChars", "nextChar", "maxChars", "ensureOpen", "", "growIfNeeded", "len", "flushBuffer", "write", "c", "min", "a", "b", "cbuf", "off", "s", "", "newLine", "flush", "close", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedWriter.kt\norg/gnit/lucenekmp/jdkport/BufferedWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public class BufferedWriter
extends Writer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Writer out;
    @Nullable
    private char[] cb;
    private int nChars;
    private int nextChar;
    private final int maxChars;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 512;
    private static final int DEFAULT_MAX_BUFFER_SIZE = 8192;

    private BufferedWriter(Writer out, int initialSize, int maxSize) {
        if (!(initialSize > 0)) {
            boolean bl = false;
            String string = "Buffer size <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.out = out;
        this.cb = new char[initialSize];
        this.nChars = initialSize;
        this.maxChars = maxSize;
    }

    public BufferedWriter(@NotNull Writer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, BufferedWriter.Companion.initialBufferSize(), 8192);
    }

    public BufferedWriter(@NotNull Writer out, int sz) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, sz, sz);
    }

    private final void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    private final void growIfNeeded(int len) {
        int neededSize = this.nextChar + len + 1;
        if (neededSize < 0) {
            neededSize = Integer.MAX_VALUE;
        }
        if (neededSize > this.nChars && this.nChars < this.maxChars) {
            int newSize = this.min(neededSize, this.maxChars);
            Intrinsics.checkNotNull((Object)this.cb);
            char[] cArray = Arrays.copyOf(this.cb, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            this.cb = cArray;
            this.nChars = newSize;
        }
    }

    public final void flushBuffer() throws IOException {
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        Writer writer = this.out;
        Intrinsics.checkNotNull((Object)writer);
        Intrinsics.checkNotNull((Object)this.cb);
        writer.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    @Override
    public void write(int c) throws IOException {
        this.ensureOpen();
        this.growIfNeeded(1);
        if (this.nextChar >= this.nChars) {
            this.flushBuffer();
        }
        Intrinsics.checkNotNull((Object)this.cb);
        int n = this.nextChar;
        this.nextChar = n + 1;
        this.cb[n] = (char)c;
    }

    private final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.ensureOpen();
        Objects.INSTANCE.checkFromIndexSize(off, len, cbuf.length);
        if (len == 0) {
            return;
        }
        if (len >= this.maxChars) {
            this.flushBuffer();
            Writer writer = this.out;
            Intrinsics.checkNotNull((Object)writer);
            writer.write(cbuf, off, len);
            return;
        }
        this.growIfNeeded(len);
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            Intrinsics.checkNotNull((Object)this.cb);
            System.INSTANCE.arraycopy(cbuf, b, this.cb, this.nextChar, d);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void write(@NotNull String s, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.ensureOpen();
        this.growIfNeeded(len);
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = this.min(this.nChars - this.nextChar, t - b);
            String string = s;
            Intrinsics.checkNotNull((Object)this.cb);
            char[] cArray = this.cb;
            int n = this.nextChar;
            int n2 = b + d;
            string.getChars(b, n2, cArray, n);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer();
        }
    }

    public final void newLine() throws IOException {
        this.write(System.INSTANCE.lineSeparator());
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        Writer writer = this.out;
        Intrinsics.checkNotNull((Object)writer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.out == null) {
            return;
        }
        try {
            AutoCloseable autoCloseable = this.out;
            Throwable throwable = null;
            try {
                Writer w = (Writer)autoCloseable;
                boolean bl = false;
                this.flushBuffer();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        finally {
            this.out = null;
            this.cb = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedWriter$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_BUFFER_SIZE", "", "DEFAULT_MAX_BUFFER_SIZE", "initialBufferSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int initialBufferSize() {
            return 8192;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

