/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.jdkport.ArraysSupport;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0001J\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/jdkport/ByteArrayOutputStream;", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "size", "", "<init>", "(I)V", "buf", "", "count", "ensureCapacity", "", "minCapacity", "write", "b", "off", "len", "writeBytes", "writeTo", "out", "reset", "toByteArray", "toString", "", "charsetName", "charset", "Lorg/gnit/lucenekmp/jdkport/Charset;", "close", "core"})
public final class ByteArrayOutputStream
extends OutputStream {
    @NotNull
    private byte[] buf;
    private int count;

    public ByteArrayOutputStream(int size2) {
        if (!(size2 >= 0)) {
            boolean bl = false;
            String string = "Negative initial size: " + size2;
            throw new IllegalArgumentException(string.toString());
        }
        this.buf = new byte[size2];
    }

    public /* synthetic */ ByteArrayOutputStream(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        this(n);
    }

    private final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buf.length;
        int minGrowth = minCapacity - oldCapacity;
        if (minGrowth > 0) {
            byte[] byArray = Arrays.copyOf(this.buf, ArraysSupport.INSTANCE.newLength(oldCapacity, minGrowth, oldCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            this.buf = byArray;
        }
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
        this.ensureCapacity(this.count + len);
        System.INSTANCE.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public final void writeBytes(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.write(b, 0, b.length);
    }

    public final void writeTo(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.write(this.buf, 0, this.count);
    }

    public final void reset() {
        this.count = 0;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.buf, this.count);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    public final int size() {
        return this.count;
    }

    @NotNull
    public String toString() {
        return StringExtKt.fromByteArray(StringCompanionObject.INSTANCE, this.buf, StandardCharsets.Companion.getUTF_8());
    }

    @NotNull
    public final String toString(@NotNull String charsetName) {
        Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
        return StringExtKt.fromByteArray(StringCompanionObject.INSTANCE, this.buf, StandardCharsets.Companion.getUTF_8());
    }

    @NotNull
    public final String toString(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return StringExtKt.fromByteArray(StringCompanionObject.INSTANCE, this.buf, charset);
    }

    @Override
    public void close() {
    }

    public ByteArrayOutputStream() {
        this(0, 1, null);
    }
}

