/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ArraysSupport;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CoderMalfunctionError;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.gnit.lucenekmp.jdkport.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\u0005\b&\u0018\u0000 42\u00020\u0001:\u00014B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\rH\u0004J\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\rH\u0004J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020!2\u0006\u0010$\u001a\u00020%J\u0010\u0010(\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0014J\u0006\u0010)\u001a\u00020\u0000J\b\u0010*\u001a\u00020\u0014H\u0014J\u0018\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H$J\u000e\u0010 \u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0002R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "averageBytesPerChar", "", "maxBytesPerChar", "replacement", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;FF[B)V", "charset", "malformedInputAction", "Lorg/gnit/lucenekmp/jdkport/CodingErrorAction;", "unmappableCharacterAction", "state", "", "replaceWith", "newReplacement", "implReplaceWith", "", "cachedDecoder", "Lorg/gnit/lucenekmp/jdkport/WeakReference;", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "isLegalReplacement", "", "repl", "onMalformedInput", "newAction", "implOnMalformedInput", "onUnmappableCharacter", "implOnUnmappableCharacter", "encode", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "in", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "out", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "endOfInput", "flush", "implFlush", "reset", "implReset", "encodeLoop", "canEncode", "cb", "c", "", "", "throwIllegalStateException", "from", "to", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharsetEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsetEncoder.kt\norg/gnit/lucenekmp/jdkport/CharsetEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,908:1\n1#2:909\n*E\n"})
public abstract class CharsetEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    @NotNull
    private byte[] replacement;
    @NotNull
    private CodingErrorAction malformedInputAction;
    @NotNull
    private CodingErrorAction unmappableCharacterAction;
    private int state;
    @Nullable
    private WeakReference<CharsetDecoder> cachedDecoder;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    @NotNull
    private static final String[] stateNames;

    protected CharsetEncoder(@NotNull Charset cs, float averageBytesPerChar, float maxBytesPerChar, @NotNull byte[] replacement) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.malformedInputAction = CodingErrorAction.Companion.getREPORT();
        this.unmappableCharacterAction = CodingErrorAction.Companion.getREPORT();
        this.charset = cs;
        if (!(averageBytesPerChar > 0.0f)) {
            boolean $i$a$-require-CharsetEncoder$42 = false;
            String $i$a$-require-CharsetEncoder$42 = "Non-positive averageBytesPerChar";
            throw new IllegalArgumentException($i$a$-require-CharsetEncoder$42.toString());
        }
        if (!(maxBytesPerChar > 0.0f)) {
            boolean $i$a$-require-CharsetEncoder$52 = false;
            String $i$a$-require-CharsetEncoder$52 = "Non-positive maxBytesPerChar";
            throw new IllegalArgumentException($i$a$-require-CharsetEncoder$52.toString());
        }
        if (!(!(averageBytesPerChar > maxBytesPerChar))) {
            boolean bl = false;
            String string = "averageBytesPerChar exceeds maxBytesPerChar";
            throw new IllegalArgumentException(string.toString());
        }
        this.replacement = replacement;
        this.averageBytesPerChar = averageBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
        this.replaceWith(replacement);
    }

    public /* synthetic */ CharsetEncoder(Charset charset, float f, float f2, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            byte[] byArray2 = new byte[]{63};
            byArray = byArray2;
        }
        this(charset, f, f2, byArray);
    }

    @NotNull
    public final Charset charset() {
        return this.charset;
    }

    @NotNull
    public final byte[] replacement() {
        byte[] byArray = Arrays.copyOf(this.replacement, this.replacement.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @NotNull
    public final CharsetEncoder replaceWith(@NotNull byte[] newReplacement) {
        Intrinsics.checkNotNullParameter((Object)newReplacement, (String)"newReplacement");
        int len = newReplacement.length;
        if (!(len != 0)) {
            boolean $i$a$-require-CharsetEncoder$replaceWith$52 = false;
            String $i$a$-require-CharsetEncoder$replaceWith$52 = "Empty replacement";
            throw new IllegalArgumentException($i$a$-require-CharsetEncoder$replaceWith$52.toString());
        }
        if (!(!((float)len > this.maxBytesPerChar))) {
            boolean $i$a$-require-CharsetEncoder$replaceWith$62 = false;
            String $i$a$-require-CharsetEncoder$replaceWith$62 = "Replacement too long";
            throw new IllegalArgumentException($i$a$-require-CharsetEncoder$replaceWith$62.toString());
        }
        if (!this.isLegalReplacement(newReplacement)) {
            boolean bl = false;
            String string = "Illegal replacement";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] byArray = newReplacement;
        int n = newReplacement.length;
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        this.replacement = byArray2;
        this.implReplaceWith(this.replacement);
        return this;
    }

    protected void implReplaceWith(@NotNull byte[] newReplacement) {
        Intrinsics.checkNotNullParameter((Object)newReplacement, (String)"newReplacement");
    }

    /*
     * Unable to fully structure code
     */
    public boolean isLegalReplacement(@NotNull byte[] repl) {
        Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
        wr = this.cachedDecoder;
        dec = null;
        if (wr == null) ** GOTO lbl-1000
        var4_4 = wr.get();
        it = (CharsetDecoder)var4_4;
        $i$a$-also-CharsetEncoder$isLegalReplacement$1 = false;
        dec = it;
        if (var4_4 == null) lbl-1000:
        // 2 sources

        {
            dec = this.charset().newDecoder();
            dec.onMalformedInput(CodingErrorAction.Companion.getREPORT());
            dec.onUnmappableCharacter(CodingErrorAction.Companion.getREPORT());
            this.cachedDecoder = new WeakReference<CharsetDecoder>(dec);
        } else {
            v0 = dec;
            Intrinsics.checkNotNull((Object)v0);
            v0.reset();
        }
        bb = ByteBuffer.Companion.wrap$default(ByteBuffer.Companion, repl, 0, 0, 6, null);
        cb = CharBuffer.Companion.allocate((int)((float)bb.remaining() * dec.maxCharsPerByte()));
        cr = dec.decode(bb, cb, true);
        return cr.isError() == false;
    }

    @NotNull
    public final CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    @NotNull
    public final CharsetEncoder onMalformedInput(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected final void implOnMalformedInput(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
    }

    @NotNull
    public final CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    @NotNull
    public final CharsetEncoder onUnmappableCharacter(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    protected final void implOnUnmappableCharacter(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @NotNull
    public final CoderResult encode(@NotNull CharBuffer in, @NotNull ByteBuffer out, boolean endOfInput) {
        int newState;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = newState = endOfInput ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            this.throwIllegalStateException(this.state, newState);
        }
        this.state = newState;
        while (true) {
            CoderResult cr = null;
            try {
                cr = this.encodeLoop(in, out);
            }
            catch (RuntimeException x) {
                throw new CoderMalfunctionError(x);
            }
            if (cr.isOverflow()) {
                return cr;
            }
            if (cr.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    cr = CoderResult.Companion.malformedForLength(in.remaining());
                } else {
                    return cr;
                }
            }
            CodingErrorAction action = null;
            CoderResult coderResult = cr;
            Intrinsics.checkNotNull((Object)coderResult);
            if (coderResult.isMalformed()) {
                action = this.malformedInputAction;
            } else if (cr.isUnmappable()) {
                action = this.unmappableCharacterAction;
            } else {
                boolean bl = false;
                String string = cr.toString();
                throw new IllegalArgumentException(string.toString());
            }
            if (action == CodingErrorAction.Companion.getREPORT()) {
                return cr;
            }
            if (action == CodingErrorAction.Companion.getREPLACE()) {
                if (out.remaining() < this.replacement.length) {
                    return CoderResult.Companion.getOVERFLOW();
                }
                ByteBuffer.put$default(out, this.replacement, 0, 0, 6, null);
            }
            if (action != CodingErrorAction.Companion.getIGNORE() && action != CodingErrorAction.Companion.getREPLACE()) break;
            in.setPosition(in.getPosition() + cr.getLength());
        }
        String string = "Failed requirement.";
        throw new IllegalArgumentException(string.toString());
    }

    @NotNull
    public final CoderResult flush(@NotNull ByteBuffer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (this.state == 2) {
            CoderResult cr = this.implFlush(out);
            if (cr.isUnderflow()) {
                this.state = 3;
            }
            return cr;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.Companion.getUNDERFLOW();
    }

    @NotNull
    protected CoderResult implFlush(@NotNull ByteBuffer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return CoderResult.Companion.getUNDERFLOW();
    }

    @NotNull
    public final CharsetEncoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    @NotNull
    protected abstract CoderResult encodeLoop(@NotNull CharBuffer var1, @NotNull ByteBuffer var2);

    @NotNull
    public final ByteBuffer encode(@NotNull CharBuffer in) throws CharacterCodingException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int n = Math.min((int)((float)in.remaining() * this.averageBytesPerChar()), 0x7FFFFFF7);
        ByteBuffer out = ByteBuffer.Companion.allocate(n);
        if (n == 0 && in.remaining() == 0) {
            return out;
        }
        this.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? this.encode(in, out, true) : CoderResult.Companion.getUNDERFLOW();
            if (cr.isUnderflow()) {
                cr = this.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                n = ArraysSupport.INSTANCE.newLength(n, Math.min(n + 1, 1024), n + 1);
                ByteBuffer o = ByteBuffer.Companion.allocate(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        out.flip();
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canEncode(CharBuffer cb) {
        if (this.state == 3) {
            this.reset();
        } else if (this.state != 0) {
            this.throwIllegalStateException(this.state, 1);
        }
        CodingErrorAction ma = this.malformedInputAction();
        CodingErrorAction ua = this.unmappableCharacterAction();
        try {
            this.onMalformedInput(CodingErrorAction.Companion.getREPORT());
            this.onUnmappableCharacter(CodingErrorAction.Companion.getREPORT());
            this.encode(cb);
        }
        catch (CharacterCodingException x) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMalformedInput(ma);
            this.onUnmappableCharacter(ua);
            this.reset();
        }
        return true;
    }

    public boolean canEncode(char c) {
        CharBuffer cb = CharBuffer.Companion.allocate(1);
        cb.put(c);
        cb.flip();
        return this.canEncode(cb);
    }

    public boolean canEncode(@NotNull CharSequence cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        CharBuffer cb = null;
        cb = cs instanceof CharBuffer ? ((CharBuffer)cs).duplicate() : CharBuffer.Companion.wrap$default(CharBuffer.Companion, ((Object)cs).toString(), 0, 0, 6, null);
        return this.canEncode(cb);
    }

    private final void throwIllegalStateException(int from, int to) {
        Intrinsics.checkNotNull((Object)stateNames);
        throw new IllegalStateException("Current state = " + stateNames[from] + ", new state = " + stateNames[to]);
    }

    static {
        String[] stringArray = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};
        stateNames = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharsetEncoder$Companion;", "", "<init>", "()V", "ST_RESET", "", "ST_CODING", "ST_END", "ST_FLUSHED", "stateNames", "", "", "[Ljava/lang/String;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

