/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.AbstractExecutorService;
import org.gnit.lucenekmp.jdkport.BlockingQueue;
import org.gnit.lucenekmp.jdkport.Callable;
import org.gnit.lucenekmp.jdkport.CompletionService;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.jdkport.Future;
import org.gnit.lucenekmp.jdkport.FutureTask;
import org.gnit.lucenekmp.jdkport.LinkedBlockingQueue;
import org.gnit.lucenekmp.jdkport.RunnableFuture;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.jdkport.Void;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001fB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u00a2\u0006\u0004\b\u0005\u0010\nJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J'\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\n\u0010\u000f\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J'\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\n\u0010\u000f\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0096@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tH\u0016J&\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/jdkport/ExecutorCompletionService;", "V", "Lorg/gnit/lucenekmp/jdkport/CompletionService;", "executor", "Lorg/gnit/lucenekmp/jdkport/Executor;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Executor;)V", "completionQueue", "Lorg/gnit/lucenekmp/jdkport/BlockingQueue;", "Lorg/gnit/lucenekmp/jdkport/Future;", "(Lorg/gnit/lucenekmp/jdkport/Executor;Lorg/gnit/lucenekmp/jdkport/BlockingQueue;)V", "aes", "Lorg/gnit/lucenekmp/jdkport/AbstractExecutorService;", "newTaskFor", "Lorg/gnit/lucenekmp/jdkport/RunnableFuture;", "task", "Lorg/gnit/lucenekmp/jdkport/Callable;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "result", "(Ljava/lang/Runnable;Ljava/lang/Object;)Lorg/gnit/lucenekmp/jdkport/RunnableFuture;", "submit", "(Ljava/lang/Runnable;Ljava/lang/Object;)Lorg/gnit/lucenekmp/jdkport/Future;", "take", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "poll", "timeout", "", "unit", "Lorg/gnit/lucenekmp/jdkport/TimeUnit;", "(JLorg/gnit/lucenekmp/jdkport/TimeUnit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "QueueingFuture", "core"})
public final class ExecutorCompletionService<V>
implements CompletionService<V> {
    @NotNull
    private final Executor executor;
    @Nullable
    private final AbstractExecutorService aes;
    @NotNull
    private final BlockingQueue<Future<V>> completionQueue;

    private final RunnableFuture<V> newTaskFor(Callable<V> task) {
        if (this.aes == null) {
            return new FutureTask<V>(task);
        }
        return this.aes.newTaskFor(task);
    }

    private final RunnableFuture<V> newTaskFor(Runnable task, V result) {
        if (this.aes == null) {
            return new FutureTask<V>(task, result);
        }
        return this.aes.newTaskFor(task, result);
    }

    public ExecutorCompletionService(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue(0, 1, null);
    }

    public ExecutorCompletionService(@NotNull Executor executor, @NotNull BlockingQueue<Future<V>> completionQueue) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(completionQueue, (String)"completionQueue");
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = completionQueue;
    }

    @Override
    @NotNull
    public Future<V> submit(@NotNull Callable<V> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        RunnableFuture<V> f = this.newTaskFor(task);
        this.executor.execute(new QueueingFuture<V>(f, this.completionQueue));
        return f;
    }

    @Override
    @NotNull
    public Future<V> submit(@NotNull Runnable task, V result) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        RunnableFuture<V> f = this.newTaskFor(task, result);
        this.executor.execute(new QueueingFuture<V>(f, this.completionQueue));
        return f;
    }

    @Override
    @Nullable
    public Object take(@NotNull Continuation<? super Future<V>> $completion) {
        return this.completionQueue.take($completion);
    }

    @Override
    @Nullable
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    @Nullable
    public Object poll(long timeout, @NotNull TimeUnit unit, @NotNull Continuation<? super Future<V>> $completion) {
        return this.completionQueue.poll(timeout, unit, $completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/ExecutorCompletionService$QueueingFuture;", "V", "Lorg/gnit/lucenekmp/jdkport/FutureTask;", "Lorg/gnit/lucenekmp/jdkport/Void;", "task", "Lorg/gnit/lucenekmp/jdkport/RunnableFuture;", "completionQueue", "Lorg/gnit/lucenekmp/jdkport/BlockingQueue;", "Lorg/gnit/lucenekmp/jdkport/Future;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/RunnableFuture;Lorg/gnit/lucenekmp/jdkport/BlockingQueue;)V", "done", "", "core"})
    private static final class QueueingFuture<V>
    extends FutureTask<Void> {
        @NotNull
        private final Future<V> task;
        @NotNull
        private final BlockingQueue<Future<V>> completionQueue;

        public QueueingFuture(@NotNull RunnableFuture<V> task, @NotNull BlockingQueue<Future<V>> completionQueue) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            Intrinsics.checkNotNullParameter(completionQueue, (String)"completionQueue");
            super(task, null);
            this.task = task;
            this.completionQueue = completionQueue;
        }

        @Override
        protected void done() {
            this.completionQueue.add(this.task);
        }
    }
}

