/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004\u001a\u0012\u0010\u000b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004\u001a\u0012\u0010\u000f\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0001\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\"\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"compare", "", "Lkotlin/Float$Companion;", "f1", "", "f2", "isNaN", "", "v", "isFinite", "f", "isInfinite", "floatToRawIntBits", "value", "floatToIntBits", "intBitsToFloat", "bits", "PRECISION", "getPRECISION", "(Lkotlin/jvm/internal/FloatCompanionObject;)I", "MIN_EXPONENT", "getMIN_EXPONENT", "MAX_EXPONENT", "getMAX_EXPONENT", "SIZE", "getSIZE", "core"})
public final class FloatExtKt {
    public static final int compare(@NotNull FloatCompanionObject $this$compare, float f1, float f2) {
        int anotherBits;
        Intrinsics.checkNotNullParameter((Object)$this$compare, (String)"<this>");
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int thisBits = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f1);
        return thisBits == (anotherBits = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static final boolean isNaN(@NotNull FloatCompanionObject $this$isNaN, float v) {
        Intrinsics.checkNotNullParameter((Object)$this$isNaN, (String)"<this>");
        return !(v == v);
    }

    public static final boolean isFinite(@NotNull FloatCompanionObject $this$isFinite, float f) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinite, (String)"<this>");
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public static final boolean isInfinite(@NotNull FloatCompanionObject $this$isInfinite, float v) {
        Intrinsics.checkNotNullParameter((Object)$this$isInfinite, (String)"<this>");
        return Math.abs(v) > Float.MAX_VALUE;
    }

    public static final int floatToRawIntBits(@NotNull FloatCompanionObject $this$floatToRawIntBits, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$floatToRawIntBits, (String)"<this>");
        return Float.floatToRawIntBits(value);
    }

    public static final int floatToIntBits(@NotNull FloatCompanionObject $this$floatToIntBits, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$floatToIntBits, (String)"<this>");
        return Float.isNaN(value) ? 2143289344 : Float.floatToRawIntBits(value);
    }

    public static final float intBitsToFloat(@NotNull FloatCompanionObject $this$intBitsToFloat, int bits) {
        float f;
        Intrinsics.checkNotNullParameter((Object)$this$intBitsToFloat, (String)"<this>");
        int e = bits >>> 23 & 0xFF;
        int mantissa = bits & 0x7FFFFF;
        int sign = bits >>> 31 == 0 ? 1 : -1;
        switch (e) {
            case 255: {
                if (mantissa == 0) {
                    if (sign > 0) {
                        f = Float.POSITIVE_INFINITY;
                        break;
                    }
                    f = Float.NEGATIVE_INFINITY;
                    break;
                }
                f = Float.NaN;
                break;
            }
            case 0: {
                if (mantissa == 0) {
                    return Float.intBitsToFloat(bits);
                }
                double d = 2.0;
                int n = -149;
                f = (float)((double)sign * (double)mantissa * Math.pow(d, n));
                break;
            }
            default: {
                int mVal = mantissa | 0x800000;
                double d = 2.0;
                double d2 = e - 127 - 23;
                f = (float)((double)(sign * mVal) * Math.pow(d, d2));
            }
        }
        return f;
    }

    public static final int getPRECISION(@NotNull FloatCompanionObject $this$PRECISION) {
        Intrinsics.checkNotNullParameter((Object)$this$PRECISION, (String)"<this>");
        return 24;
    }

    public static final int getMIN_EXPONENT(@NotNull FloatCompanionObject $this$MIN_EXPONENT) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN_EXPONENT, (String)"<this>");
        return 1 - FloatExtKt.getMAX_EXPONENT(FloatCompanionObject.INSTANCE);
    }

    public static final int getMAX_EXPONENT(@NotNull FloatCompanionObject $this$MAX_EXPONENT) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX_EXPONENT, (String)"<this>");
        return (1 << FloatExtKt.getSIZE(FloatCompanionObject.INSTANCE) - FloatExtKt.getPRECISION(FloatCompanionObject.INSTANCE) - 1) - 1;
    }

    public static final int getSIZE(@NotNull FloatCompanionObject $this$SIZE) {
        Intrinsics.checkNotNullParameter((Object)$this$SIZE, (String)"<this>");
        return 32;
    }
}

