/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.InetAddress;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B#\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\nB\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000bJ$\u0010\u0010\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet6Address;", "Lorg/gnit/lucenekmp/jdkport/InetAddress;", "<init>", "()V", "hostName", "", "addr", "", "scope_id", "", "(Ljava/lang/String;[BI)V", "(Ljava/lang/String;[B)V", "holder6", "Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$Inet6AddressHolder;", "getHolder6", "()Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$Inet6AddressHolder;", "initif", "", "nif", "Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;", "getHostAddress", "getAddress", "Companion", "core"})
public final class Inet6Address
extends InetAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Companion.Inet6AddressHolder holder6;
    public static final int INADDRSZ = 16;
    public static final int INT16SZ = 2;

    @NotNull
    public final Companion.Inet6AddressHolder getHolder6() {
        return this.holder6;
    }

    public Inet6Address() {
        this.getHolder().init(null, 2);
        this.holder6 = new Companion.Inet6AddressHolder();
    }

    public Inet6Address(@Nullable String hostName, @NotNull byte[] addr, int scope_id) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        this.getHolder().init(hostName, 2);
        this.holder6 = new Companion.Inet6AddressHolder();
        this.holder6.init(addr, scope_id);
    }

    public Inet6Address(@Nullable String hostName, @NotNull byte[] addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        this.holder6 = new Companion.Inet6AddressHolder();
        try {
            this.initif(hostName, addr, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private final void initif(String hostName, byte[] addr, Companion.NetworkInterface nif) throws UnknownHostException {
        int family = -1;
        this.holder6.init(addr, nif);
        if (addr.length == 16) {
            family = 2;
        }
        this.getHolder().init(hostName, family);
    }

    @Override
    @NotNull
    public String getHostAddress() {
        return this.holder6.getHostAddress();
    }

    @Override
    @NotNull
    public byte[] getAddress() {
        byte[] byArray = this.holder6.getIpaddress();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return byArray2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion;", "", "<init>", "()V", "INADDRSZ", "", "INT16SZ", "numericToTextFormat", "", "src", "", "NetworkInterface", "Inet6AddressHolder", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String numericToTextFormat(@NotNull byte[] src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            StringBuilder sb = new StringBuilder(39);
            for (int i = 0; i < 8; ++i) {
                sb.append(IntExtKt.toHexString(IntCompanionObject.INSTANCE, src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
                if (i >= 7) continue;
                sb.append(":");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B3\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\rJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\b\u0010%\u001a\u0004\u0018\u00010\u000bJ\u0013\u0010*\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010,\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0017\"\u0004\b \u0010\u0019R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010-\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0017R\u0011\u0010.\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0017R\u0011\u0010/\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0017R\u0011\u00100\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0017R\u0011\u00101\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0017R\u0011\u00102\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0017R\u0011\u00103\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0017R\u0011\u00104\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0017R\u0011\u00105\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0017R\u0011\u00106\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0017R\u0011\u00107\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0017\u00a8\u00068"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$Inet6AddressHolder;", "", "<init>", "()V", "ipaddress", "", "scope_id", "", "scope_id_set", "", "ifname", "Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;", "scope_ifname_set", "([BIZLorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;Z)V", "getIpaddress", "()[B", "setIpaddress", "([B)V", "getScope_id", "()I", "setScope_id", "(I)V", "getScope_id_set", "()Z", "setScope_id_set", "(Z)V", "scope_ifname", "getScope_ifname", "()Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;", "setScope_ifname", "(Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;)V", "getScope_ifname_set", "setScope_ifname_set", "setAddr", "", "addr", "init", "nif", "hostAddress", "", "getHostAddress", "()Ljava/lang/String;", "equals", "o", "hashCode", "isIPv4CompatibleAddress", "isMulticastAddress", "isAnyLocalAddress", "isLoopbackAddress", "isLinkLocalAddress", "isSiteLocalAddress", "isMCGlobal", "isMCNodeLocal", "isMCLinkLocal", "isMCSiteLocal", "isMCOrgLocal", "core"})
        public static final class Inet6AddressHolder {
            @NotNull
            private byte[] ipaddress;
            private int scope_id;
            private boolean scope_id_set;
            @Nullable
            private NetworkInterface scope_ifname;
            private boolean scope_ifname_set;

            public Inet6AddressHolder() {
                this.ipaddress = new byte[16];
            }

            public Inet6AddressHolder(@NotNull byte[] ipaddress, int scope_id, boolean scope_id_set, @Nullable NetworkInterface ifname, boolean scope_ifname_set) {
                Intrinsics.checkNotNullParameter((Object)ipaddress, (String)"ipaddress");
                this.ipaddress = ipaddress;
                this.scope_id = scope_id;
                this.scope_id_set = scope_id_set;
                this.scope_ifname_set = scope_ifname_set;
                this.scope_ifname = ifname;
            }

            @NotNull
            public final byte[] getIpaddress() {
                return this.ipaddress;
            }

            public final void setIpaddress(@NotNull byte[] byArray) {
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
                this.ipaddress = byArray;
            }

            public final int getScope_id() {
                return this.scope_id;
            }

            public final void setScope_id(int n) {
                this.scope_id = n;
            }

            public final boolean getScope_id_set() {
                return this.scope_id_set;
            }

            public final void setScope_id_set(boolean bl) {
                this.scope_id_set = bl;
            }

            @Nullable
            public final NetworkInterface getScope_ifname() {
                return this.scope_ifname;
            }

            public final void setScope_ifname(@Nullable NetworkInterface networkInterface) {
                this.scope_ifname = networkInterface;
            }

            public final boolean getScope_ifname_set() {
                return this.scope_ifname_set;
            }

            public final void setScope_ifname_set(boolean bl) {
                this.scope_ifname_set = bl;
            }

            public final void setAddr(@NotNull byte[] addr) {
                Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
                if (addr.length == 16) {
                    System.INSTANCE.arraycopy(addr, 0, this.ipaddress, 0, 16);
                }
            }

            public final void init(@NotNull byte[] addr, int scope_id) {
                Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
                this.setAddr(addr);
                if (scope_id >= 0) {
                    this.scope_id = scope_id;
                    this.scope_id_set = true;
                }
            }

            public final void init(@NotNull byte[] addr, @Nullable NetworkInterface nif) throws UnknownHostException {
                Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
                this.setAddr(addr);
                if (nif != null) {
                    this.scope_id = 0;
                    this.scope_id_set = true;
                    this.scope_ifname = nif;
                    this.scope_ifname_set = true;
                }
            }

            @NotNull
            public final String getHostAddress() {
                Object s = Companion.numericToTextFormat(this.ipaddress);
                if (this.scope_ifname != null) {
                    s = (String)s + "%";
                } else if (this.scope_id_set) {
                    s = (String)s + "%" + this.scope_id;
                }
                return s;
            }

            public boolean equals(@Nullable Object o) {
                if (!(o instanceof Inet6AddressHolder)) {
                    return false;
                }
                return Arrays.equals(this.ipaddress, ((Inet6AddressHolder)o).ipaddress);
            }

            public int hashCode() {
                if (this.ipaddress != null) {
                    int hash = 0;
                    int i = 0;
                    while (i < 16) {
                        int component = 0;
                        for (int j = 0; j < 4 && i < 16; ++j, ++i) {
                            component = (component << 8) + this.ipaddress[i];
                        }
                        hash += component;
                    }
                    return hash;
                }
                return 0;
            }

            public final boolean isIPv4CompatibleAddress() {
                return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
            }

            public final boolean isMulticastAddress() {
                return (this.ipaddress[0] & 0xFF) == 255;
            }

            public final boolean isAnyLocalAddress() {
                byte test = 0;
                for (int i = 0; i < 16; ++i) {
                    test = (byte)(test | this.ipaddress[i]);
                }
                return test == 0;
            }

            public final boolean isLoopbackAddress() {
                byte test = 0;
                for (int i = 0; i < 15; ++i) {
                    test = (byte)(test | this.ipaddress[i]);
                }
                return test == 0 && this.ipaddress[15] == 1;
            }

            public final boolean isLinkLocalAddress() {
                return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
            }

            public final boolean isSiteLocalAddress() {
                return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
            }

            public final boolean isMCGlobal() {
                return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
            }

            public final boolean isMCNodeLocal() {
                return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
            }

            public final boolean isMCLinkLocal() {
                return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
            }

            public final boolean isMCSiteLocal() {
                return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
            }

            public final boolean isMCOrgLocal() {
                return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet6Address$Companion$NetworkInterface;", "", "<init>", "()V", "core"})
        public static final class NetworkInterface {
        }
    }
}

