/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.IPAddressUtil;
import org.gnit.lucenekmp.jdkport.Inet4Address;
import org.gnit.lucenekmp.jdkport.Inet6Address;
import org.gnit.lucenekmp.jdkport.Ported;
import org.gnit.lucenekmp.jdkport.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.net.InetAddress")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/jdkport/InetAddress;", "", "<init>", "()V", "holder", "Lorg/gnit/lucenekmp/jdkport/InetAddress$Companion$InetAddressHolder;", "getHolder", "()Lorg/gnit/lucenekmp/jdkport/InetAddress$Companion$InetAddressHolder;", "getHostAddress", "", "getAddress", "", "hashCode", "", "equals", "", "obj", "toString", "Companion", "core"})
public abstract class InetAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Companion.InetAddressHolder holder = new Companion.InetAddressHolder();
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    @NotNull
    public final Companion.InetAddressHolder getHolder() {
        return this.holder;
    }

    @NotNull
    public abstract String getHostAddress();

    @NotNull
    public abstract byte[] getAddress();

    public int hashCode() {
        return -1;
    }

    public boolean equals(@Nullable Object obj) {
        return false;
    }

    @NotNull
    public String toString() {
        String string = this.holder().getHostName();
        if (string == null) {
            string = "";
        }
        return string + "/" + this.getHostAddress();
    }

    @NotNull
    public final Companion.InetAddressHolder holder() {
        Companion.InetAddressHolder inetAddressHolder = this.holder;
        Intrinsics.checkNotNull((Object)inetAddressHolder);
        return inetAddressHolder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/jdkport/InetAddress$Companion;", "", "<init>", "()V", "IPv4", "", "IPv6", "getByAddress", "Lorg/gnit/lucenekmp/jdkport/InetAddress;", "addr", "", "host", "", "InetAddressHolder", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InetAddress getByAddress(@Nullable byte[] addr) throws UnknownHostException {
            return this.getByAddress(null, addr);
        }

        @NotNull
        public final InetAddress getByAddress(@Nullable String host, @Nullable byte[] addr) throws UnknownHostException {
            String host2 = host;
            if (host2 != null && !(((CharSequence)host2).length() == 0) && host2.charAt(0) == '[' && host2.charAt(host2.length() - 1) == ']') {
                String string = host2.substring(1, host2.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                host2 = string;
            }
            if (addr != null) {
                if (addr.length == 4) {
                    return new Inet4Address(host2, addr);
                }
                if (addr.length == 16) {
                    byte[] newAddr = IPAddressUtil.INSTANCE.convertFromIPv4MappedAddress(addr);
                    if (newAddr != null) {
                        return new Inet4Address(host2, newAddr);
                    }
                    return new Inet6Address(host2, addr);
                }
            }
            throw new UnknownHostException("addr is of illegal length");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\t\b\u0010\u00a2\u0006\u0004\b\u0002\u0010\u0003B#\b\u0010\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/jdkport/InetAddress$Companion$InetAddressHolder;", "", "<init>", "()V", "hostName", "", "address", "", "family", "(Ljava/lang/String;II)V", "originalHostName", "getOriginalHostName", "()Ljava/lang/String;", "setOriginalHostName", "(Ljava/lang/String;)V", "init", "", "getHostName", "setHostName", "getAddress", "()I", "setAddress", "(I)V", "getFamily", "setFamily", "core"})
        public static final class InetAddressHolder {
            @Nullable
            private String originalHostName;
            @Nullable
            private String hostName;
            private int address;
            private int family;

            @Nullable
            public final String getOriginalHostName() {
                return this.originalHostName;
            }

            public final void setOriginalHostName(@Nullable String string) {
                this.originalHostName = string;
            }

            public InetAddressHolder() {
            }

            public InetAddressHolder(@Nullable String hostName, int address, int family) {
                this.originalHostName = hostName;
                this.hostName = hostName;
                this.address = address;
                this.family = family;
            }

            public final void init(@Nullable String hostName, int family) {
                this.originalHostName = hostName;
                this.hostName = hostName;
                if (family != -1) {
                    this.family = family;
                }
            }

            @Nullable
            public final String getHostName() {
                return this.hostName;
            }

            public final void setHostName(@Nullable String string) {
                this.hostName = string;
            }

            public final int getAddress() {
                return this.address;
            }

            public final void setAddress(int n) {
                this.address = n;
            }

            public final int getFamily() {
                return this.family;
            }

            public final void setFamily(int n) {
                this.family = n;
            }
        }
    }
}

