/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import org.gnit.lucenekmp.jdkport.BufferExtKt;
import org.gnit.lucenekmp.jdkport.BufferOverflowException;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 12\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0005J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0000J\u0011\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010,\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u0005H\u0016J\b\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/jdkport/IntBuffer;", "", "buffer", "Lokio/Buffer;", "capacity", "", "baseOffset", "", "<init>", "(Lokio/Buffer;IJ)V", "getCapacity", "()I", "position", "getPosition", "setPosition", "(I)V", "limit", "getLimit", "setLimit", "order", "Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "getOrder", "()Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "setOrder", "(Lorg/gnit/lucenekmp/jdkport/ByteOrder;)V", "remaining", "hasRemaining", "", "clear", "flip", "duplicate", "get", "index", "newPosition", "newLimit", "put", "value", "dst", "", "offset", "length", "slice", "compareTo", "other", "equals", "", "hashCode", "toString", "", "Companion", "core"})
public final class IntBuffer
implements Comparable<IntBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Buffer buffer;
    private final int capacity;
    private final long baseOffset;
    private int position;
    private int limit;
    @NotNull
    private ByteOrder order;

    public IntBuffer(@NotNull Buffer buffer, int capacity, long baseOffset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.capacity = capacity;
        this.baseOffset = baseOffset;
        this.limit = this.capacity;
        this.order = ByteOrder.Companion.nativeOrder();
    }

    public /* synthetic */ IntBuffer(Buffer buffer, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = 0L;
        }
        this(buffer, n, l);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @NotNull
    public final ByteOrder getOrder() {
        return this.order;
    }

    public final void setOrder(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"<set-?>");
        this.order = byteOrder;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @NotNull
    public final IntBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    @NotNull
    public final IntBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    @NotNull
    public final IntBuffer duplicate() {
        Buffer newBuffer = this.buffer.copy();
        IntBuffer dup = new IntBuffer(newBuffer, this.capacity, 0L, 4, null);
        dup.position = this.position;
        dup.limit = this.limit;
        dup.order = this.order;
        return dup;
    }

    public final int get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException("No more ints to read");
        }
        int result = this.get(this.position);
        int n = this.position;
        this.position = n + 1;
        return result;
    }

    public final int get(int index) {
        int result;
        block4: {
            ByteOrder byteOrder;
            long byteOffset;
            block3: {
                if (index < 0 || index >= this.limit) {
                    throw new IndexOutOfBoundsException("Index " + index + " out of bounds (limit: " + this.limit + ")");
                }
                byteOffset = this.baseOffset + (long)index * 4L;
                result = 0;
                byteOrder = this.order;
                if (!Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) break block3;
                for (int i = 0; i < 4; ++i) {
                    result = result << 8 | this.buffer.getByte(byteOffset + (long)i) & 0xFF;
                }
                break block4;
            }
            if (!Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) break block4;
            for (int i = 0; i < 4; ++i) {
                result |= (this.buffer.getByte(byteOffset + (long)i) & 0xFF) << i * 8;
            }
        }
        return result;
    }

    @NotNull
    public final IntBuffer position(int newPosition) {
        this.position = newPosition;
        return this;
    }

    @NotNull
    public final IntBuffer limit(int newLimit) {
        this.limit = newLimit;
        return this;
    }

    @NotNull
    public final IntBuffer put(int value) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException("No space to write");
        }
        this.put(this.position, value);
        int n = this.position;
        this.position = n + 1;
        return this;
    }

    @NotNull
    public final IntBuffer get(@NotNull int[] dst, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (offset < 0 || length < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", array size: " + dst.length);
        }
        int pos = this.position;
        if (length > this.limit - pos) {
            throw new BufferUnderflowException("Not enough ints remaining: requested " + length + ", available " + (this.limit - pos));
        }
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.get(pos + i);
        }
        this.position = pos + length;
        return this;
    }

    @NotNull
    public final IntBuffer get(@NotNull int[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return this.get(dst, 0, dst.length);
    }

    @NotNull
    public final IntBuffer put(int index, int value) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds (limit: " + this.limit + ")");
        }
        long byteOffset = this.baseOffset + (long)index * 4L;
        ByteOrder byteOrder = this.order;
        if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
            BufferExtKt.setByteAt(this.buffer, byteOffset, (byte)(value >> 24));
            BufferExtKt.setByteAt(this.buffer, byteOffset + 1L, (byte)(value >> 16));
            BufferExtKt.setByteAt(this.buffer, byteOffset + (long)2, (byte)(value >> 8));
            BufferExtKt.setByteAt(this.buffer, byteOffset + (long)3, (byte)value);
        } else if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) {
            BufferExtKt.setByteAt(this.buffer, byteOffset, (byte)value);
            BufferExtKt.setByteAt(this.buffer, byteOffset + 1L, (byte)(value >> 8));
            BufferExtKt.setByteAt(this.buffer, byteOffset + (long)2, (byte)(value >> 16));
            BufferExtKt.setByteAt(this.buffer, byteOffset + (long)3, (byte)(value >> 24));
        }
        return this;
    }

    @NotNull
    public final IntBuffer slice() {
        IntBuffer intBuffer;
        int remainingInts = this.remaining();
        long newBaseOffset = this.baseOffset + (long)this.position * 4L;
        IntBuffer it = intBuffer = new IntBuffer(this.buffer, remainingInts, newBaseOffset).clear();
        boolean bl = false;
        it.order = this.order;
        return intBuffer;
    }

    @Override
    public int compareTo(@NotNull IntBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = Math.min(this.remaining(), other.remaining());
        for (int i = 0; i < n; ++i) {
            int cmp = Intrinsics.compare((int)this.get(this.position + i), (int)other.get(other.position + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.remaining() - other.remaining();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntBuffer)) {
            return false;
        }
        if (this.remaining() != ((IntBuffer)other).remaining()) {
            return false;
        }
        int thisPos = this.position;
        int otherPos = ((IntBuffer)other).position;
        int n = this.remaining();
        for (int i = 0; i < n; ++i) {
            if (this.get(thisPos + i) == ((IntBuffer)other).get(otherPos + i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int pos = this.position;
        int n = this.remaining();
        for (int i = 0; i < n; ++i) {
            result = 31 * result + Integer.hashCode(this.get(pos + i));
        }
        return result;
    }

    @NotNull
    public String toString() {
        return "IntBuffer(pos=" + this.position + ", lim=" + this.limit + ", cap=" + this.capacity + ", order=" + this.order + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/jdkport/IntBuffer$Companion;", "", "<init>", "()V", "allocate", "Lorg/gnit/lucenekmp/jdkport/IntBuffer;", "capacity", "", "wrap", "array", "", "core"})
    @SourceDebugExtension(value={"SMAP\nIntBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntBuffer.kt\norg/gnit/lucenekmp/jdkport/IntBuffer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntBuffer allocate(int capacity) {
            Buffer buffer;
            if (!(capacity >= 0)) {
                boolean $i$a$-require-IntBuffer$Companion$allocate$22 = false;
                String $i$a$-require-IntBuffer$Companion$allocate$22 = "Capacity must be non-negative";
                throw new IllegalArgumentException($i$a$-require-IntBuffer$Companion$allocate$22.toString());
            }
            byte[] byteArray = new byte[capacity * 4];
            Buffer $this$allocate_u24lambda_u241 = buffer = new Buffer();
            boolean bl = false;
            $this$allocate_u24lambda_u241.write(byteArray, 0, byteArray.length);
            Buffer buf = buffer;
            return new IntBuffer(buf, capacity, 0L, 4, null).clear();
        }

        @NotNull
        public final IntBuffer wrap(@NotNull int[] array) {
            Buffer buffer;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            byte[] byteArray = new byte[array.length * 4];
            ByteOrder nativeOrder = ByteOrder.Companion.nativeOrder();
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                int offset = i * 4;
                int value = array[i];
                ByteOrder byteOrder = nativeOrder;
                if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
                    byteArray[offset] = (byte)(value >> 24);
                    byteArray[offset + 1] = (byte)(value >> 16);
                    byteArray[offset + 2] = (byte)(value >> 8);
                    byteArray[offset + 3] = (byte)value;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) continue;
                byteArray[offset] = (byte)value;
                byteArray[offset + 1] = (byte)(value >> 8);
                byteArray[offset + 2] = (byte)(value >> 16);
                byteArray[offset + 3] = (byte)(value >> 24);
            }
            Buffer $this$wrap_u24lambda_u242 = buffer = new Buffer();
            boolean bl = false;
            $this$wrap_u24lambda_u242.write(byteArray, 0, byteArray.length);
            Buffer buf = buffer;
            return new IntBuffer(buf, array.length, 0L, 4, null).clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

