/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.StringLatin1;
import org.gnit.lucenekmp.jdkport.StringUTF16;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u000e\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0001\u001a(\u0010\u0018\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001d\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u001a\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010#\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\u0012\u0010$\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010%\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"rotateLeft", "", "Lkotlin/Int$Companion;", "i", "distance", "COMPACT_STRINGS", "", "toBinaryString", "", "toUnsignedString0", "value", "shift", "digits", "", "toStringWithRadix", "radix", "toStringUTF16", "formatUnsignedInt", "", "buf", "len", "toUnsignedLong", "", "x", "formatUnsignedIntUTF16", "NoLeadingZeroHexFormat", "Lkotlin/text/HexFormat;", "getNoLeadingZeroHexFormat$annotations", "()V", "toHexString", "numberOfLeadingZeros", "numberOfTrailingZeros", "bitCount", "compare", "y", "signum", "reverseBytes", "highestOneBit", "core"})
public final class IntExtKt {
    public static final boolean COMPACT_STRINGS = true;
    @NotNull
    private static final char[] digits;
    @NotNull
    private static final HexFormat NoLeadingZeroHexFormat;

    public static final int rotateLeft(@NotNull IntCompanionObject $this$rotateLeft, int i, int distance) {
        Intrinsics.checkNotNullParameter((Object)$this$rotateLeft, (String)"<this>");
        return i << distance | i >>> -distance;
    }

    @NotNull
    public static final String toBinaryString(@NotNull IntCompanionObject $this$toBinaryString, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryString, (String)"<this>");
        return IntExtKt.toUnsignedString0(i, 1);
    }

    private static final String toUnsignedString0(int value, int shift) {
        int mag = 32 - Integer.numberOfLeadingZeros(value);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        char[] buf = new char[chars];
        IntExtKt.formatUnsignedInt(value, shift, buf, chars);
        return StringsKt.concatToString((char[])buf);
    }

    @NotNull
    public static final String toStringWithRadix(@NotNull IntCompanionObject $this$toStringWithRadix, int i, int radix) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringWithRadix, (String)"<this>");
        int radixInUse = radix;
        int intInUse = i;
        if (radix < 2 || radix > 36) {
            radixInUse = 10;
        }
        if (i == 10) {
            return String.valueOf(i);
        }
        byte[] buf = new byte[33];
        boolean negative = intInUse < 0;
        int charPos = 32;
        if (!negative) {
            intInUse = -intInUse;
        }
        while (intInUse <= -radixInUse) {
            buf[charPos--] = (byte)IntExtKt.digits(IntCompanionObject.INSTANCE)[-(intInUse % radixInUse)];
            intInUse /= radixInUse;
        }
        buf[charPos] = (byte)IntExtKt.digits(IntCompanionObject.INSTANCE)[-i];
        if (negative) {
            buf[--charPos] = 45;
        }
        return StringLatin1.INSTANCE.newString(buf, charPos, 33 - charPos);
    }

    @NotNull
    public static final String toStringUTF16(@NotNull IntCompanionObject $this$toStringUTF16, int i, int radix) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringUTF16, (String)"<this>");
        int intInUse = i;
        byte[] buf = new byte[66];
        boolean negative = intInUse < 0;
        int charPos = 32;
        if (!negative) {
            intInUse = -intInUse;
        }
        while (intInUse <= -radix) {
            StringUTF16.INSTANCE.putChar(buf, charPos--, IntExtKt.digits(IntCompanionObject.INSTANCE)[-(intInUse % radix)]);
            intInUse /= radix;
        }
        StringUTF16.INSTANCE.putChar(buf, charPos, IntExtKt.digits(IntCompanionObject.INSTANCE)[-intInUse]);
        if (negative) {
            StringUTF16.INSTANCE.putChar(buf, --charPos, 45);
        }
        return StringUTF16.INSTANCE.newString(buf, charPos, 33 - charPos);
    }

    private static final void formatUnsignedInt(int value, int shift, char[] buf, int len) {
        int v = value;
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[v & mask];
            v >>>= shift;
        } while (charPos > 0);
    }

    public static final long toUnsignedLong(@NotNull IntCompanionObject $this$toUnsignedLong, int x) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnsignedLong, (String)"<this>");
        return (long)x & 0xFFFFFFFFL;
    }

    private static final void formatUnsignedIntUTF16(int value, int shift, char[] buf, int len) {
        int v = value;
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[v & mask];
            v >>>= shift;
        } while (charPos > 0);
    }

    private static /* synthetic */ void getNoLeadingZeroHexFormat$annotations() {
    }

    @NotNull
    public static final String toHexString(@NotNull IntCompanionObject $this$toHexString, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        return HexExtensionsKt.toHexString((int)i, (HexFormat)NoLeadingZeroHexFormat);
    }

    public static final int numberOfLeadingZeros(@NotNull IntCompanionObject $this$numberOfLeadingZeros, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$numberOfLeadingZeros, (String)"<this>");
        int i2 = i;
        if (i2 <= 0) {
            return i2 == 0 ? 32 : 0;
        }
        int n = 31;
        if (i2 >= 65536) {
            n -= 16;
            i2 >>>= 16;
        }
        if (i2 >= 256) {
            n -= 8;
            i2 >>>= 8;
        }
        if (i2 >= 16) {
            n -= 4;
            i2 >>>= 4;
        }
        if (i2 >= 4) {
            n -= 2;
            i2 >>>= 2;
        }
        return n - (i2 >>> 1);
    }

    public static final int numberOfTrailingZeros(@NotNull IntCompanionObject $this$numberOfTrailingZeros, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$numberOfTrailingZeros, (String)"<this>");
        int i2 = i;
        i2 = ~i2 & i2 - 1;
        if (i2 <= 0) {
            return i2 & 0x20;
        }
        int n = 1;
        if (i2 > 65536) {
            n += 16;
            i2 >>>= 16;
        }
        if (i2 > 256) {
            n += 8;
            i2 >>>= 8;
        }
        if (i2 > 16) {
            n += 4;
            i2 >>>= 4;
        }
        if (i2 > 4) {
            n += 2;
            i2 >>>= 2;
        }
        return n + (i2 >>> 1);
    }

    public static final int bitCount(@NotNull IntCompanionObject $this$bitCount, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$bitCount, (String)"<this>");
        int x = i;
        x -= x >>> 1 & 0x55555555;
        x = (x & 0x33333333) + (x >>> 2 & 0x33333333);
        x = x + (x >>> 4) & 0xF0F0F0F;
        x += x >>> 8;
        x += x >>> 16;
        return x & 0x3F;
    }

    public static final int compare(@NotNull IntCompanionObject $this$compare, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$compare, (String)"<this>");
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static final int signum(@NotNull IntCompanionObject $this$signum, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$signum, (String)"<this>");
        return i >> 31 | -i >>> 31;
    }

    @NotNull
    public static final char[] digits(@NotNull IntCompanionObject $this$digits) {
        Intrinsics.checkNotNullParameter((Object)$this$digits, (String)"<this>");
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        return cArray;
    }

    public static final int reverseBytes(@NotNull IntCompanionObject $this$reverseBytes, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$reverseBytes, (String)"<this>");
        return i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
    }

    public static final int highestOneBit(@NotNull IntCompanionObject $this$highestOneBit, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$highestOneBit, (String)"<this>");
        return i & Integer.MIN_VALUE >>> IntExtKt.numberOfLeadingZeros($this$highestOneBit, i);
    }

    static {
        HexFormat.Builder builder;
        char[] cArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        digits = cArray;
        HexFormat.Builder $this$NoLeadingZeroHexFormat_u24lambda_u241 = builder = new HexFormat.Builder();
        boolean bl = false;
        HexFormat.NumberHexFormat.Builder $this$NoLeadingZeroHexFormat_u24lambda_u241_u24lambda_u240 = $this$NoLeadingZeroHexFormat_u24lambda_u241.getNumber();
        boolean bl2 = false;
        $this$NoLeadingZeroHexFormat_u24lambda_u241_u24lambda_u240.setRemoveLeadingZeros(true);
        NoLeadingZeroHexFormat = builder.build();
    }
}

