/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.BufferedWriter;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.FilterOutputStream;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.OutputStreamWriter;
import org.gnit.lucenekmp.jdkport.Ported;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.io.PrintStream")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/jdkport/PrintStream;", "Lorg/gnit/lucenekmp/jdkport/FilterOutputStream;", "autoFlush", "", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "<init>", "(ZLorg/gnit/lucenekmp/jdkport/OutputStream;)V", "charset", "Lorg/gnit/lucenekmp/jdkport/Charset;", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;ZLorg/gnit/lucenekmp/jdkport/Charset;)V", "trouble", "textOut", "Lorg/gnit/lucenekmp/jdkport/BufferedWriter;", "charOut", "Lorg/gnit/lucenekmp/jdkport/OutputStreamWriter;", "print", "", "x", "", "println", "writeln", "s", "newLine", "ensureOpen", "flush", "closing", "close", "core"})
public class PrintStream
extends FilterOutputStream {
    private final boolean autoFlush;
    private boolean trouble;
    @NotNull
    private Charset charset;
    @Nullable
    private BufferedWriter textOut;
    @Nullable
    private OutputStreamWriter charOut;
    private boolean closing;

    public PrintStream(boolean autoFlush, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super(out);
        this.autoFlush = autoFlush;
        this.charset = out instanceof PrintStream ? ((PrintStream)out).charset : Charset.Companion.defaultCharset();
        OutputStreamWriter outputStreamWriter = this.charOut = new OutputStreamWriter((OutputStream)this, this.charset);
        Intrinsics.checkNotNull((Object)outputStreamWriter);
        this.textOut = new BufferedWriter(outputStreamWriter);
    }

    public /* synthetic */ PrintStream(boolean bl, OutputStream outputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, outputStream);
    }

    public PrintStream(@NotNull OutputStream out, boolean autoFlush, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this(autoFlush, out);
        OutputStreamWriter outputStreamWriter = this.charOut = new OutputStreamWriter((OutputStream)this, charset);
        Intrinsics.checkNotNull((Object)outputStreamWriter);
        this.textOut = new BufferedWriter(outputStreamWriter);
        this.charset = charset;
    }

    public void print(@Nullable String x) {
        System.out.print((Object)x);
    }

    public void println(@Nullable String x) {
        if (this.getClass() == PrintStream.class) {
            this.writeln(String.valueOf(x));
        } else {
            System.out.print((Object)x);
            this.newLine();
        }
    }

    public void println() {
        this.newLine();
    }

    private final void writeln(String s) {
        try {
            this.ensureOpen();
            BufferedWriter bufferedWriter = this.textOut;
            Intrinsics.checkNotNull((Object)bufferedWriter);
            bufferedWriter.write(s);
            BufferedWriter bufferedWriter2 = this.textOut;
            Intrinsics.checkNotNull((Object)bufferedWriter2);
            bufferedWriter2.newLine();
            BufferedWriter bufferedWriter3 = this.textOut;
            Intrinsics.checkNotNull((Object)bufferedWriter3);
            bufferedWriter3.flushBuffer();
            OutputStreamWriter outputStreamWriter = this.charOut;
            Intrinsics.checkNotNull((Object)outputStreamWriter);
            outputStreamWriter.flushBuffer();
            if (this.autoFlush) {
                OutputStream outputStream = this.getOut();
                Intrinsics.checkNotNull((Object)outputStream);
                outputStream.flush();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private final void newLine() {
        try {
            this.ensureOpen();
            BufferedWriter bufferedWriter = this.textOut;
            Intrinsics.checkNotNull((Object)bufferedWriter);
            bufferedWriter.newLine();
            BufferedWriter bufferedWriter2 = this.textOut;
            Intrinsics.checkNotNull((Object)bufferedWriter2);
            bufferedWriter2.flushBuffer();
            OutputStreamWriter outputStreamWriter = this.charOut;
            Intrinsics.checkNotNull((Object)outputStreamWriter);
            outputStreamWriter.flushBuffer();
            if (this.autoFlush) {
                OutputStream outputStream = this.getOut();
                Intrinsics.checkNotNull((Object)outputStream);
                outputStream.flush();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private final void ensureOpen() throws IOException {
        if (this.getOut() == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flush() {
        try {
            this.ensureOpen();
            OutputStream outputStream = this.getOut();
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void close() {
        if (!this.closing) {
            this.closing = true;
            try {
                BufferedWriter bufferedWriter = this.textOut;
                Intrinsics.checkNotNull((Object)bufferedWriter);
                bufferedWriter.close();
                OutputStream outputStream = this.getOut();
                Intrinsics.checkNotNull((Object)outputStream);
                outputStream.close();
            }
            catch (IOException x) {
                this.trouble = true;
            }
            this.textOut = null;
            this.charOut = null;
            this.setOut(null);
        }
    }
}

