/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u001eB1\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u001c\b\u0002\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004J\u0015\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\u0002\u0010\u001dR\"\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/jdkport/PriorityQueue;", "E", "", "initialCapacity", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(ILjava/util/Comparator;)V", "heap", "", "modCount", "isEmpty", "", "size", "offer", "element", "(Ljava/lang/Object;)Z", "poll", "()Ljava/lang/Object;", "peek", "siftUp", "", "index", "(ILjava/lang/Object;)V", "siftDown", "toTypedArray", "", "()[Ljava/lang/Object;", "Companion", "core"})
public final class PriorityQueue<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Comparator<? super E> comparator;
    @NotNull
    private final List<E> heap;
    private int modCount;
    public static final int DEFAULT_INITIAL_CAPACITY = 11;

    public PriorityQueue(int initialCapacity, @NotNull Comparator<? super E> comparator2) {
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        if (!(initialCapacity >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.heap = new ArrayList(initialCapacity);
        this.comparator = comparator2;
    }

    public /* synthetic */ PriorityQueue(int n, Comparator comparator2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 11;
        }
        if ((n2 & 2) != 0) {
            comparator2 = PriorityQueue::_init_$lambda$0;
        }
        this(n, comparator2);
    }

    public final boolean isEmpty() {
        return this.heap.isEmpty();
    }

    public final int size() {
        return this.heap.size();
    }

    public final boolean offer(@Nullable E element) {
        if (element == null) {
            throw new NullPointerException("Element must not be null");
        }
        int n = this.modCount;
        this.modCount = n + 1;
        this.heap.add(element);
        this.siftUp(CollectionsKt.getLastIndex(this.heap), element);
        return true;
    }

    @Nullable
    public final E poll() {
        if (this.heap.isEmpty()) {
            return null;
        }
        int n = this.modCount;
        this.modCount = n + 1;
        E result = this.heap.get(0);
        E last = this.heap.remove(CollectionsKt.getLastIndex(this.heap));
        if (!((Collection)this.heap).isEmpty()) {
            this.heap.set(0, last);
            this.siftDown(0);
        }
        return result;
    }

    @Nullable
    public final E peek() {
        return (E)CollectionsKt.firstOrNull(this.heap);
    }

    private final void siftUp(int index, E element) {
        int parent;
        int child = index;
        E e = element;
        while (child > 0 && this.comparator.compare(e, this.heap.get(parent = (child - 1) / 2)) < 0) {
            this.heap.set(child, this.heap.get(parent));
            child = parent;
        }
        this.heap.set(child, e);
    }

    private final void siftDown(int index) {
        int parent = index;
        int size2 = this.heap.size();
        E e = this.heap.get(parent);
        while (true) {
            int left = 2 * parent + 1;
            int right = left + 1;
            int candidate = parent;
            if (left < size2 && this.comparator.compare(this.heap.get(left), this.heap.get(candidate)) < 0) {
                candidate = left;
            }
            if (right < size2 && this.comparator.compare(this.heap.get(right), this.heap.get(candidate)) < 0) {
                candidate = right;
            }
            if (candidate == parent) break;
            this.heap.set(parent, this.heap.get(candidate));
            parent = candidate;
        }
        this.heap.set(parent, e);
    }

    @NotNull
    public final E[] toTypedArray() {
        int size2 = this.heap.size();
        int n = 0;
        Object[] objectArray = new Object[size2];
        while (n < size2) {
            int n2 = n++;
            objectArray[n2] = null;
        }
        Object[] result = objectArray;
        for (int i = 0; i < size2; ++i) {
            result[i] = this.heap.get(i);
        }
        return result;
    }

    private static final int _init_$lambda$0(Object a, Object b) {
        Intrinsics.checkNotNull((Object)a, (String)"null cannot be cast to non-null type kotlin.Comparable<E of org.gnit.lucenekmp.jdkport.PriorityQueue>");
        Comparable comparable = (Comparable)a;
        Intrinsics.checkNotNull((Object)b);
        return comparable.compareTo(b);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/jdkport/PriorityQueue$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_CAPACITY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

