/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Ported;
import org.gnit.lucenekmp.jdkport.Readable;
import org.gnit.lucenekmp.jdkport.Writer;
import org.jetbrains.annotations.NotNull;

@Ported(from="java.io.Reader")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u0000 \u00162\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H&J\b\u0010\f\u001a\u00020\rH&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/jdkport/Reader;", "Lorg/gnit/lucenekmp/jdkport/Readable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "read", "", "cbuf", "", "off", "len", "close", "", "transferTo", "", "out", "Lorg/gnit/lucenekmp/jdkport/Writer;", "target", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "ready", "", "Companion", "core"})
public abstract class Reader
implements Readable,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected static final int TRANSFER_BUFFER_SIZE = 8192;

    public abstract int read(@NotNull char[] var1, int var2, int var3);

    @Override
    public abstract void close();

    public int read() {
        char[] buf = new char[1];
        int n = this.read(buf, 0, 1);
        return n == -1 ? -1 : buf[0];
    }

    public long transferTo(@NotNull Writer out) {
        int nRead;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        long transferred = 0L;
        char[] buffer = new char[8192];
        while ((nRead = this.read(buffer, 0, 8192)) != -1) {
            out.write(buffer, 0, nRead);
            transferred += (long)nRead;
        }
        return transferred;
    }

    @Override
    public int read(@NotNull CharBuffer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target.isReadOnly()) {
            throw new Exception("Read-only buffer");
        }
        int remaining = target.remaining();
        if (remaining == 0) {
            return 0;
        }
        char[] temp = new char[remaining];
        int nRead = this.read(temp, 0, remaining);
        if (nRead > 0) {
            target.put(temp, 0, nRead);
        }
        return nRead;
    }

    public boolean ready() throws IOException {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/Reader$Companion;", "", "<init>", "()V", "TRANSFER_BUFFER_SIZE", "", "nullReader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Reader nullReader() {
            return new Reader(){
                private boolean closed;

                private final void ensureOpen() {
                    if (this.closed) {
                        throw new Exception("Stream closed");
                    }
                }

                public int read(char[] cbuf, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                    this.ensureOpen();
                    if (len == 0) {
                        return 0;
                    }
                    return -1;
                }

                public void close() {
                    this.closed = true;
                }

                public boolean ready() {
                    this.ensureOpen();
                    return false;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

