/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Spliterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/jdkport/Spliterators;", "", "<init>", "()V", "spliterator", "Lorg/gnit/lucenekmp/jdkport/Spliterator;", "T", "array", "", "fromIndex", "", "toIndex", "additionalCharacteristics", "([Ljava/lang/Object;III)Lorg/gnit/lucenekmp/jdkport/Spliterator;", "ArraySpliterator", "IteratorSpliterator", "core"})
public final class Spliterators {
    @NotNull
    public static final Spliterators INSTANCE = new Spliterators();

    private Spliterators() {
    }

    @NotNull
    public final <T> Spliterator<T> spliterator(@NotNull T[] array, int fromIndex, int toIndex, int additionalCharacteristics) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return new ArraySpliterator<T>(array, fromIndex, toIndex, additionalCharacteristics);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\b\u0016\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB1\b\u0016\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bB9\b\u0012\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0007\u0010\u000fJ\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00140\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J \u0010\u001a\u001a\u001a\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u001bj\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u0001`\u001cH\u0016R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/jdkport/Spliterators$ArraySpliterator;", "T", "Lorg/gnit/lucenekmp/jdkport/Spliterator;", "array", "", "additionalCharacteristics", "", "<init>", "([Ljava/lang/Object;I)V", "origin", "fence", "([Ljava/lang/Object;III)V", "characteristics", "estimatedSize", "", "([Ljava/lang/Object;IIIJ)V", "[Ljava/lang/Object;", "index", "trySplit", "forEachRemaining", "", "action", "Lkotlin/Function1;", "tryAdvance", "", "estimateSize", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "core"})
    @SourceDebugExtension(value={"SMAP\nSpliterators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spliterators.kt\norg/gnit/lucenekmp/jdkport/Spliterators$ArraySpliterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class ArraySpliterator<T>
    implements Spliterator<T> {
        @NotNull
        private final T[] array;
        private int index;
        private final int fence;
        private final int characteristics;
        private long estimatedSize;

        public ArraySpliterator(@NotNull T[] array, int additionalCharacteristics) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this(array, 0, array.length, additionalCharacteristics);
        }

        public ArraySpliterator(@NotNull T[] array, int origin, int fence, int additionalCharacteristics) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
            this.estimatedSize = -1L;
        }

        private ArraySpliterator(T[] array, int origin, int fence, int characteristics, long estimatedSize) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = characteristics;
            this.estimatedSize = estimatedSize;
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            Spliterator spliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (this.estimatedSize == -1L) {
                ArraySpliterator<T> arraySpliterator;
                ArraySpliterator<T> it = arraySpliterator = new ArraySpliterator<T>(this.array, lo, mid, this.characteristics);
                boolean bl = false;
                this.index = mid;
                spliterator = arraySpliterator;
            } else {
                ArraySpliterator<T> arraySpliterator;
                long prefixEst = this.estimatedSize >>> 1;
                this.estimatedSize -= prefixEst;
                ArraySpliterator<T> it = arraySpliterator = new ArraySpliterator<T>(this.array, lo, mid, this.characteristics, prefixEst);
                boolean bl = false;
                this.index = mid;
                spliterator = arraySpliterator;
            }
            return spliterator;
        }

        @Override
        public void forEachRemaining(@NotNull Function1<? super T, Unit> action) {
            int i;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            T[] a = this.array;
            int hi = this.fence;
            if (a.length >= hi && i >= 0 && i < hi) {
                this.index = hi;
                for (i = this.index; i < hi; ++i) {
                    action.invoke(a[i]);
                }
            }
        }

        @Override
        public boolean tryAdvance(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.index >= 0 && this.index < this.fence) {
                int n = this.index;
                this.index = n + 1;
                T element = this.array[n];
                action.invoke(element);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize >= 0L ? this.estimatedSize : (long)(this.fence - this.index);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Nullable
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException("Spliterator does not report SORTED characteristic");
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterator.super.getExactSizeIfKnown();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterator.super.hasCharacteristics(characteristics);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001aB\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0002H\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0017\u001a\u001a\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u0018j\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u0001`\u0019H\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/jdkport/Spliterators$IteratorSpliterator;", "T", "Lorg/gnit/lucenekmp/jdkport/Spliterator;", "iterator", "", "characteristics", "", "<init>", "(Ljava/util/Iterator;I)V", "size", "", "(Ljava/util/Iterator;JI)V", "it", "est", "batch", "trySplit", "forEachRemaining", "", "action", "Lkotlin/Function1;", "tryAdvance", "", "estimateSize", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "Companion", "core"})
    public static final class IteratorSpliterator<T>
    implements Spliterator<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Iterator<T> it;
        private long est;
        private final int characteristics;
        private int batch;
        private static final int BATCH_UNIT = 1024;
        private static final int MAX_BATCH = 0x2000000;

        public IteratorSpliterator(@NotNull Iterator<? extends T> iterator2, int characteristics) {
            Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
            this.it = iterator2;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        public IteratorSpliterator(@NotNull Iterator<? extends T> iterator2, long size2, int characteristics) {
            Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
            this.it = iterator2;
            this.est = size2;
            this.characteristics = size2 >= 0L && (characteristics & 0x40) != 0 ? characteristics : characteristics & 0xFFFFBFBF;
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            Iterator<T> i = this.it;
            long s = this.est;
            if (s > 1L && i.hasNext()) {
                int j;
                int n = this.batch + 1024;
                if ((long)n > s) {
                    n = (int)s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                ArrayList<T> buffer = new ArrayList<T>(n);
                if (n <= 5) {
                    int halfSize = n / 2;
                    for (j = 0; j < halfSize && i.hasNext(); ++j) {
                        buffer.add(i.next());
                    }
                } else {
                    while (j < n && i.hasNext()) {
                        buffer.add(i.next());
                        ++j;
                    }
                }
                if (j == 0) {
                    return null;
                }
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                int n2 = 0;
                int n3 = j;
                Object[] objectArray = new Object[n3];
                while (n2 < n3) {
                    int n4 = n2++;
                    objectArray[n4] = buffer.get(n4);
                }
                Object[] anyArray = objectArray;
                return new ArraySpliterator<Object>(anyArray, 0, j, this.characteristics());
            }
            return null;
        }

        @Override
        public void forEachRemaining(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            while (this.it.hasNext()) {
                action.invoke(this.it.next());
            }
        }

        @Override
        public boolean tryAdvance(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.it.hasNext()) {
                action.invoke(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        @Nullable
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException("Spliterator does not report SORTED characteristic");
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterator.super.getExactSizeIfKnown();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterator.super.hasCharacteristics(characteristics);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/jdkport/Spliterators$IteratorSpliterator$Companion;", "", "<init>", "()V", "BATCH_UNIT", "", "MAX_BATCH", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

