/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharArrayExtKt;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\u00010B#\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB#\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\u0006\u0010$\u001a\u00020\u0012J\b\u0010(\u001a\u00020\u001bH\u0002J\u001e\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001bJ\b\u0010,\u001a\u0004\u0018\u00010\u0017J\b\u0010-\u001a\u00020\u0010H\u0002J\u0006\u0010.\u001a\u00020\u0010J\u0006\u0010/\u001a\u00020\u0012R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\"\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/jdkport/StreamDecoder;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "in", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "lock", "", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/InputStream;Ljava/lang/Object;Lorg/gnit/lucenekmp/jdkport/Charset;)V", "dec", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "(Lorg/gnit/lucenekmp/jdkport/InputStream;Ljava/lang/Object;Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "closed", "", "ensureOpen", "", "haveLeftoverChar", "leftoverChar", "", "encoding", "", "getEncoding", "()Ljava/lang/String;", "read", "", "cbuf", "", "offset", "length", "ready", "close", "isOpen", "()Z", "fillZeroToPosition", "decoder", "bb", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "readBytes", "implRead", "off", "end", "encodingName", "inReady", "implReady", "implClose", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStreamDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamDecoder.kt\norg/gnit/lucenekmp/jdkport/StreamDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
public final class StreamDecoder
extends Reader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger;
    private volatile boolean closed;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    @NotNull
    private final Charset cs;
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final ByteBuffer bb;
    @Nullable
    private final InputStream in;
    private static final int MIN_BYTE_BUFFER_SIZE = 32;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Nullable
    public final String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    @Override
    public int read() {
        this.logger.debug(StreamDecoder::read$lambda$1);
        if (this.haveLeftoverChar) {
            this.logger.debug(() -> StreamDecoder.read$lambda$2(this));
            this.haveLeftoverChar = false;
            return this.leftoverChar;
        }
        char[] cb = new char[2];
        this.logger.debug(StreamDecoder::read$lambda$3);
        int n = this.read(cb, 0, 2);
        this.logger.debug(() -> StreamDecoder.read$lambda$4(n));
        switch (n) {
            case -1: {
                this.logger.debug(StreamDecoder::read$lambda$5);
                return -1;
            }
            case 2: {
                this.logger.debug(() -> StreamDecoder.read$lambda$6(cb));
                this.leftoverChar = cb[1];
                this.haveLeftoverChar = true;
                return cb[0];
            }
            case 1: {
                this.logger.debug(() -> StreamDecoder.read$lambda$7(cb));
                return cb[0];
            }
            case 0: {
                this.logger.debug(StreamDecoder::read$lambda$8);
                return this.read();
            }
        }
        boolean bl = false;
        Integer n2 = n;
        throw new IllegalArgumentException(((Object)n2).toString());
    }

    @Override
    public int read(@NotNull char[] cbuf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.logger.debug(() -> StreamDecoder.read$lambda$10(cbuf, offset, length));
        Ref.IntRef off = new Ref.IntRef();
        off.element = offset;
        Ref.IntRef len = new Ref.IntRef();
        len.element = length;
        this.ensureOpen();
        if (off.element < 0 || off.element > cbuf.length || len.element < 0 || off.element + len.element > cbuf.length || off.element + len.element < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len.element == 0) {
            return 0;
        }
        Ref.IntRef n = new Ref.IntRef();
        if (this.haveLeftoverChar) {
            this.logger.debug(() -> StreamDecoder.read$lambda$11(this));
            cbuf[off.element] = this.leftoverChar;
            int n2 = off.element;
            off.element = n2 + 1;
            n2 = len.element;
            len.element = n2 + -1;
            this.haveLeftoverChar = false;
            n.element = 1;
            if (len.element == 0 || !this.implReady()) {
                this.logger.debug(() -> StreamDecoder.read$lambda$12(n));
                return n.element;
            }
        }
        this.logger.debug(() -> StreamDecoder.read$lambda$13(cbuf, off, len));
        int nr = this.implRead(cbuf, off.element, off.element + len.element);
        this.logger.debug(() -> StreamDecoder.read$lambda$14(nr));
        int result = nr < 0 ? (n.element == 1 ? 1 : -1) : n.element + nr;
        this.logger.debug(() -> StreamDecoder.read$lambda$15(result));
        return result;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.haveLeftoverChar || this.implReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.implClose();
        }
        finally {
            this.closed = true;
        }
    }

    private final boolean isOpen() {
        return !this.closed;
    }

    public final void fillZeroToPosition() throws IOException {
        Arrays.INSTANCE.fill(this.bb.array(), this.bb.arrayOffset(), this.bb.arrayOffset() + this.bb.getPosition(), (byte)0);
    }

    public StreamDecoder(@Nullable InputStream in, @NotNull Object lock2, @NotNull Charset cs) {
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this(in, lock2, cs.newDecoder().onMalformedInput(CodingErrorAction.Companion.getREPLACE()).onUnmappableCharacter(CodingErrorAction.Companion.getREPLACE()));
        System.out.println((Object)("[DEBUG] StreamDecoder constructor called with Charset: " + cs.name()));
    }

    /*
     * WARNING - void declaration
     */
    public StreamDecoder(@Nullable InputStream in, @NotNull Object lock2, @NotNull CharsetDecoder dec) {
        void $this$_init__u24lambda_u2416;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)dec, (String)"dec");
        this.logger = KotlinLogging.INSTANCE.logger(StreamDecoder::logger$lambda$0);
        System.out.println((Object)("[DEBUG] StreamDecoder constructor called with CharsetDecoder from Charset: " + dec.charset().name()));
        this.cs = dec.charset();
        this.decoder = dec;
        this.in = in;
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.Companion.allocate(8192);
        StreamDecoder streamDecoder = this;
        boolean bl = false;
        $this$_init__u24lambda_u2416.position(0);
        $this$_init__u24lambda_u2416.limit(0);
        streamDecoder.bb = byteBuffer;
        System.out.println((Object)("[DEBUG] ByteBuffer created: capacity=" + this.bb.getCapacity() + ", position=" + this.bb.getPosition() + ", limit=" + this.bb.getLimit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int readBytes() throws IOException {
        this.logger.debug(StreamDecoder::readBytes$lambda$17);
        this.logger.debug(() -> StreamDecoder.readBytes$lambda$18(this));
        this.bb.compact();
        this.logger.debug(() -> StreamDecoder.readBytes$lambda$19(this));
        try {
            int n;
            int lim = this.bb.getLimit();
            int pos = this.bb.getPosition();
            if (!(pos <= lim)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int rem = pos <= lim ? lim - pos : 0;
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$20(lim, pos, rem, this));
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$22(this));
            if (this.in != null) {
                this.logger.debug(() -> StreamDecoder.readBytes$lambda$23(this));
                byte[] tempBytes = new byte[rem];
                InputStream inputStream = this.in;
                Intrinsics.checkNotNull((Object)inputStream);
                int read = inputStream.read(tempBytes, 0, rem);
                this.logger.debug(() -> StreamDecoder.readBytes$lambda$24(read));
                if (read > 0) {
                    this.logger.debug(() -> StreamDecoder.readBytes$lambda$26(tempBytes, read));
                    for (int i = 0; i < read; ++i) {
                        this.bb.put(pos + i, tempBytes[i]);
                    }
                    this.logger.debug(() -> StreamDecoder.readBytes$lambda$27(pos));
                    n = read;
                } else {
                    n = read;
                }
            } else {
                n = -1;
            }
            int bytesRead = n;
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$28(bytesRead));
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$30(this));
            if (bytesRead < 0) {
                int n2 = bytesRead;
                return n2;
            }
            if (bytesRead == 0) {
                throw new IOException("Underlying input stream returned zero bytes");
            }
            if (!(bytesRead <= rem)) {
                boolean bl = false;
                String string = "bytesRead = " + bytesRead + ", rem = " + rem;
                throw new IllegalArgumentException(string.toString());
            }
            this.bb.position(pos + bytesRead);
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$32(this));
        }
        finally {
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$33(this));
            this.bb.flip();
            this.logger.debug(() -> StreamDecoder.readBytes$lambda$34(this));
        }
        int rem = this.bb.remaining();
        this.logger.debug(() -> StreamDecoder.readBytes$lambda$35(rem));
        this.logger.debug(() -> StreamDecoder.readBytes$lambda$37(this));
        if (!(rem != 0)) {
            boolean bl = false;
            Integer n = rem;
            throw new IllegalArgumentException(((Object)n).toString());
        }
        return rem;
    }

    public final int implRead(@NotNull char[] cbuf, int off, int end) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.logger.debug(() -> StreamDecoder.implRead$lambda$39(cbuf, off, end));
        if (!(end - off > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Ref.ObjectRef cb = new Ref.ObjectRef();
        cb.element = CharBuffer.Companion.wrap(cbuf, off, end - off);
        this.logger.debug(() -> StreamDecoder.implRead$lambda$40(cb));
        if (((CharBuffer)cb.element).position() != 0) {
            cb.element = ((CharBuffer)cb.element).slice();
        }
        Ref.BooleanRef eof = new Ref.BooleanRef();
        while (true) {
            this.logger.debug(() -> StreamDecoder.implRead$lambda$42(this));
            CoderResult cr = this.decoder.decode(this.bb, (CharBuffer)cb.element, eof.element);
            this.logger.debug(() -> StreamDecoder.implRead$lambda$44(cb));
            this.logger.debug(() -> StreamDecoder.implRead$lambda$45(cr, cb, eof));
            if (cr.isUnderflow()) {
                if (eof.element || !((CharBuffer)cb.element).hasRemaining() || ((CharBuffer)cb.element).position() > 0 && !this.inReady()) break;
                this.logger.debug(StreamDecoder::implRead$lambda$46);
                int n = this.readBytes();
                if (n >= 0) continue;
                eof.element = true;
                if (((CharBuffer)cb.element).position() == 0 && !this.bb.hasRemaining()) break;
                continue;
            }
            if (cr.isOverflow()) {
                if (((CharBuffer)cb.element).position() > 0) break;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            cr.throwException();
        }
        if (eof.element) {
            this.decoder.reset();
        }
        if (((CharBuffer)cb.element).position() == 0) {
            if (eof.element) {
                return -1;
            }
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return ((CharBuffer)cb.element).position();
    }

    @Nullable
    public final String encodingName() {
        return this.cs.name();
    }

    private final boolean inReady() {
        try {
            return this.in != null && this.in.available() > 0;
        }
        catch (IOException x) {
            return false;
        }
    }

    public final boolean implReady() {
        return this.bb.hasRemaining() || this.inReady();
    }

    public final void implClose() throws IOException {
        InputStream inputStream = this.in;
        Intrinsics.checkNotNull((Object)inputStream);
        inputStream.close();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object read$lambda$1() {
        return "StreamDecoder.read() called";
    }

    private static final Object read$lambda$2(StreamDecoder this$0) {
        return "StreamDecoder.read() returning leftover char: " + this$0.leftoverChar;
    }

    private static final Object read$lambda$3() {
        return "StreamDecoder.read() calling read(cb, 0, 2)";
    }

    private static final Object read$lambda$4(int $n) {
        return "StreamDecoder.read() returning n: " + $n;
    }

    private static final Object read$lambda$5() {
        return "StreamDecoder.read() returning -1 (EOF)";
    }

    private static final Object read$lambda$6(char[] $cb) {
        return "StreamDecoder.read() returning " + $cb[0] + ", saving leftover char: " + $cb[1];
    }

    private static final Object read$lambda$7(char[] $cb) {
        return "StreamDecoder.read() returning " + $cb[0];
    }

    private static final Object read$lambda$8() {
        return "StreamDecoder.read() got zero chars, trying again";
    }

    private static final Object read$lambda$10(char[] $cbuf, int $offset, int $length) {
        return "StreamDecoder.read(" + CharArrayExtKt.toCodeString($cbuf) + ", " + $offset + ", " + $length + ") called";
    }

    private static final Object read$lambda$11(StreamDecoder this$0) {
        return "StreamDecoder.read(cbuf, offset, length) using leftover char: " + this$0.leftoverChar;
    }

    private static final Object read$lambda$12(Ref.IntRef $n) {
        return "StreamDecoder.read(cbuf, offset, length) returning " + $n.element + " (only leftover char)";
    }

    private static final Object read$lambda$13(char[] $cbuf, Ref.IntRef $off, Ref.IntRef $len) {
        return "StreamDecoder.read(cbuf, offset, length) calling implRead(" + CharArrayExtKt.toCodeString($cbuf) + ", " + $off.element + ", " + ($off.element + $len.element) + ")";
    }

    private static final Object read$lambda$14(int $nr) {
        return "StreamDecoder.read(cbuf, offset, length) implRead returned " + $nr;
    }

    private static final Object read$lambda$15(int $result) {
        return "StreamDecoder.read(cbuf, offset, length) returning " + $result;
    }

    private static final Object readBytes$lambda$17() {
        return "readBytes() called";
    }

    private static final Object readBytes$lambda$18(StreamDecoder this$0) {
        return "Before compact: bb.position=" + this$0.bb.getPosition() + ", bb.limit=" + this$0.bb.getLimit() + ", bb.capacity=" + this$0.bb.getCapacity();
    }

    private static final Object readBytes$lambda$19(StreamDecoder this$0) {
        return "Before readBytes: bb.position=" + this$0.bb.getPosition() + ", bb.limit=" + this$0.bb.getLimit() + ", bb.capacity=" + this$0.bb.getCapacity();
    }

    private static final Object readBytes$lambda$20(int $lim, int $pos, int $rem, StreamDecoder this$0) {
        return "Before read: lim=" + $lim + ", pos=" + $pos + ", rem=" + $rem + ", arrayOffset=" + this$0.bb.arrayOffset();
    }

    private static final CharSequence readBytes$lambda$22$lambda$21(byte it) {
        return String.valueOf(it);
    }

    private static final Object readBytes$lambda$22(StreamDecoder this$0) {
        return "ByteBuffer array content before read: " + ArraysKt.joinToString$default((byte[])this$0.bb.array(), (CharSequence)", ", null, null, (int)0, null, StreamDecoder::readBytes$lambda$22$lambda$21, (int)30, null);
    }

    private static final Object readBytes$lambda$23(StreamDecoder this$0) {
        InputStream inputStream = this$0.in;
        Intrinsics.checkNotNull((Object)inputStream);
        return "Reading from input stream: " + Reflection.getOrCreateKotlinClass(inputStream.getClass()).getSimpleName();
    }

    private static final Object readBytes$lambda$24(int $read) {
        return "Raw input stream read result: " + $read + " bytes";
    }

    private static final CharSequence readBytes$lambda$26$lambda$25(byte it) {
        return String.valueOf(it);
    }

    private static final Object readBytes$lambda$26(byte[] $tempBytes, int $read) {
        return "Bytes read from input stream: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((byte[])$tempBytes, (IntRange)RangesKt.until((int)0, (int)$read)), (CharSequence)", ", null, null, (int)0, null, StreamDecoder::readBytes$lambda$26$lambda$25, (int)30, null);
    }

    private static final Object readBytes$lambda$27(int $pos) {
        return "Copied bytes to ByteBuffer at position " + $pos;
    }

    private static final Object readBytes$lambda$28(int $bytesRead) {
        return "Bytes read: " + $bytesRead;
    }

    private static final CharSequence readBytes$lambda$30$lambda$29(byte it) {
        return String.valueOf(it);
    }

    private static final Object readBytes$lambda$30(StreamDecoder this$0) {
        return "ByteBuffer array after read: " + ArraysKt.joinToString$default((byte[])this$0.bb.array(), (CharSequence)", ", null, null, (int)0, null, StreamDecoder::readBytes$lambda$30$lambda$29, (int)30, null);
    }

    private static final Object readBytes$lambda$32(StreamDecoder this$0) {
        return "After setting position: bb.position=" + this$0.bb.getPosition() + ", bb.limit=" + this$0.bb.getLimit();
    }

    private static final Object readBytes$lambda$33(StreamDecoder this$0) {
        return "Before flip: bb.position=" + this$0.bb.getPosition() + ", bb.limit=" + this$0.bb.getLimit();
    }

    private static final Object readBytes$lambda$34(StreamDecoder this$0) {
        return "After flip: bb.position=" + this$0.bb.getPosition() + ", bb.limit=" + this$0.bb.getLimit();
    }

    private static final Object readBytes$lambda$35(int $rem) {
        return "Final ByteBuffer remaining: " + $rem;
    }

    private static final CharSequence readBytes$lambda$37$lambda$36(byte it) {
        return String.valueOf(it);
    }

    private static final Object readBytes$lambda$37(StreamDecoder this$0) {
        return "Final ByteBuffer content: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((byte[])this$0.bb.array(), (IntRange)RangesKt.until((int)this$0.bb.getPosition(), (int)this$0.bb.getLimit())), (CharSequence)", ", null, null, (int)0, null, StreamDecoder::readBytes$lambda$37$lambda$36, (int)30, null);
    }

    private static final Object implRead$lambda$39(char[] $cbuf, int $off, int $end) {
        return "StreamDecoder.implRead(" + CharArrayExtKt.toCodeString($cbuf) + ", " + $off + ", " + $end + ") called";
    }

    private static final Object implRead$lambda$40(Ref.ObjectRef $cb) {
        return "CharBuffer contents before implRead: " + CharArrayExtKt.toCodeString(CollectionsKt.toCharArray((Collection)ArraysKt.slice((char[])((CharBuffer)$cb.element).array(), (IntRange)RangesKt.until((int)((CharBuffer)$cb.element).getPosition(), (int)((CharBuffer)$cb.element).getLimit()))));
    }

    private static final CharSequence implRead$lambda$42$lambda$41(byte it) {
        return UByte.toString-impl((byte)UByte.constructor-impl((byte)it));
    }

    private static final Object implRead$lambda$42(StreamDecoder this$0) {
        return "ByteBuffer contents before decode: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((byte[])this$0.bb.array(), (IntRange)RangesKt.until((int)this$0.bb.getPosition(), (int)this$0.bb.getLimit())), null, null, null, (int)0, null, StreamDecoder::implRead$lambda$42$lambda$41, (int)31, null);
    }

    private static final CharSequence implRead$lambda$44$lambda$43(char it) {
        return String.valueOf((int)it);
    }

    private static final Object implRead$lambda$44(Ref.ObjectRef $cb) {
        int n = 0;
        int n2 = ((CharBuffer)$cb.element).remaining();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = ((CharBuffer)$cb.element).charAt(((CharBuffer)$cb.element).position() + n3);
        }
        return "CharBuffer contents after decode: " + ArraysKt.joinToString$default((char[])cArray, null, null, null, (int)0, null, StreamDecoder::implRead$lambda$44$lambda$43, (int)31, null);
    }

    private static final Object implRead$lambda$45(CoderResult $cr, Ref.ObjectRef $cb, Ref.BooleanRef $eof) {
        return "CoderResult cr:" + $cr + " isUnderflow: " + $cr.isUnderflow() + ", cb.position=" + ((CharBuffer)$cb.element).position() + ", cb.remaining=" + ((CharBuffer)$cb.element).remaining() + ", eof=" + $eof.element;
    }

    private static final Object implRead$lambda$46() {
        return "implRead: calling readBytes()";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rJ \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/jdkport/StreamDecoder$Companion;", "", "<init>", "()V", "MIN_BYTE_BUFFER_SIZE", "", "DEFAULT_BYTE_BUFFER_SIZE", "forInputStreamReader", "Lorg/gnit/lucenekmp/jdkport/StreamDecoder;", "in", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "lock", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "dec", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamDecoder forInputStreamReader(@Nullable InputStream in, @NotNull Object lock2, @NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            return new StreamDecoder(in, lock2, cs);
        }

        @NotNull
        public final StreamDecoder forInputStreamReader(@Nullable InputStream in, @NotNull Object lock2, @NotNull CharsetDecoder dec) {
            Intrinsics.checkNotNullParameter((Object)lock2, (String)"lock");
            Intrinsics.checkNotNullParameter((Object)dec, (String)"dec");
            return new StreamDecoder(in, lock2, dec);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

