/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.Writer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\f\u0018\u0000 52\u00020\u0001:\u00015B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\b\u0010,\u001a\u00020\u0010H\u0002J\u001a\u0010-\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010.\u001a\u00020\u000eH\u0002J\u001e\u0010/\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010/\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u00100\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0018J\u0006\u00101\u001a\u00020\u0010J\u0006\u00102\u001a\u00020\u0010J\u0006\u00103\u001a\u00020\u0010J\b\u00104\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\"\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/jdkport/StreamEncoder;", "Lorg/gnit/lucenekmp/jdkport/Writer;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;Lorg/gnit/lucenekmp/jdkport/Charset;)V", "enc", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "closed", "", "ensureOpen", "", "encoding", "", "getEncoding", "()Ljava/lang/String;", "flushBuffer", "write", "c", "", "cbuf", "", "off", "len", "str", "cb", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "flush", "close", "isOpen", "()Z", "encoder", "bb", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "maxBufferCapacity", "haveLeftoverChar", "leftoverChar", "", "lcb", "writeBytes", "flushLeftoverChar", "endOfInput", "implWrite", "growByteBufferIfNeeded", "implFlushBuffer", "implFlush", "implClose", "encodingName", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStreamEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamEncoder.kt\norg/gnit/lucenekmp/jdkport/StreamEncoder\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,328:1\n3#2,8:329\n3#2,8:338\n8#2,2:347\n3#2,8:349\n3#2,8:358\n10#3:337\n10#3:346\n10#3:357\n10#3:366\n*S KotlinDebug\n*F\n+ 1 StreamEncoder.kt\norg/gnit/lucenekmp/jdkport/StreamEncoder\n*L\n147#1:329,8\n179#1:338,8\n205#1:347,2\n213#1:349,8\n259#1:358,8\n147#1:337\n179#1:346\n213#1:357\n259#1:366\n*E\n"})
public final class StreamEncoder
extends Writer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(StreamEncoder::logger$lambda$0);
    private volatile boolean closed;
    @NotNull
    private final Charset cs;
    @NotNull
    private final CharsetEncoder encoder;
    @NotNull
    private ByteBuffer bb;
    private final int maxBufferCapacity;
    @NotNull
    private final OutputStream out;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    @Nullable
    private CharBuffer lcb;
    private static final int INITIAL_BYTE_BUFFER_CAPACITY = 512;
    private static final int MAX_BYTE_BUFFER_CAPACITY = 8192;

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Nullable
    public final String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    public final void flushBuffer() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed");
        }
        this.implFlushBuffer();
    }

    @Override
    public void write(int c) throws IOException {
        char[] cbuf = new char[]{(char)c};
        this.write(cbuf, 0, 1);
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.implWrite(cbuf, off, len);
    }

    @Override
    public void write(@NotNull String str, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cbuf = new char[len];
        String string = str;
        int n = 0;
        int n2 = off + len;
        string.getChars(off, n2, cbuf, n);
        this.write(cbuf, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull CharBuffer cb) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        int position = cb.getPosition();
        try {
            this.ensureOpen();
            this.implWrite(cb);
        }
        finally {
            cb.setPosition(position);
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.implFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.implClose();
        }
        finally {
            this.closed = true;
        }
    }

    private final boolean isOpen() {
        return !this.closed;
    }

    private StreamEncoder(OutputStream out, Charset cs) {
        this(out, cs.newEncoder().onMalformedInput(CodingErrorAction.Companion.getREPLACE()).onUnmappableCharacter(CodingErrorAction.Companion.getREPLACE()));
    }

    private StreamEncoder(OutputStream out, CharsetEncoder enc) {
        this.out = out;
        this.cs = enc.charset();
        this.encoder = enc;
        this.bb = ByteBuffer.Companion.allocate(512);
        this.maxBufferCapacity = 8192;
    }

    private final void writeBytes() throws IOException {
        int rem;
        this.logger.debug(() -> StreamEncoder.writeBytes$lambda$1(this));
        this.bb.flip();
        int lim = this.bb.getLimit();
        int pos = this.bb.getPosition();
        boolean condition$iv = pos <= lim;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem > 0) {
            this.out.write(this.bb.array(), this.bb.arrayOffset() + pos, rem);
        }
        this.bb.clear();
    }

    private final void flushLeftoverChar(CharBuffer cb, boolean endOfInput) throws IOException {
        if (!this.haveLeftoverChar && !endOfInput) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.Companion.allocate(2);
        } else {
            CharBuffer charBuffer = this.lcb;
            Intrinsics.checkNotNull((Object)charBuffer);
            charBuffer.clear();
        }
        if (this.haveLeftoverChar) {
            CharBuffer charBuffer = this.lcb;
            Intrinsics.checkNotNull((Object)charBuffer);
            charBuffer.put(this.leftoverChar);
        }
        if (cb != null && cb.hasRemaining()) {
            CharBuffer charBuffer = this.lcb;
            Intrinsics.checkNotNull((Object)charBuffer);
            charBuffer.put(cb.get());
        }
        CharBuffer charBuffer = this.lcb;
        Intrinsics.checkNotNull((Object)charBuffer);
        charBuffer.flip();
        while (true) {
            CharBuffer charBuffer2 = this.lcb;
            Intrinsics.checkNotNull((Object)charBuffer2);
            if (!charBuffer2.hasRemaining() && !endOfInput) break;
            CharBuffer charBuffer3 = this.lcb;
            Intrinsics.checkNotNull((Object)charBuffer3);
            CoderResult cr = this.encoder.encode(charBuffer3, this.bb, endOfInput);
            if (cr.isUnderflow()) {
                CharBuffer charBuffer4 = this.lcb;
                Intrinsics.checkNotNull((Object)charBuffer4);
                if (!charBuffer4.hasRemaining()) break;
                CharBuffer charBuffer5 = this.lcb;
                Intrinsics.checkNotNull((Object)charBuffer5);
                this.leftoverChar = charBuffer5.get();
                if (cb != null && cb.hasRemaining()) {
                    CharBuffer charBuffer6 = this.lcb;
                    Intrinsics.checkNotNull((Object)charBuffer6);
                    charBuffer6.clear();
                    CharBuffer charBuffer7 = this.lcb;
                    Intrinsics.checkNotNull((Object)charBuffer7);
                    charBuffer7.put(this.leftoverChar).put(cb.get()).flip();
                    continue;
                }
                return;
            }
            if (cr.isOverflow()) {
                boolean condition$iv = this.bb.getPosition() > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
        this.haveLeftoverChar = false;
    }

    public final void implWrite(@NotNull char[] cbuf, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        CharBuffer cb = CharBuffer.Companion.wrap(cbuf, off, len);
        this.implWrite(cb);
    }

    public final void implWrite(@NotNull CharBuffer cb) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        if (this.haveLeftoverChar) {
            this.flushLeftoverChar(cb, false);
        }
        this.growByteBufferIfNeeded(cb.remaining());
        while (cb.hasRemaining()) {
            boolean condition$iv;
            CoderResult cr = this.encoder.encode(cb, this.bb, false);
            if (cr.isUnderflow()) {
                condition$iv = cb.remaining() <= 1;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    Integer n = cb.remaining();
                    throw new AssertionError(n);
                }
                if (cb.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = cb.get();
                break;
            }
            if (cr.isOverflow()) {
                condition$iv = this.bb.getPosition() > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
    }

    public final void growByteBufferIfNeeded(int len) throws IOException {
        int maxBytes;
        int newCap;
        int cap = this.bb.getCapacity();
        if (cap < this.maxBufferCapacity && (newCap = java.lang.Math.min(maxBytes = len * Math.INSTANCE.round(this.encoder.maxBytesPerChar()), this.maxBufferCapacity)) > cap) {
            this.implFlushBuffer();
            this.bb = ByteBuffer.Companion.allocate(newCap);
        }
    }

    public final void implFlushBuffer() throws IOException {
        if (this.bb.getPosition() > 0) {
            this.writeBytes();
        }
    }

    public final void implFlush() throws IOException {
        this.implFlushBuffer();
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void implClose() throws IOException {
        try {
            AutoCloseable autoCloseable = this.out;
            Throwable throwable = null;
            try {
                CoderResult cr;
                OutputStream it = (OutputStream)autoCloseable;
                boolean bl = false;
                this.flushLeftoverChar(null, true);
                while (!(cr = this.encoder.flush(this.bb)).isUnderflow()) {
                    if (cr.isOverflow()) {
                        boolean condition$iv = this.bb.getPosition() > 0;
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl2 = false;
                            String string = "assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        this.writeBytes();
                        continue;
                    }
                    cr.throwException();
                }
                if (this.bb.getPosition() > 0) {
                    this.writeBytes();
                }
                this.out.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException x) {
            this.encoder.reset();
            throw x;
        }
    }

    @Nullable
    public final String encodingName() {
        return this.cs.name();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object writeBytes$lambda$1(StreamEncoder this$0) {
        return "writeBytes() bb.position=" + this$0.bb.getPosition() + ", bb[0]=" + this$0.bb.array()[0];
    }

    public /* synthetic */ StreamEncoder(OutputStream out, Charset cs, DefaultConstructorMarker $constructor_marker) {
        this(out, cs);
    }

    public /* synthetic */ StreamEncoder(OutputStream out, CharsetEncoder enc, DefaultConstructorMarker $constructor_marker) {
        this(out, enc);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/jdkport/StreamEncoder$Companion;", "", "<init>", "()V", "INITIAL_BYTE_BUFFER_CAPACITY", "", "MAX_BYTE_BUFFER_CAPACITY", "forOutputStreamWriter", "Lorg/gnit/lucenekmp/jdkport/StreamEncoder;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "enc", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamEncoder forOutputStreamWriter(@NotNull OutputStream out, @NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            return new StreamEncoder(out, cs, null);
        }

        @NotNull
        public final StreamEncoder forOutputStreamWriter(@NotNull OutputStream out, @NotNull CharsetEncoder enc) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)enc, (String)"enc");
            return new StreamEncoder(out, enc, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

