/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.comparisons.UComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0007H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\n\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/jdkport/StringReader;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "s", "", "<init>", "(Ljava/lang/String;)V", "length", "", "str", "next", "mark", "ensureOpen", "", "read", "cbuf", "", "off", "len", "skip", "", "n", "ready", "", "markSupported", "readAheadLimit", "reset", "close", "core"})
@SourceDebugExtension(value={"SMAP\nStringReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringReader.kt\norg/gnit/lucenekmp/jdkport/StringReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class StringReader
extends Reader {
    private final int length;
    @Nullable
    private String str;
    private int next;
    private int mark;

    public StringReader(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.length = s.length();
        this.str = s;
    }

    private final void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() {
        this.ensureOpen();
        if (this.next >= this.length) {
            return -1;
        }
        String string = this.str;
        Intrinsics.checkNotNull((Object)string);
        int n = this.next;
        this.next = n + 1;
        return string.charAt(n);
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.ensureOpen();
        Objects.INSTANCE.checkFromIndexSize(off, len, cbuf.length);
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        String string = this.str;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        int n2 = this.next;
        int n3 = this.next + n;
        string2.getChars(n2, n3, cbuf, off);
        this.next += n;
        return n;
    }

    public final long skip(long n) {
        this.ensureOpen();
        if (this.next >= this.length) {
            return 0L;
        }
        long r = (long)UComparisonsKt.minOf-J1ME1BU((int)UInt.constructor-impl((int)(this.length - this.next)), (int)UInt.constructor-impl((int)((int)n))) & 0xFFFFFFFFL;
        r = (long)UComparisonsKt.maxOf-J1ME1BU((int)UInt.constructor-impl((int)(-this.next)), (int)UInt.constructor-impl((int)((int)r))) & 0xFFFFFFFFL;
        this.next += (int)r;
        return r;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return true;
    }

    public final boolean markSupported() {
        return true;
    }

    public final void mark(int readAheadLimit) throws IOException {
        if (!(readAheadLimit >= 0)) {
            boolean bl = false;
            String string = "Read-ahead limit < 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureOpen();
        this.mark = this.next;
    }

    public final void reset() {
        this.ensureOpen();
        this.next = this.mark;
    }

    @Override
    public void close() {
        this.str = null;
    }
}

