/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005J.\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bJ.\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J.\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005J.\u0010\"\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/jdkport/StringUTF16;", "", "<init>", "()V", "HI_BYTE_SHIFT", "", "LO_BYTE_SHIFT", "toBytes", "", "value", "", "off", "len", "newBytesFor", "newBytesLength", "putChar", "", "val", "index", "c", "length", "compress", "src", "count", "srcOff", "dst", "dstOff", "checkBoundsOffCount", "offset", "compressCharToChar", "compressByteToByte", "getChar", "", "charAt", "inflate", "newString", "", "coderFromArrayLen", "", "core"})
@SourceDebugExtension(value={"SMAP\nStringUTF16.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringUTF16.kt\norg/gnit/lucenekmp/jdkport/StringUTF16\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class StringUTF16 {
    @NotNull
    public static final StringUTF16 INSTANCE = new StringUTF16();
    private static int HI_BYTE_SHIFT;
    private static int LO_BYTE_SHIFT;

    private StringUTF16() {
    }

    @NotNull
    public final byte[] toBytes(@NotNull char[] value, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] val = this.newBytesFor(len);
        int offset = off;
        for (int i = 0; i < len; ++i) {
            this.putChar(val, i, value[offset]);
            ++offset;
        }
        return val;
    }

    @NotNull
    public final byte[] newBytesFor(int len) {
        return new byte[this.newBytesLength(len)];
    }

    public final int newBytesLength(int len) {
        int MAX_LENGTH = 0x3FFFFFFF;
        if (len < 0) {
            throw new Exception();
        }
        if (len >= MAX_LENGTH) {
            throw new Error("UTF16 String size is " + len + ", should be less than " + MAX_LENGTH);
        }
        return len << 1;
    }

    public final void putChar(@NotNull byte[] val, int index, int c) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        int index2 = index;
        if (!(index2 >= 0 && index2 < this.length(val))) {
            boolean bl = false;
            String string = "Trusted caller missed bounds check";
            throw new IllegalArgumentException(string.toString());
        }
        index2 <<= 1;
        val[index2++] = (byte)(c >> HI_BYTE_SHIFT);
        val[index2] = (byte)(c >> LO_BYTE_SHIFT);
    }

    public final int length(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.length >> 1;
    }

    @NotNull
    public final byte[] compress(@NotNull char[] src, int off, int count) {
        byte[] utf16;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        byte[] latin1 = new byte[count];
        int ndx = this.compressCharToChar(src, off, latin1, 0, count);
        if (ndx != count && (this.getChar(utf16 = this.toBytes(src, off, count), ndx) > '\u00ff' || this.compressByteToByte(utf16, 0, latin1, 0, count) != count)) {
            return utf16;
        }
        return latin1;
    }

    @NotNull
    public final byte[] compress(@NotNull byte[] val, int off, int count) {
        byte[] utf16;
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        byte[] latin1 = new byte[count];
        int ndx = INSTANCE.compress(val, off, latin1, 0, count);
        if (ndx != count && (this.getChar(utf16 = Arrays.INSTANCE.copyOfRange(val, off << 1, this.newBytesLength(off + count)), ndx) > '\u00ff' || INSTANCE.compress(utf16, 0, latin1, 0, count) != count)) {
            return utf16;
        }
        return latin1;
    }

    public final int compress(@NotNull byte[] src, int srcOff, @NotNull byte[] dst, int dstOff, int len) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        INSTANCE.checkBoundsOffCount(srcOff2, len, src);
        for (int i = 0; i < len; ++i) {
            char c = this.getChar(src, srcOff2);
            if (c > '\u00ff') {
                return i;
            }
            dst[dstOff2] = (byte)c;
            ++srcOff2;
            ++dstOff2;
        }
        return len;
    }

    public final void checkBoundsOffCount(int offset, int count, @NotNull byte[] val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
    }

    public final int compressCharToChar(@NotNull char[] src, int srcOff, @NotNull byte[] dst, int dstOff, int len) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        for (int i = 0; i < len; ++i) {
            char c = src[srcOff2];
            if (c > '\u00ff') {
                return i;
            }
            dst[dstOff2] = (byte)c;
            ++srcOff2;
            ++dstOff2;
        }
        return len;
    }

    public final int compressByteToByte(@NotNull byte[] src, int srcOff, @NotNull byte[] dst, int dstOff, int len) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        for (int i = 0; i < len; ++i) {
            char c = this.getChar(src, srcOff2);
            if (c > '\u00ff') {
                return i;
            }
            dst[dstOff2] = (byte)c;
            ++srcOff2;
            ++dstOff2;
        }
        return len;
    }

    public final char getChar(@NotNull byte[] val, int index) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        int index2 = index;
        if (!(index2 >= 0 && index2 < this.length(val))) {
            boolean bl = false;
            String string = "Trusted caller missed bounds check";
            throw new IllegalArgumentException(string.toString());
        }
        index2 <<= 1;
        return (char)((val[index2++] & 0xFF) << HI_BYTE_SHIFT | (val[index2] & 0xFF) << LO_BYTE_SHIFT);
    }

    public final char charAt(@NotNull byte[] value, int index) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getChar(value, index);
    }

    public final void inflate(@NotNull byte[] src, int srcOff, @NotNull byte[] dst, int dstOff, int len) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int srcOff2 = srcOff;
        int dstOff2 = dstOff;
        for (int i = 0; i < len; ++i) {
            this.putChar(dst, dstOff2++, src[srcOff2++] & 0xFF);
        }
    }

    @NotNull
    public final String newString(@NotNull byte[] val, int index, int len) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        if (len == 0) {
            return "";
        }
        byte[] res = INSTANCE.compress(val, index, len);
        byte coderByte = this.coderFromArrayLen(res, len);
        Charset coder = coderByte == 0 ? StandardCharsets.Companion.getISO_8859_1() : StandardCharsets.Companion.getUTF_16BE();
        return StringExtKt.fromByteArray(StringCompanionObject.INSTANCE, res, coder);
    }

    public final byte coderFromArrayLen(@NotNull byte[] value, int len) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (byte)(len - value.length >>> 31);
    }

    static {
        if (Intrinsics.areEqual((Object)ByteOrder.Companion.nativeOrder(), (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
    }
}

