/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u0002H\b0\fj\b\u0012\u0004\u0012\u0002H\b`\r\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/jdkport/Timsort;", "", "<init>", "()V", "MIN_MERGE", "", "sort", "", "T", "a", "", "c", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Ljava/lang/Object;Ljava/util/Comparator;)V", "TimSorter", "core"})
public final class Timsort {
    @NotNull
    public static final Timsort INSTANCE = new Timsort();
    private static final int MIN_MERGE = 32;

    private Timsort() {
    }

    public final <T> void sort(@NotNull T[] a, @NotNull Comparator<T> c) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (a.length < 2) {
            return;
        }
        new TimSorter<T>(a, c).sort();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u001f\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\fH\u0002J%\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010'J%\u0010(\u001a\u00020\f2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010'J(\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0002J(\u0010.\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0002J\u001d\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00042\u0006\u00100\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u00101R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/jdkport/Timsort$TimSorter;", "T", "", "a", "", "c", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "([Ljava/lang/Object;Ljava/util/Comparator;)V", "[Ljava/lang/Object;", "minGallop", "", "tmp", "runBase", "", "runLen", "stackSize", "sort", "", "minRunLength", "n", "countRunAndMakeAscending", "lo", "hi", "reverseRange", "binarySort", "start", "pushRun", "runBaseVal", "runLenVal", "mergeCollapse", "mergeForceCollapse", "mergeAt", "i", "gallopRight", "key", "base", "len", "(Ljava/lang/Object;II)I", "gallopLeft", "mergeLo", "base1", "len1", "base2", "len2", "mergeHi", "ensureCapacity", "minCapacity", "(I)[Ljava/lang/Object;", "core"})
    private static final class TimSorter<T> {
        @NotNull
        private final T[] a;
        @NotNull
        private final Comparator<T> c;
        private int minGallop;
        @NotNull
        private T[] tmp;
        @NotNull
        private final int[] runBase;
        @NotNull
        private final int[] runLen;
        private int stackSize;

        public TimSorter(@NotNull T[] a, @NotNull Comparator<T> c) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(c, (String)"c");
            this.a = a;
            this.c = c;
            this.minGallop = 7;
            this.tmp = new Object[this.a.length / 2];
            this.runBase = new int[40];
            this.runLen = new int[40];
        }

        public final void sort() {
            int runLength;
            int n = this.a.length;
            if (n < 2) {
                return;
            }
            int minRun = this.minRunLength(n);
            for (int lo = 0; lo < n; lo += runLength) {
                runLength = this.countRunAndMakeAscending(lo, n);
                if (runLength < minRun) {
                    int force = n - lo < minRun ? n - lo : minRun;
                    this.binarySort(lo, lo + force, lo + runLength);
                    runLength = force;
                }
                this.pushRun(lo, runLength);
                this.mergeCollapse();
            }
            this.mergeForceCollapse();
        }

        private final int minRunLength(int n) {
            int n2;
            int r = 0;
            for (n2 = n; n2 >= 32; n2 >>= 1) {
                r |= n2 & 1;
            }
            return n2 + r;
        }

        private final int countRunAndMakeAscending(int lo, int hi) {
            int runHi = lo + 1;
            if (runHi == hi) {
                return 1;
            }
            if (this.c.compare(this.a[runHi], this.a[lo]) < 0) {
                while (runHi < hi && this.c.compare(this.a[runHi], this.a[runHi - 1]) < 0) {
                    ++runHi;
                }
                this.reverseRange(lo, runHi);
            } else {
                while (runHi < hi && this.c.compare(this.a[runHi], this.a[runHi - 1]) >= 0) {
                    ++runHi;
                }
            }
            return runHi - lo;
        }

        private final void reverseRange(int lo, int hi) {
            int i = lo;
            for (int j = hi - 1; i < j; ++i, --j) {
                T t = this.a[i];
                this.a[i] = this.a[j];
                this.a[j] = t;
            }
        }

        private final void binarySort(int lo, int hi, int start) {
            int start2 = start;
            if (start2 == lo) {
                ++start2;
            }
            for (int i = start2; i < hi; ++i) {
                T pivot = this.a[i];
                int left = lo;
                int right = i;
                while (left < right) {
                    int mid = left + right >>> 1;
                    if (this.c.compare(pivot, this.a[mid]) < 0) {
                        right = mid;
                        continue;
                    }
                    left = mid + 1;
                }
                for (int j = i; j > left; --j) {
                    this.a[j] = this.a[j - 1];
                }
                this.a[left] = pivot;
            }
        }

        private final void pushRun(int runBaseVal, int runLenVal) {
            this.runBase[this.stackSize] = runBaseVal;
            this.runLen[this.stackSize] = runLenVal;
            int n = this.stackSize;
            this.stackSize = n + 1;
        }

        private final void mergeCollapse() {
            while (this.stackSize > 1) {
                int n = this.stackSize - 2;
                if (n >= 1 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1]) {
                    if (this.runLen[n - 1] < this.runLen[n + 1]) {
                        --n;
                    }
                    this.mergeAt(n);
                    continue;
                }
                if (this.runLen[n] > this.runLen[n + 1]) break;
                this.mergeAt(n);
            }
        }

        private final void mergeForceCollapse() {
            while (this.stackSize > 1) {
                int n = this.stackSize - 2;
                if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
            }
        }

        private final void mergeAt(int i) {
            int base1 = this.runBase[i];
            int len1 = this.runLen[i];
            int base2 = this.runBase[i + 1];
            int len2 = this.runLen[i + 1];
            this.runLen[i] = len1 + len2;
            if (i == this.stackSize - 3) {
                this.runBase[i + 1] = this.runBase[i + 2];
                this.runLen[i + 1] = this.runLen[i + 2];
            }
            int n = this.stackSize;
            this.stackSize = n + -1;
            int k = this.gallopRight(this.a[base2], base1, len1);
            int newBase1 = base1 + k;
            int newLen1 = len1 - k;
            if (newLen1 == 0) {
                return;
            }
            int newLen2 = this.gallopLeft(this.a[newBase1 + newLen1 - 1], base2, len2);
            if (newLen2 == 0) {
                return;
            }
            if (newLen1 <= newLen2) {
                this.mergeLo(newBase1, newLen1, base2, newLen2);
            } else {
                this.mergeHi(newBase1, newLen1, base2, newLen2);
            }
        }

        private final int gallopRight(T key, int base, int len) {
            int lo = 0;
            int hi = len;
            while (lo < hi) {
                int mid = lo + hi >>> 1;
                if (this.c.compare(key, this.a[base + mid]) < 0) {
                    hi = mid;
                    continue;
                }
                lo = mid + 1;
            }
            return lo;
        }

        private final int gallopLeft(T key, int base, int len) {
            int lo = 0;
            int hi = len;
            while (lo < hi) {
                int mid = lo + hi >>> 1;
                if (this.c.compare(this.a[base + mid], key) < 0) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid;
            }
            return lo;
        }

        private final void mergeLo(int base1, int len1, int base2, int len2) {
            int i;
            this.tmp = this.ensureCapacity(len1);
            for (i = 0; i < len1; ++i) {
                this.tmp[i] = this.a[base1 + i];
            }
            i = 0;
            int j = base2;
            int dest = base1;
            int remaining1 = len1;
            int remaining2 = len2;
            while (true) {
                T t = this.tmp[i];
                Intrinsics.checkNotNull(t);
                if (this.c.compare(t, this.a[j]) <= 0) {
                    int n = dest++;
                    T t2 = this.tmp[i];
                    Intrinsics.checkNotNull(t2);
                    this.a[n] = t2;
                    ++i;
                    if (--remaining1 != 0) continue;
                    break;
                }
                this.a[dest++] = this.a[j];
                ++j;
                if (--remaining2 == 0) break;
            }
            int n = remaining1;
            for (int k = 0; k < n; ++k) {
                T t = this.tmp[i + k];
                Intrinsics.checkNotNull(t);
                this.a[dest + k] = t;
            }
        }

        private final void mergeHi(int base1, int len1, int base2, int len2) {
            int i;
            this.tmp = this.ensureCapacity(len2);
            for (i = 0; i < len2; ++i) {
                this.tmp[i] = this.a[base2 + i];
            }
            i = base1 + len1 - 1;
            int j = len2 - 1;
            int dest = base2 + len2 - 1;
            int remaining1 = len1;
            int remaining2 = len2;
            while (true) {
                T t = this.a[i];
                T t2 = this.tmp[j];
                Intrinsics.checkNotNull(t2);
                if (this.c.compare(t, t2) > 0) {
                    this.a[dest--] = this.a[i];
                    --i;
                    if (--remaining1 != 0) continue;
                    break;
                }
                int n = dest--;
                T t3 = this.tmp[j];
                Intrinsics.checkNotNull(t3);
                this.a[n] = t3;
                --j;
                if (--remaining2 == 0) break;
            }
            int n = remaining2;
            for (int k = 0; k < n; ++k) {
                T t = this.tmp[j - k];
                Intrinsics.checkNotNull(t);
                this.a[dest - k] = t;
            }
        }

        private final T[] ensureCapacity(int minCapacity) {
            if (this.tmp.length < minCapacity) {
                int newSize;
                int n = newSize = this.tmp.length == 0 ? 1 : this.tmp.length;
                while (newSize < minCapacity) {
                    newSize *= 2;
                }
                this.tmp = new Object[newSize];
            }
            return this.tmp;
        }
    }
}

